/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Component;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.ArbilTreePanels;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiIcons;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.ImdiTree;
import nl.mpi.arbil.LinorgFavourites;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.clarin.CmdiComponentBuilder;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiTreeObject;

public class TreeHelper {
    public DefaultTreeModel localCorpusTreeModel;
    public DefaultTreeModel remoteCorpusTreeModel;
    public DefaultTreeModel localDirectoryTreeModel;
    public DefaultTreeModel favouritesTreeModel;
    private DefaultMutableTreeNode localCorpusRootNode;
    private DefaultMutableTreeNode remoteCorpusRootNode;
    private DefaultMutableTreeNode localDirectoryRootNode;
    private DefaultMutableTreeNode favouritesRootNode;
    public ArbilTreePanels arbilTreePanel;
    public ImdiTreeObject[] remoteCorpusNodes = new ImdiTreeObject[0];
    public ImdiTreeObject[] localCorpusNodes = new ImdiTreeObject[0];
    public ImdiTreeObject[] localFileNodes = new ImdiTreeObject[0];
    public ImdiTreeObject[] favouriteNodes = new ImdiTreeObject[0];
    private static TreeHelper singleInstance = null;
    Vector<DefaultMutableTreeNode> treeNodeSortQueue = new Vector();
    boolean treeNodeSortQueueRunning = false;
    public boolean showHiddenFilesInTree = false;

    public static synchronized TreeHelper getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new TreeHelper();
        }
        return singleInstance;
    }

    private TreeHelper() {
        this.localCorpusRootNode = new DefaultMutableTreeNode();
        this.remoteCorpusRootNode = new DefaultMutableTreeNode();
        this.localDirectoryRootNode = new DefaultMutableTreeNode();
        this.favouritesRootNode = new DefaultMutableTreeNode();
        this.localCorpusTreeModel = new DefaultTreeModel(this.localCorpusRootNode, true);
        this.remoteCorpusTreeModel = new DefaultTreeModel(this.remoteCorpusRootNode, true);
        this.localDirectoryTreeModel = new DefaultTreeModel(this.localDirectoryRootNode, true);
        this.favouritesTreeModel = new DefaultTreeModel(this.favouritesRootNode, true);
        LinorgFavourites.getSingleInstance().convertOldFormatLocationLists();
        this.loadLocationsList();
    }

    public ImdiTree getTreeForNode(DefaultMutableTreeNode nodeToTest) {
        if (nodeToTest.getRoot().equals(this.remoteCorpusRootNode)) {
            return this.arbilTreePanel.remoteCorpusTree;
        }
        if (nodeToTest.getRoot().equals(this.localCorpusRootNode)) {
            return this.arbilTreePanel.localCorpusTree;
        }
        if (nodeToTest.getRoot().equals(this.localDirectoryRootNode)) {
            return this.arbilTreePanel.localDirectoryTree;
        }
        return this.arbilTreePanel.favouritesTree;
    }

    public DefaultTreeModel getModelForNode(DefaultMutableTreeNode nodeToTest) {
        if (nodeToTest.getRoot().equals(this.remoteCorpusRootNode)) {
            return this.remoteCorpusTreeModel;
        }
        if (nodeToTest.getRoot().equals(this.localCorpusRootNode)) {
            return this.localCorpusTreeModel;
        }
        if (nodeToTest.getRoot().equals(this.localDirectoryRootNode)) {
            return this.localDirectoryTreeModel;
        }
        return this.favouritesTreeModel;
    }

    public boolean componentIsTheLocalCorpusTree(Component componentToTest) {
        return componentToTest.equals(this.arbilTreePanel.localCorpusTree);
    }

    public boolean componentIsTheFavouritesTree(Component componentToTest) {
        return componentToTest.equals(this.arbilTreePanel.favouritesTree);
    }

    public void setTrees(ArbilTreePanels arbilTreePanelLocal) {
        this.arbilTreePanel = arbilTreePanelLocal;
        this.remoteCorpusRootNode.setUserObject(new JLabel("Remote Corpus", ImdiIcons.getSingleInstance().serverIcon, 2));
        this.localCorpusRootNode.setUserObject(new JLabel("Local Corpus", ImdiIcons.getSingleInstance().directoryIcon, 2));
        this.localDirectoryRootNode.setUserObject(new JLabel("Working Directories", ImdiIcons.getSingleInstance().computerIcon, 2));
        this.favouritesRootNode.setUserObject(new JLabel("Favourites", ImdiIcons.getSingleInstance().favouriteIcon, 2));
        this.arbilTreePanel.remoteCorpusTree.setName("RemoteCorpusTree");
        this.arbilTreePanel.localCorpusTree.setName("LocalCorpusTree");
        this.arbilTreePanel.localDirectoryTree.setName("LocalDirectoryTree");
        this.arbilTreePanel.favouritesTree.setName("FavouritesTree");
        this.applyRootLocations();
    }

    public int addDefaultCorpusLocations() {
        HashSet<ImdiTreeObject> remoteCorpusNodesSet = new HashSet<ImdiTreeObject>();
        remoteCorpusNodesSet.addAll(Arrays.asList(this.remoteCorpusNodes));
        for (String currentUrlString : new String[]{"http://corpus1.mpi.nl/IMDI/metadata/IMDI.imdi", "http://corpus1.mpi.nl/qfs1/media-archive/Corpusstructure/MPI.imdi", "http://corpus1.mpi.nl/qfs1/media-archive/Corpusstructure/sign_language.imdi"}) {
            try {
                remoteCorpusNodesSet.add(ImdiLoader.getSingleInstance().getImdiObject(null, new URI(currentUrlString)));
            }
            catch (URISyntaxException ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
        this.remoteCorpusNodes = remoteCorpusNodesSet.toArray(new ImdiTreeObject[0]);
        return remoteCorpusNodesSet.size();
    }

    public void saveLocations(ImdiTreeObject[] nodesToAdd, ImdiTreeObject[] nodesToRemove) {
        try {
            HashSet<String> locationsSet = new HashSet<String>();
            ImdiTreeObject[][] arr$ = new ImdiTreeObject[][]{this.remoteCorpusNodes, this.localCorpusNodes, this.localFileNodes, this.favouriteNodes};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ImdiTreeObject[] imdiTreeObjectArray;
                for (ImdiTreeObject currentLocation : imdiTreeObjectArray = arr$[i$]) {
                    locationsSet.add(currentLocation.getUrlString());
                }
            }
            if (nodesToAdd != null) {
                for (ImdiTreeObject[] imdiTreeObjectArray : nodesToAdd) {
                    locationsSet.add(imdiTreeObjectArray.getUrlString());
                }
            }
            if (nodesToRemove != null) {
                for (ImdiTreeObject[] imdiTreeObjectArray : nodesToRemove) {
                    locationsSet.remove(imdiTreeObjectArray.getUrlString());
                }
            }
            Vector<String> locationsList = new Vector<String>();
            for (String currentLocation : locationsSet) {
                locationsList.add(URLDecoder.decode(currentLocation, "UTF-8"));
            }
            LinorgSessionStorage.getSingleInstance().saveStringArray("locationsList", locationsList.toArray(new String[0]));
            System.out.println("saved locationsList");
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public void loadLocationsList() {
        try {
            System.out.println("loading locationsList");
            String[] locationsArray = LinorgSessionStorage.getSingleInstance().loadStringArray("locationsList");
            Vector<ImdiTreeObject> remoteCorpusNodesVector = new Vector<ImdiTreeObject>();
            Vector<ImdiTreeObject> localCorpusNodesVector = new Vector<ImdiTreeObject>();
            Vector<ImdiTreeObject> localFileNodesVector = new Vector<ImdiTreeObject>();
            Vector<ImdiTreeObject> favouriteNodesVector = new Vector<ImdiTreeObject>();
            for (String currentLocationString : locationsArray) {
                URI currentLocation = ImdiTreeObject.conformStringToUrl(currentLocationString);
                ImdiTreeObject currentTreeObject = ImdiLoader.getSingleInstance().getImdiObject(null, currentLocation);
                if (currentTreeObject.isLocal()) {
                    if (currentTreeObject.isFavorite()) {
                        favouriteNodesVector.add(currentTreeObject);
                        continue;
                    }
                    if (LinorgSessionStorage.getSingleInstance().pathIsInsideCache(currentTreeObject.getFile())) {
                        if (!currentTreeObject.isMetaDataNode() || currentTreeObject.isImdiChild()) continue;
                        localCorpusNodesVector.add(currentTreeObject);
                        continue;
                    }
                    localFileNodesVector.add(currentTreeObject);
                    continue;
                }
                remoteCorpusNodesVector.add(currentTreeObject);
            }
            this.remoteCorpusNodes = remoteCorpusNodesVector.toArray(new ImdiTreeObject[0]);
            this.localCorpusNodes = localCorpusNodesVector.toArray(new ImdiTreeObject[0]);
            this.localFileNodes = localFileNodesVector.toArray(new ImdiTreeObject[0]);
            this.favouriteNodes = favouriteNodesVector.toArray(new ImdiTreeObject[0]);
        }
        catch (Exception ex) {
            System.out.println("load locationsList failed: " + ex.getMessage());
            this.addDefaultCorpusLocations();
            System.out.println("created new locationsList");
        }
        this.showHiddenFilesInTree = LinorgSessionStorage.getSingleInstance().loadBoolean("showHiddenFilesInTree", this.showHiddenFilesInTree);
    }

    public void setShowHiddenFilesInTree(boolean showState) {
        this.showHiddenFilesInTree = showState;
        this.reloadNodesInTree(this.localDirectoryRootNode);
        try {
            LinorgSessionStorage.getSingleInstance().saveBoolean("showHiddenFilesInTree", this.showHiddenFilesInTree);
        }
        catch (Exception ex) {
            System.out.println("save showHiddenFilesInTree failed");
        }
    }

    public void addLocationGui(URI addableLocation) {
        if (!this.addLocation(addableLocation)) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The location already exists and cannot be added again", "Add location");
        }
        this.applyRootLocations();
    }

    public boolean addLocation(URI addedLocation) {
        System.out.println("addLocation: " + addedLocation.toString());
        ImdiTreeObject addedLocationObject = ImdiLoader.getSingleInstance().getImdiObject(null, addedLocation);
        if (addedLocationObject != null) {
            this.saveLocations(new ImdiTreeObject[]{addedLocationObject}, null);
            this.loadLocationsList();
            return true;
        }
        return false;
    }

    public void removeLocation(ImdiTreeObject removeObject) {
        if (removeObject != null) {
            this.saveLocations(null, new ImdiTreeObject[]{removeObject});
            this.loadLocationsList();
        }
    }

    public void removeLocation(URI removeLocation) {
        System.out.println("removeLocation: " + removeLocation);
        this.removeLocation(ImdiLoader.getSingleInstance().getImdiObject(null, removeLocation));
    }

    private void reloadNodesInTree(DefaultMutableTreeNode parentTreeNode) {
        Enumeration<TreeNode> childNodesEnum = parentTreeNode.children();
        while (childNodesEnum.hasMoreElements()) {
            this.reloadNodesInTree((DefaultMutableTreeNode)childNodesEnum.nextElement());
        }
        if (parentTreeNode.getUserObject() instanceof ImdiTreeObject && ((ImdiTreeObject)parentTreeNode.getUserObject()).imdiDataLoaded) {
            ((ImdiTreeObject)parentTreeNode.getUserObject()).reloadNode();
        }
    }

    public boolean locationsHaveBeenAdded() {
        return this.localCorpusNodes.length > 0;
    }

    public void applyRootLocations() {
        System.out.println("applyRootLocations");
        this.arbilTreePanel.localCorpusTree.rootNodeChildren = this.localCorpusNodes;
        this.arbilTreePanel.remoteCorpusTree.rootNodeChildren = this.remoteCorpusNodes;
        this.arbilTreePanel.localDirectoryTree.rootNodeChildren = this.localFileNodes;
        this.arbilTreePanel.favouritesTree.rootNodeChildren = this.favouriteNodes;
        this.arbilTreePanel.localCorpusTree.requestResort();
        this.arbilTreePanel.remoteCorpusTree.requestResort();
        this.arbilTreePanel.localDirectoryTree.requestResort();
        this.arbilTreePanel.favouritesTree.requestResort();
    }

    public DefaultMutableTreeNode getLocalCorpusTreeSingleSelection() {
        System.out.println("localCorpusTree: " + this.arbilTreePanel.localCorpusTree);
        return (DefaultMutableTreeNode)this.arbilTreePanel.localCorpusTree.getSelectionPath().getLastPathComponent();
    }

    public void deleteNode(Object sourceObject) {
        System.out.println("deleteNode: " + sourceObject);
        DefaultMutableTreeNode selectedTreeNode = null;
        DefaultMutableTreeNode parentTreeNode = null;
        if (sourceObject == this.arbilTreePanel.localCorpusTree) {
            TreePath[] currentNodePaths = ((ImdiTree)sourceObject).getSelectionPaths();
            int toDeleteCount = 0;
            for (TreePath currentNodePath : currentNodePaths) {
                Object userObject;
                if (currentNodePath == null || !((userObject = (selectedTreeNode = (DefaultMutableTreeNode)currentNodePath.getLastPathComponent()).getUserObject()) instanceof ImdiTreeObject)) continue;
                if (((ImdiTreeObject)userObject).isEmptyMetaNode()) {
                    toDeleteCount += ((ImdiTreeObject)userObject).getChildCount();
                    continue;
                }
                ++toDeleteCount;
            }
            if (0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Delete " + toDeleteCount + " nodes?", "Delete", 0, -1)) {
                Vector<ImdiTreeObject> imdiNodesToRemove = new Vector<ImdiTreeObject>();
                Hashtable imdiNodesDeleteList = new Hashtable();
                Hashtable imdiChildNodeDeleteList = new Hashtable();
                for (TreePath currentNodePath : currentNodePaths) {
                    if (currentNodePath == null) continue;
                    selectedTreeNode = (DefaultMutableTreeNode)currentNodePath.getLastPathComponent();
                    Object userObject = selectedTreeNode.getUserObject();
                    System.out.println("trying to delete: " + userObject);
                    if (currentNodePath.getPath().length == 2) {
                        System.out.println("removing by location");
                        this.removeLocation((ImdiTreeObject)selectedTreeNode.getUserObject());
                        this.applyRootLocations();
                    } else {
                        System.out.println("deleting from parent");
                        parentTreeNode = (DefaultMutableTreeNode)selectedTreeNode.getParent();
                        if (parentTreeNode != null) {
                            System.out.println("found parent to remove from");
                            ImdiTreeObject parentImdiNode = (ImdiTreeObject)parentTreeNode.getUserObject();
                            ImdiTreeObject childImdiNode = (ImdiTreeObject)selectedTreeNode.getUserObject();
                            if (childImdiNode.isImdiChild()) {
                                if (!imdiChildNodeDeleteList.containsKey(childImdiNode.getParentDomNode())) {
                                    imdiChildNodeDeleteList.put(childImdiNode.getParentDomNode(), new Vector());
                                }
                                if (childImdiNode.isEmptyMetaNode()) {
                                    for (ImdiTreeObject metaChildNode : childImdiNode.getChildArray()) {
                                        ((Vector)imdiChildNodeDeleteList.get(childImdiNode.getParentDomNode())).add(metaChildNode.getURI().getFragment());
                                    }
                                }
                                ((Vector)imdiChildNodeDeleteList.get(childImdiNode.getParentDomNode())).add(childImdiNode.getURI().getFragment());
                            } else {
                                if (!imdiNodesDeleteList.containsKey(parentImdiNode)) {
                                    imdiNodesDeleteList.put(parentImdiNode, new Vector());
                                }
                                ((Vector)imdiNodesDeleteList.get(parentImdiNode)).add(childImdiNode);
                            }
                        }
                    }
                    imdiNodesToRemove.add((ImdiTreeObject)userObject);
                    ((ImdiTreeObject)userObject).getAllChildren(imdiNodesToRemove);
                }
                for (ImdiTreeObject currentParent : imdiChildNodeDeleteList.keySet()) {
                    System.out.println("deleting by child xml id link");
                    CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
                    boolean result = componentBuilder.removeChildNodes(currentParent, ((Vector)imdiChildNodeDeleteList.get(currentParent)).toArray(new String[0]));
                    if (result) {
                        currentParent.reloadNode();
                        continue;
                    }
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error deleting node, check the log file via the help menu for more information.", "Delete Node");
                }
                for (ImdiTreeObject currentParent : imdiNodesDeleteList.keySet()) {
                    System.out.println("deleting by corpus link");
                    currentParent.deleteCorpusLink(((Vector)imdiNodesDeleteList.get(currentParent)).toArray(new ImdiTreeObject[0]));
                }
                Enumeration deletedNodesEnum = imdiNodesToRemove.elements();
                while (deletedNodesEnum.hasMoreElements()) {
                    ImdiTreeObject currentDeletedNode = (ImdiTreeObject)deletedNodesEnum.nextElement();
                    for (Object currentContainer : currentDeletedNode.getRegisteredContainers()) {
                        if (!(currentContainer instanceof ImdiTableModel)) continue;
                        ((ImdiTableModel)currentContainer).removeImdiObjects(new ImdiTreeObject[]{currentDeletedNode});
                    }
                }
            }
        } else {
            System.out.println("cannot delete from this tree");
        }
    }

    public void jumpToSelectionInTree(boolean silent, ImdiTreeObject cellImdiNode) {
        System.out.println("jumpToSelectionInTree: " + cellImdiNode);
        if (cellImdiNode != null) {
            cellImdiNode.scrollToRequested = true;
            cellImdiNode.clearIcon();
        } else if (!silent) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The selected cell has no value or is not associated with a node in the tree", "Jump to in Tree");
        }
    }
}

