/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.templates.ArbilTemplateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateDialogue
extends JPanel
implements ActionListener {
    JDialog parentFrame;
    private JPanel clarinPanel;
    private JButton jButton1;
    private JButton jButton3;
    protected JPanel internalTemplatesPanel;
    protected JPanel clarinProfilesPanel;
    private JPanel jPanel4;
    protected JPanel internalTemplatesButtonPanel;
    private JProgressBar jProgressBar1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField1;
    protected JPanel templatesPanel;

    public TemplateDialogue(JDialog parentFrameLocal) {
        this.parentFrame = parentFrameLocal;
        this.initComponents();
    }

    private void initComponents() {
        this.internalTemplatesPanel = new JPanel();
        this.internalTemplatesButtonPanel = new JPanel();
        this.jButton3 = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.templatesPanel = new JPanel();
        this.clarinProfilesPanel = new JPanel();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jProgressBar1 = new JProgressBar();
        this.jScrollPane1 = new JScrollPane();
        this.clarinPanel = new JPanel();
        this.jTextField1 = new JTextField();
        this.internalTemplatesPanel.setBorder(BorderFactory.createTitledBorder("Internal Templates"));
        this.internalTemplatesPanel.setLayout(new BorderLayout());
        this.internalTemplatesButtonPanel.setLayout(new BoxLayout(this.internalTemplatesButtonPanel, 2));
        this.jButton3.setText("New Template");
        this.jButton3.setToolTipText("Create a new editable template");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplateDialogue.this.jButton3ActionPerformed(evt);
            }
        });
        this.internalTemplatesButtonPanel.add(this.jButton3);
        this.internalTemplatesPanel.add((Component)this.internalTemplatesButtonPanel, "Last");
        this.jScrollPane2.setViewportView(this.templatesPanel);
        this.internalTemplatesPanel.add((Component)this.jScrollPane2, "Center");
        this.clarinProfilesPanel.setBorder(BorderFactory.createTitledBorder("Clarin Profiles"));
        this.clarinProfilesPanel.setLayout(new BorderLayout());
        this.jPanel4.setLayout(new BoxLayout(this.jPanel4, 2));
        this.jButton1.setText("Reload Clarin Profiles");
        this.jButton1.setToolTipText("Download the latest clarin profiles");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplateDialogue.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jPanel4.add(this.jProgressBar1);
        this.clarinProfilesPanel.add((Component)this.jPanel4, "Last");
        this.jScrollPane1.setViewportView(this.clarinPanel);
        this.clarinProfilesPanel.add((Component)this.jScrollPane1, "Center");
        JPanel profilesTopPanel = new JPanel();
        profilesTopPanel.setLayout(new BoxLayout(profilesTopPanel, 2));
        JButton addButton = new JButton();
        addButton.setText("Add URL");
        addButton.setToolTipText("Add a profile URL to the list");
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String newDirectoryName = JOptionPane.showInputDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Enter the profile URL", "Add Profile", -1, null, null, null).toString();
                ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + newDirectoryName);
                TemplateDialogue.this.populateLists();
            }
        });
        profilesTopPanel.add(addButton);
        JButton browseButton = new JButton();
        browseButton.setText("Add File");
        browseButton.setToolTipText("Browse for local profiles");
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (File selectedFile : LinorgWindowManager.getSingleInstance().showFileSelectBox("Select Profile", false, true, false)) {
                    ArbilTemplateManager.getSingleInstance().addSelectedTemplates("custom:" + selectedFile.toURI().toString());
                }
                TemplateDialogue.this.populateLists();
            }
        });
        profilesTopPanel.add(browseButton);
        this.clarinProfilesPanel.add((Component)profilesTopPanel, "First");
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridLayout(1, 0));
        outerPanel.add(this.internalTemplatesPanel);
        outerPanel.add(this.clarinProfilesPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)outerPanel, "Center");
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TemplateDialogue.this.parentFrame.setVisible(false);
            }
        });
        JPanel closeButtonPanel = new JPanel();
        closeButtonPanel.setLayout(new BorderLayout());
        closeButtonPanel.add((Component)closeButton, "After");
        this.add((Component)outerPanel, "Center");
        this.add((Component)closeButtonPanel, "Last");
    }

    public void loadProfiles(final boolean forceUpdate) {
        this.clarinPanel.removeAll();
        this.clarinPanel.add(new JTextField("Loading..."));
        this.jButton1.setVisible(false);
        this.jProgressBar1.setVisible(true);
        this.doLayout();
        new Thread("loadProfiles"){

            public void run() {
                CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
                cmdiProfileReader.refreshProfiles(TemplateDialogue.this.jProgressBar1, forceUpdate);
                TemplateDialogue.this.jProgressBar1.setVisible(false);
                TemplateDialogue.this.jButton1.setVisible(true);
                TemplateDialogue.this.populateLists();
                TemplateDialogue.this.doLayout();
            }
        }.start();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.loadProfiles(true);
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        try {
            File freshTemplateFile;
            String newDirectoryName = JOptionPane.showInputDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Enter the name for the new template", LinorgWindowManager.getSingleInstance().linorgFrame.getTitle(), -1, null, null, null).toString();
            if (ArbilTemplateManager.getSingleInstance().getTemplateFile(newDirectoryName).exists()) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The template \"" + newDirectoryName + "\" already exists.", "Templates");
            }
            if ((freshTemplateFile = ArbilTemplateManager.getSingleInstance().createTemplate(newDirectoryName)) != null) {
                GuiHelper.getSingleInstance().openFileInExternalApplication(freshTemplateFile.toURI());
                GuiHelper.getSingleInstance().openFileInExternalApplication(freshTemplateFile.getParentFile().toURI());
            } else {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The template \"" + newDirectoryName + "\" could not be created.", "Templates");
            }
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        this.populateLists();
    }

    protected void addSorted(JPanel targetPanel, ArrayList<JCheckBox> checkBoxArray) {
        targetPanel.removeAll();
        targetPanel.setLayout(new BoxLayout(targetPanel, 3));
        Collections.sort(checkBoxArray, new Comparator(){

            public int compare(Object firstItem, Object secondItem) {
                return ((JCheckBox)firstItem).getText().compareToIgnoreCase(((JCheckBox)secondItem).getText());
            }
        });
        for (JCheckBox checkBox : checkBoxArray) {
            targetPanel.add(checkBox);
        }
        this.parentFrame.pack();
    }

    protected void populateLists() {
        JCheckBox templateCheckBox;
        ArrayList<String> selectedTamplates = ArbilTemplateManager.getSingleInstance().getSelectedTemplateArrayList();
        ArrayList<JCheckBox> checkBoxArray = new ArrayList<JCheckBox>();
        for (String[] stringArray : ArbilTemplateManager.getSingleInstance().getTemplate(null).rootTemplatesArray) {
            templateCheckBox = new JCheckBox();
            templateCheckBox.setText(stringArray[1] + " (internal)");
            templateCheckBox.setName(stringArray[1]);
            templateCheckBox.setActionCommand("builtin:" + stringArray[0]);
            templateCheckBox.setSelected(selectedTamplates.contains(templateCheckBox.getActionCommand()));
            templateCheckBox.setToolTipText(stringArray[1]);
            templateCheckBox.addActionListener(this);
            checkBoxArray.add(templateCheckBox);
        }
        for (String[] stringArray : ArbilTemplateManager.getSingleInstance().getAvailableTemplates()) {
            templateCheckBox = new JCheckBox();
            templateCheckBox.setText((String)stringArray);
            templateCheckBox.setName((String)stringArray);
            templateCheckBox.setActionCommand("template:" + (String)stringArray);
            templateCheckBox.setSelected(selectedTamplates.contains(templateCheckBox.getActionCommand()));
            templateCheckBox.setToolTipText((String)stringArray);
            templateCheckBox.addActionListener(this);
            checkBoxArray.add(templateCheckBox);
        }
        this.addSorted(this.templatesPanel, checkBoxArray);
        checkBoxArray.clear();
        CmdiProfileReader cmdiProfileReader = CmdiProfileReader.getSingleInstance();
        for (CmdiProfileReader.CmdiProfile currentCmdiProfile : cmdiProfileReader.cmdiProfileArray) {
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setText(currentCmdiProfile.name);
            jCheckBox.setName(currentCmdiProfile.name);
            jCheckBox.setActionCommand("clarin:" + currentCmdiProfile.getXsdHref());
            jCheckBox.setSelected(selectedTamplates.contains(jCheckBox.getActionCommand()));
            jCheckBox.setToolTipText(currentCmdiProfile.description);
            jCheckBox.addActionListener(this);
            checkBoxArray.add(jCheckBox);
        }
        for (String currentSepectedProfile : selectedTamplates) {
            if (!currentSepectedProfile.startsWith("custom:")) continue;
            String string = currentSepectedProfile.substring("custom:".length());
            String customName = currentSepectedProfile.substring(currentSepectedProfile.lastIndexOf("/") + 1);
            JCheckBox clarinProfileCheckBox = new JCheckBox();
            clarinProfileCheckBox.setText(customName);
            clarinProfileCheckBox.setName(customName);
            clarinProfileCheckBox.setActionCommand(string);
            clarinProfileCheckBox.setSelected(true);
            clarinProfileCheckBox.setToolTipText("custom profile, uncheck to remove");
            clarinProfileCheckBox.addActionListener(this);
            checkBoxArray.add(clarinProfileCheckBox);
        }
        this.addSorted(this.clarinPanel, checkBoxArray);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (((JCheckBox)e.getSource()).isSelected()) {
            ArbilTemplateManager.getSingleInstance().addSelectedTemplates(e.getActionCommand());
        } else {
            ArbilTemplateManager.getSingleInstance().removeSelectedTemplates(e.getActionCommand());
        }
    }

    public static void showTemplatesDialogue() {
        TemplateDialogue.showDialogue("Available Templates & Profiles");
    }

    protected static void showDialogue(String titleStirng) {
        JDialog dialog = new JDialog(LinorgWindowManager.getSingleInstance().linorgFrame, titleStirng, true);
        TemplateDialogue templateDialogue = new TemplateDialogue(dialog);
        dialog.setContentPane(templateDialogue);
        templateDialogue.populateLists();
        templateDialogue.loadProfiles(false);
        dialog.pack();
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        TemplateDialogue.showTemplatesDialogue();
        System.exit(0);
    }
}

