/*
 * Decompiled with CFR 0.152.
 */
package mpi.bcarchive.spider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import mpi.bcarchive.spider.AbstractIMDINodeHandler;
import mpi.bcarchive.spider.IMDISpider;
import mpi.bcarchive.typecheck.DeepFileType;
import mpi.bcarchive.typecheck.FileType;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.CorpusStructureDBWrite;
import mpi.corpusstructure.CorpusStructureDBWriteImpl;
import mpi.corpusstructure.Node;
import mpi.corpusstructure.UnknownNodeException;
import mpi.corpusstructure.UpdateInProgressException;
import mpi.util.Checksum;
import mpi.util.OurURL;
import org.apache.log4j.Logger;

public class ResourceChecker
extends AbstractIMDINodeHandler {
    private static Logger logger = Logger.getLogger((String)ResourceChecker.class.getName());
    public static final int largeFileSize = 0x6000000;
    public static final int WRITTEN = 42;
    public static final int MEDIA = 43;
    public static final int LEXICON = 44;
    public static final int INFO = 45;
    public static final int CORPUS = 46;
    public static final int SESSION = 47;
    private static FileType fileType = new FileType();
    private static DeepFileType deepFileType = new DeepFileType();
    private static String trueString = "true";
    private boolean deep = true;
    private CorpusStructureDB csdb = null;
    private CorpusStructureDBWrite csdbwr = null;
    private ArchiveObjectsDB aodb = null;
    private ArchiveObjectsDBWrite aodbwr = null;
    private boolean md5mode = false;

    public ResourceChecker() {
    }

    public ResourceChecker(boolean deepCheck, CorpusStructureDB dbRead, ArchiveObjectsDB resolv, boolean md5) {
        this.deep = deepCheck;
        this.csdb = dbRead;
        this.aodb = resolv;
        this.md5mode = md5;
    }

    public ResourceChecker(CorpusStructureDBWrite dbWrite, ArchiveObjectsDBWrite aoWrite, boolean deepCheck, ArchiveObjectsDB resolv, boolean md5) {
        this.deep = deepCheck;
        this.csdbwr = dbWrite;
        this.csdb = dbWrite;
        this.aodbwr = aoWrite;
        this.aodb = resolv;
        this.md5mode = md5;
    }

    public static void main(String[] args) {
        OurURL url = null;
        int base = 0;
        boolean deep = true;
        boolean md5 = false;
        CorpusStructureDBImpl csdb = null;
        CorpusStructureDBWrite csdbwr = null;
        CorpusStructureDBImpl aodb = null;
        CorpusStructureDBWriteImpl aodbwr = null;
        while (args.length > 1 + base) {
            CorpusStructureDBWriteImpl csdbi;
            if ("-deep".equals(args[base])) {
                deep = true;
                ++base;
                continue;
            }
            if ("-shallow".equals(args[base])) {
                deep = false;
                ++base;
                continue;
            }
            if ("-checkdb".equals(args[base]) || "-checkmd5".equals(args[base])) {
                CorpusStructureDBImpl csdbi2 = new CorpusStructureDBImpl(args[base + 1]);
                if (!csdbi2.getStatus()) {
                    csdbi2 = null;
                }
                csdb = csdbi2;
                aodb = csdbi2;
                md5 = args[base].indexOf("md5") != -1;
                base += 2;
                continue;
            }
            if (!"-updatedb".equals(args[base]) && !"-updatemd5".equals(args[base])) break;
            String user = null;
            String pass = null;
            if (args.length > 2 + base) {
                user = args[base + 2];
            }
            if (args.length > 3 + base) {
                pass = args[base + 3];
            }
            if (!(csdbi = new CorpusStructureDBWriteImpl(args[base + 1], false, user, pass)).getStatus()) {
                csdbi = null;
            }
            csdbwr = csdbi;
            aodbwr = csdbi;
            aodb = csdbi;
            md5 = args[base].indexOf("md5") != -1;
            base += 4;
        }
        if (args.length != 1 + base || !args[base].startsWith("file:")) {
            System.out.println("Usage:\nResourceChecker [-deep|-shallow] [DBargs] file:/some/place.imdi\n");
            System.out.println("Checks if all descendant resources below place.imdi are of a proper");
            System.out.println("file type / in an archivable file format, and which format is used.\n");
            System.out.println("  -deep   selects deep / extended file content checks");
            System.out.println("  -shallow   minimizes I/O by doing only easy checks\n");
            System.out.println("DBargs can be:");
            System.out.println("  -checkdb jdbc-url   to compare mimetypes to corpusstructure DB data");
            System.out.println("  -updatedb jdbc-url user pass   to update type data in corpusstructure DB");
            System.out.println("  -checkmd5 jdbc-url   to compare checksums to corpusstructure DB data");
            System.out.println("  -updatemd5 jdbc-url user pass   to update checksums in corpusstructure DB\n");
            System.out.println("If no DBargs option is given, mimetypes are only logged, not compared to DB.");
            System.out.println("For md5 checks, deep/shallow refers to check/skip large files respectively.");
            System.exit(1);
        }
        try {
            url = new OurURL(args[base]);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null) {
            System.out.println("Invalid URL: " + args[base]);
            System.exit(1);
        }
        IMDISpider sp = new IMDISpider();
        ResourceChecker rc = null;
        rc = csdbwr != null ? new ResourceChecker(csdbwr, aodbwr, deep, aodb, md5) : (csdb != null ? new ResourceChecker(deep, csdb, aodb, md5) : new ResourceChecker(deep, null, null, false));
        sp.run(url, rc, true);
        if (csdbwr != null) {
            csdbwr.shutdown();
        }
        if (aodbwr != null) {
            csdbwr.shutdown();
        }
    }

    public boolean handleCorpus(OurURL imdifile, OurURL parent) {
        return this.checkFileType(imdifile, 46);
    }

    public boolean handleSession(OurURL imdifile, OurURL corpus) {
        return this.checkFileType(imdifile, 47);
    }

    public boolean handleLexicon(OurURL imdifile, OurURL parent) {
        logger.debug((Object)"Lexicon: Treated as session file");
        return this.checkFileType(imdifile, 47);
    }

    public boolean handleCatalogue(OurURL imdifile, OurURL parent) {
        logger.debug((Object)"Catalogue: Treated as written resource");
        return this.checkFileType(imdifile, 42);
    }

    public boolean handleMediaFile(OurURL session, OurURL resource, String path, OurURL corpus) {
        return this.checkFileType(resource, 43);
    }

    public boolean handleWrittenResource(OurURL session, OurURL resource, String path, OurURL corpus) {
        return this.checkFileType(resource, 42);
    }

    public boolean handleLexiconResource(OurURL session, OurURL resource, String path, OurURL corpus) {
        return this.checkFileType(resource, 44);
    }

    public boolean handleInfoFile(OurURL session, OurURL resource, String path, OurURL corpus) {
        return this.checkFileType(resource, 45);
    }

    public boolean handleLinkError(OurURL file, OurURL parent) {
        logger.warn((Object)("Dead link: " + file + " (from: " + parent + ")"));
        return true;
    }

    public boolean handleParseError(OurURL file, OurURL parent) {
        logger.warn((Object)("Parse error: " + file));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkFileType(OurURL url, int imdiType) {
        String dbType;
        String what;
        block46: {
            block45: {
                Node node;
                String contentType;
                block47: {
                    block48: {
                        what = null;
                        String nodeId = null;
                        dbType = null;
                        contentType = null;
                        InputStream iStream = null;
                        if (url.toString().endsWith("/")) {
                            logger.info((Object)("URL without a file basename, skipped: " + url));
                            return true;
                        }
                        if (!"file".equals(url.getProtocol())) {
                            logger.info((Object)("Possibly remote item skipped, not a 'file' URL: " + url));
                            return true;
                        }
                        if (this.md5mode) {
                            File checkedFile = new File(url.getFile());
                            if (!checkedFile.canRead()) {
                                if (!checkedFile.exists()) {
                                    logger.warn((Object)("File not found: " + url));
                                    return false;
                                }
                                logger.warn((Object)("File not checked, cannot read: " + url));
                                return false;
                            }
                            if (!checkedFile.isFile()) {
                                logger.warn((Object)("File not checked, no normal file: " + url));
                                return false;
                            }
                            if (checkedFile.length() > 0x6000000L && !this.deep) {
                                logger.info((Object)("Large file, use -deep option to check. Size: " + checkedFile.length() + " location: " + url));
                                return true;
                            }
                            String md5 = Checksum.create(checkedFile.toString());
                            if (this.aodb == null) {
                                logger.info((Object)("md5sum is " + md5 + " for file: " + url));
                                return true;
                            }
                            String dbmd5 = null;
                            nodeId = this.aodb.getObjectId(url);
                            if (nodeId == null) {
                                logger.warn((Object)("Cannot compare md5sum, node not known in DB: " + url));
                                return true;
                            }
                            try {
                                dbmd5 = this.aodb.getObjectChecksum(nodeId);
                                if (dbmd5 != null && dbmd5.length() == 0) {
                                    dbmd5 = null;
                                }
                            }
                            catch (UnknownNodeException une) {
                                // empty catch block
                            }
                            if (this.aodbwr == null) {
                                if (dbmd5 != null && !md5.equalsIgnoreCase(dbmd5)) {
                                    logger.warn((Object)("md5sum is now " + md5 + " but DB said it should be " + dbmd5 + " for: " + url));
                                    return false;
                                }
                                if (dbmd5 == null) {
                                    logger.info((Object)("md5sum is " + md5 + " (new) for: " + url));
                                    return true;
                                }
                                logger.debug((Object)("md5sum is " + md5 + " (ok) for: " + url));
                                return true;
                            }
                            if (dbmd5 == null || md5.equalsIgnoreCase(dbmd5)) {
                                if (dbmd5 != null) {
                                    logger.debug((Object)("md5sum is " + md5 + " (okay) for: " + url));
                                    return true;
                                }
                                logger.info((Object)("md5sum is " + md5 + " (added) for: " + url));
                            } else {
                                logger.warn((Object)("md5sum is now " + md5 + " but DB said it should be " + dbmd5 + " for: " + url));
                            }
                            try {
                                this.aodbwr.setObjectChecksum(nodeId, md5);
                                return true;
                            }
                            catch (UnknownNodeException une) {
                                logger.error((Object)("Could not update checksum stored for " + nodeId));
                                return false;
                            }
                        }
                        try {
                            iStream = url.openStream();
                            what = this.deep ? deepFileType.checkStream(iStream, url.toString()) : fileType.checkStream(iStream, url.toString());
                            if (!what.startsWith("false UnknownType")) {
                                // empty if block
                            }
                        }
                        catch (IOException ioe) {
                            logger.warn((Object)("Cannot read file at URL: " + url));
                            return false;
                        }
                        if (iStream != null) {
                            try {
                                iStream.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        contentType = FileType.resultToMPIType((String)what);
                        node = null;
                        if (this.aodb != null && this.csdb != null) {
                            nodeId = this.aodb.getObjectId(url);
                            try {
                                if (nodeId != null) {
                                    node = this.csdb.getNode(nodeId);
                                }
                                if (node != null) {
                                    dbType = node.getFormat();
                                }
                            }
                            catch (UnknownNodeException une) {
                                logger.warn((Object)("No Node info for node id: " + nodeId + " url: " + url));
                            }
                        }
                        if (!what.startsWith(trueString) || contentType == null) break block46;
                        if (dbType != null) break block47;
                        if (this.csdbwr == null || node == null) break block48;
                        if (this.updateType(node, contentType)) {
                            if ("text/x-imdi+xml".equals(contentType)) {
                                logger.debug((Object)("Stored IMDI type " + contentType + " in DB entry for: " + url));
                                break block45;
                            } else {
                                logger.info((Object)("Stored resource type " + contentType + " in DB entry for: " + url));
                            }
                            break block45;
                        } else {
                            logger.warn((Object)("Could not store type " + contentType + " in DB entry for: " + url));
                        }
                        break block45;
                    }
                    if (node != null) {
                        if ("text/x-imdi+xml".equals(contentType)) {
                            logger.debug((Object)("Content type of IMDI file " + contentType + " not in DB for: " + url));
                            break block45;
                        } else {
                            logger.warn((Object)("Content type of resource " + contentType + " not in DB for: " + url));
                        }
                    }
                    break block45;
                }
                if (!dbType.equals(contentType)) {
                    if (this.csdbwr != null && node != null) {
                        if (this.updateType(node, contentType)) {
                            logger.info((Object)("Type updated to " + contentType + " in DB, was " + dbType + " for: " + url));
                        } else {
                            logger.warn((Object)("Could not update type to " + contentType + " in DB, still is " + dbType + " for: " + url));
                        }
                    } else if (node != null) {
                        logger.warn((Object)("Content type " + contentType + " differs from DB value " + dbType + " for: " + url));
                    }
                }
            }
            logger.debug((Object)(what + " " + url));
            return true;
        }
        if (dbType != null) {
            logger.warn((Object)(what + " [DB says: " + dbType + "] " + url));
            return false;
        }
        logger.warn((Object)(what + " " + url));
        return false;
    }

    private boolean updateType(Node node, String type) {
        try {
            if (this.csdbwr.setNode(node.getNodeId(), node.getNodeType(), type, node.getName(), node.getTitle())) {
                return true;
            }
        }
        catch (UpdateInProgressException uipe) {
        }
        catch (UnknownNodeException unknownNodeException) {
            // empty catch block
        }
        return false;
    }
}

