/*
 * Decompiled with CFR 0.152.
 */
package mpi.bcarchive.spider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import mpi.bcarchive.spider.AbstractIMDINodeHandler;
import mpi.bcarchive.spider.IMDISpider;
import mpi.bcarchive.typecheck.FileType;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.Node;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.imdi.api.IMDIDom;
import mpi.imdi.api.IMDIEdit;
import mpi.imdi.api.IMDIElement;
import mpi.imdi.api.IMDILink;
import mpi.util.OurURL;
import mpi.util.URIUtil;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class URIDNodeHandler
extends AbstractIMDINodeHandler {
    private static Logger logger = Logger.getLogger((String)URIDNodeHandler.class.getName());
    private static IMDIEdit edit = new IMDIDom();
    private boolean addUrid = false;
    private boolean setUrl = true;
    private boolean delUrid = false;
    private boolean setMime = false;
    private boolean simulate = false;
    private boolean verbose = true;
    private ArchiveAccessContext aac = null;
    private CorpusStructureDB csdb = null;
    private FileType typeChecker = null;
    private int logN = 1;

    public URIDNodeHandler(boolean addURIDs, boolean updateURLs, ArchiveAccessContext userAAC) {
        this.addUrid = addURIDs;
        this.setUrl = updateURLs;
        this.aac = userAAC;
    }

    public void setCsDb(CorpusStructureDB cs) {
        this.csdb = cs;
    }

    public void setSimulation(boolean sim) {
        this.simulate = sim;
    }

    public void setUpdateMime(boolean mimeset) {
        this.setMime = mimeset;
        if (this.setMime && this.typeChecker == null) {
            this.typeChecker = new FileType();
        }
        if (this.typeChecker != null) {
            this.typeChecker.setVerbose(this.verbose);
        }
    }

    public void setRemoveUrid(boolean remove) {
        this.delUrid = remove;
        if (this.delUrid && !this.addUrid) {
            logger.warn((Object)"setRemoveUrid: Will not remove URIDs, addUrid has to be true");
        }
    }

    public void setVerbose(boolean verb) {
        this.verbose = verb;
        edit.setVerbose(verb);
        if (this.typeChecker != null) {
            this.typeChecker.setVerbose(verb);
        }
    }

    public void setArchiveRoots(ArchiveAccessContext userAAC) {
        this.aac = userAAC;
    }

    public ArchiveAccessContext getArchiveRoots() {
        return this.aac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        OurURL url = null;
        boolean seturl = false;
        boolean addurid = false;
        boolean setmime = false;
        boolean delurid = false;
        boolean simulate = false;
        boolean singleNode = false;
        if (args.length > 0 && args[0].equals("seturl")) {
            seturl = true;
        }
        if (args.length > 0 && args[0].equals("seturlsim")) {
            seturl = true;
            simulate = true;
        }
        if (args.length > 0 && args[0].equals("addurid")) {
            addurid = true;
        }
        if (args.length > 0 && args[0].equals("adduridsim")) {
            addurid = true;
            simulate = true;
        }
        if (args.length > 0 && args[0].equals("delurid")) {
            delurid = true;
            addurid = true;
        }
        if (args.length > 0 && args[0].equals("deluridsim")) {
            delurid = true;
            addurid = true;
            simulate = true;
        }
        if (args.length > 0 && args[0].equals("addboth")) {
            addurid = true;
            setmime = true;
        }
        if (args.length > 0 && args[0].equals("addbothsim")) {
            addurid = true;
            setmime = true;
            simulate = true;
        }
        if (args.length < (delurid ? 2 : 3) || args.length > 4 || !seturl && !addurid && !delurid || !args[1].startsWith("file:")) {
            System.out.println("Usage:");
            System.out.println("1st argument: mode (seturl, addurid, addboth, delurid, seturlsim, ...)");
            System.out.println("2nd argument: file: URL of start IMDI file");
            System.out.println("              Use 'file:single:...' style URL to disable recursion");
            System.out.println("3rd argument: jdbc URL for Corpusstructure NODEID/URID resolution");
            System.out.println("4th argument: optional file name for archive roots property file");
            System.out.println();
            System.out.println("Modes:");
            System.out.println("seturl  updates URLs by using URIDs to query a database via JDBC");
            System.out.println("addurid adds or updates URIDs by using URLs to query a database");
            System.out.println("delurid removes URIDs from files  (3rd/4th argument can be omitted)");
            System.out.println("addboth as addurid, also calls ResourceChecker and updates mimetypes");
            System.out.println();
            System.out.println("seturlsim, adduridsim, deluridsim, addbothsim behave as their non-sim");
            System.out.println("counterparts, but changed IMDIs are only written to ./logdom*.xml");
            System.exit(1);
        }
        if (args[1].startsWith("file:single:")) {
            singleNode = true;
            args[1] = "file:" + args[1].substring(12);
        }
        try {
            url = new OurURL(args[1]);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null) {
            System.out.println("Invalid URL: " + args[1]);
            System.exit(1);
        }
        CorpusStructureDBImpl csdb = null;
        CorpusStructureDBImpl aodb = null;
        ArchiveAccessContext myaac = null;
        if (args.length >= 3) {
            CorpusStructureDBImpl csdbi;
            csdb = csdbi = new CorpusStructureDBImpl(args[2]);
            aodb = csdbi;
            myaac = aodb.getArchiveRoots();
            if (!aodb.getStatus()) {
                System.out.println("Failed to open DB: " + args[2]);
                System.exit(1);
            }
        }
        if (args.length == 4) {
            if (!myaac.loadPropertyFile(args[3])) {
                System.out.println("Loading archive roots property file failed, aborting.");
                System.exit(1);
            } else {
                System.out.println("Loaded archive roots from property file " + args[3]);
            }
            aodb.setArchiveRoots(myaac);
        }
        int context = 42;
        if (myaac != null) {
            try {
                context = myaac.getAccessContextFromURI(url.toString());
            }
            catch (NullPointerException npe) {
                System.out.println("Archive roots property file configuration incomplete, cannot find access context");
                System.exit(1);
            }
        }
        if (myaac != null && context != 2 && context != 1) {
            if (delurid) {
                System.out.println("Warning: Start URL is not below file: archive roots directory");
            } else {
                StringBuilder stringBuilder = new StringBuilder().append("Start URL must be 'inside' file: archive roots, fix the roots first! Current root: ");
                aodb.getArchiveRoots();
                System.out.println(stringBuilder.append(ArchiveAccessContext.getFileUrlContext()).toString());
                System.exit(1);
            }
        }
        if (aodb != null) {
            IMDILink.setResolver((ArchiveObjectsDB)aodb, (int)context, (boolean)true);
        } else {
            IMDILink.setResolver(null, (int)-1, (boolean)false);
        }
        URIDNodeHandler nh = new URIDNodeHandler(addurid, seturl, myaac);
        nh.setRemoveUrid(delurid);
        nh.setUpdateMime(setmime);
        nh.setSimulation(simulate);
        nh.setCsDb(csdb);
        try {
            if (singleNode) {
                if (edit.isIMDIFileType(edit.loadIMDIDocument(url, false), 2)) {
                    logger.info((Object)("Processing single IMDI Corpus file: " + (nh.handleCorpus(url, null) ? "okay" : "error") + " URL: " + url));
                } else if (edit.isIMDIFileType(edit.loadIMDIDocument(url, false), 1)) {
                    logger.info((Object)("Processing single IMDI Session file: " + (nh.handleSession(url, null) ? "okay" : "error") + " URL: " + url));
                } else {
                    logger.warn((Object)("Only IMDI Corpus and Session files handled, skipping: " + url));
                }
            } else {
                logger.info((Object)("Recursive IMDI file processing, spider starts at: " + url));
                IMDISpider sp = new IMDISpider();
                sp.run(url, nh, true);
            }
        }
        finally {
            if (aodb != null) {
                aodb.close();
            }
            if (csdb != null) {
                csdb.close();
            }
        }
    }

    public boolean handleCorpus(OurURL imdifile, OurURL parent) {
        return this.handleIMDI(imdifile, 2);
    }

    public boolean handleSession(OurURL imdifile, OurURL corpus) {
        return this.handleIMDI(imdifile, 1);
    }

    public boolean handleLexicon(OurURL imdifile, OurURL parent) {
        logger.warn((Object)("Lexicon files not supported: " + imdifile));
        return false;
    }

    public boolean handleCatalogue(OurURL imdifile, OurURL parent) {
        logger.warn((Object)("Catalogue files not supported: " + imdifile));
        return false;
    }

    public boolean handleLinkError(OurURL file, OurURL parent) {
        logger.warn((Object)("Dead link: " + file + " (from: " + parent + ")"));
        return true;
    }

    public boolean handleParseError(OurURL file, OurURL parent) {
        logger.warn((Object)("Parse error: " + file));
        return true;
    }

    private boolean handleIMDI(OurURL url, int imdiType) {
        if (!this.delUrid) {
            if (!IMDILink.hasResolver()) {
                logger.error((Object)"handleIMDI: cannot work without active IMDILink resolver");
                return false;
            }
            if (this.aac == null) {
                logger.error((Object)"handleIMDI: you have to provide a valid ArchiveAccessContext");
                return false;
            }
            int context = this.aac.getAccessContextFromURI(url.toString());
            if (context != 1 && context != 2) {
                if (context == 3) {
                    logger.error((Object)("Local URLs must be file: URLs. Skipped: " + url));
                    return false;
                }
                URIDNodeHandler uRIDNodeHandler = this;
                logger.warn((Object)("Skipped non-local IMDI, not below our access context " + this.aac.getRoot(uRIDNodeHandler.aac.getFileUrlContext()) + ": " + url));
                return true;
            }
        }
        Document dom = edit.loadIMDIDocument(url, false);
        boolean changed = false;
        if (dom == null) {
            logger.error((Object)("Could not load IMDI, skipped: " + url));
            return false;
        }
        if (!edit.isIMDIFileType(dom, imdiType)) {
            String realType = "an unknown file";
            realType = edit.isIMDIFileType(dom, 2) ? "a corpus" : (edit.isIMDIFileType(dom, 1) ? "a session" : "a catalogue");
            logger.info((Object)("File is not an IMDI " + (imdiType == 2 ? "corpus" : "session") + " but " + realType + " URL: " + url));
            if ("a catalogue".equals(realType)) {
                logger.error((Object)("Only CORPUS and SESSION files supported yet: " + url));
                return false;
            }
        }
        if (imdiType != 2 && imdiType != 1) {
            logger.error((Object)("Only CORPUS and SESSION files supported yet: " + url));
            return false;
        }
        IMDILink[] links = edit.getIMDILinks(dom, url, 6);
        try {
            if (this.addUrid) {
                changed |= this.addURIDs(dom, url, links);
            }
            if (this.setUrl || this.setMime) {
                if (links == null || links.length == 0) {
                    logger.info((Object)("Document contains no links: " + url));
                } else {
                    if (this.setUrl) {
                        changed |= this.setURLs(dom, url, links);
                    }
                    if (this.setMime) {
                        changed |= this.setMimeTypes(dom, url, links);
                    }
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)("Error: " + fnfe.getMessage()));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)"Unexpected error: ", (Throwable)e);
            return false;
        }
        if (changed) {
            File domFile = new File(url.getFile().replaceAll("%20", " "));
            boolean saveOkay = true;
            if (!this.simulate) {
                saveOkay = edit.writeDOM(dom, domFile, true);
            } else if (this.logN > 0) {
                saveOkay = edit.writeDOM(dom, new File("logdom" + this.logN + ".xml"), true);
                ++this.logN;
            }
            if (!saveOkay) {
                logger.error((Object)("Could not save updated IMDI to: " + domFile));
            } else {
                logger.info((Object)((this.simulate ? "Would have saved" : "Saved") + " updated IMDI to: " + domFile));
            }
            return saveOkay;
        }
        return true;
    }

    private boolean addURIDs(Document dom, OurURL url, IMDILink[] links) throws FileNotFoundException {
        boolean changed = false;
        IMDIElement selfHandle = edit.getIMDIElement(dom, "SelfHandle");
        IMDILink selfLink = new IMDILink("SelfHandle", null, 6, url);
        if (!this.delUrid) {
            selfLink.setURIDfromURL();
        }
        String selfURID = selfLink.getURID();
        if (selfHandle != null && selfHandle.getValue() != null && selfHandle.getValue().length() > 0) {
            if (this.delUrid) {
                if (!edit.removeIMDIElement(dom, selfHandle)) {
                    logger.warn((Object)("Removing SelfHandle failed for: " + url));
                } else {
                    logger.debug((Object)("Removed SelfHandle " + selfHandle.getValue() + " from: " + url));
                    changed = true;
                }
            } else if (selfURID == null || selfHandle.getValue().equals(selfURID)) {
                if (this.verbose) {
                    logger.debug((Object)("SelfHandle is: " + selfHandle.getValue() + " for URL: " + url));
                }
            } else {
                logger.warn((Object)("Updated SelfHandle: " + selfHandle.getValue() + " to " + selfURID + " for URL " + url));
                if (!edit.setIMDIValue(dom, "SelfHandle", selfURID)) {
                    logger.warn((Object)("Setting SelfHandle failed for: " + url));
                } else {
                    changed = true;
                }
            }
        } else if (selfURID != null && !this.delUrid) {
            IMDIElement ie = edit.addIMDIElement(dom, "SelfHandle");
            if (ie != null) {
                ie.setValue(selfURID);
            }
            if (ie == null || edit.setIMDIElement(dom, ie) == null) {
                logger.warn((Object)("Setting SelfHandle failed for: " + url));
            } else {
                logger.debug((Object)("Added SelfHandle: " + selfURID + " to " + url));
                changed = true;
            }
        } else if (!this.delUrid) {
            logger.warn((Object)("File has no SelfHandle but no known URID either: " + url));
        }
        for (int i = 0; i < links.length; ++i) {
            int context;
            OurURL target = links[i].getRawURL();
            if (this.delUrid && links[i].getURID() != null) {
                String oldUrid = links[i].getURID();
                links[i].setURID(null);
                if (edit.changeIMDILink(dom, url, links[i])) {
                    logger.debug((Object)("Removed URID: " + oldUrid + " of link to: " + target + " in file: " + url));
                    changed = true;
                } else {
                    logger.warn((Object)("Failed to remove URID: " + links[i].getURID() + " of link to: " + target + " in file: " + url));
                }
            }
            if (this.delUrid || target == null) continue;
            if (links[i].getURID() != null && links[i].getURID().length() > 0) {
                IMDILink compareLink = new IMDILink("Session.Description", null, 6, target);
                compareLink.setURIDfromURL();
                String compareURID = compareLink.getURID();
                if (links[i].getURID().equals(compareURID)) {
                    if (!this.verbose) continue;
                    logger.debug((Object)("Correct URID already present, skipped link: " + links[i].getURID() + " for URL " + target));
                    continue;
                }
                if (compareURID == null || compareURID.length() == 0) {
                    logger.info((Object)("Some URID already present but not in DB right now: " + links[i].getURID() + " for URL " + target));
                    continue;
                }
                logger.warn((Object)("URID mismatch, file contained: " + links[i].getURID() + " changed to: " + compareURID + " for URL " + target));
            }
            if ((context = this.aac.getAccessContextFromURI(target.toString())) == 0 || context == -1) {
                logger.debug((Object)("No URID added for external link: " + target));
                continue;
            }
            if (!links[i].setURIDfromURL()) {
                if (context == 3) {
                    logger.info((Object)("Link to HTTP URL left without URID: " + target));
                    continue;
                }
                File file = new File(target.getFile());
                if (!file.exists()) {
                    logger.warn((Object)("Link to nonexisting file left without URID: " + target));
                    continue;
                }
                throw new FileNotFoundException("Could not add URID for link: " + target);
            }
            if (edit.changeIMDILink(dom, url, links[i])) {
                logger.debug((Object)("Added URID: " + links[i].getURID() + " for " + target));
                changed = true;
                continue;
            }
            logger.warn((Object)("Adding URID: " + links[i].getURID() + " failed for " + target + " in file " + url));
        }
        return changed;
    }

    private boolean setURLs(Document dom, OurURL url, IMDILink[] links) throws FileNotFoundException {
        boolean changed = false;
        File domFile = new File(url.getFile().replaceAll("%20", " "));
        for (int i = 0; i < links.length; ++i) {
            String urid = links[i].getURID();
            OurURL target = links[i].getRawURL();
            File targetFile = null;
            if (urid == null || urid.length() == 0) {
                logger.debug((Object)("No URID stored in IMDI file for: " + target));
                continue;
            }
            links[i].setURL(null);
            links[i].setURL(links[i].getURL());
            if (links[i].getRawURL() != null) {
                String newDef = null;
                OurURL rawURL = links[i].getRawURL();
                if ("file".equals(rawURL.getProtocol())) {
                    targetFile = new File(rawURL.getFile().replaceAll("%20", " "));
                    newDef = URIUtil.calculateRelativeURI(domFile, targetFile);
                } else {
                    newDef = rawURL.getProtocol() != null && rawURL.getProtocol().startsWith("http") ? rawURL.toString().replaceAll(" ", "%20") : rawURL.toString();
                }
                if (newDef.equals(links[i].getLinkDefinition())) continue;
                logger.debug((Object)("Updated URL for URID: " + urid + " -> " + links[i].getRawURL() + " -> " + newDef));
                links[i].setLinkDefinition(newDef);
                links[i].setURL(null);
                edit.changeIMDILink(dom, url, links[i]);
                changed = true;
                continue;
            }
            throw new FileNotFoundException("URID given but could not resolve: " + urid + " old URL: " + links[i].getRawURL());
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setMimeTypes(Document dom, OurURL url, IMDILink[] links) throws FileNotFoundException {
        boolean changed = false;
        for (int i = 0; i < links.length; ++i) {
            OurURL target = links[i].getRawURL();
            String oldMimetype = links[i].getFormat();
            if (links[i].getNodeType() == 2 || links[i].getNodeType() == 1) continue;
            if (!"file".equals(target.getProtocol())) {
                logger.info((Object)("Remote file not typechecked: " + target + " linked from: " + url));
                continue;
            }
            File targetFile = new File(target.getFile().replaceAll("%20", " "));
            FileInputStream fileStream = null;
            try {
                fileStream = new FileInputStream(targetFile);
            }
            catch (FileNotFoundException fnfe) {
                logger.warn((Object)("Cannot access file for typechecking: " + targetFile + " Problem: " + fnfe));
                continue;
            }
            String newMimetype = null;
            try {
                newMimetype = FileType.resultToMPIType((String)this.typeChecker.checkStream((InputStream)fileStream, targetFile.toString()));
            }
            catch (IOException ioe) {
                logger.warn((Object)("File read error while typechecking: " + targetFile + " Problem: " + ioe));
                continue;
            }
            finally {
                try {
                    fileStream.close();
                }
                catch (IOException ioe2) {}
            }
            if (newMimetype == null) {
                logger.warn((Object)("No archivable type, kept user value: " + oldMimetype + " for file: " + targetFile));
                continue;
            }
            if (oldMimetype == null || oldMimetype.toLowerCase().startsWith("un")) {
                if (links[i].getNodeType() == 3) {
                    logger.debug((Object)("Detected mimetype: " + newMimetype + " for info file: " + targetFile));
                    this.updateDbMimetype(newMimetype, links[i]);
                    continue;
                }
                logger.debug((Object)("Changed mimetype from missing/unknown/unspecified to: " + newMimetype + " for file: " + targetFile));
            }
            if (oldMimetype != null && oldMimetype.equalsIgnoreCase(newMimetype)) {
                logger.debug((Object)("Confirmed mimetype: " + newMimetype + " for file: " + targetFile));
                continue;
            }
            logger.warn((Object)("Detected mimetype " + newMimetype + " but IMDI file used: " + oldMimetype + " for file: " + targetFile));
            links[i].setFormat(newMimetype);
            this.updateDbMimetype(newMimetype, links[i]);
            if (edit.changeIMDILink(dom, url, links[i])) {
                logger.debug((Object)("Updated mimetype in link to: " + targetFile + " in: " + url));
                changed = true;
                continue;
            }
            logger.warn((Object)("Failed to update mimetype in link to: " + targetFile + " in: " + url));
        }
        return changed;
    }

    private void updateDbMimetype(String mimeType, IMDILink link) {
        String prefix = this.aac.getHandlePrefix();
        int nodeNr = -1;
        String urid = link.getURID();
        OurURL url = link.getRawURL();
        if (urid.startsWith("hdl:")) {
            urid = urid.substring(4);
        }
        while (urid.startsWith("/")) {
            urid = urid.substring(1);
        }
        if (urid == null || !urid.startsWith(prefix) && url != null) {
            link.setURIDfromURL();
            urid = link.getURID();
            if (urid.startsWith("hdl:")) {
                urid = urid.substring(4);
            }
            while (urid.startsWith("/")) {
                urid = urid.substring(1);
            }
        }
        if (urid != null && urid.startsWith(prefix)) {
            nodeNr = NodeIdUtils.handleToNode(urid, prefix);
        }
        if (nodeNr < 0) {
            logger.warn((Object)("updateDbMimetype: Cannot check, no node ID found for: " + url + " (" + urid + ")"));
            return;
        }
        if (this.csdb != null) {
            Node node = null;
            try {
                node = this.csdb.getNode(NodeIdUtils.TONODEID(nodeNr));
                if (mimeType.equals(node.getFormat())) {
                    logger.info((Object)("updateDbMimetype: Format already was " + mimeType + " in DB at " + NodeIdUtils.TONODEID(nodeNr) + " for: " + link.getURL()));
                    return;
                }
            }
            catch (UnknownNodeException une) {
                logger.warn((Object)("updateDbMimetype: Cannot update, no such node: " + NodeIdUtils.TONODEID(nodeNr) + " for: " + link.getURL()));
                return;
            }
        }
        System.err.println("UPDATE corpusnodes SET format = '" + mimeType + "' WHERE nodeid = " + nodeNr + ";");
        logger.debug((Object)("updateDbMimetype: Logged SQL to set '" + mimeType + "' at " + nodeNr));
    }
}

