/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mpi.bcarchive.spider.IMDINodeHandler;
import mpi.bcarchive.spider.URIDNodeHandler;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.ArchiveObjectsDBWriteImplHS;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBWriteImpl;
import mpi.corpusstructure.Mover;
import mpi.corpusstructure.UnknownNodeException;
import mpi.imdi.api.IMDILink;
import mpi.util.OurURL;
import org.apache.log4j.Logger;

public class ArchiveMover {
    private Logger logger = Logger.getLogger((String)ArchiveMover.class.getName());
    private ArchiveAccessContext aac = null;
    private CorpusStructureDB csdb = null;
    private ArchiveObjectsDB aodb = null;
    private Vector aodbWriters = new Vector();
    private Vector sources = new Vector();
    private Hashtable targets = new Hashtable();
    private HashSet unmanagedFiles = new HashSet();
    private boolean movePhysical = true;
    private boolean simulation = false;
    private boolean simWriteable = false;
    private boolean verbose = true;

    private int parseOptions(String[] argv) throws ArrayIndexOutOfBoundsException {
        ArchiveObjectsDBWrite aodbwr = null;
        ArchiveObjectsDBWrite aodbUrid = null;
        int base = 0;
        if (argv.length < 3 || !argv[0].startsWith("-")) {
            return -1;
        }
        while (base < argv.length && argv[base].startsWith("-")) {
            if (argv[base].equals("-csdb")) {
                String jdbcURL = argv[base + 1];
                String user = argv[base + 2];
                String pass = argv[base + 3];
                if (pass.equals("-")) {
                    pass = "";
                }
                base += 4;
                CorpusStructureDBWriteImpl csdbi = new CorpusStructureDBWriteImpl(jdbcURL, false, user, pass);
                aodbwr = csdbi;
                this.csdb = csdbi;
                this.aodb = csdbi;
                csdbi = null;
                if (aodbwr == null || !aodbwr.getStatus()) {
                    System.out.println("ArchiveObjects CorpusStructure database connection error!");
                    return -2;
                }
                if (this.aodbWriters.size() == 0) {
                    this.aac = aodbwr.getArchiveRoots();
                } else {
                    aodbwr.setArchiveRoots(this.aac);
                }
                if (!aodbwr.canWrite() && !this.simWriteable) {
                    System.out.println("ArchiveObjects CorpusStructure database not writeable!");
                    return -2;
                }
                if (aodbUrid == null) {
                    aodbUrid = aodbwr;
                    ArchiveMover archiveMover = this;
                    IMDILink.setResolver((ArchiveObjectsDB)aodbUrid, (int)archiveMover.aac.getFileUrlContext(), (boolean)true);
                }
                this.aodbWriters.add(aodbwr);
                aodbwr = null;
                continue;
            }
            if (argv[base].equals("-handle")) {
                String configFile = argv[base + 1];
                base += 2;
                aodbwr = new ArchiveObjectsDBWriteImplHS(configFile);
                if (aodbwr == null || !aodbwr.getStatus()) {
                    System.out.println("ArchiveObjects HandleSystem database connection error! Config: " + configFile);
                    return -2;
                }
                if (this.aodbWriters.size() == 0) {
                    this.aac = aodbwr.getArchiveRoots();
                    System.out.println("HandleSystem should not be the first DB, specify a CorpusStructure DB first!");
                    return -2;
                }
                aodbwr.setArchiveRoots(this.aac);
                if (!aodbwr.canWrite() && !this.simWriteable) {
                    System.out.println("ArchiveObjects HandleSystem database not writeable! Config: " + configFile);
                    return -2;
                }
                if (aodbUrid == null) {
                    aodbUrid = aodbwr;
                    ArchiveMover archiveMover = this;
                    IMDILink.setResolver((ArchiveObjectsDB)aodbUrid, (int)archiveMover.aac.getFileUrlContext(), (boolean)false);
                }
                this.aodbWriters.add(aodbwr);
                aodbwr = null;
                continue;
            }
            if (argv[base].equals("-nodb")) {
                ++base;
                continue;
            }
            if (argv[base].equals("-simulate")) {
                this.simulation = true;
                ++base;
                continue;
            }
            if (argv[base].equals("-simforce")) {
                this.simulation = true;
                this.simWriteable = true;
                ++base;
                continue;
            }
            if (argv[base].equals("-quiet")) {
                this.verbose = false;
                ++base;
                continue;
            }
            if (argv[base].equals("-dbonly")) {
                this.movePhysical = false;
                System.out.println("WARNING: Will only modify URLs in database, without moving the files!");
                System.out.println("WARNING: Any IMDI files using the modified URLs are not updated either.");
                ++base;
                continue;
            }
            if (argv[base].equals("-help") || argv[base].equals("--help")) {
                return -1;
            }
            System.out.println("Unknown option: " + argv[base]);
            return -1;
        }
        if (argv.length < base + 2) {
            System.out.println("Provide 1 or more source file names and 1 target directory name");
            System.out.println("or provide 1 source file name and 1 target file name");
            return -1;
        }
        if (this.aac == null) {
            this.aac = new ArchiveAccessContext();
            System.out.println("WARNING: No DB specified, using default root context and handle settings!");
            if (!this.simulation) {
                System.out.println("No DB mode only supported for simulation runs!");
                return -2;
            }
        }
        return base;
    }

    public static void showHelp() {
        System.out.println("This tool moves archive object files while keeping AO database(s) in sync:");
        System.out.println("\nFirst arguments must specify the AO database connection(s),");
        System.out.println("  as '-handle configfile' or as '-csdb jdbcurl user pass' or both.");
        System.out.println("The first -handle or -csdb option also selects the URID resolver");
        System.out.println("  and the archive access roots: All db must use the same table context!");
        System.out.println("The configfile argument points to a Handle System config.dct file.");
        System.out.println("\nExpert options:");
        System.out.println("Add '-nodb' (no options) to specify a null database connection.");
        System.out.println("Add '-dbonly' to modify only the contents of the database(s),");
        System.out.println("  without actually moving / updating the files and IMDIs. DANGEROUS!");
        System.out.println("  Only '-dbonly' mode supports http: source / target specifications.");
        System.out.println("Use '-simulate' to only check what would be changed, without actually");
        System.out.println("  moving files / updating databases. NOTE: This can create debug IMDI");
        System.out.println("  files 'logdom*.xml' in the current directory, so allow writes there.");
        System.out.println("Use '-simforce' instead to simulate and omit check for write permissions");
        System.out.println("Use '-quiet' to reduce verbosity of DEBUG log messages. To get even fewer");
        System.out.println("  messages, set the loglevel to INFO or WARN in your log4j.properties file.");
        System.out.println("\nExample, no -simforce in real move: java mpi.corpusstructure.ArchiveMover \\");
        System.out.println("  -csdb jdbc:postgresql://SERVER/corpusstructure imdiArchive - \\");
        System.out.println("  -simforce /archive/somewhere/*.jpg /archive/elsewhere/");
        System.out.println("\nClasspath: dir with log4j.properties in it + JARs for: JDBC, Handle System,");
        System.out.println("log4j, xalan + serializer, xercesImpl + xml-apis, corpusstructure");
    }

    public boolean isTargetDirectory(File target) throws IOException {
        if (target == null) {
            throw new IOException("Invalid target specification - must be a file");
        }
        if (target.exists() && !target.canWrite() && !this.simWriteable) {
            throw new IOException("Target already exists and is write protected: " + target);
        }
        if (target.isDirectory()) {
            if (!target.canWrite() && !this.simWriteable) {
                throw new IOException("Target directory is not writeable: " + target);
            }
            return true;
        }
        File parent = target.getParentFile();
        if (parent == null || !parent.canWrite() && !this.simWriteable) {
            throw new IOException("Directory of target file is not writeable: " + parent);
        }
        return false;
    }

    public int isValidSource(File source) {
        if (source == null) {
            return 0;
        }
        File parent = source.getParentFile();
        if (parent == null || !parent.canWrite() && !this.simWriteable) {
            this.logger.warn((Object)("Directory of source item not writeable: " + parent));
            return 0;
        }
        String parentName = source.getParent();
        String baseName = source.getName();
        if (parentName == null) {
            parentName = File.separator;
        }
        if (parentName.indexOf("*") != -1 || parentName.indexOf("?") != -1) {
            this.logger.warn((Object)("Source directory name must not contain wildcards: " + parentName));
            return 0;
        }
        if (baseName.equals("") || source.isDirectory()) {
            if (source.canRead() && (source.canWrite() || this.simWriteable)) {
                return 3;
            }
            this.logger.warn((Object)("Source directory must be readable and writeable: " + parentName));
            return 0;
        }
        if (baseName.indexOf("*") != -1 || baseName.indexOf("?") != -1) {
            if (!parent.canRead()) {
                this.logger.warn((Object)("Cannot resolve source wildcards, directory not readable: " + source));
                return 0;
            }
            return 2;
        }
        if (!source.canRead()) {
            this.logger.warn((Object)("Source file is not readable: " + source));
            return 0;
        }
        return 1;
    }

    private URI getURIofFile(File file) {
        try {
            return this.aac.stringToURI(new OurURL(file.toURI().toURL()).toString());
        }
        catch (MalformedURLException mue) {
            this.logger.error((Object)("getURIofFile got bad URL for: " + file + " error: " + mue));
            return null;
        }
        catch (URISyntaxException usi) {
            this.logger.error((Object)("getURIofFile got bad URI for: " + file + " error: " + usi));
            return null;
        }
    }

    private URI normalizedURI(String what) {
        File whatFile;
        if (what.startsWith("/")) {
            what = "file://" + what;
        }
        if ((whatFile = Mover.fileOf(what)) != null) {
            if (!whatFile.isAbsolute()) {
                whatFile = whatFile.getAbsoluteFile();
            }
            return this.getURIofFile(whatFile);
        }
        if (what.indexOf("///") != -1) {
            what = what.replaceFirst("///", "/");
        }
        try {
            return this.aac.stringToURI(what);
        }
        catch (URISyntaxException use) {
            this.logger.warn((Object)("Invalid URI: " + use));
            return null;
        }
    }

    private boolean addPairPhysical(String sourceName, String targetName) {
        File source = null;
        File target = null;
        try {
            source = Mover.fileOf(sourceName);
            target = Mover.fileOf(targetName);
            if (!source.isAbsolute()) {
                source = source.getAbsoluteFile();
            }
            if (!target.isAbsolute()) {
                target = target.getAbsoluteFile();
            }
            if (this.isTargetDirectory(target) && this.isTargetDirectory(target = new File(target, source.getName()))) {
                this.logger.warn((Object)("There is already a directory with the same name, cannot create file: " + target));
                return false;
            }
        }
        catch (IOException ioe) {
            this.logger.warn((Object)("Cannot create source target pair: " + ioe));
            return false;
        }
        if (this.getURIofFile(source) == null) {
            this.logger.warn((Object)("Bad source: " + source));
            return false;
        }
        if (this.getURIofFile(target) == null) {
            this.logger.warn((Object)("Bad target: " + target));
            return false;
        }
        this.sources.add(source);
        this.targets.put(source, target);
        return true;
    }

    private boolean addPairURI(String sourceName, String targetName) {
        URI source;
        if (targetName.endsWith(File.separator) || targetName.endsWith("/")) {
            int sourceSlash = sourceName.lastIndexOf("/");
            int sourceBackSlash = sourceName.lastIndexOf("\\");
            if (sourceBackSlash > sourceSlash) {
                sourceSlash = sourceBackSlash;
            }
            targetName = targetName + sourceName.substring(sourceSlash + 1);
        }
        if ((source = this.normalizedURI(sourceName)) == null) {
            this.logger.warn((Object)("Invalid source URI: " + sourceName));
            return false;
        }
        URI target = this.normalizedURI(targetName);
        if (target == null) {
            this.logger.warn((Object)("Invalid target URI: " + targetName));
            return false;
        }
        this.sources.add(source);
        this.targets.put(source, target);
        return true;
    }

    private boolean collectPairsPhysical(String[] args, int index) {
        String targetString = args[args.length - 1];
        for (int i = index; i < args.length - 1; ++i) {
            String aSource = args[i];
            File aFile = Mover.fileOf(aSource);
            int n = this.isValidSource(aFile);
            if (n == 3) {
                File targetDir = new File(Mover.fileOf(targetString).getAbsoluteFile(), aFile.getName());
                if (targetDir != null && !targetDir.exists()) {
                    targetDir.mkdirs();
                }
                try {
                    if (!this.isTargetDirectory(targetDir)) {
                        throw new IOException("directory target already exists as file");
                    }
                }
                catch (IOException e) {
                    this.logger.warn((Object)("Cannot recurse and create: " + targetDir + " for: " + aSource));
                    return false;
                }
                String[] recurse = new String[]{aFile.getPath() + File.separator + "*", targetDir.getPath()};
                this.logger.debug((Object)("Recursion: " + recurse[0] + " --> " + recurse[1]));
                if (this.collectPairsPhysical(recurse, 0)) continue;
                return false;
            }
            if (n <= 0) {
                System.err.println("WARNING: Invalid source item: " + aSource);
                this.logger.warn((Object)("Invalid source item: " + aSource));
                return false;
            }
            if (n == 1) {
                if (this.addPairPhysical(aSource, targetString)) continue;
                System.err.println("WARNING: Bad source/target pair: " + aSource + " -> " + targetString);
                this.logger.warn((Object)("Bad source/target pair: " + aSource + " -> " + targetString));
                return false;
            }
            String baseName = aFile.getName();
            String dirName = aFile.getParent();
            String[] globbed = aFile.getParentFile().list(new myFilter(baseName));
            if (globbed == null || globbed.length == 0) {
                this.logger.warn((Object)("No file matches: " + dirName + " / " + baseName));
                continue;
            }
            String[] expanded = new String[globbed.length + 1];
            expanded[globbed.length] = targetString;
            for (int j = 0; j < globbed.length; ++j) {
                expanded[j] = dirName + File.separator + globbed[j];
            }
            globbed = null;
            if (!this.collectPairsPhysical(expanded, 0)) {
                return false;
            }
            expanded = null;
        }
        return true;
    }

    private boolean collectPairsURI(String[] args, int index) {
        String targetString = args[args.length - 1];
        for (int i = index; i < args.length - 1; ++i) {
            String aSource = args[i];
            if (aSource.indexOf("*") != -1 || aSource.indexOf("?") != -1) {
                System.err.println("WARNING: Bad source URL, no wildcards allowed: " + aSource);
                this.logger.warn((Object)("Bad source URL, no wildcards allowed: " + aSource));
                return false;
            }
            if (this.addPairURI(aSource, targetString)) continue;
            System.err.println("WARNING: Bad source/target pair: " + aSource + " -> " + targetString);
            this.logger.warn((Object)("Bad source/target pair: " + aSource + " -> " + targetString));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateOnlyDB() {
        block10: {
            Enumeration aodbwrEnum2;
            boolean bl;
            block9: {
                try {
                    Enumeration sourceEnum = this.sources.elements();
                    while (sourceEnum.hasMoreElements()) {
                        URI sourceURI = (URI)sourceEnum.nextElement();
                        URI targetURI = (URI)this.targets.get(sourceURI);
                        boolean wasVerbose = Mover.verbose;
                        Mover.verbose = this.verbose;
                        if (!Mover.moveURImulti(sourceURI, targetURI, this.simulation, this.aodbWriters)) {
                            this.logger.error((Object)("Problems updating the database information for: " + sourceURI));
                            this.logger.error((Object)"Not moving any other files for now...");
                            Mover.verbose = wasVerbose;
                            bl = false;
                            Object var7_6 = null;
                            aodbwrEnum2 = this.aodbWriters.elements();
                            break block9;
                        }
                        Mover.verbose = wasVerbose;
                    }
                    break block10;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    Enumeration aodbwrEnum2 = this.aodbWriters.elements();
                    while (true) {
                        if (!aodbwrEnum2.hasMoreElements()) {
                            throw throwable;
                        }
                        ArchiveObjectsDBWrite aodbwr = (ArchiveObjectsDBWrite)aodbwrEnum2.nextElement();
                        if (aodbwr == null) continue;
                        aodbwr.shutdown();
                        aodbwr.close();
                        aodbwr = null;
                    }
                }
            }
            while (aodbwrEnum2.hasMoreElements()) {
                ArchiveObjectsDBWrite aodbwr = (ArchiveObjectsDBWrite)aodbwrEnum2.nextElement();
                if (aodbwr == null) continue;
                aodbwr.shutdown();
                aodbwr.close();
                aodbwr = null;
            }
            return bl;
        }
        Object var7_7 = null;
        Enumeration aodbwrEnum2 = this.aodbWriters.elements();
        while (aodbwrEnum2.hasMoreElements()) {
            ArchiveObjectsDBWrite aodbwr = (ArchiveObjectsDBWrite)aodbwrEnum2.nextElement();
            if (aodbwr == null) continue;
            aodbwr.shutdown();
            aodbwr.close();
            aodbwr = null;
        }
        return true;
    }

    private File fileOfNodeId(String nodeId) {
        try {
            ArchiveMover archiveMover = this;
            OurURL affectedURL = this.aodb.getObjectURL(nodeId, archiveMover.aac.getFileUrlContext());
            if ("file".equals(affectedURL.getProtocol())) {
                File affectedFile = new File(affectedURL.getFile());
                if (affectedFile.canWrite() || this.simWriteable) {
                    return affectedFile;
                }
                this.logger.warn((Object)("No write rights, MANUAL update required for IMDI: " + affectedFile));
            } else {
                this.logger.warn((Object)("MANUAL update required for EXTERNAL IMDI: " + affectedURL));
            }
        }
        catch (UnknownNodeException une) {
            this.logger.warn((Object)("IMDI file with UNKNOWN URL?? node: " + nodeId));
        }
        return null;
    }

    private HashSet collectAffectedIMDI(Enumeration sourceEnum) {
        HashSet<String> affectedIMDI = new HashSet<String>();
        while (sourceEnum.hasMoreElements()) {
            File sourceFile = (File)sourceEnum.nextElement();
            URI sourceURI = this.getURIofFile(sourceFile);
            if (sourceURI == null) {
                this.logger.error((Object)"collectAffectedIMDI: getURIofFile failure, skipped 1 input data point");
                continue;
            }
            String itemId = this.aodb.getObjectId(sourceURI);
            if (itemId == null) {
                try {
                    OurURL itemURL = new OurURL(sourceURI.toURL().toString());
                    itemId = this.aodb.getObjectId(itemURL);
                }
                catch (MalformedURLException mue) {
                    // empty catch block
                }
            }
            if (sourceURI.toString().toLowerCase().endsWith("imdi")) {
                if (itemId != null) {
                    if (affectedIMDI.add(itemId)) {
                        this.logger.debug((Object)("Moving IMDI file: " + sourceURI));
                    }
                } else {
                    this.logger.error((Object)("Manual fixup needed for IMDI file not in DB: " + sourceURI));
                }
            }
            if (itemId != null) {
                String[] parentIds = null;
                try {
                    parentIds = this.csdb.getParentNodes(itemId);
                    if (parentIds == null) {
                        throw new UnknownNodeException("empty");
                    }
                    for (int i = 0; i < parentIds.length; ++i) {
                        if (!affectedIMDI.add(parentIds[i])) continue;
                        this.logger.debug((Object)("Will update IMDI file linking to a moved file: " + parentIds[i]));
                    }
                    continue;
                }
                catch (UnknownNodeException une) {
                    this.logger.info((Object)("Moving UNLINKED file known in DB: " + sourceURI));
                    continue;
                }
            }
            this.logger.warn((Object)("Moving resource file not in DB: " + sourceURI));
            this.unmanagedFiles.add(sourceFile);
        }
        return affectedIMDI;
    }

    private String updateSomeIMDI(IMDINodeHandler imdiRewriter, Iterator affectedIter, boolean contOnError) {
        String failMsg = null;
        while (affectedIter.hasNext()) {
            String affectedId = (String)affectedIter.next();
            OurURL imdiUrl = null;
            try {
                imdiUrl = new OurURL(this.fileOfNodeId(affectedId).getAbsoluteFile().toURL());
            }
            catch (NullPointerException npe) {
                failMsg = "fileOfNodeId returned null for: " + affectedId;
                if (contOnError) continue;
                return failMsg;
            }
            catch (MalformedURLException mue) {
                failMsg = "fileOfNodeId returned bad URL for: " + affectedId;
                if (contOnError) continue;
                return failMsg;
            }
            int nodeType = 32;
            try {
                nodeType = this.csdb.getNode(affectedId).getNodeType();
            }
            catch (UnknownNodeException une) {
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
            this.logger.debug((Object)("Process IMDI " + (nodeType == 2 ? "corpus" : (nodeType == 1 ? "session" : "catalogue")) + ": " + imdiUrl));
            if (nodeType == 2) {
                if (imdiRewriter.handleCorpus(imdiUrl, null)) continue;
                failMsg = "handleCorpus failure for: " + imdiUrl;
                if (contOnError) continue;
                return failMsg;
            }
            if (nodeType == 1) {
                if (imdiRewriter.handleSession(imdiUrl, null)) continue;
                failMsg = "handleSession failure for: " + imdiUrl;
                if (contOnError) continue;
                return failMsg;
            }
            if (imdiRewriter.handleCatalogue(imdiUrl, null)) continue;
            failMsg = "handleCatalogue failure for: " + imdiUrl;
            if (contOnError) continue;
            return failMsg;
        }
        return failMsg;
    }

    public static void main(String[] argv) {
        new ArchiveMover(argv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveMover(String[] argv) {
        Enumeration aodbwrEnum2;
        String targetString;
        int base = 0;
        boolean singleTarget = true;
        boolean singleSource = true;
        try {
            base = this.parseOptions(argv);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            base = -1;
        }
        if (base == -2) {
            System.exit(-1);
        }
        if (base == -1) {
            ArchiveMover.showHelp();
            System.exit(1);
        }
        if ((targetString = argv[argv.length - 1]).indexOf("*") != -1 || targetString.indexOf("?") != -1) {
            System.out.println("ERROR: Target name must not contain wildcards: " + targetString);
            System.exit(1);
        }
        if (this.movePhysical) {
            try {
                singleTarget = !this.isTargetDirectory(Mover.fileOf(targetString));
            }
            catch (IOException ioe) {
                System.out.println("ERROR: Invalid target: " + ioe);
                System.exit(1);
            }
            int whichSource = this.isValidSource(Mover.fileOf(argv[base]));
            if (whichSource == 0 && base == argv.length - 2) {
                System.out.println("ERROR: There was only one but unusable source spec:");
                System.out.println("Not usable: " + argv[base]);
                System.out.println("Possible causes: Not readable, dir not writeable, bad wildcards - see log");
                System.exit(2);
            }
            boolean bl = singleSource = base == argv.length - 2 && whichSource == 1;
            if (singleTarget) {
                if (!singleSource) {
                    System.out.println("ERROR: Target must be a directory when specifying several source items (nsrc=" + (argv.length - 1 - base) + " t=" + this.isValidSource(Mover.fileOf(argv[base])) + " base=" + base + ")");
                    System.out.println("First  source: " + argv[base]);
                    System.out.println("Second source: " + argv[base + 1]);
                    System.out.println("(...)  Target: " + argv[argv.length - 1]);
                    System.exit(1);
                } else if (!this.addPairPhysical(argv[base], targetString)) {
                    System.out.println("ERROR: Cannot move: " + argv[base]);
                    System.exit(2);
                }
            } else if (!this.collectPairsPhysical(argv, base)) {
                System.exit(2);
            }
        } else {
            boolean isDirectoryURI = targetString.endsWith(File.separator) || targetString.endsWith("/");
            singleTarget = !isDirectoryURI;
            boolean bl = singleSource = base == argv.length - 2 && argv[base].indexOf("?") == -1 && argv[base].indexOf("*") == -1 && !argv[base].endsWith("/");
            if (singleTarget) {
                if (!singleSource) {
                    System.out.println("ERROR: Several sources or a source directory specified - target URL must end in a slash");
                    System.exit(1);
                } else if (!this.addPairURI(argv[base], targetString)) {
                    System.out.println("ERROR: Cannot change URL: " + argv[base]);
                    System.exit(2);
                }
            } else if (!this.collectPairsURI(argv, base)) {
                System.exit(2);
            }
            if (!this.updateOnlyDB()) {
                System.out.println("ERROR: Database update failed");
                System.exit(3);
            }
            System.out.println("Database(s) updated, but did not move any files and did not update any IMDI files");
            System.exit(0);
        }
        if (this.aodb == null || this.csdb == null) {
            System.out.println("No CSDB active, cannot find files which link to the to be moved files!");
            System.exit(4);
        }
        HashSet affectedIMDI = this.collectAffectedIMDI(this.sources.elements());
        for (String affectedId : affectedIMDI) {
            if (this.fileOfNodeId(affectedId) != null) continue;
            System.out.println("Unwriteable IMDI node would have to be updated: " + affectedId);
            System.exit(5);
        }
        URIDNodeHandler imdiRewriter = new URIDNodeHandler(true, false, this.aac);
        imdiRewriter.setSimulation(this.simulation);
        imdiRewriter.setVerbose(this.verbose);
        String errMsg = this.updateSomeIMDI(imdiRewriter, affectedIMDI.iterator(), false);
        if (errMsg != null) {
            System.out.println("Could not add URIDs to file, check and try again: " + errMsg);
            System.exit(5);
        }
        try {
            Enumeration sourceEnum = this.sources.elements();
            boolean keepMoving = true;
            while (sourceEnum.hasMoreElements() && keepMoving) {
                File source = (File)sourceEnum.nextElement();
                File target = (File)this.targets.get(source);
                URI sourceURI = this.getURIofFile(source);
                URI targetURI = this.getURIofFile(target);
                if (sourceURI == null || targetURI == null) {
                    this.logger.error((Object)("Incomplete pair: " + sourceURI + " / " + source + " -> " + targetURI + " / " + target));
                    keepMoving = false;
                    continue;
                }
                if (Mover.moveFile(source, target, this.simulation) || this.simWriteable) {
                    boolean wasVerbose = Mover.verbose;
                    Mover.verbose = this.verbose;
                    if (this.unmanagedFiles.contains(source)) {
                        this.logger.debug((Object)("No database update attempt for file not known there: " + source));
                        continue;
                    }
                    if (!Mover.moveURImulti(sourceURI, targetURI, this.simulation, this.aodbWriters)) {
                        this.logger.error((Object)("Problems updating the database information for: " + sourceURI));
                        keepMoving = false;
                    }
                    Mover.verbose = wasVerbose;
                    continue;
                }
                this.logger.error((Object)("Could not actually move file: " + source + " -> " + target));
                keepMoving = false;
            }
            if (!keepMoving) {
                this.logger.error((Object)"Not moving any other files for now...");
            }
            imdiRewriter = new URIDNodeHandler(false, true, this.aac);
            imdiRewriter.setSimulation(this.simulation);
            imdiRewriter.setVerbose(this.verbose);
            errMsg = this.updateSomeIMDI(imdiRewriter, affectedIMDI.iterator(), true);
            if (errMsg != null) {
                System.out.println("Could not update links in file, check and try again: " + errMsg);
                System.exit(5);
            }
            Object var18_20 = null;
            aodbwrEnum2 = this.aodbWriters.elements();
        }
        catch (Throwable throwable) {
            Object var18_21 = null;
            Enumeration aodbwrEnum2 = this.aodbWriters.elements();
            while (aodbwrEnum2.hasMoreElements()) {
                ArchiveObjectsDBWrite aodbwr = (ArchiveObjectsDBWrite)aodbwrEnum2.nextElement();
                if (aodbwr == null) continue;
                aodbwr.shutdown();
                aodbwr.close();
                aodbwr = null;
            }
            throw throwable;
        }
        while (aodbwrEnum2.hasMoreElements()) {
            ArchiveObjectsDBWrite aodbwr = (ArchiveObjectsDBWrite)aodbwrEnum2.nextElement();
            if (aodbwr == null) continue;
            aodbwr.shutdown();
            aodbwr.close();
            aodbwr = null;
        }
    }

    class myFilter
    implements FilenameFilter {
        Pattern pattern = null;

        public myFilter(String globPattern) {
            try {
                String oldPattern = globPattern;
                globPattern = globPattern.replaceAll("\\\\", "\\\\\\\\");
                globPattern = globPattern.replaceAll("\\.", "\\\\.");
                globPattern = globPattern.replaceAll("\\^", "\\\\^");
                globPattern = globPattern.replaceAll("\\$", "\\\\$");
                globPattern = globPattern.replaceAll("\\(", "\\\\(");
                globPattern = globPattern.replaceAll("\\)", "\\\\)");
                globPattern = globPattern.replaceAll("\\|", "\\\\|");
                globPattern = globPattern.replaceAll("\\?", ".");
                globPattern = globPattern.replaceAll("\\*", ".*");
                this.pattern = Pattern.compile(globPattern);
                if (oldPattern.replaceAll("[a-z0-9.*]", "").length() > 0) {
                    ArchiveMover.this.logger.debug((Object)("myFilter: glob: " + oldPattern + " regexp: " + globPattern));
                }
            }
            catch (PatternSyntaxException pse) {
                ArchiveMover.this.logger.warn((Object)("myFilter: Illegal regular expression: " + globPattern + " error: " + pse));
                System.exit(3);
            }
        }

        public boolean accept(File dir, String name) {
            if (this.pattern == null) {
                return false;
            }
            boolean retval = this.pattern.matcher(name).matches();
            return retval;
        }
    }
}

