/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import mpi.corpusstructure.AccessInfo;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBImplHS;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.util.DBConnection;
import mpi.util.OurURL;
import org.apache.log4j.Logger;

public class ArchiveObjectsDBImpl
implements ArchiveObjectsDB {
    protected static Logger logger = Logger.getLogger((String)ArchiveObjectsDBImpl.class.getName());
    protected static ArchiveObjectsDB aoHS = null;
    protected static Hashtable rootsHash = new Hashtable();
    protected static String dbname = null;
    protected static final String adminTableName = "IMDIADMIN";
    protected static String ARCHIVEOBJECTS = "ARCHIVEOBJECTS";
    protected static String staticSyncFlag = "dummy";
    protected boolean status = false;
    protected DBConnection db = null;
    protected static int instance = 0;
    private ArchiveObjectsDB aodbPlugin = null;
    private PreparedStatement getURLFromArchiveObjectsSTM = null;
    private PreparedStatement getTimestampFromArchiveObjectsSTM = null;
    private PreparedStatement getFileTimeFromArchiveObjectsSTM = null;
    private PreparedStatement getAccessInfoFromArchiveObjectsSTM = null;
    private PreparedStatement getIdFromArchiveObjectsSTM = null;
    private PreparedStatement getIdsFromArchiveObjectsChecksumSTM = null;
    private PreparedStatement getSizeFromArchiveObjectsSTM = null;
    private PreparedStatement getChecksumFromArchiveObjectsSTM = null;
    private PreparedStatement getOnSiteFromArchiveObjectsSTM = null;
    private static final String PROPERTYFILENAME = "CorpusStructure.props";

    protected ArchiveObjectsDBImpl(Exception e) {
    }

    public ArchiveObjectsDBImpl(String dbname) {
        this(dbname, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveObjectsDBImpl(String dbname, String user, String passwd) {
        String string = staticSyncFlag;
        synchronized (string) {
            this.db = new DBConnection(dbname, user, passwd, "ArchiveObjectsDBImpl:constructor");
            if (this.db == null || !this.db.getStatus()) {
                if (this.db == null) {
                    logger.error((Object)"constructor: NULL DB connection!");
                } else {
                    logger.error((Object)("constructor: ERROR creating DB connection: " + this.db.getMessage()));
                }
                this.status = false;
                return;
            }
            this.status = true;
            ++instance;
            ArchiveObjectsDBImpl.dbname = dbname;
            this.initArchiveAccessRoots();
            this.initPreparedStatements();
        }
    }

    public boolean setArchiveObjectsDBAccessPlugin(ArchiveObjectsDB aodbp) {
        this.aodbPlugin = aodbp;
        if (aodbp != null) {
            return aodbp.getStatus();
        }
        return true;
    }

    protected void initArchiveAccessRoots() {
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
        if (aac != null) {
            if (aoHS != null) {
                aoHS.setArchiveRoots(aac);
            }
            return;
        }
        aac = new ArchiveAccessContext();
        int[] contexts = new int[]{1, 2, 3, 4, 5, 6};
        int j = 0;
        for (int i = 0; i < contexts.length; ++i) {
            String defValue = this.getAdminKey(ArchiveAccessContext.aRootsPropertyNames[contexts[i]]);
            if (defValue != null && !defValue.equals("")) {
                try {
                    aac.updateRoot(contexts[i], defValue);
                }
                catch (MalformedURLException murle) {
                    logger.error((Object)("initArchiveAccessRoots: Error in ArchiveAccessContext roots: " + murle), (Throwable)murle);
                    System.exit(0);
                }
                continue;
            }
            ++j;
            logger.warn((Object)("initArchiveAccessRoots: No root setup in DB yet, starting with dummy default for " + ArchiveAccessContext.aRootsPropertyNames[i]));
            try {
                aac.updateRoot(contexts[i], null);
                continue;
            }
            catch (MalformedURLException murle) {
                logger.error((Object)("initArchiveAccessRoots: Error in ArchiveAccessContext roots: " + murle), (Throwable)murle);
                System.exit(0);
            }
        }
        Properties csProps = new Properties(System.getProperties());
        String propertyfile = csProps.getProperty("Properties", PROPERTYFILENAME);
        if (aac.loadPropertyFile("ArchiveRoots")) {
            logger.info((Object)"initArchiveAccessRoots: loaded ArchiveRoots file");
            j = 0;
        }
        if (aac.loadPropertyFile(propertyfile)) {
            logger.info((Object)("initArchiveAccessRoots: loaded " + propertyfile + " file"));
            j = 0;
        }
        if (j > 0) {
            logger.error((Object)("initArchiveAccessRoots: Dummy default settings active (" + j + " items) and no user ArchiveRoots or properties setup file found!"));
        }
        logger.info((Object)("Initialised archive access roots: " + aac.getRoot(1) + ", " + aac.getRoot(2) + ", " + aac.getRoot(3)));
        logger.info((Object)("Initialised Handle System settings: " + aac.getHandleProxy() + ", " + aac.getHandlePrefix()));
        logger.info((Object)("Initialised archive name: " + aac.getArchiveName()));
        rootsHash.put(dbname, aac);
        if (aoHS != null) {
            aoHS.setArchiveRoots(aac);
        }
    }

    protected synchronized void initPreparedStatements() {
        try {
            this.getURLFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT URL FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getTimestampFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT CRAWLTIME FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getFileTimeFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT FILETIME FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getAccessInfoFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT (SELECT ACLSTRING FROM accessgroups WHERE MD5 = (SELECT READRIGHTS FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?))" + " AS READRIGHTS, " + "(SELECT ACLSTRING FROM " + "accessgroups" + " WHERE MD5 = " + "(SELECT WRITERIGHTS FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?))" + " AS WRITERIGHTS " + "FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getIdFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ARCHIVEOBJECTS + " WHERE URL = ?");
            this.getIdsFromArchiveObjectsChecksumSTM = this.db.getConnection().prepareStatement("SELECT NODEID FROM " + ARCHIVEOBJECTS + " WHERE CHECKSUM = ?");
            this.getSizeFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT SIZE FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getChecksumFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT CHECKSUM FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
            this.getOnSiteFromArchiveObjectsSTM = this.db.getConnection().prepareStatement("SELECT ONSITE FROM " + ARCHIVEOBJECTS + " WHERE NODEID = ?");
        }
        catch (SQLException sqle) {
            logger.error((Object)("initPreparedStatements: " + sqle));
            while ((sqle = sqle.getNextException()) != null) {
                logger.error((Object)("initPreparedStatements: " + sqle));
            }
        }
    }

    protected synchronized void closePreparedStatements() {
        try {
            if (this.getURLFromArchiveObjectsSTM != null) {
                this.getURLFromArchiveObjectsSTM.close();
            }
            if (this.getTimestampFromArchiveObjectsSTM != null) {
                this.getTimestampFromArchiveObjectsSTM.close();
            }
            if (this.getFileTimeFromArchiveObjectsSTM != null) {
                this.getFileTimeFromArchiveObjectsSTM.close();
            }
            if (this.getAccessInfoFromArchiveObjectsSTM != null) {
                this.getAccessInfoFromArchiveObjectsSTM.close();
            }
            if (this.getIdFromArchiveObjectsSTM != null) {
                this.getIdFromArchiveObjectsSTM.close();
            }
            if (this.getIdsFromArchiveObjectsChecksumSTM != null) {
                this.getIdsFromArchiveObjectsChecksumSTM.close();
            }
            if (this.getSizeFromArchiveObjectsSTM != null) {
                this.getSizeFromArchiveObjectsSTM.close();
            }
            if (this.getChecksumFromArchiveObjectsSTM != null) {
                this.getChecksumFromArchiveObjectsSTM.close();
            }
            if (this.getOnSiteFromArchiveObjectsSTM != null) {
                this.getOnSiteFromArchiveObjectsSTM.close();
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"closePreparedStatements: ", (Throwable)sqle);
        }
        this.getURLFromArchiveObjectsSTM = null;
        this.getTimestampFromArchiveObjectsSTM = null;
        this.getFileTimeFromArchiveObjectsSTM = null;
        this.getAccessInfoFromArchiveObjectsSTM = null;
        this.getIdFromArchiveObjectsSTM = null;
        this.getIdsFromArchiveObjectsChecksumSTM = null;
        this.getSizeFromArchiveObjectsSTM = null;
        this.getChecksumFromArchiveObjectsSTM = null;
        this.getOnSiteFromArchiveObjectsSTM = null;
    }

    public synchronized void close() {
        this.closePreparedStatements();
        if (this.db != null) {
            this.db.close();
        }
        this.db = null;
        this.status = false;
    }

    public boolean getStatus() {
        if (!this.status) {
            return this.status;
        }
        if (!this.db.getStatus()) {
            this.status = false;
        }
        if (this.aodbPlugin != null && !this.aodbPlugin.getStatus()) {
            this.status = false;
        }
        return this.status;
    }

    public static void setLogger(Logger l) {
        logger = l;
        NodeIdUtils.setLogger(l);
        DBConnection.setLogger(l);
    }

    public String getAdminKey(String name) {
        return this.getMultiAdminKey(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getMultiAdminKey(String name, boolean multi) {
        block33: {
            block32: {
                block26: {
                    block31: {
                        block24: {
                            block25: {
                                ps = null;
                                answer = null;
                                rs = null;
                                try {
                                    try {
                                        ps = this.db.getConnection().prepareStatement("SELECT Value FROM IMDIADMIN WHERE NAME = ?");
                                        ps.clearParameters();
                                        ps.setString(1, name);
                                        rs = ps.executeQuery();
                                        while (rs.next()) {
                                            answer = answer == null ? "" : answer + ";";
                                            o = rs.getObject(1);
                                            if (o != null) {
                                                answer = answer + o.toString();
                                                if (multi) continue;
                                                var7_8 = answer;
                                                var9_10 = null;
                                                if (ps == null) break block24;
                                                break block25;
                                            }
                                            ArchiveObjectsDBImpl.logger.error((Object)("getAdminKey: " + name + " error Object is null"));
                                        }
                                        o = answer;
                                        break block26;
                                    }
                                    catch (SQLException sqle) {
                                        ArchiveObjectsDBImpl.logger.warn((Object)("getAdminKey: cannot read key '" + name + "' - admin table not yet there? SQLException: " + sqle.getMessage()));
                                        var7_9 = null;
                                        var9_12 = null;
                                        if (ps != null) {
                                            try {
                                                ps.close();
                                            }
                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                        ps = null;
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                        rs = null;
                                        return var7_9;
                                    }
                                }
                                catch (Throwable var8_18) {
                                    block30: {
                                        block29: {
                                            var9_13 = null;
                                            if (ps != null) {
                                                ** try [egrp 2[TRYBLOCK] [6 : 249->258)] { 
lbl53:
                                                // 1 sources

                                                ps.close();
                                                break block29;
lbl55:
                                                // 1 sources

                                                catch (SQLException e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        ps = null;
                                        if (rs != null) {
                                            ** try [egrp 3[TRYBLOCK] [7 : 267->277)] { 
lbl61:
                                            // 1 sources

                                            rs.close();
                                            break block30;
lbl63:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    rs = null;
                                    throw var8_18;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [6 : 249->258)] { 
lbl70:
                            // 1 sources

                            ps.close();
                            break block24;
lbl72:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        ps = null;
                        if (rs != null) {
                            ** try [egrp 3[TRYBLOCK] [7 : 267->277)] { 
lbl78:
                            // 1 sources

                            rs.close();
                            break block31;
lbl80:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    rs = null;
                    return var7_8;
                }
                var9_11 = null;
                if (ps != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 249->258)] { 
lbl89:
                    // 1 sources

                    ps.close();
                    break block32;
lbl91:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            ps = null;
            if (rs != null) {
                ** try [egrp 3[TRYBLOCK] [7 : 267->277)] { 
lbl97:
                // 1 sources

                rs.close();
                break block33;
lbl99:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        rs = null;
        return o;
    }

    public void setArchiveRoots(ArchiveAccessContext aac) {
        if (dbname == null) {
            logger.error((Object)"Cannot setArchiveRoots for null dbname");
            return;
        }
        rootsHash.put(dbname, aac);
        if (aoHS != null) {
            aoHS.setArchiveRoots(aac);
        }
        logger.info((Object)("setArchiveRoots for database " + dbname));
    }

    public ArchiveAccessContext getArchiveRoots() {
        if (dbname == null) {
            logger.error((Object)"Cannot getArchiveRoots for null dbname");
            return null;
        }
        return (ArchiveAccessContext)rootsHash.get(dbname);
    }

    public boolean hasReadAccess(String nodeId, String uid) throws UnknownNodeException {
        AccessInfo ai = this.getObjectAccessInfo(nodeId);
        if (ai == null) {
            return false;
        }
        return ai.hasReadAccess(uid);
    }

    public boolean canWrite() {
        return false;
    }

    public OurURL getObjectURL(String id, int context) throws UnknownNodeException {
        String urlstr = null;
        URI objectURI = this.getObjectURI(id);
        if (objectURI == null) {
            return null;
        }
        try {
            URI result;
            ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
            if (aoHS == null && objectURI.toString().startsWith("hdl")) {
                aoHS = new ArchiveObjectsDBImplHS();
                aoHS.setArchiveRoots(aac);
            }
            if ((result = aac.uriInContext(urlstr = aac.toClassicURL(objectURI.toString(), false, aoHS).toString(), context)) == null) {
                logger.error((Object)("getObjectURL: urlInContext error, context: " + context));
                return null;
            }
            return new OurURL(result.toString().replaceAll("%20", " "));
        }
        catch (MalformedURLException mue) {
            logger.error((Object)("getObjectURL: error creating URL from " + objectURI + " error: " + mue), (Throwable)mue);
        }
        catch (URISyntaxException use) {
            logger.error((Object)("getObjectURL: error creating URI from " + urlstr + " error: " + use), (Throwable)use);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI getObjectURI(String id) throws UnknownNodeException {
        block28: {
            block26: {
                block27: {
                    block25: {
                        if (this.aodbPlugin != null) {
                            try {
                                pluginResult = this.aodbPlugin.getObjectURI(id);
                                if (pluginResult != null) {
                                    return pluginResult;
                                }
                                if (!NodeIdUtils.isNodeId(id)) {
                                    return pluginResult;
                                }
                            }
                            catch (UnknownNodeException une) {
                                if (NodeIdUtils.isNodeId(id)) break block25;
                                throw une;
                            }
                        }
                    }
                    if (!this.statusLog("getObjectURI")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        this.throwUnknownObjectException("getObjectURI", "", id);
                    }
                    rs = null;
                    urlstr = "";
                    try {
                        try {
                            var4_5 = this.getURLFromArchiveObjectsSTM;
                            synchronized (var4_5) {
                                this.getURLFromArchiveObjectsSTM.clearParameters();
                                this.getURLFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                                rs = this.getURLFromArchiveObjectsSTM.executeQuery();
                                while (rs.next()) {
                                    urlstr = rs.getString("URL");
                                    if (!rs.isLast()) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("getObjectURI: ERROR more than one entry for object: " + id));
                                    }
                                    try {
                                        aac = (ArchiveAccessContext)ArchiveObjectsDBImpl.rootsHash.get(ArchiveObjectsDBImpl.dbname);
                                        var6_9 = aac.stringToURI(urlstr);
                                        // MONITOREXIT @DISABLED, blocks:[16, 1, 2, 4, 7] lbl32 : MonitorExitStatement: MONITOREXIT : var4_5
                                    }
                                    catch (URISyntaxException use) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("getObjectURI: DB contained invalid URI: " + urlstr));
                                        continue;
                                    }
                                    var9_10 = null;
                                    if (rs == null) break block26;
                                    break block27;
                                }
                                this.throwUnknownObjectException("getObjectURI", "", id);
                                break block28;
                            }
                        }
                        catch (SQLException e) {
                            ArchiveObjectsDBImpl.logger.error((Object)("getObjectURI: SQL exception: nodeid=" + NodeIdUtils.TOINT(id) + " " + e));
                            var9_12 = null;
                            if (rs == null) return null;
                            try {
                                rs.close();
                                return null;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return null;
                        }
                    }
                    catch (Throwable var8_18) {
                        block29: {
                            var9_13 = null;
                            if (rs != null) {
                                ** try [egrp 6[TRYBLOCK] [12 : 321->330)] { 
lbl60:
                                // 1 sources

                                rs.close();
                                break block29;
lbl62:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        rs = null;
                        throw var8_18;
                    }
                }
                ** try [egrp 6[TRYBLOCK] [12 : 321->330)] { 
lbl69:
                // 1 sources

                rs.close();
                break block26;
lbl71:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var6_9;
        }
        var9_11 = null;
        if (rs == null) return null;
        ** try [egrp 6[TRYBLOCK] [12 : 321->330)] { 
lbl80:
        // 1 sources

        rs.close();
        return null;
lbl82:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return null;
    }

    public String getObjectId(OurURL urlin, int context) {
        String pluginResult;
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectId(urlin, context)) != null) {
            return pluginResult;
        }
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        if (urlin == null) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
        URI uri = null;
        try {
            uri = aac.uriToTableContext(aac.stringToURI(urlin.toString()), context);
        }
        catch (URISyntaxException use) {
            uri = null;
        }
        if (uri == null) {
            logger.warn((Object)("getObjectId: urlToTableContext(" + urlin + ", " + context + ") failed"));
            return null;
        }
        return this.getObjectId(uri);
    }

    public String getObjectId(OurURL url) {
        String pluginResult;
        if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectId(url)) != null) {
            return pluginResult;
        }
        if (!this.statusLog("getObjectId")) {
            return null;
        }
        ArchiveAccessContext aac = (ArchiveAccessContext)rootsHash.get(dbname);
        int context = aac.getAccessContextFromURI(url.toString());
        if (context == -1) {
            logger.error((Object)("getObjectId: Could not guess access context for URL: " + url));
            context = 0;
        }
        return this.getObjectId(url, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public String getObjectId(URI uri) {
        block21: {
            block20: {
                if (uri == null || !uri.isAbsolute()) {
                    ArchiveObjectsDBImpl.logger.warn((Object)("getObjectId: Invalid URI, must specify schema/protocol: " + uri));
                    return null;
                }
                if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectId(uri)) != null) {
                    return pluginResult;
                }
                if (!this.statusLog("getObjectId")) {
                    return null;
                }
                aac = (ArchiveAccessContext)ArchiveObjectsDBImpl.rootsHash.get(ArchiveObjectsDBImpl.dbname);
                uri = aac.inTableContext(uri);
                rs = null;
                var4_4 = this.getIdFromArchiveObjectsSTM;
                synchronized (var4_4) {
                    this.getIdFromArchiveObjectsSTM.clearParameters();
                    this.getIdFromArchiveObjectsSTM.setString(1, uri.toString().replaceAll("%20", " "));
                    rs = this.getIdFromArchiveObjectsSTM.executeQuery();
                    if (!rs.next()) ** break block19
                    id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                    if (!rs.isLast()) {
                        ArchiveObjectsDBImpl.logger.error((Object)("getObjectId: ERROR more than one id for URI: " + uri));
                    }
                    var6_7 = id;
                }
                var9_8 = null;
                if (rs == null) break block20;
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var6_7;
            {
                // MONITOREXIT @DISABLED, blocks:[2, 3, 6] lbl36 : MonitorExitStatement: MONITOREXIT : var4_4
                {
                    catch (Throwable var7_16) {
                        throw var7_16;
                    }
                }
                ArchiveObjectsDBImpl.logger.debug((Object)("## getObjectId: NONE for " + uri));
                var4_4 = null;
                var9_9 = null;
                if (rs == null) break block21;
            }
            try {
                rs.close();
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        rs = null;
        return var4_4;
        {
            catch (SQLException e) {
                block22: {
                    try {
                        ArchiveObjectsDBImpl.logger.error((Object)("getObjectId: SQL exception: " + e));
                        var9_10 = null;
                        if (rs == null) break block22;
                    }
                    catch (Throwable var8_17) {
                        var9_11 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        rs = null;
                        throw var8_17;
                    }
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                rs = null;
                {
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] getObjectsByChecksum(String checksum) {
        TreeSet<String> items;
        block18: {
            ResultSet rs;
            block17: {
                String[] pluginResult;
                if (checksum == null || !checksum.matches("^[0-9a-f]*$")) {
                    logger.warn((Object)("getObjectsByChecksum: Invalid checksum, must be lower case hex: " + checksum));
                    return null;
                }
                if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getObjectsByChecksum(checksum)) != null && pluginResult.length > 0) {
                    return pluginResult;
                }
                if (!this.statusLog("getObjectsByChecksum")) {
                    return null;
                }
                rs = null;
                items = new TreeSet<String>(new NodeIdComparator());
                PreparedStatement preparedStatement = this.getIdsFromArchiveObjectsChecksumSTM;
                synchronized (preparedStatement) {
                    this.getIdsFromArchiveObjectsChecksumSTM.clearParameters();
                    this.getIdsFromArchiveObjectsChecksumSTM.setString(1, checksum);
                    rs = this.getIdsFromArchiveObjectsChecksumSTM.executeQuery();
                    while (rs.next()) {
                        String id = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                        items.add(id);
                    }
                }
                Object var8_8 = null;
                if (rs == null) break block17;
                try {
                    rs.close();
                }
                catch (SQLException e2) {
                    // empty catch block
                }
            }
            rs = null;
            {
                break block18;
                catch (SQLException e) {
                    logger.error((Object)("getObjectsByChecksum: SQL exception: " + e));
                    Object var8_9 = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2) {
                            // empty catch block
                        }
                    }
                    rs = null;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2) {
                        // empty catch block
                    }
                }
                rs = null;
                throw throwable;
            }
        }
        return items.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getObjectTimestamp(String id) throws UnknownNodeException {
        block25: {
            block23: {
                block24: {
                    block22: {
                        if (this.aodbPlugin != null) {
                            try {
                                pluginResult = this.aodbPlugin.getObjectTimestamp(id);
                                if (pluginResult != null) {
                                    return pluginResult;
                                }
                                if (!NodeIdUtils.isNodeId(id)) {
                                    return pluginResult;
                                }
                            }
                            catch (UnknownNodeException une) {
                                if (NodeIdUtils.isNodeId(id)) break block22;
                                throw une;
                            }
                        }
                    }
                    if (!this.statusLog("getObjectTimestamp")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        this.throwUnknownObjectException("getObjectTimestamp", "", id);
                    }
                    rs = null;
                    try {
                        try {
                            var3_4 = this.getTimestampFromArchiveObjectsSTM;
                            synchronized (var3_4) {
                                this.getTimestampFromArchiveObjectsSTM.clearParameters();
                                this.getTimestampFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                                rs = this.getTimestampFromArchiveObjectsSTM.executeQuery();
                                if (rs.next()) {
                                    timestamp = rs.getTimestamp("CRAWLTIME");
                                    if (!rs.isLast()) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("getTimestamp: ERROR more than one entry for object: " + id));
                                    }
                                    var5_7 = timestamp;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 20, 6] lbl29 : MonitorExitStatement: MONITOREXIT : var3_4
                                    var8_8 = null;
                                    if (rs == null) break block23;
                                    break block24;
                                }
                            }
                            this.throwUnknownObjectException("getObjectTimeStamp", "", id);
                            break block25;
                        }
                        catch (SQLException e) {
                            ArchiveObjectsDBImpl.logger.error((Object)"getObjectTimeStamp", (Throwable)e);
                            var8_10 = null;
                            if (rs == null) return null;
                            try {
                                rs.close();
                                return null;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return null;
                        }
                    }
                    catch (Throwable var7_16) {
                        block26: {
                            var8_11 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [11 : 237->246)] { 
lbl53:
                                // 1 sources

                                rs.close();
                                break block26;
lbl55:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        rs = null;
                        throw var7_16;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [11 : 237->246)] { 
lbl62:
                // 1 sources

                rs.close();
                break block23;
lbl64:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var5_7;
        }
        var8_9 = null;
        if (rs == null) return null;
        ** try [egrp 5[TRYBLOCK] [11 : 237->246)] { 
lbl73:
        // 1 sources

        rs.close();
        return null;
lbl75:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getObjectFileTime(String id) throws UnknownNodeException {
        block25: {
            block23: {
                block24: {
                    block22: {
                        if (this.aodbPlugin != null) {
                            try {
                                pluginResult = this.aodbPlugin.getObjectFileTime(id);
                                if (pluginResult != null) {
                                    return pluginResult;
                                }
                                if (!NodeIdUtils.isNodeId(id)) {
                                    return pluginResult;
                                }
                            }
                            catch (UnknownNodeException une) {
                                if (NodeIdUtils.isNodeId(id)) break block22;
                                throw une;
                            }
                        }
                    }
                    if (!this.statusLog("getObjectFileTime")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        this.throwUnknownObjectException("getObjectFileTime", "", id);
                    }
                    rs = null;
                    try {
                        try {
                            var3_4 = this.getFileTimeFromArchiveObjectsSTM;
                            synchronized (var3_4) {
                                this.getFileTimeFromArchiveObjectsSTM.clearParameters();
                                this.getFileTimeFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                                rs = this.getFileTimeFromArchiveObjectsSTM.executeQuery();
                                if (rs.next()) {
                                    timestamp = rs.getTimestamp("FILETIME");
                                    if (!rs.isLast()) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("getObjectFileTime: ERROR more than one entry for object: " + id));
                                    }
                                    var5_7 = timestamp;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 20, 6] lbl29 : MonitorExitStatement: MONITOREXIT : var3_4
                                    var8_8 = null;
                                    if (rs == null) break block23;
                                    break block24;
                                }
                            }
                            this.throwUnknownObjectException("getObjectFileTime", "", id);
                            break block25;
                        }
                        catch (SQLException e) {
                            ArchiveObjectsDBImpl.logger.error((Object)"getObjectFileTime", (Throwable)e);
                            var8_10 = null;
                            if (rs == null) return null;
                            try {
                                rs.close();
                                return null;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return null;
                        }
                    }
                    catch (Throwable var7_16) {
                        block26: {
                            var8_11 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [11 : 237->246)] { 
lbl53:
                                // 1 sources

                                rs.close();
                                break block26;
lbl55:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        rs = null;
                        throw var7_16;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [11 : 237->246)] { 
lbl62:
                // 1 sources

                rs.close();
                break block23;
lbl64:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var5_7;
        }
        var8_9 = null;
        if (rs == null) return null;
        ** try [egrp 5[TRYBLOCK] [11 : 237->246)] { 
lbl73:
        // 1 sources

        rs.close();
        return null;
lbl75:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AccessInfo getObjectAccessInfo(String id) {
        block25: {
            block23: {
                block24: {
                    block22: {
                        if (this.aodbPlugin != null) {
                            try {
                                pluginResult = this.aodbPlugin.getObjectAccessInfo(id);
                                if (pluginResult != null) {
                                    return pluginResult;
                                }
                                if (!NodeIdUtils.isNodeId(id)) {
                                    return pluginResult;
                                }
                            }
                            catch (UnknownNodeException une) {
                                if (NodeIdUtils.isNodeId(id)) break block22;
                                throw une;
                            }
                        }
                    }
                    if (!this.statusLog("getObjectAccessInfo")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(id)) {
                        this.throwUnknownObjectException("getObjectAccessInfo", "", id);
                    }
                    rs = null;
                    try {
                        try {
                            var3_4 = this.getAccessInfoFromArchiveObjectsSTM;
                            synchronized (var3_4) {
                                this.getAccessInfoFromArchiveObjectsSTM.clearParameters();
                                this.getAccessInfoFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(id));
                                this.getAccessInfoFromArchiveObjectsSTM.setInt(2, NodeIdUtils.TOINT(id));
                                this.getAccessInfoFromArchiveObjectsSTM.setInt(3, NodeIdUtils.TOINT(id));
                                rs = this.getAccessInfoFromArchiveObjectsSTM.executeQuery();
                                if (rs.next()) {
                                    ai = new AccessInfo(null, null, rs.getString("READRIGHTS"), rs.getString("WRITERIGHTS"));
                                    if (!rs.isLast()) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("getAccessInfo: ERROR more than one entry for object: " + id));
                                    }
                                    var5_7 = ai;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 20, 6] lbl31 : MonitorExitStatement: MONITOREXIT : var3_4
                                    var8_8 = null;
                                    if (rs == null) break block23;
                                    break block24;
                                }
                            }
                            this.throwUnknownObjectException("getObjectAccessInfo", "", id);
                            break block25;
                        }
                        catch (SQLException e) {
                            ArchiveObjectsDBImpl.logger.error((Object)"getObjectAccessInfo: ", (Throwable)e);
                            var8_10 = null;
                            if (rs == null) return null;
                            try {
                                rs.close();
                                return null;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return null;
                        }
                    }
                    catch (Throwable var7_16) {
                        block26: {
                            var8_11 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [11 : 282->291)] { 
lbl55:
                                // 1 sources

                                rs.close();
                                break block26;
lbl57:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        rs = null;
                        throw var7_16;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [11 : 282->291)] { 
lbl64:
                // 1 sources

                rs.close();
                break block23;
lbl66:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var5_7;
        }
        var8_9 = null;
        if (rs == null) return null;
        ** try [egrp 5[TRYBLOCK] [11 : 282->291)] { 
lbl75:
        // 1 sources

        rs.close();
        return null;
lbl77:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getObjectSize(String nodeId) throws UnknownNodeException {
        block25: {
            block23: {
                block24: {
                    block22: {
                        if (this.aodbPlugin != null) {
                            try {
                                pluginResult = this.aodbPlugin.getObjectSize(nodeId);
                                if (pluginResult >= 0L) {
                                    return pluginResult;
                                }
                                if (!NodeIdUtils.isNodeId(nodeId)) {
                                    return pluginResult;
                                }
                            }
                            catch (UnknownNodeException une) {
                                if (NodeIdUtils.isNodeId(nodeId)) break block22;
                                throw une;
                            }
                        }
                    }
                    if (!this.statusLog("getObjectSize")) {
                        return -1L;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        this.throwUnknownObjectException("getObjectSize", "", nodeId);
                    }
                    rs = null;
                    size = 0L;
                    try {
                        try {
                            var5_6 = this.getSizeFromArchiveObjectsSTM;
                            synchronized (var5_6) {
                                this.getSizeFromArchiveObjectsSTM.clearParameters();
                                this.getSizeFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                                rs = this.getSizeFromArchiveObjectsSTM.executeQuery();
                                if (rs.next()) {
                                    size = rs.getLong("SIZE");
                                    if (!rs.isLast()) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("getObjectSize: ERROR more than one entry for object: " + nodeId));
                                    }
                                    var6_8 = size;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 20, 6] lbl30 : MonitorExitStatement: MONITOREXIT : var5_6
                                    var10_9 = null;
                                    if (rs == null) break block23;
                                    break block24;
                                }
                            }
                            this.throwUnknownObjectException("getObjectSize: ", "", nodeId);
                            break block25;
                        }
                        catch (SQLException e) {
                            ArchiveObjectsDBImpl.logger.error((Object)("getObjectSize: nodeid=" + NodeIdUtils.TOINT(nodeId) + " " + e));
                            var10_11 = null;
                            if (rs == null) return -1L;
                            try {
                                rs.close();
                                return -1L;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return -1L;
                        }
                    }
                    catch (Throwable var9_17) {
                        block26: {
                            var10_12 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [11 : 275->284)] { 
lbl54:
                                // 1 sources

                                rs.close();
                                break block26;
lbl56:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        rs = null;
                        throw var9_17;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [11 : 275->284)] { 
lbl63:
                // 1 sources

                rs.close();
                break block23;
lbl65:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var6_8;
        }
        var10_10 = null;
        if (rs == null) return -1L;
        ** try [egrp 5[TRYBLOCK] [11 : 275->284)] { 
lbl74:
        // 1 sources

        rs.close();
        return -1L;
lbl76:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getObjectChecksum(String nodeId) {
        block25: {
            block23: {
                block24: {
                    block22: {
                        if (this.aodbPlugin != null) {
                            try {
                                pluginResult = this.aodbPlugin.getObjectChecksum(nodeId);
                                if (pluginResult != null) {
                                    return pluginResult;
                                }
                                if (!NodeIdUtils.isNodeId(nodeId)) {
                                    return pluginResult;
                                }
                            }
                            catch (UnknownNodeException une) {
                                if (NodeIdUtils.isNodeId(nodeId)) break block22;
                                throw une;
                            }
                        }
                    }
                    if (!this.statusLog("getObjectChecksum")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        this.throwUnknownObjectException("getObjectChecksum", "", nodeId);
                    }
                    rs = null;
                    checksum = null;
                    try {
                        try {
                            var4_5 = this.getChecksumFromArchiveObjectsSTM;
                            synchronized (var4_5) {
                                this.getChecksumFromArchiveObjectsSTM.clearParameters();
                                this.getChecksumFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                                rs = this.getChecksumFromArchiveObjectsSTM.executeQuery();
                                if (rs.next()) {
                                    checksum = rs.getString("CHECKSUM");
                                    if (!rs.isLast()) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("getObjectChecksum: ERROR more than one entry for object: " + nodeId));
                                    }
                                    var5_7 = checksum;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 20, 6] lbl30 : MonitorExitStatement: MONITOREXIT : var4_5
                                    var8_8 = null;
                                    if (rs == null) break block23;
                                    break block24;
                                }
                            }
                            this.throwUnknownObjectException("getObjectChecksum: ", "", nodeId);
                            break block25;
                        }
                        catch (SQLException e) {
                            ArchiveObjectsDBImpl.logger.error((Object)"getObjectChecksum: ", (Throwable)e);
                            var8_10 = null;
                            if (rs == null) return null;
                            try {
                                rs.close();
                                return null;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return null;
                        }
                    }
                    catch (Throwable var7_16) {
                        block26: {
                            var8_11 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [11 : 243->252)] { 
lbl54:
                                // 1 sources

                                rs.close();
                                break block26;
lbl56:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        rs = null;
                        throw var7_16;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [11 : 243->252)] { 
lbl63:
                // 1 sources

                rs.close();
                break block23;
lbl65:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var5_7;
        }
        var8_9 = null;
        if (rs == null) return null;
        ** try [egrp 5[TRYBLOCK] [11 : 243->252)] { 
lbl74:
        // 1 sources

        rs.close();
        return null;
lbl76:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return null;
    }

    public boolean isAccessible(String nodeId) throws UnknownNodeException {
        block4: {
            try {
                if (this.aodbPlugin != null && this.aodbPlugin.isAccessible(nodeId)) {
                    return true;
                }
                if (!NodeIdUtils.isNodeId(nodeId)) {
                    return false;
                }
            }
            catch (UnknownNodeException une) {
                if (NodeIdUtils.isNodeId(nodeId)) break block4;
                throw une;
            }
        }
        return this.getObjectSize(nodeId) > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOnSite(String nodeId) throws UnknownNodeException {
        block24: {
            block22: {
                block23: {
                    block21: {
                        try {
                            if (this.aodbPlugin != null && this.aodbPlugin.isOnSite(nodeId)) {
                                return true;
                            }
                            if (!NodeIdUtils.isNodeId(nodeId)) {
                                return false;
                            }
                        }
                        catch (UnknownNodeException une) {
                            if (NodeIdUtils.isNodeId(nodeId)) break block21;
                            throw une;
                        }
                    }
                    if (!this.statusLog("isOnSite")) {
                        return false;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        this.throwUnknownObjectException("isOnSite", "", nodeId);
                    }
                    rs = null;
                    try {
                        try {
                            var3_4 = this.getOnSiteFromArchiveObjectsSTM;
                            synchronized (var3_4) {
                                this.getOnSiteFromArchiveObjectsSTM.clearParameters();
                                this.getOnSiteFromArchiveObjectsSTM.setInt(1, NodeIdUtils.TOINT(nodeId));
                                rs = this.getOnSiteFromArchiveObjectsSTM.executeQuery();
                                if (rs.next()) {
                                    onSite = rs.getBoolean("ONSITE");
                                    if (!rs.isLast()) {
                                        ArchiveObjectsDBImpl.logger.error((Object)("isOnSite: ERROR more than one entry for object: " + nodeId));
                                    }
                                    var5_7 = onSite;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 20, 6] lbl27 : MonitorExitStatement: MONITOREXIT : var3_4
                                    var8_8 = null;
                                    if (rs == null) break block22;
                                    break block23;
                                }
                            }
                            this.throwUnknownObjectException("isOnSite: ", "", nodeId);
                            break block24;
                        }
                        catch (SQLException sqle) {
                            ArchiveObjectsDBImpl.logger.error((Object)("isOnSite(" + nodeId + ") : "), (Throwable)sqle);
                            var8_10 = null;
                            if (rs == null) return false;
                            try {
                                rs.close();
                                return false;
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                            return false;
                        }
                    }
                    catch (Throwable var7_16) {
                        block25: {
                            var8_11 = null;
                            if (rs != null) {
                                ** try [egrp 5[TRYBLOCK] [11 : 257->266)] { 
lbl51:
                                // 1 sources

                                rs.close();
                                break block25;
lbl53:
                                // 1 sources

                                catch (SQLException e) {
                                    // empty catch block
                                }
                            }
                        }
                        rs = null;
                        throw var7_16;
                    }
                }
                ** try [egrp 5[TRYBLOCK] [11 : 257->266)] { 
lbl60:
                // 1 sources

                rs.close();
                break block22;
lbl62:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
            rs = null;
            return var5_7;
        }
        var8_9 = null;
        if (rs == null) return false;
        ** try [egrp 5[TRYBLOCK] [11 : 257->266)] { 
lbl71:
        // 1 sources

        rs.close();
        return false;
lbl73:
        // 1 sources

        catch (SQLException e) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] getNewArchiveObjectsSince(Timestamp timestamp, boolean onsiteonly, boolean urlformat, boolean usefiletime) {
        SQLException e222;
        String[] stringArray;
        Statement statement;
        ResultSet rs;
        block24: {
            String[] pluginResult;
            if (this.aodbPlugin != null && (pluginResult = this.aodbPlugin.getNewArchiveObjectsSince(timestamp, onsiteonly, urlformat, usefiletime)) != null) {
                return pluginResult;
            }
            if (!this.statusLog("getNewArchiveObjectsSince")) {
                return null;
            }
            String format = urlformat ? "URL" : "NODEID";
            if (timestamp != null && timestamp.getTime() == 0L) {
                timestamp = null;
            }
            TreeSet<String> results = new TreeSet<String>(urlformat ? null : new NodeIdComparator());
            rs = null;
            statement = null;
            statement = this.db.getConnection().createStatement();
            String cmd = "SELECT " + format + " FROM " + ARCHIVEOBJECTS;
            if (timestamp != null || onsiteonly) {
                cmd = cmd + " WHERE ";
            }
            if (timestamp != null) {
                cmd = usefiletime ? cmd + "FILETIME" : cmd + "CRAWLTIME";
                cmd = cmd + " > '" + timestamp + "'";
                if (onsiteonly) {
                    cmd = cmd + " AND ";
                }
            }
            if (onsiteonly) {
                cmd = cmd + "ONSITE";
            }
            logger.debug((Object)("getNewArchiveObjectsSince: " + cmd));
            rs = statement.executeQuery(cmd);
            while (rs.next()) {
                String res = null;
                res = urlformat ? rs.getString(1) : NodeIdUtils.TONODEID(rs.getInt(1));
                results.add(res);
            }
            stringArray = results.toArray(new String[0]);
            Object var12_12 = null;
            if (statement == null) break block24;
            try {
                statement.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        rs = null;
        return stringArray;
        catch (SQLException e3) {
            SQLException e222;
            block26: {
                try {
                    logger.error((Object)"getNewArchiveObjectsSince: ", (Throwable)e3);
                    Object var12_13 = null;
                    if (statement == null) break block26;
                }
                catch (Throwable throwable) {
                    SQLException e222;
                    Object var12_14 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            rs = null;
            {
            }
        }
        return null;
    }

    protected void throwUnknownNodeException(String method, String message, String nodeId) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no node with nodeId " + nodeId + ", " + message);
    }

    protected void throwUnknownObjectException(String method, String message, String id) throws UnknownNodeException {
        throw new UnknownNodeException("" + method + ": no object with Id " + id + ", " + message);
    }

    protected boolean statusLog(String method) {
        boolean okay = this.getStatus();
        if (!okay) {
            logger.error((Object)("ArchiveObjectsDBImpl." + method + ": DB / object status is false"));
        }
        return okay;
    }

    protected class NodeIdComparator
    implements Comparator {
        protected NodeIdComparator() {
        }

        public int compare(Object o1, Object o2) {
            try {
                int n1 = NodeIdUtils.TOINT((String)o1);
                int n2 = NodeIdUtils.TOINT((String)o2);
                return n1 < n2 ? -1 : (n1 > n2 ? 1 : 0);
            }
            catch (UnknownNodeException une) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            return ((Comparable)o1).compareTo((Comparable)o2);
        }
    }
}

