/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.index;

import java.io.File;

public class MDIndexConfig {
    static final String dateFile = "databasecreationdate";
    static final String contentFieldName = "content";
    static final String idFieldName = "id";
    static final String nameFieldName = "name";
    static final String titleFieldName = "title";
    static final String urlFieldName = "url";
    static final String treePathFieldName = "treePath";
    public static final String defaultIndexDir = "MDSimpleSearchIndex";
    private static String baseDir = "";

    public static final void setBaseDir(String s) {
        if (s != null) {
            baseDir = s;
        }
    }

    public static final String getIndexDir(String dbName) {
        String indexDir = null;
        if (dbName.matches(".*://.*") || dbName.toLowerCase().startsWith("java:")) {
            indexDir = baseDir + defaultIndexDir;
        } else {
            try {
                int extension = dbName.lastIndexOf(46);
                String modifiedDbName = dbName;
                if (dbName.startsWith("jdbc:hsqldb:")) {
                    modifiedDbName = dbName.substring("jdbc:hsqldb:".length());
                }
                modifiedDbName = modifiedDbName.replace('\\', '/');
                File file = new File(modifiedDbName.substring(0, extension > 0 ? extension : modifiedDbName.length()));
                indexDir = new File(file.getParentFile().getParent() + File.separator + "INDEX", file.getName()).toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return indexDir;
    }
}

