/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import mpi.metadata.search.index.MDAnalyzer;
import mpi.metadata.search.index.SessionFilter;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryFilter;
import org.apache.lucene.search.spans.SpanQuery;

public class MDIndexSearch {
    private static final Logger logger = Logger.getLogger(MDIndexSearch.class);
    private Date DBCreationDate;
    private Date lastModified;
    private IndexSearcher searcher;
    private QueryParser queryParser;

    public MDIndexSearch(String indexFile) throws IOException {
        this.setIndexDir(indexFile);
    }

    public Date getDBCreationDate() {
        return this.DBCreationDate;
    }

    public void setIndexDir(String indexDir) throws IOException {
        File indexFile = new File(indexDir);
        if (!indexFile.exists()) {
            logger.error((Object)("Cannot read index. Directory with name " + indexDir + " doesn't exist."));
            throw new IOException("Cannot read index. Directory with name " + indexDir + " doesn't exist.");
        }
        if (!indexFile.isDirectory()) {
            throw new IOException("Cannot read index. '" + indexDir + "' isn't a directory.");
        }
        this.lastModified = new Date(new File(indexDir).lastModified());
        File dateFile = new File(indexDir, "databasecreationdate");
        if (dateFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(dateFile));
                this.DBCreationDate = new SimpleDateFormat("EEE MMM d hh:mm:ss z yyyy", Locale.US).parse(reader.readLine());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.searcher = new IndexSearcher(indexDir);
        this.queryParser = new QueryParser("content", (Analyzer)new MDAnalyzer());
    }

    public Date lastModified() {
        return this.lastModified;
    }

    public static void main(String[] args) {
        try {
            MDIndexSearch sf = new MDIndexSearch("MDSimpleSearchIndex");
            String querySpec = "aweti";
            HashSet<String> set = new HashSet<String>();
            set.add("MPI66800");
            String[] nodeIDs = sf.performSearch(set, querySpec);
            for (int i = 1; i <= nodeIDs.length; ++i) {
                logger.debug((Object)nodeIDs[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] getTokenNrs(String querySpec, String nodeId) throws Exception {
        int docNumber = this.getDocumentNumber(nodeId);
        if (docNumber == -1) {
            return null;
        }
        HashSet terms = new HashSet();
        this.queryParser.parse(querySpec).rewrite(this.searcher.getIndexReader()).extractTerms(terms);
        HashSet<Integer> tokenNumbers = new HashSet<Integer>();
        for (Term term : terms) {
            logger.info((Object)("Searching for term: " + term.text()));
            TermPositions positions = this.searcher.getIndexReader().termPositions(term);
            if (!positions.skipTo(docNumber) || positions.doc() != docNumber) continue;
            logger.info((Object)("Frequency: " + positions.freq()));
            for (int j = 0; j < positions.freq(); ++j) {
                tokenNumbers.add(new Integer(positions.nextPosition()));
            }
        }
        int[] tokenNrs = new int[tokenNumbers.size()];
        Iterator iter = tokenNumbers.iterator();
        int i = 0;
        while (iter.hasNext()) {
            tokenNrs[i] = (Integer)iter.next();
            ++i;
        }
        Arrays.sort(tokenNrs);
        return tokenNrs;
    }

    public Set getTokens(String querySpec, String nodeId) throws Exception {
        int docNumber = this.getDocumentNumber(nodeId);
        if (docNumber == -1) {
            return null;
        }
        HashSet terms = new HashSet();
        this.queryParser.parse(querySpec).rewrite(this.searcher.getIndexReader()).extractTerms(terms);
        HashSet<String> tokens = new HashSet<String>();
        for (Term term : terms) {
            logger.info((Object)("Searching for term: " + term.text()));
            TermPositions positions = this.searcher.getIndexReader().termPositions(term);
            if (!positions.skipTo(docNumber) || positions.doc() != docNumber) continue;
            tokens.add(term.text());
        }
        return tokens;
    }

    public void performSearch(String querySpec) throws Exception {
        this.performSearch(null, querySpec);
    }

    public String[] performSearch(final Set selectedNodeIds, String querySpec) throws Exception {
        Hits hits;
        boolean filterAfterSearch;
        int cutOff = 1000;
        Query query = this.queryParser.parse(querySpec);
        if (query instanceof PhraseQuery || query instanceof SpanQuery) {
            // empty if block
        }
        logger.info((Object)("Searching index for: " + query.toString("content")));
        BooleanQuery.setMaxClauseCount((int)100000);
        boolean bl = filterAfterSearch = selectedNodeIds != null && selectedNodeIds.size() > cutOff;
        if (selectedNodeIds == null || selectedNodeIds.size() == 0 || filterAfterSearch) {
            hits = this.searcher.search(query);
        } else {
            QueryFilter queryFilter = new QueryFilter((Query)new MultiTermQuery(null){

                public FilteredTermEnum getEnum(IndexReader reader) {
                    SessionFilter filteredTermEnum = null;
                    try {
                        filteredTermEnum = new SessionFilter(selectedNodeIds);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return filteredTermEnum;
                }
            });
            hits = this.searcher.search(query, (Filter)queryFilter);
        }
        ArrayList<String> nodeIdList = new ArrayList<String>();
        for (int i = 0; i < hits.length(); ++i) {
            String nodeId = hits.doc(i).get("id");
            if (filterAfterSearch && !selectedNodeIds.contains(nodeId)) continue;
            nodeIdList.add(nodeId);
        }
        this.searcher.close();
        logger.info((Object)(nodeIdList.size() + " matching documents found"));
        return nodeIdList.toArray(new String[0]);
    }

    private int getDocumentNumber(String nodeId) throws Exception {
        TermDocs termDocs = this.searcher.getIndexReader().termDocs(new Term("id", nodeId));
        if (!termDocs.next()) {
            return -1;
        }
        int docNumber = termDocs.doc();
        if (termDocs.next()) {
            logger.warn((Object)("Node id " + nodeId + " found more than once in index!"));
        }
        return docNumber;
    }
}

