/*
 * Decompiled with CFR 0.152.
 */
package mpi.imdi.api;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.stream.StreamSource;
import mpi.imdi.api.IMDIAPI;
import mpi.imdi.api.IMDIDom;
import mpi.imdi.api.IMDIElement;
import mpi.imdi.api.IMDILink;
import mpi.imdi.api.WSNodeType;
import mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class IMDIAPIImpl
implements IMDIAPI {
    private static IMDIAPIImpl imdiAPIImpl = null;
    private static Logger logger = Logger.getLogger((String)IMDIAPIImpl.class.getName());
    private static IMDIDom iDom = new IMDIDom();
    private EntityResolver resolver = null;
    private String message = "";
    private static final int MAX_FILES_IN_CACHE = 250;
    private static int dom_cnt = 0;
    private File cacheDir = null;
    public static final String defLangId = "ISO639-2:eng";
    private Map doms = Collections.synchronizedMap(new HashMap());
    private Map domsPerWS = Collections.synchronizedMap(new HashMap());
    private Map cacheDirHash = Collections.synchronizedMap(new HashMap());
    private Set modifiedDoms = Collections.synchronizedSet(new HashSet());
    int unique = 0;

    public static IMDIAPIImpl getInstance() {
        if (imdiAPIImpl == null) {
            imdiAPIImpl = new IMDIAPIImpl();
        }
        return imdiAPIImpl;
    }

    private IMDIAPIImpl() {
        this(null);
    }

    public IMDIAPIImpl(File cacheDir) {
        if (cacheDir != null) {
            if (!cacheDir.exists() || !cacheDir.isDirectory()) {
                this.SEPe("does not exist or is not a directory: " + cacheDir);
                this.cacheDir = null;
            }
            if (!cacheDir.canWrite()) {
                this.SEPe("can not write in cache directory: " + cacheDir);
                this.cacheDir = null;
            }
        }
        this.cacheDir = cacheDir;
    }

    public String getMessage() {
        return this.message;
    }

    public void setVerbose(boolean verb) {
        iDom.setVerbose(verb);
    }

    public void setEntityResolver(EntityResolver resolver) {
        iDom.setEntityResolver(resolver);
        this.resolver = resolver;
    }

    public boolean openIMDIFile(int workSpaceId, OurURL url) {
        return this.openIMDIFile(workSpaceId, url, true);
    }

    public boolean closeAllIMDIFiles(boolean save, boolean clean) {
        return this.closeIMDIFiles(-2, save, clean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeIMDIFiles(int workSpaceId, boolean save, boolean clean) {
        boolean success = true;
        String[] keys = null;
        Map map = this.doms;
        synchronized (map) {
            keys = this.doms.keySet().toArray(new String[0]);
        }
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            int wsId = this.getWorkSpaceIdFromKey(key);
            if (workSpaceId != wsId && workSpaceId != -2) continue;
            OurURL url = this.getURLfromKey(key);
            if (url == null) {
                this.SEPi("closeIMDIFiles: invalid URL in key: " + key);
                continue;
            }
            if (this.closeIMDIFile(wsId, url, save, clean)) continue;
            this.SEPi("closeIMDIFiles: error closing file: " + url);
            success = false;
        }
        return success;
    }

    public boolean closeIMDIFile(int workSpaceId, OurURL url, boolean save, boolean clean) {
        if (!save) {
            this.removeKey(workSpaceId, url);
            return true;
        }
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPe("closeIMDIFile: error, not found file " + key);
            return false;
        }
        boolean success = true;
        if (this.isModified(key) || this.cacheDir == null || clean) {
            success = iDom.writeDOM((Document)this.doms.get(key), new File(url.getFile()), clean);
            logger.debug((Object)("closeIMDIFile: written file: " + url));
        }
        if (!this.removeKey(workSpaceId, url)) {
            this.SEPw("closeIMDIFile: key not found in domsPerWS: " + workSpaceId + "," + url);
        }
        return success;
    }

    public boolean saveAllIMDIFiles() {
        return this.saveIMDIFiles(-2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveIMDIFiles(int workSpaceId) {
        boolean success = true;
        logger.info((Object)("saveIMDIFiles starting for " + workSpaceId));
        String[] keys = null;
        Map map = this.doms;
        synchronized (map) {
            keys = this.doms.keySet().toArray(new String[0]);
        }
        for (int i = 0; i < keys.length; ++i) {
            int wsId;
            String key = keys[i];
            if (!this.isModified(key) || workSpaceId != (wsId = this.getWorkSpaceIdFromKey(key)) && workSpaceId != -2) continue;
            OurURL url = this.getURLfromKey(key);
            if (url == null) {
                this.SEPi("saveIMDIFiles: invalid URL in key: " + key);
                continue;
            }
            if (this.saveIMDIFile(wsId, url)) continue;
            this.SEPi("saveIMDIFiles: error saving file: " + url);
            success = false;
        }
        logger.info((Object)("saveIMDIFiles result for " + workSpaceId + " is: " + (success ? "success" : "failure")));
        return success;
    }

    public boolean saveIMDIFile(int workSpaceId, OurURL url) {
        boolean success = true;
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            return true;
        }
        if (this.cacheDir != null) {
            success = this.writeDomToCacheDir(workSpaceId, url);
        } else {
            Document dom = (Document)this.doms.get(key);
            if (dom == null) {
                this.SEPe("saveIMDIFile: No DOM to save for: " + url);
                return false;
            }
            success = iDom.writeDOM(dom, new File(url.getFile()), false);
            this.setModified(key, false);
        }
        return success;
    }

    public boolean saveIMDIFileAs(int workSpaceId, OurURL oldUrl, OurURL newUrl) {
        boolean success = true;
        this.openIMDIFile(workSpaceId, oldUrl, false);
        String key = this.checkFileAvailability(workSpaceId, oldUrl);
        if (key == null) {
            return false;
        }
        Document doc = (Document)this.doms.get(key);
        try {
            success = iDom.writeDOM(doc, new File(newUrl.getFile()), false);
            this.setModified(key, false);
            if (!this.removeKey(workSpaceId, oldUrl)) {
                this.SEPw("saveIMDIFileAs: Just saved a DOM but key not in domsPerWS? " + key);
            }
            this.addDocumentToCache(workSpaceId, newUrl, doc);
        }
        catch (Exception e) {
            this.SEPe("saveIMDIFileAs: " + e.getMessage());
            return false;
        }
        return success;
    }

    public boolean createIMDIFile(int workSpaceId, OurURL url, int imdiFileType) {
        Document doc = iDom.createIMDIDOM(imdiFileType);
        if (doc == null) {
            return false;
        }
        String key = this.addDocumentToCache(workSpaceId, url, doc);
        if (key == null) {
            return false;
        }
        this.setModified(key, true);
        return true;
    }

    public boolean isIMDIFileType(int workSpaceId, OurURL url, int imdiFileType) {
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            return false;
        }
        Document doc = (Document)this.doms.get(key);
        return iDom.isIMDIFileType(doc, imdiFileType);
    }

    public boolean isValidIMDIFile(int workSpaceId, OurURL url) {
        return iDom.isValidIMDIFile(url, this.resolver);
    }

    boolean applyStyleSheet(int workSpaceId, OurURL url, String styleSheetName) {
        try {
            StreamSource sSource = new StreamSource(IMDIAPIImpl.class.getResource(styleSheetName).openStream());
            return this.applyStyleSheet(workSpaceId, url, sSource);
        }
        catch (IOException ioe) {
            this.SEPw("applyStyleSheet: cannot load resource: " + styleSheetName);
            return false;
        }
    }

    boolean applyStyleSheet(int workSpaceId, OurURL url, OurURL styleSheetURL) {
        StreamSource sSource = new StreamSource(styleSheetURL.getPath());
        return this.applyStyleSheet(workSpaceId, url, sSource);
    }

    boolean applyStyleSheet(int workSpaceId, OurURL url, StreamSource styleSource) {
        boolean success;
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key != null) {
            this.saveIMDIFile(workSpaceId, url);
        }
        if (success = iDom.applyStyleSheet(url, styleSource)) {
            this.setModified(key, true);
        }
        return success;
    }

    public IMDILink createIMDILink(int workSpaceId, OurURL url, String urlToLink, String linkName, int linkType, String spec) {
        if (iDom.getVerbose()) {
            logger.debug((Object)("createIMDILink called for node " + url.toString() + " url " + urlToLink + " name " + linkName + " type " + WSNodeType.nameForType(linkType) + " spec " + spec));
        }
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPe("createIMDILink: File not available: " + url);
            return null;
        }
        Document doc = (Document)this.doms.get(key);
        IMDILink result = iDom.createIMDILink(doc, url, urlToLink, linkName, linkType, spec);
        if (result == null) {
            this.SEPw("createIMDILink: Failed for type: " + WSNodeType.nameForType(linkType) + " spec: " + spec + " file: " + url);
        }
        if (result != null) {
            this.setModified(key, true);
        }
        return result;
    }

    public boolean changeIMDILink(int workSpaceId, OurURL url, IMDILink link) {
        if (link == null) {
            return false;
        }
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPw("changeIMDILink: file not available: " + url);
            return false;
        }
        Document doc = (Document)this.doms.get(key);
        boolean result = iDom.changeIMDILink(doc, url, link);
        if (iDom.getVerbose()) {
            logger.debug((Object)("changeIMDILink: changed: " + url + " link: " + link + " url: " + link.getRawURL() + " urid: " + link.getURID() + " success: " + result));
        }
        if (result) {
            this.setModified(key, true);
        }
        return result;
    }

    public boolean removeIMDILink(int workSpaceId, OurURL url, IMDILink il) {
        return this.removeIMDIElement(workSpaceId, url, il);
    }

    public IMDILink[] getIMDILinks(int workSpaceId, OurURL url, int nodeType) {
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPe("getIMDILinks: file not available: " + url);
            return null;
        }
        Document doc = (Document)this.doms.get(key);
        return iDom.getIMDILinks(doc, url, nodeType);
    }

    public IMDILink getIMDILink(int workSpaceId, OurURL url, String domNodeId) {
        if (domNodeId == null || domNodeId.equals("")) {
            return null;
        }
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            return null;
        }
        Document doc = (Document)this.doms.get(key);
        return iDom.getIMDILink(doc, url, domNodeId);
    }

    public IMDIElement setIMDIElement(int workSpaceId, OurURL url, IMDIElement il) {
        if (il.getValue() == null) {
            return null;
        }
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPw("setIMDIElement: file not available: " + url);
            return null;
        }
        Document doc = (Document)this.doms.get(key);
        IMDIElement result = iDom.setIMDIElement(doc, il);
        if (iDom.getVerbose()) {
            logger.debug((Object)("setIMDIElement: file: " + url.toString() + " spec: " + il.getSpec() + " value: " + il.getValue() + " result: " + result));
        }
        if (result != null) {
            this.setModified(key, true);
        }
        return result;
    }

    public boolean setIMDIValue(int workSpaceId, OurURL url, String spec, String value) {
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPw("setIMDIValue: file not available: " + url);
            return false;
        }
        Document doc = (Document)this.doms.get(key);
        boolean result = iDom.setIMDIValue(doc, spec, value);
        if (result) {
            this.setModified(key, true);
        }
        if (iDom.getVerbose()) {
            logger.debug((Object)("setIMDIValue: file: " + url.toString() + " spec: " + spec + " value: " + value + " success: " + result));
        }
        return result;
    }

    public IMDIElement addIMDIElement(int workSpaceId, OurURL url, String spec) {
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPe("addIMDIElement: file not available: " + url);
            return null;
        }
        Document doc = (Document)this.doms.get(key);
        if (doc == null) {
            return null;
        }
        IMDIElement result = iDom.addIMDIElement(doc, spec);
        if (result != null) {
            this.setModified(key, true);
        }
        if (iDom.getVerbose()) {
            logger.debug((Object)("addIMDIElement: file: " + url + " spec: " + spec + " result: " + result));
        }
        return result;
    }

    public boolean removeIMDIElement(int workSpaceId, OurURL url, IMDIElement iEmt) {
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPe("removeIMDIElement: File not available: " + url);
            return false;
        }
        Document doc = (Document)this.doms.get(key);
        boolean result = iDom.removeIMDIElement(doc, iEmt);
        if (result) {
            this.setModified(key, true);
        }
        if (iDom.getVerbose()) {
            logger.debug((Object)("removeIMDIElement: file: " + url + " domId: " + iEmt.getDomId() + ", spec: " + iEmt.getSpec() + " success: " + result));
        }
        return result;
    }

    public IMDIElement getIMDIElement(int workSpaceId, OurURL url, String spec) {
        this.openIMDIFile(workSpaceId, url, false);
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key == null) {
            this.SEPw("getIMDIElement: file not available: " + url);
            return null;
        }
        Document doc = (Document)this.doms.get(key);
        return iDom.getIMDIElement(doc, spec);
    }

    public Hashtable getKeyValuePairs(int workSpaceId, OurURL url, String elementName) {
        this.openIMDIFile(workSpaceId, url, false);
        String dKey = this.checkFileAvailability(workSpaceId, url);
        if (dKey == null) {
            this.SEPw("getKeyValuePairs: file not available: " + url);
            return new Hashtable();
        }
        Document doc = (Document)this.doms.get(dKey);
        return iDom.getKeyValuePairs(doc, elementName);
    }

    public boolean setKeyValuePair(int workSpaceId, OurURL url, String elementName, String key, String value) {
        this.openIMDIFile(workSpaceId, url, false);
        String dKey = this.checkFileAvailability(workSpaceId, url);
        if (dKey == null) {
            this.SEPw("setKeyValuePair: file not available: " + url);
            return false;
        }
        Document doc = (Document)this.doms.get(dKey);
        boolean result = iDom.setKeyValuePair(doc, elementName, key, value);
        if (result) {
            this.setModified(dKey, true);
        }
        return result;
    }

    private String makeKey(int workSpaceId, OurURL url) {
        return "" + workSpaceId + "," + url.toString();
    }

    private OurURL getURLfromKey(String key) {
        OurURL result = null;
        String strUrl = key.split(",")[1];
        try {
            result = new OurURL(strUrl);
        }
        catch (MalformedURLException mue) {
            this.SEPe("could not get URL from key: " + mue.getMessage());
        }
        return result;
    }

    private int getWorkSpaceIdFromKey(String key) {
        int id = -1;
        String strInt = key.split(",")[0];
        try {
            id = new Integer(strInt);
        }
        catch (NumberFormatException nfe) {
            this.SEPe("could not get workspace number from key: " + nfe.getMessage());
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkFileAvailability(int workSpaceId, OurURL url) {
        String key = this.makeKey(workSpaceId, url);
        if (this.doms.containsKey(key) && this.doms.get(key) != null) {
            return key;
        }
        if (this.cacheDir != null && this.cacheDirHash.containsKey(key)) {
            OurURL urlInCache = (OurURL)this.cacheDirHash.get(key);
            File fileInCache = new File(urlInCache.getFile());
            if (fileInCache.exists()) {
                try {
                    Document doc = iDom.loadIMDIDocument(urlInCache, false, this.resolver);
                    if (doc == null) {
                        return null;
                    }
                    this.addDocumentToCache(workSpaceId, url, doc);
                    return key;
                }
                catch (Exception e) {
                    this.SEPe("checkFileAvailability: Disk cache error: " + e.getMessage());
                }
            }
        } else if (this.doms.containsKey(key) && this.doms.get(key) == null) {
            Document doc = null;
            doc = iDom.loadIMDIDocument(url, false, this.resolver);
            if (doc != null) {
                Map fileInCache = this.doms;
                synchronized (fileInCache) {
                    this.doms.put(key, doc);
                }
                ++dom_cnt;
                Vector wsdoms = (Vector)this.domsPerWS.get(String.valueOf(workSpaceId));
                if (wsdoms != null && !wsdoms.contains(key)) {
                    wsdoms.add(key);
                    this.cacheReduction(workSpaceId, "checkFileAvailability", wsdoms);
                }
                logger.debug((Object)("checkFileAvailability: reloaded " + key));
                return key;
            }
            this.SEPe("checkFileAvailability: error reloading document key=" + key + " ,url=" + url);
        } else if (iDom.getVerbose()) {
            logger.debug((Object)("checkFileAvailability:IMDI file with key(" + workSpaceId + "," + url.getPath() + ") not in memory cache."));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addDocumentToCache(int workSpaceId, OurURL url, Document doc) {
        Vector<String> wsdoms;
        String key = this.makeKey(workSpaceId, url);
        Map map = this.doms;
        synchronized (map) {
            this.doms.put(key, doc);
        }
        ++dom_cnt;
        String wsidstr = String.valueOf(workSpaceId);
        Map map2 = this.domsPerWS;
        synchronized (map2) {
            wsdoms = (Vector<String>)this.domsPerWS.get(wsidstr);
            if (wsdoms == null) {
                wsdoms = new Vector<String>(10);
                this.domsPerWS.put(wsidstr, wsdoms);
            }
        }
        wsdoms.add(key);
        this.cacheReduction(workSpaceId, "addDocumentToCache", wsdoms);
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheReduction(int workSpaceId, String reason, Vector wsdoms) {
        if (wsdoms.size() > 250) {
            logger.info((Object)(reason + ": cache reduction at size " + wsdoms.size()));
            for (int reduced = 0; reduced < 10 && !wsdoms.isEmpty(); ++reduced) {
                String aKey = (String)wsdoms.firstElement();
                OurURL anUrl = this.getURLfromKey(aKey);
                if (anUrl == null) continue;
                if (this.cacheDir != null) {
                    this.writeDomToCacheDir(workSpaceId, anUrl);
                } else {
                    this.saveIMDIFile(workSpaceId, anUrl);
                    this.setModified(aKey, true);
                }
                Map map = this.doms;
                synchronized (map) {
                    this.doms.put(aKey, null);
                }
                wsdoms.remove(aKey);
                --dom_cnt;
            }
        }
    }

    private boolean openIMDIFile(int workSpaceId, OurURL url, boolean validateFile) {
        String key = this.checkFileAvailability(workSpaceId, url);
        if (key != null) {
            return true;
        }
        Document doc = iDom.loadIMDIDocument(url, validateFile, this.resolver);
        if (doc == null) {
            return false;
        }
        key = this.addDocumentToCache(workSpaceId, url, doc);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeDomToCacheDir(int workSpaceId, OurURL url) {
        String key = this.makeKey(workSpaceId, url);
        if (!this.isModified(key) && this.cacheDirHash.containsKey(key)) {
            return true;
        }
        Object fileInCacheName = null;
        OurURL urlInCacheDir = null;
        if (this.cacheDirHash.containsKey(key)) {
            urlInCacheDir = (OurURL)this.cacheDirHash.get(key);
        } else {
            File f = new File(this.cacheDir, "" + this.unique++ + "_" + url.getPath().substring(url.getPath().lastIndexOf("/") + 1));
            try {
                urlInCacheDir = new OurURL(f.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                this.SEPe("writeDomToCacheDir: malformed URL: " + mue);
                return false;
            }
        }
        boolean success = iDom.writeDOM((Document)this.doms.get(key), new File(urlInCacheDir.getFile()), false);
        Map map = this.cacheDirHash;
        synchronized (map) {
            this.cacheDirHash.put(key, urlInCacheDir);
        }
        logger.debug((Object)("writeDomToCacheDir: written file " + key + " to " + urlInCacheDir));
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeKey(int workSpaceId, OurURL url) {
        String wsidstr;
        Vector wsdoms;
        String key = this.makeKey(workSpaceId, url);
        boolean dirCache = false;
        Map map = this.doms;
        synchronized (map) {
            if (this.doms.remove(key) != null) {
                --dom_cnt;
            }
        }
        this.setModified(key, false);
        if (this.cacheDir != null && this.cacheDirHash.get(key) != null) {
            OurURL curl = (OurURL)this.cacheDirHash.get(key);
            File cf = new File(curl.getFile());
            cf.delete();
            Map map2 = this.cacheDirHash;
            synchronized (map2) {
                this.cacheDirHash.remove(key);
            }
            dirCache = true;
        }
        if ((wsdoms = (Vector)this.domsPerWS.get(wsidstr = String.valueOf(workSpaceId))) != null) {
            if (!wsdoms.remove(key)) {
                if (dirCache) {
                    logger.debug((Object)("IMDIAPIImpl: removeKey: cached file but key not found in domsPerWS: " + key));
                } else {
                    logger.debug((Object)("IMDIAPIImpl: removeKey: not in cache directory and key not found in domsPerWS: " + key));
                }
                return false;
            }
        } else {
            this.SEPe("IMDIAPIImpl: removeKey: unknown WS for domsPerWS: " + workSpaceId);
            return false;
        }
        return true;
    }

    private boolean isModified(String key) {
        return this.modifiedDoms.contains(key);
    }

    private synchronized boolean setModified(String key, boolean modified) {
        if (modified) {
            if (!this.modifiedDoms.contains(key)) {
                return this.modifiedDoms.add(key);
            }
        } else if (this.modifiedDoms.contains(key)) {
            return this.modifiedDoms.remove(key);
        }
        return true;
    }

    private void SEPi(String errorMessage) {
        iDom.SEPi(errorMessage);
    }

    private void SEPw(String errorMessage) {
        iDom.SEPw(errorMessage);
    }

    private void SEPe(String errorMessage) {
        iDom.SEPe(errorMessage);
    }
}

