/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.net.URI;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.MetadataFile.MetadataReader;
import nl.mpi.arbil.data.ImdiTreeObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryMetadataReader {
    public ImdiField[] getExifMetadata(ImdiTreeObject resourceImdi, int currentFieldId) {
        Vector<ImdiField> exifTagFields = new Vector<ImdiField>();
        System.out.println("tempGetExif: " + resourceImdi.getFile());
        try {
            URI uri = resourceImdi.getURI();
            if (resourceImdi.getFile().getName().contains(".")) {
                String fileSuffix = resourceImdi.getFile().getName().substring(resourceImdi.getFile().getName().lastIndexOf(".") + 1);
                System.out.println("tempGetExifSuffix: " + fileSuffix);
                Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(fileSuffix);
                if (readers.hasNext()) {
                    ImageReader reader = readers.next();
                    reader.setInput(ImageIO.createImageInputStream(uri.toURL().openStream()));
                    IIOMetadata metadata = reader.getImageMetadata(0);
                    if (metadata != null) {
                        String[] names = metadata.getMetadataFormatNames();
                        for (int i = 0; i < names.length; ++i) {
                            System.out.println();
                            System.out.println("METADATA FOR FORMAT: " + names[i]);
                            this.decendExifTree(resourceImdi, metadata.getAsTree(names[i]), null, exifTagFields, currentFieldId);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        System.out.println("end tempGetExif");
        return exifTagFields.toArray(new ImdiField[0]);
    }

    public void decendExifTree(ImdiTreeObject resourceImdi, Node node, String prefixString, Vector<ImdiField> exifTagFields, int currentFieldId) {
        prefixString = prefixString == null ? "EXIF" : prefixString + MetadataReader.imdiPathSeparator + node.getNodeName();
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            for (int attributeCounter = 0; attributeCounter < namedNodeMap.getLength(); ++attributeCounter) {
                String attributeName = namedNodeMap.item(attributeCounter).getNodeName();
                String attributeValue = namedNodeMap.item(attributeCounter).getNodeValue();
                exifTagFields.add(new ImdiField(currentFieldId++, resourceImdi, prefixString + MetadataReader.imdiPathSeparator + attributeName, attributeValue, 0));
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            int ub = children.getLength();
            for (int i = 0; i < ub; ++i) {
                this.decendExifTree(resourceImdi, children.item(i), prefixString, exifTagFields, currentFieldId);
            }
        }
    }
}

