/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.util.ArrayList;
import java.util.Arrays;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgSessionStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentationLanguages {
    static String languageVocabularyUrl = null;

    public ImdiVocabularies.VocabularyItem[] getallLanguages() {
        if (languageVocabularyUrl == null && (languageVocabularyUrl = LinorgSessionStorage.getSingleInstance().loadString("languageVocabularyUrl")) == null) {
            languageVocabularyUrl = "http://www.mpi.nl/IMDI/Schema/ISO639-2Languages.xml";
            LinorgSessionStorage.getSingleInstance().saveString("LanguageVocabularyUrl", languageVocabularyUrl);
        }
        return ImdiVocabularies.getSingleInstance().getVocabulary(null, languageVocabularyUrl).getVocabularyItems();
    }

    public ArrayList<String> getSelectedLanguagesArrayList() {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(LinorgSessionStorage.getSingleInstance().loadStringArray("selectedLanguages")));
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError("No selectedLanguages file, will create one now.", e);
            this.addDefaultTemplates();
        }
        return selectedLanguages;
    }

    public ImdiVocabularies.VocabularyItem[] getLanguageListSubset() {
        ArrayList<ImdiVocabularies.VocabularyItem> languageListSubset = new ArrayList<ImdiVocabularies.VocabularyItem>();
        ArrayList<String> selectedLanguages = this.getSelectedLanguagesArrayList();
        for (ImdiVocabularies.VocabularyItem currentVocabItem : this.getallLanguages()) {
            if (!selectedLanguages.contains(currentVocabItem.languageName)) continue;
            languageListSubset.add(currentVocabItem);
        }
        return languageListSubset.toArray(new ImdiVocabularies.VocabularyItem[0]);
    }

    private void addDefaultTemplates() {
        for (ImdiVocabularies.VocabularyItem currentTemplate : this.getallLanguages()) {
            this.addselectedLanguages(currentTemplate.languageName);
        }
    }

    public void addselectedLanguages(String templateString) {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        try {
            selectedLanguages.addAll(Arrays.asList(LinorgSessionStorage.getSingleInstance().loadStringArray("selectedLanguages")));
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError("No selectedLanguages file, will create one now.", e);
        }
        selectedLanguages.add(templateString);
        LinorgSessionStorage.getSingleInstance().saveStringArray("selectedLanguages", selectedLanguages.toArray(new String[0]));
    }

    public void removeselectedLanguages(String templateString) {
        ArrayList<String> selectedLanguages = new ArrayList<String>();
        selectedLanguages.addAll(Arrays.asList(LinorgSessionStorage.getSingleInstance().loadStringArray("selectedLanguages")));
        while (selectedLanguages.contains(templateString)) {
            selectedLanguages.remove(templateString);
        }
        LinorgSessionStorage.getSingleInstance().saveStringArray("selectedLanguages", selectedLanguages.toArray(new String[0]));
    }
}

