/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.ArbilDragDrop;
import nl.mpi.arbil.ContextMenu;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.ImdiTreeRenderer;
import nl.mpi.arbil.JListToolTip;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.PreviewSplitPanel;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiTree
extends JTree {
    JListToolTip listToolTip = new JListToolTip();
    static final Object sortLockObject = new Object();
    private boolean sortThreadRunning = false;
    private boolean sortRequested = false;
    public ImdiTreeObject[] rootNodeChildren;

    public ImdiTree() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ImdiTree.this.treeMousePressedReleased(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                ImdiTree.this.treeMousePressedReleased(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                ImdiTree.this.treeKeyTyped(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                if (evt.getModifiers() == 0 && evt.getButton() == 1) {
                    System.out.println("jTree1MouseDragged");
                    JComponent c = (JComponent)evt.getSource();
                    TransferHandler th = c.getTransferHandler();
                    th.exportAsDrag(c, evt, 1);
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent evt) {
                DefaultMutableTreeNode parentNode = null;
                if (evt.getPath() != null) {
                    parentNode = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
                    ImdiTree.this.requestResort();
                }
            }

            public void treeCollapsed(TreeExpansionEvent evt) {
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
                if (evt.getPath().getPathCount() == 1) {
                    System.out.println("root node cannot be collapsed");
                    throw new ExpandVetoException(evt, "root node cannot be collapsed");
                }
            }

            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                if (PreviewSplitPanel.previewTableShown && PreviewSplitPanel.previewTable != null) {
                    TableCellEditor currentCellEditor = PreviewSplitPanel.previewTable.getCellEditor();
                    if (currentCellEditor != null) {
                        currentCellEditor.stopCellEditing();
                    }
                    ((ImdiTableModel)PreviewSplitPanel.previewTable.getModel()).removeAllImdiRows();
                    ((ImdiTableModel)PreviewSplitPanel.previewTable.getModel()).addSingleImdiObject(((ImdiTree)evt.getSource()).getLeadSelectionNode());
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new ImdiTreeRenderer());
        ArbilDragDrop.getSingleInstance().addDrag(this);
    }

    private void treeMousePressedReleased(MouseEvent evt) {
        TreePath clickedNodePath = ((JTree)evt.getSource()).getPathForLocation(evt.getX(), evt.getY());
        int clickedNodeInt = ((JTree)evt.getSource()).getClosestRowForLocation(evt.getX(), evt.getY());
        int leadSelectedInt = ((JTree)evt.getSource()).getLeadSelectionRow();
        boolean clickedPathIsSelected = ((JTree)evt.getSource()).isPathSelected(clickedNodePath);
        if (evt.isPopupTrigger() && !evt.isShiftDown() && !evt.isControlDown() && !clickedPathIsSelected) {
            ((JTree)evt.getSource()).clearSelection();
            ((JTree)evt.getSource()).addSelectionPath(clickedNodePath);
        }
        if (evt.isPopupTrigger()) {
            ContextMenu.getSingleInstance().showTreePopup(evt.getSource(), evt.getX(), evt.getY());
        }
    }

    private void treeKeyTyped(KeyEvent evt) {
        System.out.println(evt.paramString());
        if (evt.getKeyChar() == '\n') {
            LinorgWindowManager.getSingleInstance().openFloatingTableOnce(((ImdiTree)evt.getSource()).getSelectedNodes(), null);
        }
        if (evt.getKeyChar() == '\u007f') {
            TreeHelper.getSingleInstance().deleteNode((JTree)evt.getSource());
        }
        System.out.println("evt.getKeyChar(): " + evt.getKeyChar());
        System.out.println("VK_CONTEXT_MENU: 525");
        if (evt.getKeyCode() == 525) {
            Rectangle selectionBounds = ((JTree)evt.getSource()).getRowBounds(((JTree)evt.getSource()).getLeadSelectionRow());
            ContextMenu.getSingleInstance().showTreePopup(evt.getSource(), selectionBounds.x, selectionBounds.y);
        }
    }

    public JToolTip createToolTip() {
        this.listToolTip.updateList();
        return this.listToolTip;
    }

    public String getToolTipText(MouseEvent event) {
        String tip = null;
        Point p = event.getPoint();
        TreePath treePath = ((ImdiTree)event.getComponent()).getPathForLocation(p.x, p.y);
        if (this.getRowForLocation(event.getX(), event.getY()) == -1) {
            this.listToolTip.setTartgetObject(null);
        } else {
            TreePath curPath = this.getPathForLocation(event.getX(), event.getY());
            Object targetObject = ((DefaultMutableTreeNode)curPath.getLastPathComponent()).getUserObject();
            if (targetObject instanceof ImdiTreeObject) {
                this.listToolTip.setTartgetObject(targetObject);
                tip = ((ImdiTreeObject)targetObject).getUrlString();
            } else {
                this.listToolTip.setTartgetObject(null);
            }
        }
        return tip;
    }

    public ImdiTreeObject[] getSelectedNodes() {
        ArrayList<ImdiTreeObject> selectedNodes = new ArrayList<ImdiTreeObject>();
        for (int selectedCount = 0; selectedCount < this.getSelectionCount(); ++selectedCount) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getSelectionPaths()[selectedCount].getLastPathComponent();
            if (!(parentNode.getUserObject() instanceof ImdiTreeObject)) continue;
            ImdiTreeObject currentTreeObject = (ImdiTreeObject)parentNode.getUserObject();
            selectedNodes.add(currentTreeObject);
        }
        return selectedNodes.toArray(new ImdiTreeObject[0]);
    }

    public ImdiTreeObject getLeadSelectionNode() {
        DefaultMutableTreeNode selectedTreeNode = null;
        ImdiTreeObject returnObject = null;
        TreePath currentNodePath = this.getSelectionPath();
        if (currentNodePath != null) {
            selectedTreeNode = (DefaultMutableTreeNode)currentNodePath.getLastPathComponent();
        }
        if (selectedTreeNode != null && selectedTreeNode.getUserObject() instanceof ImdiTreeObject) {
            returnObject = (ImdiTreeObject)selectedTreeNode.getUserObject();
        }
        return returnObject;
    }

    public void copyNodeUrlToClipboard(ImdiTreeObject[] selectedNodes) {
        if (selectedNodes != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String copiedNodeUrls = null;
            for (ImdiTreeObject currentNode : selectedNodes) {
                if (currentNode == null) continue;
                copiedNodeUrls = copiedNodeUrls == null ? "" : copiedNodeUrls.concat("\n");
                try {
                    if (currentNode.hasResource()) {
                        copiedNodeUrls = copiedNodeUrls.concat(URLDecoder.decode(currentNode.getFullResourceURI().toString(), "UTF-8"));
                        continue;
                    }
                    copiedNodeUrls = copiedNodeUrls.concat(URLDecoder.decode(currentNode.getURI().toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException murle) {
                    GuiHelper.linorgBugCatcher.logError(murle);
                }
            }
            StringSelection stringSelection = new StringSelection(copiedNodeUrls);
            clipboard.setContents(stringSelection, GuiHelper.clipboardOwner);
            System.out.println("copied: \n" + copiedNodeUrls);
        }
    }

    private void sortDescendentNodes(DefaultMutableTreeNode currentNode) {
        ImdiTreeObject curentImdiObject;
        System.out.println("currentNode: " + currentNode);
        boolean isExpanded = true;
        Object[] childImdiObjectArray = this.rootNodeChildren;
        if (currentNode instanceof DefaultMutableTreeNode && currentNode.getUserObject() instanceof ImdiTreeObject && (curentImdiObject = (ImdiTreeObject)currentNode.getUserObject()) != null) {
            childImdiObjectArray = curentImdiObject.getChildArray();
            isExpanded = this.isExpanded(new TreePath(currentNode.getPath()));
        }
        Arrays.sort(childImdiObjectArray);
        if (childImdiObjectArray.length > 0) {
            currentNode.setAllowsChildren(true);
        }
        if (!isExpanded) {
            for (int childIndex = childImdiObjectArray.length; childIndex < currentNode.getChildCount(); ++childIndex) {
                DefaultMutableTreeNode removedNode = (DefaultMutableTreeNode)currentNode.getChildAt(childIndex);
                ImdiTreeObject removedTreeObject = (ImdiTreeObject)removedNode.getUserObject();
                removedTreeObject.removeContainer(this);
            }
            currentNode.setAllowsChildren(childImdiObjectArray.length > 0);
        } else {
            int childIndex;
            for (childIndex = currentNode.getChildCount(); childIndex < childImdiObjectArray.length; ++childIndex) {
                DefaultMutableTreeNode addableNode = new DefaultMutableTreeNode(childImdiObjectArray[childIndex]);
                currentNode.add(addableNode);
                ((DefaultTreeModel)this.treeModel).nodesWereInserted(currentNode, new int[]{childIndex});
                ((ImdiTreeObject)childImdiObjectArray[childIndex]).registerContainer(this);
            }
            childIndex = currentNode.getChildCount() - 1;
            while (childIndex >= childImdiObjectArray.length) {
                DefaultMutableTreeNode removedNode = (DefaultMutableTreeNode)currentNode.getChildAt(childIndex);
                ImdiTreeObject removedTreeObject = (ImdiTreeObject)removedNode.getUserObject();
                currentNode.remove(childIndex);
                ((DefaultTreeModel)this.treeModel).nodesWereRemoved(currentNode, new int[]{childIndex--}, new DefaultMutableTreeNode[]{removedNode});
                removedTreeObject.removeContainer(this);
            }
            childIndex = 0;
            while (childIndex < childImdiObjectArray.length) {
                if (!((DefaultMutableTreeNode)currentNode.getChildAt(childIndex)).getUserObject().equals(childImdiObjectArray[childIndex])) {
                    ((DefaultMutableTreeNode)currentNode.getChildAt(childIndex)).setUserObject(childImdiObjectArray[childIndex]);
                    ((ImdiTreeObject)childImdiObjectArray[childIndex]).registerContainer(this);
                }
                ((DefaultTreeModel)this.treeModel).nodesChanged(currentNode, new int[]{childIndex++});
            }
            Enumeration<TreeNode> childTreeNodeEnum = currentNode.children();
            while (childTreeNodeEnum.hasMoreElements()) {
                this.sortDescendentNodes((DefaultMutableTreeNode)childTreeNodeEnum.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestResort() {
        Object object = sortLockObject;
        synchronized (object) {
            this.sortRequested = true;
            if (!this.sortThreadRunning) {
                this.sortThreadRunning = true;
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            while (ImdiTree.this.sortRequested) {
                                7.sleep(100L);
                                ImdiTree.this.sortRequested = false;
                                ImdiTree.this.sortDescendentNodes((DefaultMutableTreeNode)ImdiTree.this.getModel().getRoot());
                            }
                        }
                        catch (Exception exception) {
                            GuiHelper.linorgBugCatcher.logError(exception);
                        }
                        Object object = sortLockObject;
                        synchronized (object) {
                            ImdiTree.this.sortThreadRunning = false;
                        }
                    }
                }.start();
            }
        }
    }
}

