/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ArbilDragDrop;
import nl.mpi.arbil.ContextMenu;
import nl.mpi.arbil.FindReplacePanel;
import nl.mpi.arbil.ImageBoxRenderer;
import nl.mpi.arbil.ImdiTable;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiTreeObject;

public class LinorgSplitPanel
extends JPanel {
    private JList fileList;
    public ImdiTable imdiTable;
    private JScrollPane tableScrollPane;
    private JScrollPane listScroller;
    private JSplitPane splitPane;
    private JLabel hiddenColumnsLabel;
    private FindReplacePanel findReplacePanel = null;
    private boolean showSearchPanel = false;
    private JPanel tableOuterPanel;
    boolean selectionChangeInProcess = false;

    public LinorgSplitPanel(ImdiTable localImdiTable) {
        this.setLayout(new BorderLayout());
        this.imdiTable = localImdiTable;
        this.splitPane = new JSplitPane();
        this.hiddenColumnsLabel = new JLabel();
        this.tableScrollPane = new JScrollPane(this.imdiTable);
        this.tableScrollPane.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                LinorgSplitPanel.this.imdiTable.setColumnWidths();
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        this.tableOuterPanel = new JPanel(new BorderLayout());
        this.tableOuterPanel.add((Component)this.tableScrollPane, "Center");
        this.tableOuterPanel.add((Component)this.hiddenColumnsLabel, "South");
        ((ImdiTableModel)localImdiTable.getModel()).setHiddenColumnsLabel(this.hiddenColumnsLabel);
        this.fileList = new JList(((ImdiTableModel)localImdiTable.getModel()).getListModel(this));
        this.fileList.setSelectionMode(1);
        this.fileList.setLayoutOrientation(2);
        this.fileList.setVisibleRowCount(-1);
        this.listScroller = new JScrollPane(this.fileList);
        this.listScroller.setPreferredSize(new Dimension(250, 80));
        ImageBoxRenderer renderer = new ImageBoxRenderer();
        this.fileList.setCellRenderer(renderer);
        this.splitPane.setOrientation(0);
        this.splitPane.setDividerSize(5);
        this.fileList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    ContextMenu.getSingleInstance().showTreePopup(evt.getSource(), evt.getX(), evt.getY());
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    ContextMenu.getSingleInstance().showTreePopup(evt.getSource(), evt.getX(), evt.getY());
                }
            }
        });
        this.fileList.setSelectionMode(2);
        this.fileList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !LinorgSplitPanel.this.selectionChangeInProcess) {
                    LinorgSplitPanel.this.selectionChangeInProcess = true;
                    if (e.getSource() instanceof JList) {
                        LinorgSplitPanel.this.imdiTable.clearSelection();
                        int minSelectedRow = -1;
                        int maxSelectedRow = -1;
                        for (Object selectedRow : ((JList)e.getSource()).getSelectedValues()) {
                            LinorgSplitPanel.this.imdiTable.setColumnSelectionAllowed(false);
                            LinorgSplitPanel.this.imdiTable.setRowSelectionAllowed(true);
                            for (int rowCount = 0; rowCount < LinorgSplitPanel.this.imdiTable.getRowCount(); ++rowCount) {
                                if (!LinorgSplitPanel.this.imdiTable.getValueAt(rowCount, 0).equals(selectedRow)) continue;
                                LinorgSplitPanel.this.imdiTable.addRowSelectionInterval(rowCount, rowCount);
                                if (maxSelectedRow == -1 || maxSelectedRow < rowCount) {
                                    maxSelectedRow = rowCount;
                                }
                                if (minSelectedRow != -1 && minSelectedRow <= rowCount) continue;
                                minSelectedRow = rowCount;
                            }
                            if (maxSelectedRow == -1) continue;
                            LinorgSplitPanel.this.imdiTable.scrollRectToVisible(LinorgSplitPanel.this.imdiTable.getCellRect(minSelectedRow, 0, true));
                        }
                        if (LinorgSessionStorage.getSingleInstance().trackTableSelection) {
                            TreeHelper.getSingleInstance().jumpToSelectionInTree(true, (ImdiTreeObject)((JList)e.getSource()).getSelectedValue());
                        }
                    }
                    LinorgSplitPanel.this.selectionChangeInProcess = false;
                }
            }
        });
        this.imdiTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !LinorgSplitPanel.this.selectionChangeInProcess) {
                    LinorgSplitPanel.this.selectionChangeInProcess = true;
                    LinorgSplitPanel.this.fileList.clearSelection();
                    int minSelectedRow = -1;
                    int maxSelectedRow = -1;
                    for (ImdiTreeObject selectedRow : LinorgSplitPanel.this.imdiTable.getSelectedRowsFromTable()) {
                        for (int rowCount = 0; rowCount < LinorgSplitPanel.this.fileList.getModel().getSize(); ++rowCount) {
                            if (!LinorgSplitPanel.this.fileList.getModel().getElementAt(rowCount).equals(selectedRow)) continue;
                            LinorgSplitPanel.this.fileList.addSelectionInterval(rowCount, rowCount);
                            if (maxSelectedRow == -1 || maxSelectedRow < rowCount) {
                                maxSelectedRow = rowCount;
                            }
                            if (minSelectedRow != -1 && minSelectedRow <= rowCount) continue;
                            minSelectedRow = rowCount;
                        }
                    }
                    if (maxSelectedRow != -1) {
                        LinorgSplitPanel.this.fileList.scrollRectToVisible(LinorgSplitPanel.this.fileList.getCellBounds(minSelectedRow, maxSelectedRow));
                    }
                    if (LinorgSessionStorage.getSingleInstance().trackTableSelection) {
                        TreeHelper.getSingleInstance().jumpToSelectionInTree(true, LinorgSplitPanel.this.imdiTable.getImdiNodeForSelection());
                    }
                    LinorgSplitPanel.this.selectionChangeInProcess = false;
                }
            }
        });
    }

    public void showSearchPane() {
        if (this.findReplacePanel == null) {
            this.findReplacePanel = new FindReplacePanel(this);
        }
        if (!this.showSearchPanel) {
            this.tableOuterPanel.remove(this.hiddenColumnsLabel);
            this.tableOuterPanel.add((Component)this.findReplacePanel, "South");
        } else {
            this.tableOuterPanel.remove(this.findReplacePanel);
            this.tableOuterPanel.add((Component)this.hiddenColumnsLabel, "South");
        }
        this.showSearchPanel = !this.showSearchPanel;
        this.revalidate();
        this.repaint();
    }

    public void setSplitDisplay() {
        this.removeAll();
        if (this.fileList.getModel().getSize() == 0) {
            this.add(this.tableOuterPanel);
        } else {
            this.splitPane.setTopComponent(this.tableOuterPanel);
            this.splitPane.setBottomComponent(this.listScroller);
            ArbilDragDrop.getSingleInstance().addDrag(this.fileList);
            ArbilDragDrop.getSingleInstance().addTransferHandler(this.tableScrollPane);
            this.add(this.splitPane);
            this.doLayout();
            this.splitPane.setDividerLocation(0.5);
        }
        ArbilDragDrop.getSingleInstance().addDrag(this.imdiTable);
        ArbilDragDrop.getSingleInstance().addTransferHandler(this);
        this.doLayout();
    }

    public void doLayout() {
        super.doLayout();
    }

    public void addFocusListener(JInternalFrame internalFrame) {
        internalFrame.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameDeactivated(InternalFrameEvent e) {
                TableCellEditor tableCellEditor = LinorgSplitPanel.this.imdiTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                super.internalFrameDeactivated(e);
            }
        });
    }
}

