/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.importexport;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.DownloadAbortFlag;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.LinorgJournal;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.MetadataFile.MetadataUtils;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.XsdChecker;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.importexport.ShibbolethNegotiator;

public class ImportExportDialog {
    private JDialog searchDialog;
    private JPanel searchPanel;
    private JPanel inputNodePanel;
    private JPanel outputNodePanel;
    private JCheckBox copyFilesCheckBox;
    private JCheckBox renameFileToNodeName;
    private JCheckBox detailsCheckBox;
    private JCheckBox overwriteCheckBox;
    private JCheckBox shibbolethCheckBox;
    private JPanel shibbolethPanel;
    private JProgressBar progressBar;
    private JLabel diskSpaceLabel;
    JPanel detailsPanel;
    JPanel bottomPanel;
    private JLabel progressFoundLabel;
    private JLabel progressProcessedLabel;
    private JLabel progressAlreadyInCacheLabel;
    private JLabel progressFailedLabel;
    private JLabel progressXmlErrorsLabel;
    private JLabel resourceCopyErrorsLabel;
    private JButton showInTableButton;
    String progressFoundLabelText = "Total Metadata Files Found: ";
    String progressProcessedLabelText = "Total Metadata Files Processed: ";
    String progressAlreadyInCacheLabelText = "Metadata Files already in Local Corpus: ";
    String progressFailedLabelText = "Metadata File Copy Errors: ";
    String progressXmlErrorsLabelText = "Metadata File Validation Errors: ";
    String resourceCopyErrorsLabelText = "Resource File Copy Errors: ";
    String diskFreeLabelText = "Total Disk Free: ";
    private JButton stopButton;
    private JButton startButton;
    private JTabbedPane detailsTabPane;
    private JTextArea taskOutput;
    private JTextArea xmlOutput;
    private JTextArea resourceCopyOutput;
    private boolean stopSearch = false;
    private Vector selectedNodes;
    ImdiTreeObject destinationNode = null;
    File exportDestinationDirectory = null;
    DownloadAbortFlag downloadAbortFlag = new DownloadAbortFlag();
    ShibbolethNegotiator shibbolethNegotiator = null;
    Vector<URI> validationErrors = new Vector();
    Vector<URI> metaDataCopyErrors = new Vector();
    Vector<URI> fileCopyErrors = new Vector();

    private void setNodesPanel(ImdiTreeObject selectedNode, JPanel nodePanel) {
        JLabel currentLabel = new JLabel(selectedNode.toString(), selectedNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setNodesPanel(Vector selectedNodes, JPanel nodePanel) {
        Enumeration selectedNodesEnum = selectedNodes.elements();
        while (selectedNodesEnum.hasMoreElements()) {
            ImdiTreeObject currentNode = (ImdiTreeObject)selectedNodesEnum.nextElement();
            JLabel currentLabel = new JLabel(currentNode.toString(), currentNode.getIcon(), 0);
            nodePanel.add(currentLabel);
        }
    }

    private void setLocalCacheToNodesPanel(JPanel nodePanel) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)TreeHelper.getSingleInstance().localCorpusTreeModel.getRoot();
        JLabel rootNodeLabel = (JLabel)rootNode.getUserObject();
        JLabel currentLabel = new JLabel(rootNodeLabel.getText(), rootNodeLabel.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setLocalFileToNodesPanel(JPanel nodePanel, File destinationDirectory) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)TreeHelper.getSingleInstance().localDirectoryTreeModel.getRoot();
        JLabel rootNodeLabel = (JLabel)rootNode.getUserObject();
        JLabel currentLabel = new JLabel(destinationDirectory.getPath(), rootNodeLabel.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    public void importImdiBranch() {
        File[] selectedFiles = LinorgWindowManager.getSingleInstance().showFileSelectBox("Import", false, true, true);
        if (selectedFiles != null) {
            Vector<ImdiTreeObject> importNodeVector = new Vector<ImdiTreeObject>();
            for (File currentFile : selectedFiles) {
                ImdiTreeObject imdiToImport = ImdiLoader.getSingleInstance().getImdiObject(null, currentFile.toURI());
                importNodeVector.add(imdiToImport);
            }
            this.copyToCache(importNodeVector);
        }
    }

    public void selectExportDirectoryAndExport(ImdiTreeObject[] localCorpusSelectedNodes) {
        this.searchDialog.setTitle("Export Branch");
        File destinationDirectory = LinorgWindowManager.getSingleInstance().showEmptyExportDirectoryDialogue(this.searchDialog.getTitle());
        if (destinationDirectory != null) {
            this.exportFromCache(new Vector<ImdiTreeObject>(Arrays.asList(localCorpusSelectedNodes)), destinationDirectory);
        }
    }

    private void exportFromCache(Vector localSelectedNodes, File destinationDirectory) {
        this.selectedNodes = localSelectedNodes;
        if (!this.selectedNodesContainImdi()) {
            JOptionPane.showMessageDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "No relevant nodes are selected", this.searchDialog.getTitle(), -1);
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        this.setLocalFileToNodesPanel(this.outputNodePanel, destinationDirectory);
        this.exportDestinationDirectory = destinationDirectory;
        this.searchDialog.setVisible(true);
    }

    public void copyToCache(ImdiTreeObject[] localSelectedNodes) {
        this.copyToCache(new Vector<ImdiTreeObject>(Arrays.asList(localSelectedNodes)));
    }

    public void setDestinationNode(ImdiTreeObject localDestinationNode) {
        this.destinationNode = localDestinationNode;
        this.setNodesPanel(this.destinationNode, this.outputNodePanel);
    }

    public void copyToCache(Vector localSelectedNodes) {
        this.selectedNodes = localSelectedNodes;
        this.searchDialog.setTitle("Import Branch");
        if (!this.selectedNodesContainImdi()) {
            JOptionPane.showMessageDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "No relevant nodes are selected", this.searchDialog.getTitle(), -1);
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        if (this.destinationNode == null) {
            this.setLocalCacheToNodesPanel(this.outputNodePanel);
        }
        this.searchDialog.setVisible(true);
    }

    private boolean selectedNodesContainImdi() {
        Enumeration selectedNodesEnum = this.selectedNodes.elements();
        while (selectedNodesEnum.hasMoreElements()) {
            if (!(selectedNodesEnum.nextElement() instanceof ImdiTreeObject)) continue;
            return true;
        }
        return false;
    }

    private void showDetails(boolean showFlag) {
        if (!showFlag || this.detailsTabPane.isVisible() != showFlag) {
            this.detailsTabPane.setVisible(showFlag);
            this.bottomPanel.setVisible(showFlag);
            this.copyFilesCheckBox.setVisible(showFlag);
            this.renameFileToNodeName.setVisible(showFlag && this.exportDestinationDirectory != null);
            this.overwriteCheckBox.setVisible(showFlag && this.exportDestinationDirectory == null);
            this.shibbolethPanel.setVisible(showFlag);
            this.outputNodePanel.setVisible(false);
            this.inputNodePanel.setVisible(false);
            this.outputNodePanel.setVisible(true);
            this.inputNodePanel.setVisible(true);
        }
    }

    public ImportExportDialog(Component targetComponent) throws Exception {
        LinorgWindowManager.getSingleInstance().offerUserToSaveChanges();
        this.searchDialog = new JDialog(JOptionPane.getFrameForComponent(LinorgWindowManager.getSingleInstance().linorgFrame), true);
        this.searchDialog.addWindowStateListener(new WindowAdapter(){

            public void windowStateChanged(WindowEvent e) {
                if ((e.getNewState() & 6) == 6) {
                    ImportExportDialog.this.detailsCheckBox.setSelected(true);
                    ImportExportDialog.this.showDetails(true);
                } else {
                    ImportExportDialog.this.searchDialog.pack();
                }
            }
        });
        this.searchDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportExportDialog.this.stopSearch = true;
                ImportExportDialog.this.downloadAbortFlag.abortDownload = true;
            }
        });
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout(new BorderLayout());
        this.searchDialog.getContentPane().setLayout(new BorderLayout());
        this.searchDialog.add((Component)this.searchPanel, "Center");
        JPanel inOutNodePanel = new JPanel();
        inOutNodePanel.setLayout(new BoxLayout(inOutNodePanel, 3));
        JPanel inputNodeLabelPanel = new JPanel();
        inputNodeLabelPanel.setLayout(new BorderLayout());
        this.inputNodePanel = new JPanel();
        this.inputNodePanel.setLayout(new GridLayout());
        inputNodeLabelPanel.add((Component)new JLabel("From: "), "Before");
        inputNodeLabelPanel.add((Component)this.inputNodePanel, "Center");
        inOutNodePanel.add(inputNodeLabelPanel);
        JPanel outputNodeLabelPanel = new JPanel();
        outputNodeLabelPanel.setLayout(new BorderLayout());
        this.outputNodePanel = new JPanel();
        this.outputNodePanel.setLayout(new GridLayout());
        outputNodeLabelPanel.add((Component)new JLabel("To: "), "Before");
        outputNodeLabelPanel.add((Component)this.outputNodePanel, "Center");
        inOutNodePanel.add(outputNodeLabelPanel);
        this.detailsCheckBox = new JCheckBox("Show Details", false);
        this.detailsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.showDetails(ImportExportDialog.this.detailsCheckBox.isSelected());
                    ImportExportDialog.this.searchDialog.pack();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        JPanel detailsCheckBoxPanel = new JPanel();
        detailsCheckBoxPanel.setLayout(new GridLayout());
        detailsCheckBoxPanel.add(this.detailsCheckBox);
        inOutNodePanel.add(detailsCheckBoxPanel);
        this.searchPanel.add((Component)inOutNodePanel, "North");
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new BoxLayout(this.detailsPanel, 3));
        this.copyFilesCheckBox = new JCheckBox("Copy Resource Files (if available)", false);
        this.renameFileToNodeName = new JCheckBox("Rename Metadata Files (to match local corpus tree names)", true);
        this.overwriteCheckBox = new JCheckBox("Overwrite Local Changes", false);
        this.shibbolethCheckBox = new JCheckBox("Shibboleth authentication via the SURFnet method", false);
        this.shibbolethPanel = new JPanel();
        this.shibbolethCheckBox.setVisible(false);
        this.shibbolethPanel.setVisible(false);
        this.shibbolethCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ImportExportDialog.this.shibbolethCheckBox.isSelected()) {
                    if (ImportExportDialog.this.shibbolethNegotiator == null) {
                        ImportExportDialog.this.shibbolethNegotiator = new ShibbolethNegotiator();
                    }
                    ImportExportDialog.this.shibbolethPanel.add(ImportExportDialog.this.shibbolethNegotiator.getControlls());
                } else {
                    ImportExportDialog.this.shibbolethPanel.removeAll();
                    ImportExportDialog.this.shibbolethNegotiator = null;
                }
                ImportExportDialog.this.searchDialog.pack();
            }
        });
        this.copyFilesCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportExportDialog.this.shibbolethCheckBox.setVisible(ImportExportDialog.this.copyFilesCheckBox.isSelected());
                ImportExportDialog.this.shibbolethPanel.setVisible(ImportExportDialog.this.copyFilesCheckBox.isSelected());
                ImportExportDialog.this.searchDialog.pack();
            }
        });
        this.detailsPanel.add((Component)this.renameFileToNodeName, "North");
        this.detailsPanel.add((Component)this.overwriteCheckBox, "North");
        this.detailsPanel.add((Component)this.copyFilesCheckBox, "North");
        this.detailsPanel.add((Component)this.shibbolethCheckBox, "North");
        this.detailsPanel.add((Component)this.shibbolethPanel, "North");
        this.detailsTabPane = new JTabbedPane();
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.detailsTabPane.add("Process Details", new JScrollPane(this.taskOutput));
        this.xmlOutput = new JTextArea(5, 20);
        this.xmlOutput.setMargin(new Insets(5, 5, 5, 5));
        this.xmlOutput.setEditable(false);
        this.detailsTabPane.add("Validation Errors", new JScrollPane(this.xmlOutput));
        this.resourceCopyOutput = new JTextArea(5, 20);
        this.resourceCopyOutput.setMargin(new Insets(5, 5, 5, 5));
        this.resourceCopyOutput.setEditable(false);
        this.detailsTabPane.add("Resource Copy Errors", new JScrollPane(this.resourceCopyOutput));
        this.detailsPanel.add((Component)this.detailsTabPane, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 3));
        this.progressFoundLabel = new JLabel(this.progressFoundLabelText);
        this.progressProcessedLabel = new JLabel(this.progressProcessedLabelText);
        this.progressAlreadyInCacheLabel = new JLabel(this.progressAlreadyInCacheLabelText);
        this.progressFailedLabel = new JLabel(this.progressFailedLabelText);
        this.progressXmlErrorsLabel = new JLabel(this.progressXmlErrorsLabelText);
        this.resourceCopyErrorsLabel = new JLabel(this.resourceCopyErrorsLabelText);
        this.showInTableButton = new JButton("Show errors in table");
        this.diskSpaceLabel = new JLabel(this.diskFreeLabelText);
        this.progressAlreadyInCacheLabel.setForeground(Color.darkGray);
        this.progressFailedLabel.setForeground(Color.red);
        this.progressXmlErrorsLabel.setForeground(Color.red);
        this.resourceCopyErrorsLabel.setForeground(Color.red);
        this.bottomPanel.add(this.progressFoundLabel);
        this.bottomPanel.add(this.progressProcessedLabel);
        this.bottomPanel.add(this.progressAlreadyInCacheLabel);
        this.bottomPanel.add(this.progressFailedLabel);
        this.bottomPanel.add(this.progressXmlErrorsLabel);
        this.bottomPanel.add(this.resourceCopyErrorsLabel);
        this.bottomPanel.add(this.showInTableButton);
        this.bottomPanel.add(this.diskSpaceLabel);
        this.detailsPanel.add((Component)this.bottomPanel, "South");
        this.searchPanel.add((Component)this.detailsPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.stopButton = new JButton("Stop");
        this.startButton = new JButton("Start");
        this.stopButton.setEnabled(false);
        buttonsPanel.add(this.stopButton);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        buttonsPanel.add(this.progressBar);
        buttonsPanel.add(this.startButton);
        this.searchPanel.add((Component)buttonsPanel, "South");
        this.searchDialog.setLocationRelativeTo(targetComponent);
        this.showInTableButton.setEnabled(false);
        this.showInTableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (ImportExportDialog.this.metaDataCopyErrors.size() > 0) {
                        LinorgWindowManager.getSingleInstance().openFloatingTableOnce(ImportExportDialog.this.metaDataCopyErrors.toArray(new URI[0]), ImportExportDialog.this.progressFailedLabelText);
                    }
                    if (ImportExportDialog.this.validationErrors.size() > 0) {
                        LinorgWindowManager.getSingleInstance().openAllChildNodesInFloatingTableOnce(ImportExportDialog.this.validationErrors.toArray(new URI[0]), ImportExportDialog.this.progressXmlErrorsLabelText);
                    }
                    if (ImportExportDialog.this.fileCopyErrors.size() > 0) {
                        ImdiTableModel resourceFileErrorsTable = LinorgWindowManager.getSingleInstance().openFloatingTableOnce(ImportExportDialog.this.fileCopyErrors.toArray(new URI[0]), ImportExportDialog.this.resourceCopyErrorsLabelText);
                        resourceFileErrorsTable.addChildTypeToDisplay("MediaFiles");
                        resourceFileErrorsTable.addChildTypeToDisplay("WrittenResources");
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.performCopy();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.stopSearch = true;
                    ImportExportDialog.this.downloadAbortFlag.abortDownload = true;
                    ImportExportDialog.this.stopButton.setEnabled(false);
                    ImportExportDialog.this.startButton.setEnabled(false);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.taskOutput.append("The details of the import / export process will be displayed here.\n");
        this.xmlOutput.append("When the metadata files are imported or exported they will be validated (for XML schema conformance) and any errors will be reported here.\n");
        this.resourceCopyOutput.append("If copying of resource files is selected, any file copy errors will be reported here.\n");
        this.showDetails(this.detailsCheckBox.isSelected());
        this.searchDialog.pack();
    }

    private void appendToTaskOutput(String lineOfText) {
        this.taskOutput.append(lineOfText + "\n");
        this.taskOutput.setCaretPosition(this.taskOutput.getText().length());
    }

    private void setUItoRunningState() {
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        this.showInTableButton.setEnabled(false);
        this.taskOutput.setCursor(Cursor.getPredefinedCursor(3));
        this.searchDialog.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setUItoStoppedState() {
        Toolkit.getDefaultToolkit().beep();
        this.taskOutput.setCursor(null);
        this.searchDialog.setCursor(null);
        this.progressBar.setIndeterminate(false);
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(this.selectedNodes.size() > 0);
        this.showInTableButton.setEnabled(this.validationErrors.size() > 0 || this.metaDataCopyErrors.size() > 0 || this.fileCopyErrors.size() > 0);
        this.stopSearch = false;
        this.downloadAbortFlag.abortDownload = false;
    }

    private void waitTillVisible() {
        while (!this.searchDialog.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                GuiHelper.linorgBugCatcher.logError(ignore);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeEmptyDirectoryPaths(File currentDirectory, File[] destinationFile) {
        File[] childDirectories = currentDirectory.listFiles();
        if (childDirectories != null && childDirectories.length == 1) {
            this.removeEmptyDirectoryPaths(childDirectories[0], destinationFile);
            if (!childDirectories[0].isDirectory()) return;
            childDirectories[0].delete();
            return;
        } else {
            try {
                File tempFile = destinationFile[0] = File.createTempFile("tmp-" + currentDirectory.getName(), "", this.exportDestinationDirectory);
                destinationFile[1] = new File(this.exportDestinationDirectory, currentDirectory.getName());
                tempFile.delete();
                if (currentDirectory.renameTo(tempFile)) return;
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
    }

    private void performCopy() {
        this.setUItoRunningState();
        new Thread("performCopy"){

            public void run() {
                boolean testFreeSpace = true;
                String javaVersionString = System.getProperty("java.version");
                if (javaVersionString.startsWith("1.4.") || javaVersionString.startsWith("1.5.")) {
                    testFreeSpace = false;
                }
                int freeGbWarningPoint = 3;
                int xsdErrors = 0;
                int totalLoaded = 0;
                int totalErrors = 0;
                int totalExisting = 0;
                int resourceCopyErrors = 0;
                String finalMessageString = "";
                File directoryForSizeTest = ImportExportDialog.this.exportDestinationDirectory != null ? ImportExportDialog.this.exportDestinationDirectory : LinorgSessionStorage.getSingleInstance().getCacheDirectory();
                if (ImportExportDialog.this.copyFilesCheckBox.isSelected()) {
                    ImportExportDialog.this.resourceCopyOutput.append("'Copy Resource Files' is selected: Resource files will be downloaded where appropriate permission are granted.\n");
                } else {
                    ImportExportDialog.this.resourceCopyOutput.append("'Copy Resource Files' is not selected: No resource files will be downloaded, however they will be still accessible via the web server.\n");
                }
                try {
                    XsdChecker xsdChecker = new XsdChecker();
                    ImportExportDialog.this.waitTillVisible();
                    ImportExportDialog.this.progressBar.setIndeterminate(true);
                    Enumeration selectedNodesEnum = ImportExportDialog.this.selectedNodes.elements();
                    ArrayList<ImdiTreeObject> finishedTopNodes = new ArrayList<ImdiTreeObject>();
                    class RetrievableFile {
                        URI sourceURI;
                        File destinationDirectory;
                        File childDestinationDirectory;
                        File destinationFile;
                        String fileSuffix;

                        public RetrievableFile(URI sourceURILocal, File destinationDirectoryLocal) {
                            this.sourceURI = sourceURILocal;
                            this.destinationDirectory = destinationDirectoryLocal;
                        }

                        public void calculateUriFileName() {
                            this.destinationFile = this.destinationDirectory != null ? LinorgSessionStorage.getSingleInstance().getExportPath(this.sourceURI.toString(), this.destinationDirectory.getPath()) : LinorgSessionStorage.getSingleInstance().getSaveLocation(this.sourceURI.toString());
                            this.childDestinationDirectory = this.destinationDirectory;
                        }

                        public void calculateTreeFileName() {
                            String fileNameString;
                            this.fileSuffix = this.sourceURI.toString().substring(this.sourceURI.toString().lastIndexOf("."));
                            ImdiTreeObject currentNode = ImdiLoader.getSingleInstance().getImdiObject(null, this.sourceURI);
                            currentNode.waitTillLoaded();
                            if (currentNode.isMetaDataNode()) {
                                fileNameString = currentNode.toString();
                            } else {
                                String urlString = this.sourceURI.toString();
                                try {
                                    urlString = URLDecoder.decode(urlString, "UTF-8");
                                }
                                catch (Exception ex) {
                                    GuiHelper.linorgBugCatcher.logError(urlString, ex);
                                    ImportExportDialog.this.appendToTaskOutput("unable to decode the file name for: " + urlString);
                                    System.out.println("unable to decode the file name for: " + urlString);
                                }
                                fileNameString = urlString.substring(urlString.lastIndexOf("/") + 1, urlString.lastIndexOf("."));
                            }
                            this.destinationFile = new File(this.destinationDirectory, fileNameString + this.fileSuffix);
                            this.childDestinationDirectory = new File(this.destinationDirectory, currentNode.toString());
                            int fileCounter = 1;
                            while (this.destinationFile.exists()) {
                                this.destinationFile = new File(this.destinationDirectory, currentNode.toString() + "(" + fileCounter + ")" + this.fileSuffix);
                                this.childDestinationDirectory = new File(this.destinationDirectory, currentNode.toString() + "(" + fileCounter + ")");
                                ++fileCounter;
                            }
                        }
                    }
                    Hashtable<URI, RetrievableFile> seenFiles = new Hashtable<URI, RetrievableFile>();
                    ArrayList<URI> getList = new ArrayList<URI>();
                    ArrayList doneList = new ArrayList();
                    while (selectedNodesEnum.hasMoreElements() && !ImportExportDialog.this.stopSearch) {
                        Object currentElement = selectedNodesEnum.nextElement();
                        if (!(currentElement instanceof ImdiTreeObject)) continue;
                        URI currentGettableUri = ((ImdiTreeObject)currentElement).getParentDomNode().getURI();
                        getList.add(currentGettableUri);
                        if (!seenFiles.containsKey(currentGettableUri)) {
                            seenFiles.put(currentGettableUri, new RetrievableFile(((ImdiTreeObject)currentElement).getParentDomNode().getURI(), ImportExportDialog.this.exportDestinationDirectory));
                        }
                        while (!ImportExportDialog.this.stopSearch && getList.size() > 0) {
                            RetrievableFile currentRetrievableFile = (RetrievableFile)seenFiles.get(getList.remove(0));
                            try {
                                if (!doneList.contains(currentRetrievableFile.sourceURI)) {
                                    boolean replacingExitingFile;
                                    String journalActionString;
                                    if (ImportExportDialog.this.exportDestinationDirectory == null) {
                                        currentRetrievableFile.calculateUriFileName();
                                        journalActionString = "import";
                                    } else {
                                        if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                                            currentRetrievableFile.calculateTreeFileName();
                                        } else {
                                            currentRetrievableFile.calculateUriFileName();
                                        }
                                        journalActionString = "export";
                                    }
                                    MetadataUtils currentMetdataUtil = ImdiTreeObject.getMetadataUtils(currentRetrievableFile.sourceURI.toString());
                                    ArrayList<URI[]> uncopiedLinks = new ArrayList<URI[]>();
                                    URI[] linksUriArray = currentMetdataUtil.getCorpusLinks(currentRetrievableFile.sourceURI);
                                    if (linksUriArray != null) {
                                        for (int linkCount = 0; linkCount < linksUriArray.length && !ImportExportDialog.this.stopSearch; ++linkCount) {
                                            File downloadFileLocation;
                                            System.out.println("Link: " + linksUriArray[linkCount].toString());
                                            String currentLink = linksUriArray[linkCount].toString();
                                            URI gettableLinkUri = linksUriArray[linkCount].normalize();
                                            if (!seenFiles.containsKey(gettableLinkUri)) {
                                                seenFiles.put(gettableLinkUri, new RetrievableFile(gettableLinkUri, currentRetrievableFile.childDestinationDirectory));
                                            }
                                            RetrievableFile retrievableLink = (RetrievableFile)seenFiles.get(gettableLinkUri);
                                            if (ImdiTreeObject.isPathMetadata(currentLink)) {
                                                getList.add(gettableLinkUri);
                                                if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                                                    retrievableLink.calculateTreeFileName();
                                                } else {
                                                    retrievableLink.calculateUriFileName();
                                                }
                                                uncopiedLinks.add(new URI[]{linksUriArray[linkCount], retrievableLink.destinationFile.toURI()});
                                                continue;
                                            }
                                            if (!ImportExportDialog.this.copyFilesCheckBox.isSelected()) {
                                                uncopiedLinks.add(new URI[]{linksUriArray[linkCount], linksUriArray[linkCount]});
                                                continue;
                                            }
                                            if (ImportExportDialog.this.exportDestinationDirectory == null) {
                                                downloadFileLocation = LinorgSessionStorage.getSingleInstance().updateCache(currentLink, ImportExportDialog.this.shibbolethNegotiator, false, ImportExportDialog.this.downloadAbortFlag);
                                            } else {
                                                if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                                                    retrievableLink.calculateTreeFileName();
                                                } else {
                                                    retrievableLink.calculateUriFileName();
                                                }
                                                if (!retrievableLink.destinationFile.getParentFile().exists()) {
                                                    retrievableLink.destinationFile.getParentFile().mkdirs();
                                                }
                                                downloadFileLocation = retrievableLink.destinationFile;
                                                LinorgSessionStorage.getSingleInstance().saveRemoteResource(new URL(currentLink), downloadFileLocation, ImportExportDialog.this.shibbolethNegotiator, true, ImportExportDialog.this.downloadAbortFlag);
                                            }
                                            if (downloadFileLocation.exists()) {
                                                ImportExportDialog.this.appendToTaskOutput("Downloaded resource: " + downloadFileLocation.getAbsolutePath());
                                                uncopiedLinks.add(new URI[]{linksUriArray[linkCount], downloadFileLocation.toURI()});
                                            } else {
                                                ImportExportDialog.this.resourceCopyOutput.append("Download failed: " + currentLink + " \n");
                                                ImportExportDialog.this.fileCopyErrors.add(currentRetrievableFile.sourceURI);
                                                uncopiedLinks.add(new URI[]{linksUriArray[linkCount], linksUriArray[linkCount]});
                                                ++resourceCopyErrors;
                                            }
                                            ImportExportDialog.this.resourceCopyOutput.setCaretPosition(ImportExportDialog.this.resourceCopyOutput.getText().length() - 1);
                                        }
                                    }
                                    boolean bl = replacingExitingFile = currentRetrievableFile.destinationFile.exists() && ImportExportDialog.this.overwriteCheckBox.isSelected();
                                    if (currentRetrievableFile.destinationFile.exists()) {
                                        ++totalExisting;
                                    }
                                    if (currentRetrievableFile.destinationFile.exists() && !ImportExportDialog.this.overwriteCheckBox.isSelected()) {
                                        ImportExportDialog.this.appendToTaskOutput(currentRetrievableFile.sourceURI.toString());
                                        ImportExportDialog.this.appendToTaskOutput("Destination already exists, skipping file: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                                    } else {
                                        ImdiTreeObject destinationNode;
                                        if (replacingExitingFile) {
                                            ImportExportDialog.this.appendToTaskOutput("Replaced: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                                        }
                                        if ((destinationNode = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(currentRetrievableFile.destinationFile.toURI())).getNeedsSaveToDisk()) {
                                            destinationNode.saveChangesToCache(true);
                                        }
                                        if (destinationNode.hasHistory()) {
                                            destinationNode.bumpHistory();
                                        }
                                        if (!currentRetrievableFile.destinationFile.getParentFile().exists()) {
                                            currentRetrievableFile.destinationFile.getParentFile().mkdir();
                                        }
                                        currentMetdataUtil.copyMetadataFile(currentRetrievableFile.sourceURI, currentRetrievableFile.destinationFile, (URI[][])uncopiedLinks.toArray((T[])new URI[0][]), true);
                                        LinorgJournal.getSingleInstance().saveJournalEntry(currentRetrievableFile.destinationFile.getAbsolutePath(), "", currentRetrievableFile.sourceURI.toString(), "", journalActionString);
                                        String checkerResult = xsdChecker.simpleCheck(currentRetrievableFile.destinationFile, currentRetrievableFile.sourceURI);
                                        if (checkerResult != null) {
                                            ImportExportDialog.this.xmlOutput.append(currentRetrievableFile.sourceURI.toString() + "\n");
                                            ImportExportDialog.this.xmlOutput.append("destination path: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                                            System.out.println("checkerResult: " + checkerResult);
                                            ImportExportDialog.this.xmlOutput.append(checkerResult + "\n");
                                            ImportExportDialog.this.xmlOutput.setCaretPosition(ImportExportDialog.this.xmlOutput.getText().length() - 1);
                                            ImportExportDialog.this.validationErrors.add(currentRetrievableFile.sourceURI);
                                            ++xsdErrors;
                                        }
                                        if (replacingExitingFile) {
                                            ImdiLoader.getSingleInstance().requestReloadOnlyIfLoaded(currentRetrievableFile.destinationFile.toURI());
                                        }
                                    }
                                }
                            }
                            catch (Exception ex) {
                                GuiHelper.linorgBugCatcher.logError(currentRetrievableFile.sourceURI.toString(), ex);
                                ++totalErrors;
                                ImportExportDialog.this.metaDataCopyErrors.add(currentRetrievableFile.sourceURI);
                                ImportExportDialog.this.appendToTaskOutput("unable to process the file: " + currentRetrievableFile.sourceURI);
                                System.out.println("Error getting links from: " + currentRetrievableFile.sourceURI);
                            }
                            ImportExportDialog.this.progressFoundLabel.setText(ImportExportDialog.this.progressFoundLabelText + (getList.size() + ++totalLoaded));
                            ImportExportDialog.this.progressProcessedLabel.setText(ImportExportDialog.this.progressProcessedLabelText + totalLoaded);
                            ImportExportDialog.this.progressAlreadyInCacheLabel.setText(ImportExportDialog.this.progressAlreadyInCacheLabelText + totalExisting);
                            ImportExportDialog.this.progressFailedLabel.setText(ImportExportDialog.this.progressFailedLabelText + totalErrors);
                            ImportExportDialog.this.progressXmlErrorsLabel.setText(ImportExportDialog.this.progressXmlErrorsLabelText + xsdErrors);
                            ImportExportDialog.this.resourceCopyErrorsLabel.setText(ImportExportDialog.this.resourceCopyErrorsLabelText + resourceCopyErrors);
                            ImportExportDialog.this.progressBar.setString(totalLoaded + "/" + (getList.size() + totalLoaded) + " (" + (totalErrors + xsdErrors + resourceCopyErrors) + " errors)");
                            if (!testFreeSpace) continue;
                            try {
                                int diskFreePercent = (int)(directoryForSizeTest.getFreeSpace() / directoryForSizeTest.getTotalSpace() * 100L);
                                int freeGBytes = (int)(directoryForSizeTest.getFreeSpace() / 0x40000000L);
                                ImportExportDialog.this.diskSpaceLabel.setText(ImportExportDialog.this.diskFreeLabelText + freeGBytes + "GB");
                                if (freeGbWarningPoint <= freeGBytes) continue;
                                ImportExportDialog.this.progressBar.setIndeterminate(false);
                                if (0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "There is only " + freeGBytes + "GB free space left on the disk.\nTo you still want to continue?", ImportExportDialog.this.searchDialog.getTitle(), 0, -1)) {
                                    freeGbWarningPoint = freeGBytes - 1;
                                } else {
                                    ImportExportDialog.this.stopSearch = true;
                                }
                                ImportExportDialog.this.progressBar.setIndeterminate(true);
                            }
                            catch (Exception ex) {
                                ImportExportDialog.this.diskSpaceLabel.setText(ImportExportDialog.this.diskFreeLabelText + "N/A");
                                testFreeSpace = false;
                            }
                        }
                        if (ImportExportDialog.this.exportDestinationDirectory != null) continue;
                        File newNodeLocation = LinorgSessionStorage.getSingleInstance().getSaveLocation(((ImdiTreeObject)currentElement).getParentDomNode().getUrlString());
                        finishedTopNodes.add(ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(newNodeLocation.toURI()));
                    }
                    finalMessageString = finalMessageString + "Processed " + totalLoaded + " Metadata Files.\n";
                    if (ImportExportDialog.this.exportDestinationDirectory == null) {
                        if (!ImportExportDialog.this.stopSearch) {
                            for (ImdiTreeObject currentFinishedNode : finishedTopNodes) {
                                if (ImportExportDialog.this.destinationNode != null) {
                                    if (!ImportExportDialog.this.destinationNode.getURI().equals(currentFinishedNode.getURI())) {
                                        ImportExportDialog.this.destinationNode.addCorpusLink(currentFinishedNode);
                                    }
                                } else if (!TreeHelper.getSingleInstance().addLocation(currentFinishedNode.getURI())) {
                                    finalMessageString = finalMessageString + "The location:\n" + currentFinishedNode + "\nalready exists and need not be added again\n";
                                }
                                currentFinishedNode.reloadNode();
                            }
                        }
                        if (ImportExportDialog.this.destinationNode == null) {
                            TreeHelper.getSingleInstance().applyRootLocations();
                        }
                    }
                    ImportExportDialog.this.progressBar.setIndeterminate(false);
                    if (totalErrors != 0) {
                        finalMessageString = finalMessageString + "There were " + totalErrors + " errors, some files may not have been copied.\n";
                    }
                    if (xsdErrors != 0) {
                        finalMessageString = finalMessageString + "There were " + xsdErrors + " files that failed to validate and have xml errors.\n";
                    }
                    if (ImportExportDialog.this.stopSearch) {
                        ImportExportDialog.this.appendToTaskOutput("copy canceled");
                        System.out.println("copy canceled");
                        finalMessageString = finalMessageString + "The process was canceled, some files may not have been copied.\n";
                    } else {
                        ImportExportDialog.this.selectedNodes.removeAllElements();
                        if (ImportExportDialog.this.exportDestinationDirectory != null) {
                            File[] destinationFile = new File[2];
                            ImportExportDialog.this.removeEmptyDirectoryPaths(ImportExportDialog.this.exportDestinationDirectory, destinationFile);
                            destinationFile[0].renameTo(destinationFile[1]);
                        }
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                    finalMessageString = finalMessageString + "There was a critical error.";
                }
                ImportExportDialog.this.setUItoStoppedState();
                System.out.println("finalMessageString: " + finalMessageString);
                Object[] options = new Object[]{"Close", "Details"};
                int detailsOption = JOptionPane.showOptionDialog(LinorgWindowManager.getSingleInstance().linorgFrame, finalMessageString, ImportExportDialog.this.searchDialog.getTitle(), 0, -1, null, options, options[0]);
                if (detailsOption == 0) {
                    ImportExportDialog.this.searchDialog.setVisible(false);
                } else if (!ImportExportDialog.this.detailsCheckBox.isSelected()) {
                    ImportExportDialog.this.detailsCheckBox.setSelected(true);
                    ImportExportDialog.this.showDetails(true);
                    ImportExportDialog.this.searchDialog.pack();
                }
                if (ImportExportDialog.this.exportDestinationDirectory != null) {
                    GuiHelper.getSingleInstance().openFileInExternalApplication(ImportExportDialog.this.exportDestinationDirectory.toURI());
                }
            }
        }.start();
    }
}

