/**
 * File  : additTooltip.js
 * Author: klasal
 * Date  : June 6th, 2007
 *
 * Add tooltips to html elements. 
 * For every element of a  certain tag name which
 * posesses an id, the webnotes-servlet will be asked to return
 * a tooltip (as text) with a short info (count) about possible 
 * corresponding web notes.
 * No tooltip is shown, if no corresponding web notes exist.
 * After a (right) mouse click on an element a window pops up to show 
 * the existing web notes with the option to add a new one.
 *
 * !!!
 * Opening the popup window depends on the corresponding
 * function in additPopup.js !
 * !!!
 *
 * Copyright (C) 2006 Alexander Klassmann <alex.klassmann@mpi.nl>
 * Max Planck Institute for Psycholinguistics
 * Wundtlaan 1, 6525 XD Nijmegen, The Netherlands
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

document.onmousemove = updateTooltip;
var webnoteColour = "#FFFFB0";
var sessionId = null;
var tooltipHash = {};
var tooltip = null;
var menu = null;
var tagNames = null;
var additUrl = null;
var documentId = null;
var reg = null;
var separator = '/';
var uriHash = {};

/**
 * 'Constructor' without filter
 */
function additTooltipInit(additUrl, sessionId, documentId, tagNameString){
	additTooltipInit(additURL, sessionId, documentId, tagNameString, null);
}

/** 
 * 'Constructor'
 * fills the hashtable with element ids and corresponding tooltips (plain text);
 * adds a mouse listener to elements which have one of the given tagNames
 * and a non-empty id attribute that passes, if given, the filter
 *
 * @param additUrl URL of addit web application
 * @param documentId id of document, e.g. imdi node id or URID
 * @param tagNames one String with tagNames separated by ';'
 * @param elemendIdFilter regular Expression to filter ids (wanted ids have to pass) 
 */
function additTooltipInit(additUrl, sessionId, documentId, tagNameString, elementIdFilter){
	if(!additUrl || additUrl.length == 0) return;
	this.additUrl = additUrl;
	tagNames = tagNameString.toLowerCase().split(';');
	this.documentId = escape(documentId);
	this.sessionId = sessionId;
	if(elementIdFilter){
		reg = new RegExp(elementIdFilter);
	}
	for(var j=0; j<tagNames.length; j++){
		elements = document.getElementsByTagName(tagNames[j]);
		var exception = null;
		for(var i=0; i<elements.length; i++){
			if(valid(elements[i].id)){
				elements[i].onmousedown = showWebnotes; 	
				if(!exception){
					uriHash[getUri(documentId,elements[i].id, false)]=elements[i];
				}
			}
		}
	}
	try{
        var servletUrl = additUrl+"/servlet";
        if(sessionId != null && sessionId != ""){
        		servletUrl += ";jsessionid="+sessionId;
        }
		callServlet(servletUrl);
	}
	catch(e){
		//if Firebug is installed, log exception
		if (typeof console != "undefined"        // test for Firebug
      		&& typeof console.log == "function"){ // test for method
		    		console.log('Could not contact to '+additUrl+'servlet: '+e);
  			} 		
	}
	window.oncontextmenu = function(e){ return !getId(e.target); } 
}

/**
 * returns concatenation of the two ids; inserts separator if necessary
 */
function getUri(documentId, elementId, esc){
	if(esc){
	 	documentId = escape(documentId);
	}
	if(documentId[documentId.length - 1] != separator && elementId[0] != separator){
		return documentId + separator + elementId;
	}
	return documentId + elementId;
}

/**
 * creates the tooltip element
 * note that only its (inner) text changes, not the tooltip element itself
 */
function createTooltip(){
	tooltip = document.createElement("div");
	tooltip.setAttribute("class","tooltip");
	tooltip.setAttribute("id", "webnote-tooltip");
	document.body.appendChild(tooltip);
}

/**
 * gets tooltip text from servlet
 */
function callServlet(url){ 
	var httpRequest = false;
    if (window.XMLHttpRequest) { // Mozilla, Safari,...
         httpRequest = new XMLHttpRequest();
         if (httpRequest.overrideMimeType) {
         	// set type accordingly to anticipated content type
            httpRequest.overrideMimeType('text/html');
        }
    } else if (window.ActiveXObject) { // IE
        try {
            httpRequest = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e) {
            try {
               httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e) {}
		}
    }
    if(!httpRequest) return null;
    var params = "request=getDocCountsAsJson";
    for(uri in uriHash){
	    params += "&uri="+escape(uri);
	}
	httpRequest.open("POST",url,true);
    httpRequest.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	httpRequest.setRequestHeader("Content-length", params.length);
	httpRequest.setRequestHeader("Connection", "close");
	
	httpRequest.onreadystatechange = function(){
		if(httpRequest.readyState == 4){
		    //if status isn't 'OK' throw Exception
		    if(httpRequest.status != 200){
			    //alert('HTTP Status ' + httpRequest.status + ' - ' + httpRequest.statusText);
    			}
			
			linkTooltipsToElements(httpRequest.responseText);
		}
	};
    httpRequest.send(params);
}

function linkTooltipsToElements(responseText){
	if(! responseText) return;
	try{
		var response = eval("("+responseText +")");
		var docCounts = response.DocCounts;		
		if(! docCounts) return;
		
		var element;
		var tooltipText;
		if(docCounts.length > 0){
			createTooltip();
		}
		for(var i=0; i<docCounts.length; i++){
			if(docCounts[i].count > 0){
				element = uriHash[docCounts[i].uri];
				if(element){	
					tooltipText = docCounts[i].count == 1 ? 'One webnote' : docCounts[i].count + ' webnotes';
					tooltipHash[element.id] = tooltipText;	
					element.onmouseover = showTooltip;
					element.onmouseout = hideTooltip;

					//mark elements with webnote if not already highlighted by server 
					if(!element.className || element.className != 'addit-highlighted'){
						if(element.tagName.toLowerCase() == "img"){
							element.style.border = "solid " + webnoteColour +" 3px";
						}
						else{
							element.style.background = webnoteColour;
						}
					}
				}else{
					//if Firebug is installed, log exception
					if (typeof console != "undefined"        // test for Firebug
      					&& typeof console.log == "function"){ // test for method
		    				console.log('No element found for '+docCounts[i].uri);
		    			}
				}
			}
		}
	}
	catch(e){
		alert(e);
	}
	uriHash = null;	
}

/**
 * sets tooltip position
 */
function updateTooltip(e) {
	x = (document.all) ? window.event.x + document.body.scrollLeft : e.pageX;
	y = (document.all) ? window.event.y + document.body.scrollTop  : e.pageY;
	if (tooltip != null) {
		tooltip.style.left	= (x + 20) + "px";
		tooltip.style.top	= (y + 20) + "px";
	}
}

/**
 * sets text (HTML) of tooltip and makes it visible
 */
function showTooltip(e) {
	var elementId = getId(e.target);
	if(elementId != "" && (tooltipHTML = tooltipHash[elementId])){
		tooltip = document.getElementById("webnote-tooltip");
		tooltip.innerHTML = tooltipHTML;
		tooltip.style.display = "block";
	}
	else{
		hideTooltip(e);
	}
}

/**
 * hides tooltip
 */
function hideTooltip(e) {
	if(tooltip!=null){
		tooltip.style.display = "none";
		tooltip = null;
	}
}

/*
 * returns id of the element or, if the element's tag name is wrong,
 * the id of parent node;
 * returns null if id is not valid
 */
function getId(element){
	var b = null;
	for(var j=0; j<tagNames.length; j++){
		if(element.tagName.toLowerCase() == tagNames[j]){
			b = true;
		}
	}
	if(!b){
		element = element.parentNode;
	}
	return valid(element.id) ? element.id : null;
}

/**
 * an id is valid, if it is not empty and passes, if applicable, the filter
 */
function valid(id){
	return id && id.trim != "" && (!reg || reg.test(id));
}

/**
 * if (any) mouse button and SHIFT+ALT, calls open window
 */
function showWebnotes(e) {
	if(e.altKey){	
		var elementId = getId(e.target);
		if(elementId){
			var objectUri = getUri(documentId,elementId,false);
			openAdditList(additUrl, objectUri);
		}
	}
}
