/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilJournal;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.data.MetadataFormat;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.DownloadAbortFlag;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.XsdChecker;

public class ImportExportDialog {
    private JDialog importExportDialog;
    private JPanel importExportPanel;
    private JPanel inputNodePanel;
    private JPanel outputNodePanel;
    protected JCheckBox copyFilesExportCheckBox;
    protected JCheckBox copyFilesImportCheckBox;
    protected JCheckBox renameFileToNodeName;
    protected JCheckBox renameFileToLamusFriendlyName;
    protected JButton showMoreButton;
    protected JButton showDetailsButton;
    protected JCheckBox overwriteCheckBox;
    protected JCheckBox shibbolethCheckBox;
    private JPanel shibbolethPanel;
    private JLabel resourceProgressLabel;
    private JProgressBar progressBar;
    private JLabel diskSpaceLabel;
    JPanel moreOptionsPanel;
    JPanel detailsPanel;
    JPanel detailsBottomPanel;
    private JLabel progressFoundLabel;
    private JLabel progressProcessedLabel;
    private JLabel progressAlreadyInCacheLabel;
    private JLabel progressFailedLabel;
    private JLabel progressXmlErrorsLabel;
    private JLabel resourceCopyErrorsLabel;
    private JButton showInTableButton;
    private JButton closeButton;
    String progressFoundLabelText = "Total Metadata Files Found: ";
    String progressProcessedLabelText = "Total Metadata Files Processed: ";
    String progressAlreadyInCacheLabelText = "Metadata Files already in Local Corpus: ";
    String progressFailedLabelText = "Metadata File Copy Errors: ";
    String progressXmlErrorsLabelText = "Metadata File Validation Errors: ";
    String resourceCopyErrorsLabelText = "Resource File Copy Errors: ";
    String diskFreeLabelText = "Total Disk Free: ";
    private JButton stopButton;
    private JButton startButton;
    private JTabbedPane detailsTabPane;
    private JTextArea taskOutput;
    private JTextArea xmlOutput;
    private JTextArea resourceCopyOutput;
    private boolean stopCopy = false;
    protected Vector<ArbilDataNode> selectedNodes;
    ArbilDataNode destinationNode = null;
    protected File exportDestinationDirectory = null;
    DownloadAbortFlag downloadAbortFlag = new DownloadAbortFlag();
    Vector<URI> validationErrors = new Vector();
    Vector<URI> metaDataCopyErrors = new Vector();
    Vector<URI> fileCopyErrors = new Vector();
    private static TreeHelper treeHelper;
    private boolean showingMoreOptions = false;
    private boolean showingDetails = false;
    private static DataNodeLoader dataNodeLoader;

    public static void setTreeHelper(TreeHelper treeHelperInstance) {
        treeHelper = treeHelperInstance;
    }

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    private void setNodesPanel(ArbilDataNode selectedNode, JPanel nodePanel) {
        JLabel currentLabel = new JLabel(selectedNode.toString(), selectedNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setNodesPanel(Vector selectedNodes, JPanel nodePanel) {
        Enumeration selectedNodesEnum = selectedNodes.elements();
        while (selectedNodesEnum.hasMoreElements()) {
            ArbilDataNode currentNode = (ArbilDataNode)selectedNodesEnum.nextElement();
            JLabel currentLabel = new JLabel(currentNode.toString(), currentNode.getIcon(), 0);
            nodePanel.add(currentLabel);
        }
    }

    private void setLocalCacheToNodesPanel(JPanel nodePanel) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeHelper.getLocalCorpusTreeModel().getRoot();
        ArbilNode rootArbilNode = (ArbilNode)rootNode.getUserObject();
        JLabel currentLabel = new JLabel(rootArbilNode.toString(), rootArbilNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    private void setLocalFileToNodesPanel(JPanel nodePanel, File destinationDirectory) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)treeHelper.getLocalDirectoryTreeModel().getRoot();
        ArbilNode rootArbilNode = (ArbilNode)rootNode.getUserObject();
        JLabel currentLabel = new JLabel(destinationDirectory.getPath(), rootArbilNode.getIcon(), 0);
        nodePanel.add(currentLabel);
    }

    public void importArbilBranch() {
        File[] selectedFiles = ArbilWindowManager.getSingleInstance().showFileSelectBox("Import", false, true, true);
        if (selectedFiles != null) {
            Vector<ArbilDataNode> importNodeVector = new Vector<ArbilDataNode>();
            for (File currentFile : selectedFiles) {
                ArbilDataNode nodeToImport = dataNodeLoader.getArbilDataNode(null, currentFile.toURI());
                importNodeVector.add(nodeToImport);
            }
            this.copyToCache(importNodeVector);
        }
    }

    public void selectExportDirectoryAndExport(ArbilDataNode[] localCorpusSelectedNodes) {
        this.importExportDialog.setTitle("Export Branch");
        File destinationDirectory = ArbilWindowManager.getSingleInstance().showEmptyExportDirectoryDialogue(this.importExportDialog.getTitle());
        if (destinationDirectory != null) {
            this.exportFromCache(new Vector<ArbilDataNode>(Arrays.asList(localCorpusSelectedNodes)), destinationDirectory);
        }
    }

    private void exportFromCache(Vector localSelectedNodes, File destinationDirectory) {
        this.selectedNodes = localSelectedNodes;
        if (!this.selectedNodesContainDataNode()) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No relevant nodes are selected", this.importExportDialog.getTitle());
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        this.setLocalFileToNodesPanel(this.outputNodePanel, destinationDirectory);
        this.exportDestinationDirectory = destinationDirectory;
        this.updateDialog(this.showingMoreOptions, this.showingDetails);
        this.importExportDialog.setVisible(true);
    }

    public void copyToCache(ArbilDataNode[] localSelectedNodes) {
        this.copyToCache(new Vector<ArbilDataNode>(Arrays.asList(localSelectedNodes)));
    }

    public void setDestinationNode(ArbilDataNode localDestinationNode) {
        this.destinationNode = localDestinationNode;
        this.setNodesPanel(this.destinationNode, this.outputNodePanel);
    }

    public void copyToCache(Vector localSelectedNodes) {
        this.selectedNodes = localSelectedNodes;
        this.importExportDialog.setTitle("Import Branch");
        if (!this.selectedNodesContainDataNode()) {
            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("No relevant nodes are selected", this.importExportDialog.getTitle());
            return;
        }
        this.setNodesPanel(this.selectedNodes, this.inputNodePanel);
        if (this.destinationNode == null) {
            this.setLocalCacheToNodesPanel(this.outputNodePanel);
        }
        this.importExportDialog.setVisible(true);
    }

    private boolean selectedNodesContainDataNode() {
        Enumeration<ArbilDataNode> selectedNodesEnum = this.selectedNodes.elements();
        while (selectedNodesEnum.hasMoreElements()) {
            if (!(selectedNodesEnum.nextElement() instanceof ArbilDataNode)) continue;
            return true;
        }
        return false;
    }

    private synchronized void updateDialog(boolean optionsFlag, boolean detailsFlag) {
        this.overwriteCheckBox.setVisible(this.exportDestinationDirectory == null);
        this.copyFilesImportCheckBox.setVisible(this.exportDestinationDirectory == null);
        this.copyFilesExportCheckBox.setVisible(this.exportDestinationDirectory != null);
        if (!optionsFlag || !detailsFlag || this.showingMoreOptions != optionsFlag || this.showingDetails != detailsFlag) {
            this.detailsTabPane.setVisible(detailsFlag);
            this.detailsBottomPanel.setVisible(detailsFlag);
            this.copyFilesImportCheckBox.setVisible(optionsFlag && this.exportDestinationDirectory == null);
            this.renameFileToNodeName.setVisible(optionsFlag && this.exportDestinationDirectory != null);
            this.renameFileToLamusFriendlyName.setVisible(optionsFlag && this.exportDestinationDirectory != null);
            this.shibbolethCheckBox.setVisible(optionsFlag && this.copyFilesImportCheckBox.isSelected());
            this.shibbolethPanel.setVisible(optionsFlag && this.copyFilesImportCheckBox.isSelected());
            if (detailsFlag) {
                this.importExportDialog.setMinimumSize(new Dimension(500, 500));
            } else {
                this.importExportDialog.setMinimumSize(null);
            }
            this.showMoreButton.setText(optionsFlag ? "< < Fewer options" : "More options> >");
            this.showDetailsButton.setText(detailsFlag ? "< < Hide details" : "Details > >");
            this.showingMoreOptions = optionsFlag;
            this.showingDetails = detailsFlag;
            this.importExportDialog.pack();
        }
    }

    public ImportExportDialog(Component targetComponent) throws Exception {
        ArbilWindowManager.getSingleInstance().offerUserToSaveChanges();
        this.importExportPanel = new JPanel();
        this.importExportPanel.setLayout(new BorderLayout());
        this.importExportPanel.add((Component)this.createInOutNodePanel(), "North");
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)this.createOptionsPanel(), "Center");
        optionsPanel.add((Component)this.createMoreOptionsPanel(), "South");
        this.importExportPanel.add((Component)optionsPanel, "Center");
        JPanel dialogBottomPanel = new JPanel(new BorderLayout());
        dialogBottomPanel.add((Component)this.createStartStopButtonsPanel(), "West");
        dialogBottomPanel.add((Component)this.createDetailsPanel(), "South");
        this.importExportPanel.add((Component)dialogBottomPanel, "South");
        this.importExportDialog = new JDialog(JOptionPane.getFrameForComponent(ArbilWindowManager.getSingleInstance().linorgFrame), true);
        this.importExportDialog.setDefaultCloseOperation(2);
        this.importExportDialog.addWindowStateListener(new WindowAdapter(){

            public void windowStateChanged(WindowEvent e) {
                if ((e.getNewState() & 6) == 6) {
                    ImportExportDialog.this.updateDialog(true, true);
                } else {
                    ImportExportDialog.this.importExportDialog.pack();
                }
            }
        });
        this.importExportDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ImportExportDialog.this.stopCopy = true;
                ImportExportDialog.this.downloadAbortFlag.abortDownload = true;
            }
        });
        this.importExportDialog.getContentPane().setLayout(new BorderLayout());
        this.importExportDialog.add((Component)this.importExportPanel, "Center");
        this.importExportDialog.setLocationRelativeTo(targetComponent);
        this.importExportDialog.setResizable(false);
        this.updateDialog(this.showingMoreOptions, this.showingDetails);
        JPanel closeButtonPanel = new JPanel(new FlowLayout(4));
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportExportDialog.this.importExportDialog.dispose();
            }
        });
        closeButtonPanel.add(this.closeButton);
        closeButtonPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.GRAY));
        this.importExportDialog.add((Component)closeButtonPanel, "South");
        this.importExportDialog.pack();
    }

    private JPanel createOptionsPanel() {
        this.overwriteCheckBox = new JCheckBox("Overwrite Local Changes", false);
        this.overwriteCheckBox.setToolTipText("If checked, after import the local version will be an exact copy of the remote version and any local changes will be overwritten. If not checked, previous local changes will remain.");
        this.copyFilesExportCheckBox = new JCheckBox("Export Resource Files (if available)", false);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 3));
        this.overwriteCheckBox.setAlignmentX(0.0f);
        optionsPanel.add(this.overwriteCheckBox);
        this.copyFilesExportCheckBox.setAlignmentX(0.0f);
        optionsPanel.add(this.copyFilesExportCheckBox);
        optionsPanel.setAlignmentX(0.0f);
        return optionsPanel;
    }

    private JPanel createMoreOptionsPanel() {
        this.moreOptionsPanel = new JPanel();
        JPanel moreOptionsButtonPanel = new JPanel(new BorderLayout());
        this.showMoreButton = new JButton("");
        this.showMoreButton.setToolTipText("Show/hide additional options");
        this.showMoreButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.updateDialog(!ImportExportDialog.this.showingMoreOptions, ImportExportDialog.this.showingDetails);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        moreOptionsButtonPanel.add((Component)this.showMoreButton, "West");
        this.moreOptionsPanel.setLayout(new BorderLayout());
        this.shibbolethCheckBox.setEnabled(false);
        this.shibbolethPanel = new JPanel();
        this.shibbolethCheckBox.setVisible(false);
        this.shibbolethPanel.setVisible(false);
        this.copyFilesImportCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImportExportDialog.this.shibbolethCheckBox.setVisible(ImportExportDialog.this.copyFilesImportCheckBox.isSelected());
                ImportExportDialog.this.shibbolethPanel.setVisible(ImportExportDialog.this.copyFilesImportCheckBox.isSelected());
                ImportExportDialog.this.importExportDialog.pack();
            }
        });
        JPanel moreOptionsTopPanel = new JPanel();
        moreOptionsTopPanel.setLayout(new BoxLayout(moreOptionsTopPanel, 3));
        JPanel moreOptionsTopCheckBoxPanel = new JPanel();
        moreOptionsTopCheckBoxPanel.setLayout(new BoxLayout(moreOptionsTopCheckBoxPanel, 3));
        moreOptionsTopCheckBoxPanel.add(this.renameFileToNodeName);
        moreOptionsTopCheckBoxPanel.add(this.renameFileToLamusFriendlyName);
        moreOptionsTopCheckBoxPanel.add(this.copyFilesImportCheckBox);
        moreOptionsTopCheckBoxPanel.add(this.shibbolethCheckBox);
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new BoxLayout(paddingPanel, 2));
        JPanel leftPadding = new JPanel();
        leftPadding.setMaximumSize(new Dimension(500, 100));
        paddingPanel.add(leftPadding);
        paddingPanel.add(moreOptionsTopCheckBoxPanel);
        paddingPanel.add(new JPanel());
        moreOptionsTopPanel.add(paddingPanel);
        moreOptionsTopPanel.add(this.shibbolethPanel);
        this.moreOptionsPanel.add((Component)moreOptionsTopPanel, "North");
        JPanel moreOptionsContainerPanel = new JPanel();
        moreOptionsContainerPanel.setLayout(new BoxLayout(moreOptionsContainerPanel, 3));
        moreOptionsButtonPanel.setAlignmentX(0.0f);
        moreOptionsContainerPanel.add(moreOptionsButtonPanel);
        this.moreOptionsPanel.setAlignmentX(0.0f);
        moreOptionsContainerPanel.add(this.moreOptionsPanel);
        moreOptionsContainerPanel.setAlignmentX(0.0f);
        return moreOptionsContainerPanel;
    }

    private JPanel createDetailsPanel() {
        this.detailsPanel = new JPanel();
        this.detailsPanel.setLayout(new BorderLayout());
        this.detailsTabPane = new JTabbedPane();
        this.taskOutput = new JTextArea(5, 20);
        this.taskOutput.setMargin(new Insets(5, 5, 5, 5));
        this.taskOutput.setEditable(false);
        this.taskOutput.append("The details of the import / export process will be displayed here.\n");
        this.detailsTabPane.add("Process Details", new JScrollPane(this.taskOutput));
        this.xmlOutput = new JTextArea(5, 20);
        this.xmlOutput.setMargin(new Insets(5, 5, 5, 5));
        this.xmlOutput.setEditable(false);
        this.xmlOutput.append("When the metadata files are imported or exported they will be validated (for XML schema conformance) and any errors will be reported here.\n");
        this.detailsTabPane.add("Validation Errors", new JScrollPane(this.xmlOutput));
        this.resourceCopyOutput = new JTextArea(5, 20);
        this.resourceCopyOutput.setMargin(new Insets(5, 5, 5, 5));
        this.resourceCopyOutput.setEditable(false);
        this.resourceCopyOutput.append("If copying of resource files is selected, any file copy errors will be reported here.\n");
        this.detailsTabPane.add("Resource Copy Errors", new JScrollPane(this.resourceCopyOutput));
        this.detailsPanel.add((Component)this.detailsTabPane, "Center");
        this.detailsBottomPanel = new JPanel();
        this.detailsBottomPanel.setLayout(new BoxLayout(this.detailsBottomPanel, 3));
        this.progressFoundLabel = new JLabel(this.progressFoundLabelText);
        this.progressProcessedLabel = new JLabel(this.progressProcessedLabelText);
        this.progressAlreadyInCacheLabel = new JLabel(this.progressAlreadyInCacheLabelText);
        this.progressFailedLabel = new JLabel(this.progressFailedLabelText);
        this.progressXmlErrorsLabel = new JLabel(this.progressXmlErrorsLabelText);
        this.resourceCopyErrorsLabel = new JLabel(this.resourceCopyErrorsLabelText);
        this.showInTableButton = new JButton("Show errors in table");
        this.showInTableButton.setEnabled(false);
        this.showInTableButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (ImportExportDialog.this.metaDataCopyErrors.size() > 0) {
                        ArbilWindowManager.getSingleInstance().openFloatingTableOnce(ImportExportDialog.this.metaDataCopyErrors.toArray(new URI[0]), ImportExportDialog.this.progressFailedLabelText);
                    }
                    if (ImportExportDialog.this.validationErrors.size() > 0) {
                        ArbilWindowManager.getSingleInstance().openAllChildNodesInFloatingTableOnce(ImportExportDialog.this.validationErrors.toArray(new URI[0]), ImportExportDialog.this.progressXmlErrorsLabelText);
                    }
                    if (ImportExportDialog.this.fileCopyErrors.size() > 0) {
                        ArbilTableModel resourceFileErrorsTable = ArbilWindowManager.getSingleInstance().openFloatingTableOnceGetModel(ImportExportDialog.this.fileCopyErrors.toArray(new URI[0]), ImportExportDialog.this.resourceCopyErrorsLabelText);
                        resourceFileErrorsTable.addChildTypeToDisplay("MediaFiles");
                        resourceFileErrorsTable.addChildTypeToDisplay("WrittenResources");
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.diskSpaceLabel = new JLabel(this.diskFreeLabelText);
        this.progressAlreadyInCacheLabel.setForeground(Color.darkGray);
        this.progressFailedLabel.setForeground(Color.red);
        this.progressXmlErrorsLabel.setForeground(Color.red);
        this.resourceCopyErrorsLabel.setForeground(Color.red);
        this.detailsBottomPanel.add(this.progressFoundLabel);
        this.detailsBottomPanel.add(this.progressProcessedLabel);
        this.detailsBottomPanel.add(this.progressAlreadyInCacheLabel);
        this.detailsBottomPanel.add(this.progressFailedLabel);
        this.detailsBottomPanel.add(this.progressXmlErrorsLabel);
        this.detailsBottomPanel.add(this.resourceCopyErrorsLabel);
        this.detailsBottomPanel.add(this.showInTableButton);
        this.detailsBottomPanel.add(this.diskSpaceLabel);
        this.resourceProgressLabel = new JLabel(" ");
        this.detailsBottomPanel.add(this.resourceProgressLabel);
        this.detailsPanel.add((Component)this.detailsBottomPanel, "South");
        JPanel paddingPanel = new JPanel();
        paddingPanel.setLayout(new BoxLayout(paddingPanel, 2));
        JPanel leftPadding = new JPanel();
        leftPadding.setMaximumSize(new Dimension(500, 100));
        paddingPanel.add(leftPadding);
        paddingPanel.add(this.detailsPanel);
        paddingPanel.add(new JPanel());
        paddingPanel.setMinimumSize(new Dimension(800, 200));
        return paddingPanel;
    }

    private JPanel createInOutNodePanel() {
        JPanel inOutNodePanel = new JPanel();
        inOutNodePanel.setLayout(new BoxLayout(inOutNodePanel, 3));
        JPanel inputNodeLabelPanel = new JPanel();
        inputNodeLabelPanel.setLayout(new BorderLayout());
        this.inputNodePanel = new JPanel();
        this.inputNodePanel.setLayout(new GridLayout());
        inputNodeLabelPanel.add((Component)new JLabel("From: "), "Before");
        inputNodeLabelPanel.add((Component)this.inputNodePanel, "Center");
        inputNodeLabelPanel.setAlignmentX(0.0f);
        inOutNodePanel.add(inputNodeLabelPanel);
        JPanel outputNodeLabelPanel = new JPanel();
        outputNodeLabelPanel.setLayout(new BorderLayout());
        this.outputNodePanel = new JPanel();
        this.outputNodePanel.setLayout(new GridLayout());
        outputNodeLabelPanel.add((Component)new JLabel("To: "), "Before");
        outputNodeLabelPanel.add((Component)this.outputNodePanel, "Center");
        outputNodeLabelPanel.setAlignmentX(0.0f);
        inOutNodePanel.add(outputNodeLabelPanel);
        this.copyFilesImportCheckBox = new JCheckBox("Import Resource Files (if available)", false);
        this.renameFileToNodeName = new JCheckBox("Rename Metadata Files (to match local corpus tree names)", true);
        this.renameFileToLamusFriendlyName = new JCheckBox("Limit Characters in File Names (LAMUS friendly format)", true);
        this.shibbolethCheckBox = new JCheckBox("Shibboleth authentication via the SURFnet method", false);
        inOutNodePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        return inOutNodePanel;
    }

    private JPanel createStartStopButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        this.stopButton = new JButton("Stop");
        this.startButton = new JButton("Start");
        this.stopButton.setEnabled(false);
        buttonsPanel.add(this.stopButton);
        this.progressBar = new JProgressBar(0, 100);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setString("");
        buttonsPanel.add(this.progressBar);
        buttonsPanel.add(this.startButton);
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.performCopy();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.stopCopy = true;
                    ImportExportDialog.this.downloadAbortFlag.abortDownload = true;
                    ImportExportDialog.this.stopButton.setEnabled(false);
                    ImportExportDialog.this.startButton.setEnabled(false);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.showDetailsButton = new JButton("");
        buttonsPanel.add(this.showDetailsButton);
        this.showDetailsButton.setToolTipText("Show/hide detailed information");
        this.showDetailsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ImportExportDialog.this.updateDialog(ImportExportDialog.this.showingMoreOptions, !ImportExportDialog.this.showingDetails);
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        buttonsPanel.setAlignmentX(0.0f);
        return buttonsPanel;
    }

    private void appendToTaskOutput(String lineOfText) {
        this.taskOutput.append(lineOfText + "\n");
        this.taskOutput.setCaretPosition(this.taskOutput.getText().length());
    }

    private void setUItoRunningState() {
        this.stopButton.setEnabled(true);
        this.startButton.setEnabled(false);
        this.closeButton.setEnabled(false);
        this.showMoreButton.setEnabled(false);
        this.showInTableButton.setEnabled(false);
        this.overwriteCheckBox.setEnabled(false);
        this.copyFilesExportCheckBox.setEnabled(false);
        this.copyFilesImportCheckBox.setEnabled(false);
        this.taskOutput.setCursor(Cursor.getPredefinedCursor(3));
        this.importExportDialog.setCursor(Cursor.getPredefinedCursor(3));
    }

    private void setUItoStoppedState() {
        Toolkit.getDefaultToolkit().beep();
        this.taskOutput.setCursor(null);
        this.importExportDialog.setCursor(null);
        this.progressBar.setIndeterminate(false);
        this.resourceProgressLabel.setText(" ");
        this.stopButton.setEnabled(false);
        this.startButton.setEnabled(this.selectedNodes.size() > 0);
        this.closeButton.setEnabled(true);
        this.showMoreButton.setEnabled(true);
        this.showInTableButton.setEnabled(this.validationErrors.size() > 0 || this.metaDataCopyErrors.size() > 0 || this.fileCopyErrors.size() > 0);
        this.overwriteCheckBox.setEnabled(true);
        this.copyFilesExportCheckBox.setEnabled(true);
        this.copyFilesImportCheckBox.setEnabled(true);
        this.stopCopy = false;
        this.downloadAbortFlag.abortDownload = false;
    }

    private void waitTillVisible() {
        while (!this.importExportDialog.isVisible()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignore) {
                GuiHelper.linorgBugCatcher.logError(ignore);
            }
        }
    }

    private void performCopy() {
        this.setUItoRunningState();
        this.createPerformCopyThread("performCopy").start();
    }

    private Thread createPerformCopyThread(String threadName) {
        return new Thread(threadName){
            int freeGbWarningPoint;
            int xsdErrors;
            int totalLoaded;
            int totalErrors;
            int totalExisting;
            int resourceCopyErrors;
            String finalMessageString;
            File directoryForSizeTest;
            boolean testFreeSpace;
            {
                this.freeGbWarningPoint = 3;
                this.xsdErrors = 0;
                this.totalLoaded = 0;
                this.totalErrors = 0;
                this.totalExisting = 0;
                this.resourceCopyErrors = 0;
                this.finalMessageString = "";
            }

            @Override
            public void run() {
                String javaVersionString = System.getProperty("java.version");
                this.testFreeSpace = !javaVersionString.startsWith("1.4.") && !javaVersionString.startsWith("1.5.");
                File file = this.directoryForSizeTest = ImportExportDialog.this.exportDestinationDirectory != null ? ImportExportDialog.this.exportDestinationDirectory : ArbilSessionStorage.getSingleInstance().getCacheDirectory();
                if (ImportExportDialog.this.copyFilesImportCheckBox.isSelected() || ImportExportDialog.this.copyFilesExportCheckBox.isSelected()) {
                    ImportExportDialog.this.resourceCopyOutput.append("'Copy Resource Files' is selected: Resource files will be downloaded where appropriate permission are granted.\n");
                } else {
                    ImportExportDialog.this.resourceCopyOutput.append("'Copy Resource Files' is not selected: No resource files will be downloaded, however they will be still accessible via the web server.\n");
                }
                try {
                    this.copyElements(ImportExportDialog.this.selectedNodes.elements());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                    this.finalMessageString = this.finalMessageString + "There was a critical error.";
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ImportExportDialog.this.setUItoStoppedState();
                    }
                });
                System.out.println("finalMessageString: " + this.finalMessageString);
                Object[] options = new Object[]{"Close", "Details"};
                int detailsOption = JOptionPane.showOptionDialog(ArbilWindowManager.getSingleInstance().linorgFrame, this.finalMessageString, ImportExportDialog.this.importExportDialog.getTitle(), 0, -1, null, options, options[0]);
                if (detailsOption == 0) {
                    ImportExportDialog.this.importExportDialog.dispose();
                } else if (!ImportExportDialog.this.showingDetails) {
                    ImportExportDialog.this.updateDialog(ImportExportDialog.this.showingMoreOptions, true);
                    ImportExportDialog.this.importExportDialog.pack();
                }
                if (ImportExportDialog.this.exportDestinationDirectory != null) {
                    GuiHelper.getSingleInstance().openFileInExternalApplication(ImportExportDialog.this.exportDestinationDirectory.toURI());
                }
            }

            private void copyElements(Enumeration selectedNodesEnum) {
                XsdChecker xsdChecker = new XsdChecker();
                ImportExportDialog.this.waitTillVisible();
                ImportExportDialog.this.progressBar.setIndeterminate(true);
                ArrayList<ArbilDataNode> finishedTopNodes = new ArrayList<ArbilDataNode>();
                Hashtable<URI, RetrievableFile> seenFiles = new Hashtable<URI, RetrievableFile>();
                ArrayList<URI> getList = new ArrayList<URI>();
                ArrayList<URI> doneList = new ArrayList<URI>();
                while (selectedNodesEnum.hasMoreElements() && !ImportExportDialog.this.stopCopy) {
                    Object currentElement = selectedNodesEnum.nextElement();
                    if (!(currentElement instanceof ArbilDataNode)) continue;
                    this.copyElement(currentElement, getList, seenFiles, doneList, xsdChecker, finishedTopNodes);
                }
                this.finalMessageString = this.finalMessageString + "Processed " + this.totalLoaded + " Metadata Files.\n";
                if (ImportExportDialog.this.exportDestinationDirectory == null) {
                    if (!ImportExportDialog.this.stopCopy) {
                        for (ArbilDataNode currentFinishedNode : finishedTopNodes) {
                            if (ImportExportDialog.this.destinationNode != null) {
                                if (!ImportExportDialog.this.destinationNode.getURI().equals(currentFinishedNode.getURI())) {
                                    ImportExportDialog.this.destinationNode.addCorpusLink(currentFinishedNode);
                                }
                            } else if (!treeHelper.addLocation(currentFinishedNode.getURI())) {
                                this.finalMessageString = this.finalMessageString + "The location:\n" + currentFinishedNode + "\nalready exists and need not be added again\n";
                            }
                            currentFinishedNode.reloadNode();
                        }
                    }
                    if (ImportExportDialog.this.destinationNode == null) {
                        treeHelper.applyRootLocations();
                    } else {
                        ImportExportDialog.this.destinationNode.reloadNode();
                    }
                }
                ImportExportDialog.this.progressBar.setIndeterminate(false);
                if (this.totalErrors != 0) {
                    this.finalMessageString = this.finalMessageString + "There were " + this.totalErrors + " errors, some files may not have been copied.\n";
                }
                if (this.xsdErrors != 0) {
                    this.finalMessageString = this.finalMessageString + "There were " + this.xsdErrors + " files that failed to validate and have xml errors.\n";
                }
                if (ImportExportDialog.this.stopCopy) {
                    ImportExportDialog.this.appendToTaskOutput("copy canceled");
                    System.out.println("copy canceled");
                    this.finalMessageString = this.finalMessageString + "The process was canceled, some files may not have been copied.\n";
                } else {
                    ImportExportDialog.this.selectedNodes.removeAllElements();
                }
            }

            private void copyElement(Object currentElement, ArrayList<URI> getList, Hashtable<URI, RetrievableFile> seenFiles, ArrayList<URI> doneList, XsdChecker xsdChecker, ArrayList<ArbilDataNode> finishedTopNodes) {
                URI currentGettableUri = ((ArbilDataNode)currentElement).getParentDomNode().getURI();
                getList.add(currentGettableUri);
                if (!seenFiles.containsKey(currentGettableUri)) {
                    seenFiles.put(currentGettableUri, new RetrievableFile(((ArbilDataNode)currentElement).getParentDomNode().getURI(), ImportExportDialog.this.exportDestinationDirectory));
                }
                while (!ImportExportDialog.this.stopCopy && getList.size() > 0) {
                    RetrievableFile currentRetrievableFile = seenFiles.get(getList.remove(0));
                    this.copyFile(currentRetrievableFile, seenFiles, doneList, getList, xsdChecker);
                }
                if (ImportExportDialog.this.exportDestinationDirectory == null) {
                    File newNodeLocation = ArbilSessionStorage.getSingleInstance().getSaveLocation(((ArbilDataNode)currentElement).getParentDomNode().getUrlString());
                    finishedTopNodes.add(dataNodeLoader.getArbilDataNodeWithoutLoading(newNodeLocation.toURI()));
                }
            }

            private void copyFile(RetrievableFile currentRetrievableFile, Hashtable<URI, RetrievableFile> seenFiles, ArrayList<URI> doneList, ArrayList<URI> getList, XsdChecker xsdChecker) {
                try {
                    if (!doneList.contains(currentRetrievableFile.sourceURI)) {
                        boolean replacingExitingFile;
                        String journalActionString;
                        if (ImportExportDialog.this.exportDestinationDirectory == null) {
                            currentRetrievableFile.calculateUriFileName();
                            journalActionString = "import";
                        } else {
                            if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                                currentRetrievableFile.calculateTreeFileName(ImportExportDialog.this.renameFileToLamusFriendlyName.isSelected(), Collections.<URI[]>emptyList());
                            } else {
                                currentRetrievableFile.calculateUriFileName();
                            }
                            journalActionString = "export";
                        }
                        MetadataUtils currentMetdataUtil = ArbilDataNode.getMetadataUtils(currentRetrievableFile.sourceURI.toString());
                        if (currentMetdataUtil == null) {
                            throw new ArbilMetadataException("Metadata format could not be determined");
                        }
                        ArrayList<URI[]> uncopiedLinks = new ArrayList<URI[]>();
                        URI[] linksUriArray = currentMetdataUtil.getCorpusLinks(currentRetrievableFile.sourceURI);
                        if (linksUriArray != null) {
                            this.copyLinks(linksUriArray, seenFiles, currentRetrievableFile, getList, uncopiedLinks);
                        }
                        boolean bl = replacingExitingFile = currentRetrievableFile.destinationFile.exists() && ImportExportDialog.this.overwriteCheckBox.isSelected();
                        if (currentRetrievableFile.destinationFile.exists()) {
                            ++this.totalExisting;
                        }
                        if (currentRetrievableFile.destinationFile.exists() && !ImportExportDialog.this.overwriteCheckBox.isSelected()) {
                            ImportExportDialog.this.appendToTaskOutput(currentRetrievableFile.sourceURI.toString());
                            ImportExportDialog.this.appendToTaskOutput("Destination already exists, skipping file: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                        } else {
                            ArbilDataNode destinationNode;
                            if (replacingExitingFile) {
                                ImportExportDialog.this.appendToTaskOutput("Replaced: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                            }
                            if ((destinationNode = dataNodeLoader.getArbilDataNodeWithoutLoading(currentRetrievableFile.destinationFile.toURI())).getNeedsSaveToDisk(false)) {
                                destinationNode.saveChangesToCache(true);
                            }
                            if (destinationNode.hasHistory()) {
                                destinationNode.bumpHistory();
                            }
                            if (!currentRetrievableFile.destinationFile.getParentFile().exists() && !currentRetrievableFile.destinationFile.getParentFile().mkdir()) {
                                GuiHelper.linorgBugCatcher.logError(new IOException("Could not create missing parent directory for " + currentRetrievableFile.destinationFile));
                            }
                            currentMetdataUtil.copyMetadataFile(currentRetrievableFile.sourceURI, currentRetrievableFile.destinationFile, (URI[][])uncopiedLinks.toArray((T[])new URI[0][]), true);
                            ArbilJournal.getSingleInstance().saveJournalEntry(currentRetrievableFile.destinationFile.getAbsolutePath(), "", currentRetrievableFile.sourceURI.toString(), "", journalActionString);
                            String checkerResult = xsdChecker.simpleCheck(currentRetrievableFile.destinationFile);
                            if (checkerResult != null) {
                                ImportExportDialog.this.xmlOutput.append(currentRetrievableFile.sourceURI.toString() + "\n");
                                ImportExportDialog.this.xmlOutput.append("destination path: " + currentRetrievableFile.destinationFile.getAbsolutePath());
                                System.out.println("checkerResult: " + checkerResult);
                                ImportExportDialog.this.xmlOutput.append(checkerResult + "\n");
                                ImportExportDialog.this.xmlOutput.setCaretPosition(ImportExportDialog.this.xmlOutput.getText().length() - 1);
                                ImportExportDialog.this.validationErrors.add(currentRetrievableFile.sourceURI);
                                ++this.xsdErrors;
                            }
                            if (replacingExitingFile) {
                                dataNodeLoader.requestReloadOnlyIfLoaded(currentRetrievableFile.destinationFile.toURI());
                            }
                        }
                    }
                }
                catch (ArbilMetadataException ex) {
                    GuiHelper.linorgBugCatcher.logError(currentRetrievableFile.sourceURI.toString(), ex);
                    ++this.totalErrors;
                    ImportExportDialog.this.metaDataCopyErrors.add(currentRetrievableFile.sourceURI);
                    ImportExportDialog.this.appendToTaskOutput("Unable to process the file: " + currentRetrievableFile.sourceURI + " (" + ex.getMessage() + ")");
                }
                catch (MalformedURLException ex) {
                    GuiHelper.linorgBugCatcher.logError(currentRetrievableFile.sourceURI.toString(), ex);
                    ++this.totalErrors;
                    ImportExportDialog.this.metaDataCopyErrors.add(currentRetrievableFile.sourceURI);
                    ImportExportDialog.this.appendToTaskOutput("Unable to process the file: " + currentRetrievableFile.sourceURI);
                    System.out.println("Error getting links from: " + currentRetrievableFile.sourceURI);
                }
                catch (IOException ex) {
                    GuiHelper.linorgBugCatcher.logError(currentRetrievableFile.sourceURI.toString(), ex);
                    ++this.totalErrors;
                    ImportExportDialog.this.metaDataCopyErrors.add(currentRetrievableFile.sourceURI);
                    ImportExportDialog.this.appendToTaskOutput("Unable to process the file: " + currentRetrievableFile.sourceURI);
                }
                ++this.totalLoaded;
                ImportExportDialog.this.progressFoundLabel.setText(ImportExportDialog.this.progressFoundLabelText + (getList.size() + this.totalLoaded));
                ImportExportDialog.this.progressProcessedLabel.setText(ImportExportDialog.this.progressProcessedLabelText + this.totalLoaded);
                ImportExportDialog.this.progressAlreadyInCacheLabel.setText(ImportExportDialog.this.progressAlreadyInCacheLabelText + this.totalExisting);
                ImportExportDialog.this.progressFailedLabel.setText(ImportExportDialog.this.progressFailedLabelText + this.totalErrors);
                ImportExportDialog.this.progressXmlErrorsLabel.setText(ImportExportDialog.this.progressXmlErrorsLabelText + this.xsdErrors);
                ImportExportDialog.this.resourceCopyErrorsLabel.setText(ImportExportDialog.this.resourceCopyErrorsLabelText + this.resourceCopyErrors);
                ImportExportDialog.this.progressBar.setString(this.totalLoaded + "/" + (getList.size() + this.totalLoaded) + " (" + (this.totalErrors + this.xsdErrors + this.resourceCopyErrors) + " errors)");
                if (this.testFreeSpace) {
                    this.testFreeSpace();
                }
            }

            private void copyLinks(URI[] linksUriArray, Hashtable<URI, RetrievableFile> seenFiles, RetrievableFile currentRetrievableFile, ArrayList<URI> getList, ArrayList<URI[]> uncopiedLinks) throws MalformedURLException {
                for (int linkCount = 0; linkCount < linksUriArray.length && !ImportExportDialog.this.stopCopy; ++linkCount) {
                    File downloadFileLocation;
                    System.out.println("Link: " + linksUriArray[linkCount].toString());
                    String currentLink = linksUriArray[linkCount].toString();
                    URI gettableLinkUri = linksUriArray[linkCount].normalize();
                    if (!seenFiles.containsKey(gettableLinkUri)) {
                        seenFiles.put(gettableLinkUri, new RetrievableFile(gettableLinkUri, currentRetrievableFile.childDestinationDirectory));
                    }
                    RetrievableFile retrievableLink = seenFiles.get(gettableLinkUri);
                    if (MetadataFormat.isPathMetadata(currentLink)) {
                        getList.add(gettableLinkUri);
                        if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                            retrievableLink.calculateTreeFileName(ImportExportDialog.this.renameFileToLamusFriendlyName.isSelected(), uncopiedLinks);
                        } else {
                            retrievableLink.calculateUriFileName();
                        }
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], retrievableLink.destinationFile.toURI()});
                        continue;
                    }
                    if (!ImportExportDialog.this.copyFilesImportCheckBox.isSelected() && !ImportExportDialog.this.copyFilesExportCheckBox.isSelected()) {
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], linksUriArray[linkCount]});
                        continue;
                    }
                    if (ImportExportDialog.this.exportDestinationDirectory == null) {
                        downloadFileLocation = ArbilSessionStorage.getSingleInstance().updateCache(currentLink, false, false, ImportExportDialog.this.downloadAbortFlag, ImportExportDialog.this.resourceProgressLabel);
                    } else {
                        if (ImportExportDialog.this.renameFileToNodeName.isSelected() && ImportExportDialog.this.exportDestinationDirectory != null) {
                            retrievableLink.calculateTreeFileName(ImportExportDialog.this.renameFileToLamusFriendlyName.isSelected(), uncopiedLinks);
                        } else {
                            retrievableLink.calculateUriFileName();
                        }
                        if (!retrievableLink.destinationFile.getParentFile().exists() && !retrievableLink.destinationFile.getParentFile().mkdirs()) {
                            GuiHelper.linorgBugCatcher.logError(new IOException("Could not create missing parent directory for " + retrievableLink.destinationFile));
                        }
                        downloadFileLocation = retrievableLink.destinationFile;
                        ImportExportDialog.this.resourceProgressLabel.setText(" ");
                        ArbilSessionStorage.getSingleInstance().saveRemoteResource(new URL(currentLink), downloadFileLocation, true, false, ImportExportDialog.this.downloadAbortFlag, ImportExportDialog.this.resourceProgressLabel);
                        ImportExportDialog.this.resourceProgressLabel.setText(" ");
                    }
                    if (downloadFileLocation != null && downloadFileLocation.exists()) {
                        ImportExportDialog.this.appendToTaskOutput("Downloaded resource: " + downloadFileLocation.getAbsolutePath());
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], downloadFileLocation.toURI()});
                    } else {
                        ImportExportDialog.this.resourceCopyOutput.append("Download failed: " + currentLink + " \n");
                        ImportExportDialog.this.fileCopyErrors.add(currentRetrievableFile.sourceURI);
                        uncopiedLinks.add(new URI[]{linksUriArray[linkCount], linksUriArray[linkCount]});
                        ++this.resourceCopyErrors;
                    }
                    ImportExportDialog.this.resourceCopyOutput.setCaretPosition(ImportExportDialog.this.resourceCopyOutput.getText().length() - 1);
                }
            }

            private void testFreeSpace() {
                try {
                    int freeGBytes = (int)(this.directoryForSizeTest.getFreeSpace() / 0x40000000L);
                    ImportExportDialog.this.diskSpaceLabel.setText(ImportExportDialog.this.diskFreeLabelText + freeGBytes + "GB");
                    if (this.freeGbWarningPoint > freeGBytes) {
                        ImportExportDialog.this.progressBar.setIndeterminate(false);
                        if (0 == ArbilWindowManager.getSingleInstance().showDialogBox("There is only " + freeGBytes + "GB free space left on the disk.\nTo you still want to continue?", ImportExportDialog.this.importExportDialog.getTitle(), 0, -1)) {
                            this.freeGbWarningPoint = freeGBytes - 1;
                        } else {
                            ImportExportDialog.this.stopCopy = true;
                        }
                        ImportExportDialog.this.progressBar.setIndeterminate(true);
                    }
                }
                catch (Exception ex) {
                    ImportExportDialog.this.diskSpaceLabel.setText(ImportExportDialog.this.diskFreeLabelText + "N/A");
                    this.testFreeSpace = false;
                }
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RetrievableFile {
        URI sourceURI;
        File destinationDirectory;
        File childDestinationDirectory;
        File destinationFile;
        String fileSuffix;

        public RetrievableFile(URI sourceURILocal, File destinationDirectoryLocal) {
            this.sourceURI = sourceURILocal;
            this.destinationDirectory = destinationDirectoryLocal;
        }

        private String makeFileNameLamusFriendly(String fileNameString) {
            String friendlyFileName = fileNameString.replaceAll("[^A-Za-z0-9-]", "_");
            friendlyFileName = friendlyFileName.replaceAll("__+", "_");
            return friendlyFileName;
        }

        public void calculateUriFileName() {
            this.destinationFile = this.destinationDirectory != null ? ArbilSessionStorage.getSingleInstance().getExportPath(this.sourceURI.toString(), this.destinationDirectory.getPath()) : ArbilSessionStorage.getSingleInstance().getSaveLocation(this.sourceURI.toString());
            this.childDestinationDirectory = this.destinationDirectory;
        }

        public void calculateTreeFileName(boolean lamusFriendly, List<URI[]> reservedLinks) {
            String urlString = this.sourceURI.toString();
            int suffixSeparator = urlString.lastIndexOf(".");
            this.fileSuffix = suffixSeparator > 0 && suffixSeparator > urlString.lastIndexOf("/") ? urlString.substring(suffixSeparator) : "";
            ArbilDataNode currentNode = dataNodeLoader.getArbilDataNode(null, this.sourceURI);
            currentNode.waitTillLoaded();
            String fileName = this.normalizeFileName(this.calculateDestinationFileName(currentNode, urlString), lamusFriendly);
            this.destinationFile = new File(this.destinationDirectory, fileName + this.fileSuffix);
            this.childDestinationDirectory = new File(this.destinationDirectory, fileName);
            int fileCounter = 1;
            while (this.destinationExistsOrIsReserved(reservedLinks)) {
                if (lamusFriendly) {
                    this.destinationFile = new File(this.destinationDirectory, fileName + "_" + fileCounter + this.fileSuffix);
                    this.childDestinationDirectory = new File(this.destinationDirectory, fileName + "_" + fileCounter);
                } else {
                    this.destinationFile = new File(this.destinationDirectory, fileName + "(" + fileCounter + ")" + this.fileSuffix);
                    this.childDestinationDirectory = new File(this.destinationDirectory, fileName + "(" + fileCounter + ")");
                }
                ++fileCounter;
            }
        }

        private boolean destinationExistsOrIsReserved(List<URI[]> reservedLinks) {
            URI destinationURI = this.destinationFile.toURI();
            if (this.destinationFile.exists()) {
                return true;
            }
            for (URI[] link : reservedLinks) {
                if (!link[1].equals(destinationURI)) continue;
                return true;
            }
            return false;
        }

        private String normalizeFileName(String fileNameString, boolean lamusFriendly) {
            fileNameString = fileNameString.replace("\\", "_");
            fileNameString = fileNameString.replace("/", "_");
            if (lamusFriendly) {
                fileNameString = this.makeFileNameLamusFriendly(fileNameString);
            }
            if (fileNameString.length() < 1) {
                fileNameString = "unnamed";
            }
            return fileNameString;
        }

        private String calculateDestinationFileName(ArbilDataNode currentNode, String urlString) {
            int lastPathSeparatorIndex;
            if (currentNode.isMetaDataNode()) {
                return currentNode.toString();
            }
            try {
                urlString = URLDecoder.decode(urlString, "UTF-8");
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(urlString, ex);
                ImportExportDialog.this.appendToTaskOutput("unable to decode the file name for: " + urlString);
                System.out.println("unable to decode the file name for: " + urlString);
            }
            if (urlString.endsWith("/")) {
                urlString = urlString.substring(0, urlString.length() - 1);
            }
            if ((lastPathSeparatorIndex = urlString.lastIndexOf("/")) >= 0) {
                int lastSuffixIndex = urlString.lastIndexOf(".");
                if (lastSuffixIndex > 0 && lastSuffixIndex > lastPathSeparatorIndex) {
                    return urlString.substring(lastPathSeparatorIndex + 1, lastSuffixIndex);
                }
                return urlString.substring(lastPathSeparatorIndex + 1);
            }
            return urlString;
        }
    }
}

