/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.awt.Component;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.data.AbstractTreeHelper;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.ui.ArbilTree;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.MessageDialogHandler;

public class ArbilTreeHelper
extends AbstractTreeHelper {
    private static ArbilTreeHelper singleInstance = null;
    private static MessageDialogHandler messageDialogHandler;
    private ArbilTreePanels arbilTreePanel;

    public static synchronized ArbilTreeHelper getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ArbilTreeHelper();
        }
        return singleInstance;
    }

    public static void setMessageDialogHandler(MessageDialogHandler handler) {
        messageDialogHandler = handler;
    }

    protected ArbilTreeHelper() {
        this.initTrees();
        this.loadLocationsList();
    }

    protected SessionStorage getSessionStorage() {
        return ArbilSessionStorage.getSingleInstance();
    }

    public void setTrees(ArbilTreePanels arbilTreePanelLocal) {
        this.arbilTreePanel = arbilTreePanelLocal;
        this.arbilTreePanel.remoteCorpusTree.setName("RemoteCorpusTree");
        this.arbilTreePanel.localCorpusTree.setName("LocalCorpusTree");
        this.arbilTreePanel.localDirectoryTree.setName("LocalDirectoryTree");
        this.arbilTreePanel.favouritesTree.setName("FavouritesTree");
        this.applyRootLocations();
    }

    public boolean componentIsTheLocalCorpusTree(Component componentToTest) {
        return componentToTest.equals(this.arbilTreePanel.localCorpusTree);
    }

    public boolean componentIsTheFavouritesTree(Component componentToTest) {
        return componentToTest.equals(this.arbilTreePanel.favouritesTree);
    }

    public void applyRootLocations() {
        if (this.arbilTreePanel != null) {
            this.arbilTreePanel.localCorpusTree.rootNodeChildren = this.getLocalCorpusNodes();
            this.arbilTreePanel.remoteCorpusTree.rootNodeChildren = this.getRemoteCorpusNodes();
            this.arbilTreePanel.localDirectoryTree.rootNodeChildren = this.getLocalFileNodes();
            this.arbilTreePanel.favouritesTree.rootNodeChildren = this.getFavouriteNodes();
            this.arbilTreePanel.localCorpusTree.requestResort();
            this.arbilTreePanel.remoteCorpusTree.requestResort();
            this.arbilTreePanel.localDirectoryTree.requestResort();
            this.arbilTreePanel.favouritesTree.requestResort();
        }
    }

    public DefaultMutableTreeNode getLocalCorpusTreeSingleSelection() {
        System.out.println("localCorpusTree: " + this.arbilTreePanel.localCorpusTree);
        return (DefaultMutableTreeNode)this.arbilTreePanel.localCorpusTree.getSelectionPath().getLastPathComponent();
    }

    public void deleteNodes(Object sourceObject) {
        System.out.println("deleteNode: " + sourceObject);
        if (sourceObject == this.arbilTreePanel.localCorpusTree || sourceObject == this.arbilTreePanel.favouritesTree) {
            TreePath[] currentNodePaths = ((ArbilTree)sourceObject).getSelectionPaths();
            int toDeleteCount = 0;
            String nameOfFirst = null;
            for (TreePath currentNodePath : currentNodePaths) {
                DefaultMutableTreeNode selectedTreeNode;
                Object userObject;
                if (currentNodePath == null || !((userObject = (selectedTreeNode = (DefaultMutableTreeNode)currentNodePath.getLastPathComponent()).getUserObject()) instanceof ArbilDataNode)) continue;
                toDeleteCount = ((ArbilDataNode)userObject).fileNotFound ? ++toDeleteCount : (((ArbilDataNode)userObject).isEmptyMetaNode() ? (toDeleteCount += ((ArbilDataNode)userObject).getChildCount()) : ++toDeleteCount);
                if (nameOfFirst != null) continue;
                nameOfFirst = ((ArbilDataNode)userObject).toString();
            }
            if (0 == messageDialogHandler.showDialogBox("Delete " + (toDeleteCount == 1 ? "the node \"" + nameOfFirst + "\"?" : toDeleteCount + " nodes?") + " This will also save any pending changes to disk.", "Delete", 0, -1)) {
                HashMap<ArbilDataNode, List<ArbilDataNode>> dataNodesDeleteList = new HashMap<ArbilDataNode, List<ArbilDataNode>>();
                HashMap<ArbilDataNode, List<String>> childNodeDeleteList = new HashMap<ArbilDataNode, List<String>>();
                HashMap<ArbilDataNode, List<ArbilDataNode>> cmdiLinksDeleteList = new HashMap<ArbilDataNode, List<ArbilDataNode>>();
                this.determineNodesToDelete(currentNodePaths, childNodeDeleteList, dataNodesDeleteList, cmdiLinksDeleteList);
                this.deleteNodesByChidXmlIdLink(childNodeDeleteList);
                this.deleteNodesByCorpusLink(dataNodesDeleteList);
                this.deleteCmdiLinks(cmdiLinksDeleteList);
            }
        } else {
            System.out.println("cannot delete from this tree");
        }
    }

    public void addLocationGui(URI addableLocation) {
        if (!this.addLocation(addableLocation)) {
            messageDialogHandler.addMessageDialogToQueue("The location already exists and cannot be added again", "Add location");
        }
        this.applyRootLocations();
    }

    public ArbilTreePanels getArbilTreePanel() {
        return this.arbilTreePanel;
    }
}

