/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.GuiHelper;
import nl.mpi.arbil.ui.menu.ArbilContextMenu;

public class TableContextMenu
extends ArbilContextMenu {
    private ArbilTable table;
    private JMenuItem copySelectedRowsMenuItem = new JMenuItem();
    private JMenuItem pasteIntoSelectedRowsMenuItem = new JMenuItem();
    private JMenuItem viewSelectedRowsMenuItem = new JMenuItem();
    private JMenuItem matchingRowsMenuItem = new JMenuItem();
    private JMenuItem removeSelectedRowsMenuItem = new JMenuItem();
    private JMenuItem hideSelectedColumnsMenuItem = new JMenuItem();
    private JMenuItem searchReplaceMenuItem = new JMenuItem();
    private JMenuItem deleteFieldMenuItem = new JMenuItem();
    private JMenuItem revertFieldMenuItem = new JMenuItem();
    private JMenuItem copyCellToColumnMenuItem = new JMenuItem();
    private JMenuItem matchingCellsMenuItem = new JMenuItem();
    private JMenuItem openInLongFieldEditorMenuItem = new JMenuItem();
    private JMenuItem clearCellColoursMenuItem = new JMenuItem();
    private JMenuItem jumpToNodeInTreeMenuItem = new JMenuItem();
    private JMenuItem showChildNodesMenuItem = new JMenuItem();
    private JMenuItem showInContextMenuItem = new JMenuItem();

    public TableContextMenu(ArbilTable table) {
        this.table = table;
        this.setInvoker(table);
        this.selectedTreeNodes = table.getSelectedRowsFromTable();
        this.leadSelectedTreeNode = table.getDataNodeForSelection();
    }

    protected void setUpMenu() {
        this.setUpItems();
        this.setUpActions();
    }

    private void setUpItems() {
        if (this.table.getSelectedRow() != -1) {
            ArbilField[] currentSelection;
            this.copySelectedRowsMenuItem.setVisible(true);
            this.pasteIntoSelectedRowsMenuItem.setVisible(true);
            this.openInLongFieldEditorMenuItem.setVisible(true);
            if (this.table.getArbilTableModel().isHorizontalView()) {
                this.viewSelectedRowsMenuItem.setVisible(true);
                this.matchingRowsMenuItem.setVisible(true);
                this.removeSelectedRowsMenuItem.setVisible(true);
                this.showChildNodesMenuItem.setVisible(true);
                this.showInContextMenuItem.setVisible(true);
            }
            boolean canDeleteSelectedFields = true;
            for (ArbilField currentField : currentSelection = this.table.getSelectedFields()) {
                if (currentField.getParentDataNode().getNodeTemplate().pathIsDeleteableField(currentField.getGenericFullXmlPath())) continue;
                canDeleteSelectedFields = false;
                break;
            }
            if (canDeleteSelectedFields && currentSelection.length > 0) {
                String menuText = currentSelection[0].isAttributeField() ? "Delete attribute " + currentSelection[0].getTranslateFieldName() : "Delete " + currentSelection[0].getTranslateFieldName();
                if (currentSelection.length > 1) {
                    menuText = menuText + " X " + currentSelection.length;
                }
                this.deleteFieldMenuItem.setText(menuText);
                this.deleteFieldMenuItem.setVisible(true);
            }
            for (ArbilField currentField : currentSelection) {
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                this.revertFieldMenuItem.setVisible(true);
                break;
            }
        }
        if (this.table.getSelectedRow() != -1 && this.table.getSelectedColumn() != -1) {
            if (this.table.getArbilTableModel().isHorizontalView() && this.table.getSelectionModel().getSelectionMode() == 1) {
                this.copyCellToColumnMenuItem.setVisible(true);
                this.hideSelectedColumnsMenuItem.setVisible(true);
            }
            if (!this.table.getArbilTableModel().isHorizontalView() || this.table.getSelectionModel().getSelectionMode() == 1) {
                this.matchingCellsMenuItem.setVisible(true);
            }
            this.jumpToNodeInTreeMenuItem.setVisible(false);
            this.clearCellColoursMenuItem.setVisible(true);
        }
        if (this.table.getParent().getParent().getParent().getParent() instanceof ArbilSplitPanel) {
            this.searchReplaceMenuItem.setVisible(true);
        }
    }

    private void setUpActions() {
        this.copySelectedRowsMenuItem.setText("Copy");
        this.copySelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.copySelectedTableRowsToClipBoard();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("edit", 105, this.copySelectedRowsMenuItem);
        this.pasteIntoSelectedRowsMenuItem.setText("Paste");
        this.pasteIntoSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.pasteIntoSelectedTableRowsFromClipBoard();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("edit", 110, this.pasteIntoSelectedRowsMenuItem);
        this.openInLongFieldEditorMenuItem.setText("Open in Long Field Editor");
        this.openInLongFieldEditorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.startLongFieldEditorForSelectedFields();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.hideSelectedColumnsMenuItem.setText("Hide Selected Columns");
        this.hideSelectedColumnsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.hideSelectedColumnsFromTable();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("table cell1", 15, this.hideSelectedColumnsMenuItem);
        this.showChildNodesMenuItem.setText("Show Child Nodes");
        this.showChildNodesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.showRowChildData();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        if (this.deleteFieldMenuItem.getText() == null || this.deleteFieldMenuItem.getText().length() == 0) {
            this.deleteFieldMenuItem.setText("Delete MultiField");
        }
        this.deleteFieldMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilField[] selectedFields = TableContextMenu.this.table.getSelectedFields();
                    if (selectedFields != null) {
                        Hashtable<ArbilDataNode, ArrayList<String>> selectedFieldHashtable = new Hashtable<ArbilDataNode, ArrayList<String>>();
                        for (ArbilField currentField : selectedFields) {
                            ArrayList<String> currentList = (ArrayList<String>)selectedFieldHashtable.get(currentField.getParentDataNode());
                            if (currentList == null) {
                                currentList = new ArrayList<String>();
                                selectedFieldHashtable.put(currentField.getParentDataNode(), currentList);
                            }
                            currentList.add(currentField.getFullXmlPath());
                        }
                        Iterator i$ = selectedFieldHashtable.keySet().iterator();
                        while (i$.hasNext()) {
                            ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
                            ArbilDataNode currentDataNode = (ArbilDataNode)i$.next();
                            boolean result = componentBuilder.removeChildNodes(currentDataNode, ((ArrayList)selectedFieldHashtable.get(currentDataNode)).toArray(new String[0]));
                            if (result) {
                                currentDataNode.reloadNode();
                                continue;
                            }
                            ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Error deleting fields, check the log file via the help menu for more information.", "Delete Field");
                        }
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.revertFieldMenuItem.setText("Revert Selected Fields");
        this.revertFieldMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilField[] selectedFields = TableContextMenu.this.table.getSelectedFields();
                    if (selectedFields != null) {
                        for (ArbilField currentField : selectedFields) {
                            currentField.revertChanges();
                        }
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.copyCellToColumnMenuItem.setText("Copy Cell to Whole Column");
        this.copyCellToColumnMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!(TableContextMenu.this.table.getArbilTableModel().getTableCellContentAt(TableContextMenu.this.table.getSelectedRow(), TableContextMenu.this.table.getSelectedColumn()) instanceof ArbilField)) {
                        ArbilWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot copy this type of field", "Copy Cell to Whole Column");
                    } else if (0 == JOptionPane.showConfirmDialog(ArbilWindowManager.getSingleInstance().linorgFrame, "About to replace all values in column \"" + TableContextMenu.this.table.getArbilTableModel().getColumnName(TableContextMenu.this.table.getSelectedColumn()) + "\"\nwith the value \"" + TableContextMenu.this.table.getArbilTableModel().getValueAt(TableContextMenu.this.table.getSelectedRow(), TableContextMenu.this.table.getSelectedColumn()) + "\"\n(<multiple values> will not be affected)", "Copy cell to whole column", 0, -1)) {
                        TableContextMenu.this.table.getArbilTableModel().copyCellToColumn(TableContextMenu.this.table.getSelectedRow(), TableContextMenu.this.table.getSelectedColumn());
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.addItem("edit", 100, this.copyCellToColumnMenuItem);
        this.matchingCellsMenuItem.setText("Highlight Matching Cells");
        this.matchingCellsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.getArbilTableModel().highlightMatchingCells(TableContextMenu.this.table.getSelectedRow(), TableContextMenu.this.table.getSelectedColumn());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.clearCellColoursMenuItem.setText("Clear Cell Highlight");
        this.clearCellColoursMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.getArbilTableModel().clearCellColours();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.searchReplaceMenuItem.setText("Find/Replace");
        this.searchReplaceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ((ArbilSplitPanel)TableContextMenu.this.table.getParent().getParent().getParent().getParent()).showSearchPane();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.viewSelectedRowsMenuItem.setText("View Selected Rows");
        this.viewSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.viewSelectedTableRows();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.matchingRowsMenuItem.setText("Select Matching Rows");
        this.matchingRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.highlightMatchingRows();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.removeSelectedRowsMenuItem.setText("Remove Selected Rows");
        this.removeSelectedRowsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    TableContextMenu.this.table.removeSelectedRowsFromTable();
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.jumpToNodeInTreeMenuItem.setText("Jump to in Tree");
        this.jumpToNodeInTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ArbilTreeHelper.getSingleInstance().jumpToSelectionInTree(false, TableContextMenu.this.table.getDataNodeForSelection());
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
        });
        this.jumpToNodeInTreeMenuItem.setEnabled(true);
        this.showInContextMenuItem.setText("Show Context");
        this.showInContextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashSet<ArbilDataNode> parentNodes = new HashSet<ArbilDataNode>();
                for (ArbilField selectedField : TableContextMenu.this.table.getSelectedFields()) {
                    parentNodes.add(selectedField.getParentDataNode().getParentDomNode());
                }
                ArbilWindowManager.getSingleInstance().openFloatingSubnodesWindows(parentNodes.toArray(new ArbilDataNode[0]));
            }
        });
        this.addItem("table cell1", 10, this.openInLongFieldEditorMenuItem);
        this.addItem("table cell1", 15, this.hideSelectedColumnsMenuItem);
        this.addItem("table cell1", 20, this.showChildNodesMenuItem);
        this.addItem("table cell1", 25, this.showInContextMenuItem);
        this.addItem("table cell2", 10, this.copyCellToColumnMenuItem);
        this.addItem("table cell2", 20, this.matchingCellsMenuItem);
        this.addItem("table cell2", 30, this.clearCellColoursMenuItem);
        this.addItem("table cell2", 60, this.searchReplaceMenuItem);
        this.addItem("table cell2", 65, this.deleteFieldMenuItem);
        this.addItem("table cell2", 70, this.revertFieldMenuItem);
        this.addItem("table row", 10, this.viewSelectedRowsMenuItem);
        this.addItem("table row", 15, this.matchingRowsMenuItem);
        this.addItem("table row", 20, this.removeSelectedRowsMenuItem);
        this.addItem("table row", 110, this.jumpToNodeInTreeMenuItem);
        this.addItem("edit", 60, this.copySelectedRowsMenuItem);
        this.addItem("edit", 65, this.pasteIntoSelectedRowsMenuItem);
    }

    protected void setAllInvisible() {
        this.copySelectedRowsMenuItem.setVisible(false);
        this.pasteIntoSelectedRowsMenuItem.setVisible(false);
        this.viewSelectedRowsMenuItem.setVisible(false);
        this.matchingRowsMenuItem.setVisible(false);
        this.removeSelectedRowsMenuItem.setVisible(false);
        this.hideSelectedColumnsMenuItem.setVisible(false);
        this.deleteFieldMenuItem.setVisible(false);
        this.revertFieldMenuItem.setVisible(false);
        this.copyCellToColumnMenuItem.setVisible(false);
        this.matchingCellsMenuItem.setVisible(false);
        this.openInLongFieldEditorMenuItem.setVisible(false);
        this.clearCellColoursMenuItem.setVisible(false);
        this.searchReplaceMenuItem.setVisible(false);
        this.jumpToNodeInTreeMenuItem.setVisible(false);
        this.showChildNodesMenuItem.setVisible(false);
        this.showInContextMenuItem.setVisible(false);
    }
}

