/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import net.handle.apps.db_tool.AttributePanel;
import net.handle.apps.db_tool.ServerInfoPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.Attribute;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class SiteInfoPanel
extends Panel
implements ActionListener {
    private TextField dataVersionField;
    private TextField protoMajorVersionField;
    private TextField protoMinorVersionField;
    private TextField serialNumberField;
    private Checkbox isPrimaryCheckbox;
    private Checkbox multiPrimaryCheckbox;
    private Choice hashOptionChoice;
    private List attributeList;
    private Button addAttributeButton;
    private Button remAttributeButton;
    private Button editAttributeButton;
    private Button upAttributeButton;
    private Button downAttributeButton;
    private List serverList;
    private Button addServerButton;
    private Button remServerButton;
    private Button editServerButton;
    private Button upServerButton;
    private Button downServerButton;
    private Vector attributes = new Vector();
    private Vector servers = new Vector();

    public SiteInfoPanel() {
        super(new GridBagLayout());
        this.dataVersionField = new TextField("1");
        this.dataVersionField.setEditable(false);
        this.protoMajorVersionField = new TextField("2");
        this.protoMinorVersionField = new TextField("0");
        this.serialNumberField = new TextField("1");
        this.isPrimaryCheckbox = new Checkbox("Primary Site", false);
        this.multiPrimaryCheckbox = new Checkbox("Multi-Primary", false);
        this.hashOptionChoice = new Choice();
        this.hashOptionChoice.addItem("By Entire Handle");
        this.hashOptionChoice.addItem("By Naming Authority");
        this.hashOptionChoice.addItem("By Local Name");
        this.attributeList = new List(5);
        this.addAttributeButton = new Button("Add");
        this.remAttributeButton = new Button("Remove");
        this.editAttributeButton = new Button("Modify");
        this.upAttributeButton = new Button("^");
        this.downAttributeButton = new Button("v");
        this.serverList = new List(5);
        this.addServerButton = new Button("Add");
        this.remServerButton = new Button("Remove");
        this.editServerButton = new Button("Modify");
        this.upServerButton = new Button("^");
        this.downServerButton = new Button("v");
        int x = 0;
        int y = 0;
        this.add((Component)new Label("Data Version: ", 2), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.dataVersionField, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)new Label("Protocol: ", 2), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.protoMajorVersionField, AwtUtil.getConstraints(x + 1, y, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)this.protoMinorVersionField, AwtUtil.getConstraints(x + 2, y++, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)new Label("Serial #: ", 2), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.serialNumberField, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)this.isPrimaryCheckbox, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)this.multiPrimaryCheckbox, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)new Label("Hash: ", 2), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)this.hashOptionChoice, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        Panel attributePanel = new Panel(new GridBagLayout());
        attributePanel.add((Component)this.attributeList, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 10, true, true));
        attributePanel.add((Component)this.addAttributeButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 2, 1, true, true));
        attributePanel.add((Component)this.remAttributeButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 2, 1, true, true));
        attributePanel.add((Component)this.editAttributeButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 2, 1, true, true));
        attributePanel.add((Component)this.upAttributeButton, AwtUtil.getConstraints(1, 3, 0.1, 0.0, 1, 1, true, true));
        attributePanel.add((Component)this.downAttributeButton, AwtUtil.getConstraints(2, 3, 0.1, 0.0, 1, 1, true, true));
        this.add((Component)new Label("Attributes: ", 2), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)attributePanel, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        Panel serverPanel = new Panel(new GridBagLayout());
        serverPanel.add((Component)this.serverList, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 10, true, true));
        serverPanel.add((Component)this.addServerButton, AwtUtil.getConstraints(1, 0, 0.0, 0.0, 2, 1, true, true));
        serverPanel.add((Component)this.remServerButton, AwtUtil.getConstraints(1, 1, 0.0, 0.0, 2, 1, true, true));
        serverPanel.add((Component)this.editServerButton, AwtUtil.getConstraints(1, 2, 0.0, 0.0, 2, 1, true, true));
        serverPanel.add((Component)this.upServerButton, AwtUtil.getConstraints(1, 3, 0.1, 0.0, 1, 1, true, true));
        serverPanel.add((Component)this.downServerButton, AwtUtil.getConstraints(2, 3, 0.1, 0.0, 1, 1, true, true));
        this.add((Component)new Label("Servers: ", 2), AwtUtil.getConstraints(x, y, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)serverPanel, AwtUtil.getConstraints(x + 1, y++, 1.0, 0.0, 2, 1, true, true));
        this.attributeList.addActionListener(this);
        this.addAttributeButton.addActionListener(this);
        this.remAttributeButton.addActionListener(this);
        this.editAttributeButton.addActionListener(this);
        this.upAttributeButton.addActionListener(this);
        this.downAttributeButton.addActionListener(this);
        this.serverList.addActionListener(this);
        this.addServerButton.addActionListener(this);
        this.remServerButton.addActionListener(this);
        this.editServerButton.addActionListener(this);
        this.upServerButton.addActionListener(this);
        this.downServerButton.addActionListener(this);
    }

    public void setSiteInfo(SiteInfo site) {
        int i;
        this.dataVersionField.setText(String.valueOf(site.dataFormatVersion));
        this.protoMajorVersionField.setText(String.valueOf(site.majorProtocolVersion));
        this.protoMinorVersionField.setText(String.valueOf(site.minorProtocolVersion));
        this.serialNumberField.setText(String.valueOf(site.serialNumber));
        this.isPrimaryCheckbox.setState(site.isPrimary);
        this.multiPrimaryCheckbox.setState(site.multiPrimary);
        switch (site.hashOption) {
            case 0: {
                this.hashOptionChoice.select(1);
                break;
            }
            case 1: {
                this.hashOptionChoice.select(2);
                break;
            }
            default: {
                this.hashOptionChoice.select(0);
            }
        }
        this.servers.removeAllElements();
        if (site.servers != null) {
            for (i = 0; i < site.servers.length; ++i) {
                this.servers.addElement(site.servers[i]);
            }
        }
        this.rebuildServerList();
        this.attributes.removeAllElements();
        if (site.attributes != null) {
            for (i = 0; i < site.attributes.length; ++i) {
                this.attributes.addElement(site.attributes[i]);
            }
        }
        this.rebuildAttributeList();
    }

    public void getSiteInfo(SiteInfo site) {
        try {
            int i;
            site.dataFormatVersion = Integer.parseInt(this.dataVersionField.getText().trim());
            site.majorProtocolVersion = (byte)Integer.parseInt(this.protoMajorVersionField.getText().trim());
            site.minorProtocolVersion = (byte)Integer.parseInt(this.protoMinorVersionField.getText().trim());
            site.serialNumber = Integer.parseInt(this.serialNumberField.getText().trim());
            site.isPrimary = this.isPrimaryCheckbox.getState();
            site.multiPrimary = this.multiPrimaryCheckbox.getState();
            switch (this.hashOptionChoice.getSelectedIndex()) {
                case 0: {
                    site.hashOption = (byte)2;
                    break;
                }
                case 1: {
                    site.hashOption = 0;
                    break;
                }
                case 2: {
                    site.hashOption = 1;
                    break;
                }
                default: {
                    site.hashOption = (byte)2;
                }
            }
            site.servers = new ServerInfo[this.servers.size()];
            for (i = 0; i < this.servers.size(); ++i) {
                site.servers[i] = (ServerInfo)this.servers.elementAt(i);
            }
            site.attributes = new Attribute[this.attributes.size()];
            for (i = 0; i < this.attributes.size(); ++i) {
                site.attributes[i] = (Attribute)this.attributes.elementAt(i);
            }
        }
        catch (Exception e) {
            this.getToolkit().beep();
            System.err.println("There was an error getting the data");
        }
    }

    private void rebuildServerList() {
        this.serverList.removeAll();
        for (int i = 0; i < this.servers.size(); ++i) {
            this.serverList.addItem(String.valueOf(this.servers.elementAt(i)));
        }
    }

    private void rebuildAttributeList() {
        this.attributeList.removeAll();
        for (int i = 0; i < this.attributes.size(); ++i) {
            this.attributeList.addItem(String.valueOf(this.attributes.elementAt(i)));
        }
    }

    private void evtAddAttribute() {
        AttributePanel attPanel = new AttributePanel();
        if (2 == GenericDialog.showDialog("Add Attribute", attPanel, 3, this)) {
            return;
        }
        this.attributes.addElement(new Attribute(Util.encodeString(attPanel.getName()), Util.encodeString(attPanel.getValue())));
        this.rebuildAttributeList();
    }

    private void evtRemAttribute() {
        int idx = this.attributeList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        this.attributes.removeElementAt(idx);
        this.rebuildAttributeList();
    }

    private void evtEditAttribute() {
        int idx = this.attributeList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        Attribute attribute = (Attribute)this.attributes.elementAt(idx);
        AttributePanel attPanel = new AttributePanel();
        attPanel.setName(Util.decodeString(attribute.name));
        attPanel.setValue(Util.decodeString(attribute.value));
        if (2 == GenericDialog.showDialog("Edit Attribute", attPanel, 3, this)) {
            return;
        }
        attribute.name = Util.encodeString(attPanel.getName());
        attribute.value = Util.encodeString(attPanel.getValue());
        this.rebuildAttributeList();
    }

    private void evtUpAttribute() {
        int idx = this.attributeList.getSelectedIndex();
        if (idx <= 0) {
            return;
        }
        Attribute attribute = (Attribute)this.attributes.elementAt(idx);
        this.attributes.removeElementAt(idx);
        this.attributes.insertElementAt(attribute, idx - 1);
        this.rebuildAttributeList();
        this.attributeList.select(idx - 1);
    }

    private void evtDownAttribute() {
        int idx = this.attributeList.getSelectedIndex();
        if (idx < 0 || idx == this.attributes.size() - 1) {
            return;
        }
        Attribute attribute = (Attribute)this.attributes.elementAt(idx);
        this.attributes.removeElementAt(idx);
        this.attributes.insertElementAt(attribute, idx + 1);
        this.rebuildAttributeList();
        this.attributeList.select(idx + 1);
    }

    private void evtAddServer() {
        ServerInfoPanel svrPanel = new ServerInfoPanel();
        if (2 == GenericDialog.showDialog("Add Server", svrPanel, 3, this)) {
            return;
        }
        ServerInfo server = new ServerInfo();
        svrPanel.getServerInfo(server);
        this.servers.addElement(server);
        this.rebuildServerList();
    }

    private void evtRemServer() {
        int idx = this.serverList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        this.servers.removeElementAt(idx);
        this.rebuildServerList();
    }

    private void evtEditServer() {
        int idx = this.serverList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        ServerInfo server = (ServerInfo)this.servers.elementAt(idx);
        ServerInfoPanel svrPanel = new ServerInfoPanel();
        svrPanel.setServerInfo(server);
        if (2 == GenericDialog.showDialog("Edit Server", svrPanel, 3, this)) {
            return;
        }
        svrPanel.getServerInfo(server);
        this.rebuildServerList();
    }

    private void evtUpServer() {
        int idx = this.serverList.getSelectedIndex();
        if (idx <= 0) {
            return;
        }
        ServerInfo server = (ServerInfo)this.servers.elementAt(idx);
        this.servers.removeElementAt(idx);
        this.servers.insertElementAt(server, idx - 1);
        this.rebuildServerList();
        this.serverList.select(idx - 1);
    }

    private void evtDownServer() {
        int idx = this.serverList.getSelectedIndex();
        if (idx < 0 || idx == this.servers.size() - 1) {
            return;
        }
        ServerInfo server = (ServerInfo)this.servers.elementAt(idx);
        this.servers.removeElementAt(idx);
        this.servers.insertElementAt(server, idx + 1);
        this.rebuildServerList();
        this.serverList.select(idx + 1);
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.attributeList) {
            this.evtEditAttribute();
        } else if (src == this.addAttributeButton) {
            this.evtAddAttribute();
        } else if (src == this.remAttributeButton) {
            this.evtRemAttribute();
        } else if (src == this.editAttributeButton) {
            this.evtEditAttribute();
        } else if (src == this.upAttributeButton) {
            this.evtUpAttribute();
        } else if (src == this.downAttributeButton) {
            this.evtDownAttribute();
        } else if (src == this.serverList) {
            this.evtEditServer();
        } else if (src == this.addServerButton) {
            this.evtAddServer();
        } else if (src == this.remServerButton) {
            this.evtRemServer();
        } else if (src == this.editServerButton) {
            this.evtEditServer();
        } else if (src == this.upServerButton) {
            this.evtUpServer();
        } else if (src == this.downServerButton) {
            this.evtDownServer();
        }
    }
}

