/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.File;
import java.io.FileInputStream;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SecretKeyAuthenticationInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class DoCheckpoint {
    private AuthenticationInfo authInfo = null;
    private SiteInfo siteToCheckpoint = null;
    private static HandleResolver resolver = new HandleResolver();

    public static void main(String[] argv) throws Exception {
        if (argv.length != 5) {
            System.err.println("java net.handle.apps.tools.DoCheckpoint [siteinfo] [admin-hdl] [admin-index] [keytype] [key]");
            System.exit(1);
        }
        SiteInfo siteInfo = DoCheckpoint.createSiteInfo(argv[0]);
        AuthenticationInfo auth = DoCheckpoint.createAuth(argv[1], argv[2], argv[3], argv[4]);
        DoCheckpoint checkpointer = new DoCheckpoint(auth, siteInfo);
        checkpointer.doIt();
    }

    private static SiteInfo createSiteInfo(String siteInfoFileName) throws Exception {
        int r;
        File siteFile = new File(siteInfoFileName);
        FileInputStream in = new FileInputStream(siteFile);
        byte[] buf = new byte[(int)siteFile.length()];
        for (int n = 0; n < buf.length && (r = in.read(buf, n, buf.length - n)) >= 0; n += r) {
        }
        SiteInfo siteInfo = new SiteInfo();
        Encoder.decodeSiteInfoRecord(buf, 0, siteInfo);
        return siteInfo;
    }

    private static AuthenticationInfo createAuth(String id, String idIdx, String type, String key) throws Exception {
        if (type.equals("PRIVATE")) {
            int r;
            File privateKeyFile = new File(key);
            FileInputStream in = new FileInputStream(privateKeyFile);
            byte[] encKeyBytes = new byte[(int)privateKeyFile.length()];
            for (int n = 0; n < encKeyBytes.length && (r = in.read(encKeyBytes, n, encKeyBytes.length - n)) >= 0; n += r) {
            }
            byte[] keyBytes = null;
            byte[] secKey = null;
            keyBytes = Util.decrypt(encKeyBytes, secKey);
            for (int i = 0; secKey != null && i < secKey.length; ++i) {
                secKey[i] = false;
            }
            PrivateKey privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
            return new PublicKeyAuthenticationInfo(Util.encodeString(id), Integer.parseInt(idIdx), privateKey);
        }
        return new SecretKeyAuthenticationInfo(Util.encodeString(id), Integer.parseInt(idIdx), Util.encodeString(key));
    }

    public DoCheckpoint(AuthenticationInfo auth, SiteInfo siteInfo) {
        this.authInfo = auth;
        this.siteToCheckpoint = siteInfo;
    }

    public void doIt() {
        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 1003, this.authInfo);
        for (int i = 0; i < this.siteToCheckpoint.servers.length; ++i) {
            try {
                System.out.println("----------------------------------------------------");
                System.out.println("Checkpointing server " + i + ": " + this.siteToCheckpoint.servers[i]);
                AbstractResponse resp = resolver.sendRequestToServer(req, this.siteToCheckpoint.servers[i]);
                if (resp != null && resp.responseCode == 1) continue;
                System.err.println("Error sending backup message: " + resp);
                continue;
            }
            catch (Throwable t) {
                System.err.println("Error checkpointing server " + i + ": " + t);
                t.printStackTrace(System.err);
            }
        }
    }
}

