/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.handle.hdllib4.InvalidPacketException;
import net.handle.hdllib4.ResponsePacketBody;
import net.handle.hdllib4.ResponsePacketHeader;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;
import net.handle.hdllib4.XdrEncodingException;

public class HandleResponsePacket {
    public ResponsePacketHeader packetHeader;
    public ResponsePacketBody packetBody;

    public HandleResponsePacket(ResponsePacketHeader header, ResponsePacketBody body) {
        this.packetHeader = header;
        this.packetBody = body;
    }

    public HandleResponsePacket(byte[] buf, int length) throws IOException, XdrEncodingException, InvalidPacketException {
        XdrDecoder decoder = new XdrDecoder(buf, 0, length);
        this.packetHeader = new ResponsePacketHeader(decoder);
        if (this.packetHeader.bodyLength < 0 || this.packetHeader.bodyLength > 484) {
            throw new InvalidPacketException("Invalid body length: " + this.packetHeader.bodyLength);
        }
        byte[] body = decoder.readBytes(this.packetHeader.bodyLength);
        this.packetBody = new ResponsePacketBody(this.packetHeader.errorCode, body, 0, body.length);
    }

    public HandleResponsePacket(InputStream in) throws IOException, XdrEncodingException, InvalidPacketException {
        int idx = 0;
        int n = 0;
        XdrDecoder decoder = new XdrDecoder(in);
        this.packetHeader = new ResponsePacketHeader(decoder);
        if (this.packetHeader.bodyLength < 0 || this.packetHeader.bodyLength > 484) {
            throw new InvalidPacketException("Invalid body length: " + this.packetHeader.bodyLength);
        }
        byte[] buf = new byte[Math.max(this.packetHeader.bodyLength, 0)];
        for (idx = 0; idx < this.packetHeader.bodyLength; idx += n) {
            n = in.read(buf, idx, buf.length - idx);
            if (n > 0) continue;
            throw new InvalidPacketException("Unexpected end of packet");
        }
        this.packetBody = new ResponsePacketBody(this.packetHeader.errorCode, buf, 0, buf.length);
    }

    public byte[] getPacket() throws InvalidPacketException {
        XdrEncoder encoder = new XdrEncoder(512);
        byte[] body = this.packetBody.encodePacketBody();
        this.packetHeader.bodyLength = body.length;
        this.packetHeader.encodeHeader(encoder);
        encoder.writeBytes(body);
        return encoder.getCurrentBuffer();
    }

    public XdrDecoder getBodyDecoder() throws IOException {
        return new XdrDecoder(this.packetBody.getData());
    }

    public void printValues(PrintStream out) {
        this.packetHeader.printValues(out);
    }
}

