/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util.gui.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import nl.mpi.util.gui.swing.NothingComponent;

public class MultiLineStringRenderer
extends JTextArea
implements TableCellRenderer {
    private static final String EMPTY_STRING = "";
    private static final Border BORDER_SELECTED = UIManager.getBorder("Table.focusCellHighlightBorder");
    private static final Border BORDER_EMPTY = new EmptyBorder(1, 2, 1, 2);
    private static final Color FC_FOREGROUND = UIManager.getColor("Table.focusCellForeground");
    private static final Color FC_BACKGROUND = UIManager.getColor("Table.focusCellBackground");
    protected Component stubRenderer = new NothingComponent();

    public MultiLineStringRenderer() {
        this.setLineWrap(false);
        this.setWrapStyleWord(false);
        this.setEditable(false);
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(isSelected || hasFocus || value != null && ((String)value).length() != 0)) {
            return this.stubRenderer;
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(BORDER_SELECTED);
            if (table.isCellEditable(row, column)) {
                this.setForeground(FC_FOREGROUND);
                this.setBackground(FC_BACKGROUND);
            }
        } else {
            this.setBorder(BORDER_EMPTY);
        }
        this.setText(value == null ? EMPTY_STRING : value.toString());
        return this;
    }
}

