/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data.metadatafile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.metadatafile.MetadataUtils;
import nl.mpi.arbil.util.BugCatcherManager;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CmdiUtils
implements MetadataUtils {
    public boolean addCorpusLink(URI nodeURI, URI[] linkURI) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyMetadataFile(URI sourceURI, File destinationFile, URI[][] linksToUpdate, boolean updateLinks) throws IOException, ArbilMetadataException {
        try {
            ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
            Document document = ArbilComponentBuilder.getDocument(sourceURI);
            this.copySchemaFile(sourceURI, destinationFile, document);
            CmdiComponentLinkReader cmdiComponentLinkReader = new CmdiComponentLinkReader();
            ArrayList<CmdiComponentLinkReader.CmdiResourceLink> links = cmdiComponentLinkReader.readLinks(sourceURI);
            if (links != null && updateLinks) {
                block5: for (CmdiComponentLinkReader.CmdiResourceLink link : links) {
                    try {
                        URI originalRef = link.getResolvedLinkUri();
                        if (linksToUpdate == null) continue;
                        for (URI[] updatableLink : linksToUpdate) {
                            if (!sourceURI.resolve(updatableLink[0]).equals(originalRef)) continue;
                            URI newReferenceURi = destinationFile.getParentFile().toURI().relativize(updatableLink[1]);
                            if (componentBuilder.updateResourceProxyReference(document, link.resourceProxyId, newReferenceURi)) continue block5;
                            BugCatcherManager.getBugCatcher().logError("Could not update resource proxy with id" + link.resourceProxyId + " in " + sourceURI.toString(), null);
                            continue block5;
                        }
                    }
                    catch (URISyntaxException ex) {
                        BugCatcherManager.getBugCatcher().logError("Cannot resolve resource proxy link while copying. Any replacements for this link have been skipped. ResourceProxy id:" + link.resourceProxyId, ex);
                    }
                }
            }
            ArbilComponentBuilder.savePrettyFormatting(document, destinationFile);
        }
        catch (ParserConfigurationException e) {
            throw new ArbilMetadataException("Parser error: " + e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ArbilMetadataException("Parser error: " + e.getMessage(), e);
        }
    }

    public MetadataUtils.MetadataLinkSet getCorpusLinks(URI nodeURI) {
        ArrayList<URI> metadataLinks = new ArrayList<URI>();
        ArrayList<URI> resourceLinks = new ArrayList<URI>();
        CmdiComponentLinkReader cmdiComponentLinkReader = new CmdiComponentLinkReader();
        ArrayList<CmdiComponentLinkReader.CmdiResourceLink> links = cmdiComponentLinkReader.readLinks(nodeURI);
        if (links != null) {
            for (CmdiComponentLinkReader.CmdiResourceLink link : links) {
                try {
                    URI linkUri = link.getLinkUri();
                    if (linkUri == null) continue;
                    if (!linkUri.isAbsolute()) {
                        linkUri = nodeURI.resolve(linkUri);
                    }
                    if (link.resourceType.equalsIgnoreCase("Metadata")) {
                        metadataLinks.add(linkUri);
                        continue;
                    }
                    resourceLinks.add(linkUri);
                }
                catch (URISyntaxException ex) {
                    BugCatcherManager.getBugCatcher().logError("Invalid link URI found in " + nodeURI.toString(), ex);
                }
            }
        }
        return new MetadataUtils.MetadataLinkSet(resourceLinks, metadataLinks);
    }

    public boolean moveMetadataFile(URI sourceURI, File destinationFile, boolean updateLinks) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean removeCorpusLink(URI nodeURI, URI[] linkURI) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void copySchemaFile(URI mdSourceURI, File mdDestinationFile, Document mdDocument) {
        Element cmdElement;
        Attr schemaAttr;
        Node rootNode = mdDocument.getFirstChild();
        if (rootNode instanceof Element && (schemaAttr = (cmdElement = (Element)rootNode).getAttributeNode("xsi:schemaLocation")) != null) {
            String[] schemaLocationValues = schemaAttr.getValue().split("\\s+");
            String[] newSchemaLocationValues = new String[schemaLocationValues.length];
            int i = 0;
            while (i + 1 < schemaLocationValues.length) {
                String nameSpace = schemaLocationValues[i];
                String originalLocation = schemaLocationValues[i + 1];
                newSchemaLocationValues[i] = nameSpace;
                try {
                    URI locationURI = new URI(originalLocation);
                    if (!locationURI.isAbsolute() || locationURI.getScheme().equals("file")) {
                        File exportDirectory;
                        File newLocationFile;
                        File originalLocationFile = new File(locationURI = mdSourceURI.resolve(locationURI));
                        if (this.copySchemaFile(originalLocationFile, newLocationFile = new File(exportDirectory = mdDestinationFile.getParentFile(), originalLocationFile.getName()))) {
                            URI newLocationURI = exportDirectory.toURI().relativize(newLocationFile.toURI());
                            newSchemaLocationValues[i + 1] = newLocationURI.toString();
                        } else {
                            newSchemaLocationValues[i + 1] = originalLocation;
                        }
                    } else {
                        newSchemaLocationValues[i + 1] = originalLocation;
                    }
                }
                catch (URISyntaxException ex) {
                    BugCatcherManager.getBugCatcher().logError("Problematic URI in xsi:schemaLocation: " + schemaLocationValues[i], ex);
                }
                i += 2;
            }
            StringBuilder schemaLocationsBuilder = new StringBuilder();
            for (String locationValue : newSchemaLocationValues) {
                schemaLocationsBuilder.append(locationValue).append(" ");
            }
            schemaAttr.setValue(schemaLocationsBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copySchemaFile(File originalLocation, File targetLocation) {
        block6: {
            boolean bl;
            FileInputStream inStream = new FileInputStream(originalLocation);
            try {
                bl = 0 != CmdiUtils.copyFile(inStream, targetLocation);
            }
            catch (Throwable throwable) {
                try {
                    inStream.close();
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                    break block6;
                }
                catch (IOException ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
            inStream.close();
            return bl;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copyFile(InputStream inStream, File outFile) throws FileNotFoundException, IOException {
        int bufferLength = 3072;
        byte[] buffer = new byte[3072];
        FileOutputStream outStream = new FileOutputStream(outFile);
        int totalRead = 0;
        try {
            int bytesread = 0;
            while (bytesread >= 0) {
                bytesread = inStream.read(buffer);
                totalRead += bytesread;
                if (bytesread == -1) {
                    break;
                }
                outStream.write(buffer, 0, bytesread);
            }
        }
        finally {
            outStream.close();
        }
        return totalRead;
    }
}

