/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ArbilMetadataException;
import nl.mpi.arbil.data.ArbilComponentBuilder;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.data.MetadataBuilder;
import nl.mpi.arbil.data.NodeCreationCallback;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.ui.ArbilFieldPlaceHolder;
import nl.mpi.arbil.ui.ArbilFieldViewTable;
import nl.mpi.arbil.ui.ArbilFieldViews;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableCellEditor;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.TableController;
import nl.mpi.arbil.ui.fieldeditors.ArbilLongFieldEditor;
import nl.mpi.arbil.ui.menu.TableContextMenu;
import nl.mpi.arbil.ui.menu.TableHeaderContextMenu;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;
import nl.mpi.arbil.util.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTableController
implements TableController {
    private static final Logger logger = LoggerFactory.getLogger(ArbilTableController.class);
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    public static final String DELETE_ROW_ACTION_KEY = "deleteRow";
    private final TreeHelper treeHelper;
    private final MessageDialogHandler dialogHandler;
    private final WindowManager windowManager;
    private final MouseListener tableMouseListener = new TableMouseListener();
    private final MouseListener tableHeaderMouseListener = new TableHeaderMouseListener();
    private final Action deleteRowAction = new DeleteRowAction();

    public ArbilTableController(TreeHelper treeHelper, MessageDialogHandler dialogHandler, WindowManager windowManager) {
        this.treeHelper = treeHelper;
        this.dialogHandler = dialogHandler;
        this.windowManager = windowManager;
    }

    @Override
    public void initKeyMapping(ArbilTable table) {
        table.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), DELETE_ROW_ACTION_KEY);
        table.getActionMap().put(DELETE_ROW_ACTION_KEY, this.deleteRowAction);
    }

    @Override
    public MouseListener getTableMouseListener() {
        return this.tableMouseListener;
    }

    @Override
    public MouseListener getTableHeaderMouseListener() {
        return this.tableHeaderMouseListener;
    }

    @Override
    public void openNodesInNewTable(ArbilDataNode[] nodes, String fieldName, ArbilDataNode registeredOwner) {
        this.windowManager.openFloatingTableOnce(nodes, MessageFormat.format(widgets.getString("%S IN %S"), fieldName, registeredOwner));
    }

    @Override
    public void showRowChildData(ArbilTableModel tableModel) {
        Object[] possibilities = tableModel.getChildNames();
        String selectionResult = (String)JOptionPane.showInputDialog(this.windowManager.getMainFrame(), widgets.getString("SELECT THE CHILD NODE TYPE TO DISPLAY"), widgets.getString("SHOW CHILD NODES"), -1, null, possibilities, null);
        if (selectionResult != null && selectionResult.length() > 0) {
            tableModel.addChildTypeToDisplay(selectionResult);
        }
    }

    @Override
    public void viewSelectedTableRows(ArbilTable table) {
        int[] selectedRows = table.getSelectedRows();
        this.windowManager.openFloatingTableOnce(table.getArbilTableModel().getSelectedDataNodes(selectedRows), null);
    }

    @Override
    public void showColumnViewsEditor(ArbilTable table) {
        table.updateStoredColumnWidths();
        try {
            ArbilFieldViewTable fieldViewTable = new ArbilFieldViewTable(table.getArbilTableModel());
            JDialog editViewsDialog = new JDialog(JOptionPane.getFrameForComponent(this.windowManager.getMainFrame()), true);
            editViewsDialog.setTitle(widgets.getString("EDITING CURRENT COLUMN VIEW"));
            JScrollPane js = new JScrollPane(fieldViewTable);
            editViewsDialog.getContentPane().add(js);
            editViewsDialog.setBounds(50, 50, 600, 400);
            editViewsDialog.setVisible(true);
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    @Override
    public void saveCurrentColumnView(ArbilTable table) {
        try {
            String fieldViewName = JOptionPane.showInputDialog(null, widgets.getString("ENTER A NAME TO SAVE THIS COLUMN VIEW AS"), widgets.getString("SAVE COLUMN VIEW"), -1);
            if (fieldViewName != null) {
                table.updateStoredColumnWidths();
                if (!ArbilFieldViews.getSingleInstance().addArbilFieldView(fieldViewName, table.getArbilTableModel().getFieldView())) {
                    this.dialogHandler.addMessageDialogToQueue(widgets.getString("A COLUMN VIEW WITH THE SAME NAME ALREADY EXISTS, NOTHING SAVED"), widgets.getString("SAVE COLUMN VIEW"));
                }
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    @Override
    public boolean deleteSelectedFields(ArbilTable table) {
        ArbilField[] selectedFields = table.getSelectedFields();
        if (selectedFields != null) {
            return this.deleteFields(Arrays.asList(selectedFields));
        }
        return false;
    }

    @Override
    public boolean deleteColumnFieldFromAllNodes(ArbilTable table, String columnName) {
        ArrayList<ArbilDataNode> rowNodes = Collections.list(table.getArbilTableModel().getArbilDataNodes());
        ArrayList<ArbilField> fieldsToDelete = new ArrayList<ArbilField>(rowNodes.size());
        for (ArbilDataNode rowNode : rowNodes) {
            ArbilField[] fields = rowNode.getFields().get(columnName);
            if (fields == null) continue;
            for (ArbilField field : fields) {
                String fieldPath;
                ArbilTemplate fieldParentTemplate = field.getParentDataNode().getNodeTemplate();
                if (!fieldParentTemplate.pathIsDeleteableField(fieldPath = field.getGenericFullXmlPath())) {
                    this.dialogHandler.addMessageDialogToQueue(widgets.getString("THIS FIELD CANNOT BE DELETED FROM ONE OR MORE OF THE SHOWN NODES"), widgets.getString("CANNOT DELETE"));
                    return false;
                }
                fieldsToDelete.add(fields[0]);
            }
        }
        if (this.dialogHandler.showConfirmDialogBox(MessageFormat.format(widgets.getString("DELETE %D INSTANCE OF THE FIELD '%S'?"), fieldsToDelete.size(), columnName), widgets.getString("DELETE FIELD"))) {
            return this.deleteFields(fieldsToDelete);
        }
        return false;
    }

    private boolean deleteFields(Collection<ArbilField> fields) {
        ArbilComponentBuilder componentBuilder = new ArbilComponentBuilder();
        try {
            Map<ArbilDataNode, List<String>> selectedFieldHashtable = this.getFieldDeletionMap(fields);
            for (ArbilDataNode currentDataNode : selectedFieldHashtable.keySet()) {
                String[] fieldsToDelete;
                if (componentBuilder.removeChildNodes(currentDataNode, fieldsToDelete = selectedFieldHashtable.get(currentDataNode).toArray(new String[0]))) {
                    currentDataNode.reloadNode();
                    continue;
                }
                this.dialogHandler.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ERROR DELETING FIELDS, CHECK THE LOG FILE VIA THE HELP MENU FOR MORE INFORMATION."), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("DELETE FIELD"));
            }
            return true;
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
            return false;
        }
    }

    private Map<ArbilDataNode, List<String>> getFieldDeletionMap(Collection<ArbilField> fields) {
        HashMap<ArbilDataNode, List<String>> selectedFieldHashtable = new HashMap<ArbilDataNode, List<String>>();
        for (ArbilField currentField : fields) {
            ArbilDataNode fieldParent = currentField.getParentDataNode();
            if (!selectedFieldHashtable.containsKey(fieldParent)) {
                selectedFieldHashtable.put(fieldParent, new ArrayList());
            }
            List fieldParentList = (List)selectedFieldHashtable.get(fieldParent);
            fieldParentList.add(currentField.getFullXmlPath());
        }
        return selectedFieldHashtable;
    }

    @Override
    public void copySelectedCellToColumn(ArbilTable table) {
        try {
            String messageString = MessageFormat.format(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("ABOUT TO REPLACE ALL VALUES IN COLUMN {0} WITH THE VALUE {1}(<MULTIPLE VALUES> WILL NOT BE AFFECTED)"), table.getArbilTableModel().getColumnName(table.getSelectedColumn()), table.getArbilTableModel().getValueAt(table.getSelectedRow(), table.getSelectedColumn()));
            if (!(table.getArbilTableModel().getTableCellContentAt(table.getSelectedRow(), table.getSelectedColumn()) instanceof ArbilField)) {
                this.dialogHandler.addMessageDialogToQueue(ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("CANNOT COPY THIS TYPE OF FIELD"), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COPY CELL TO WHOLE COLUMN"));
            } else if (0 == JOptionPane.showConfirmDialog(this.windowManager.getMainFrame(), messageString, ResourceBundle.getBundle("nl/mpi/arbil/localisation/Menus").getString("COPY CELL TO WHOLE COLUMN"), 0, -1)) {
                table.getArbilTableModel().copyCellToColumn(table.getSelectedRow(), table.getSelectedColumn());
            }
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    @Override
    public void deleteNodes(ArbilTable table) {
        this.treeHelper.deleteNodes(table);
    }

    @Override
    public void jumpToSelectionInTree(ArbilTable table) {
        try {
            this.treeHelper.jumpToSelectionInTree(false, table.getDataNodeForSelection());
        }
        catch (Exception ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
    }

    @Override
    public void showContextForSelectedNodes(ArbilTable table) {
        HashSet<ArbilDataNode> parentNodes = new HashSet<ArbilDataNode>();
        for (ArbilField selectedField : table.getSelectedFields()) {
            parentNodes.add(selectedField.getParentDataNode().getParentDomNode());
        }
        this.windowManager.openFloatingSubnodesWindows(parentNodes.toArray(new ArbilDataNode[0]));
    }

    @Override
    public void highlightMatchingRows(ArbilTable table) {
        ArbilTableModel tableModel = table.getArbilTableModel();
        int selectedRow = table.getSelectedRow();
        if (selectedRow == -1) {
            this.dialogHandler.addMessageDialogToQueue(widgets.getString("NO ROWS HAVE BEEN SELECTED"), widgets.getString("HIGHLIGHT MATCHING ROWS"));
            return;
        }
        List<Integer> foundRows = tableModel.getMatchingRows(selectedRow);
        table.getSelectionModel().setSelectionMode(2);
        table.getSelectionModel().clearSelection();
        this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("FOUND %D MATCHING ROWS"), foundRows.size()), ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets").getString("HIGHLIGHT MATCHING ROWS"));
        for (int foundCount = 0; foundCount < foundRows.size(); ++foundCount) {
            for (int coloumCount = 0; coloumCount < table.getColumnCount(); ++coloumCount) {
                table.getSelectionModel().addSelectionInterval(foundRows.get(foundCount), foundRows.get(foundCount));
            }
        }
    }

    @Override
    public void startLongFieldEditorForSelectedFields(ArbilTable table) {
        ArbilTableModel tableModel = table.getArbilTableModel();
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length > 0) {
            int[] selectedCols;
            if (table.getCellSelectionEnabled()) {
                selectedCols = table.getSelectedColumns();
            } else {
                selectedCols = new int[table.getColumnCount()];
                for (int colCounter = 0; colCounter < selectedCols.length; ++colCounter) {
                    selectedCols[colCounter] = colCounter;
                }
            }
            for (int currentRow : selectedRows) {
                if (tableModel.isHorizontalView() && table.getSelectionModel().getSelectionMode() == 2 && table.getSelectedColumnCount() > 0) {
                    ArbilDataNode node;
                    Object currentCellValue = table.getTableCellContentAt(currentRow, table.getSelectedColumns()[0]);
                    if (!(currentCellValue instanceof ArbilDataNode) || (node = (ArbilDataNode)currentCellValue).getFields().size() <= 0) continue;
                    List<ArbilField[]> fieldArrays = node.getFieldsSorted();
                    new ArbilLongFieldEditor(table).showEditor(fieldArrays.get(0), fieldArrays.get(0)[0].getFieldValue(), 0);
                    continue;
                }
                for (int currentCol : selectedCols) {
                    Object currentCellValue = table.getTableCellContentAt(currentRow, currentCol);
                    if (!(currentCellValue instanceof ArbilField) && !(currentCellValue instanceof ArbilField[])) continue;
                    new ArbilTableCellEditor(this).startLongfieldEditor(table, table.getTableCellAt(currentRow, currentCol), false, currentRow, currentCol);
                }
            }
        }
    }

    @Override
    public synchronized void addFieldFromPlaceholder(ArbilTable table, int selectedFieldIndex, ArbilFieldPlaceHolder placeholder) {
        ArbilTableModel tableModel = table.getArbilTableModel();
        ArbilDataNode dataNode = placeholder.getArbilDataNode();
        if (dataNode.isEditable()) {
            MetadataBuilder metadataBuilder = new MetadataBuilder();
            ArbilField columnField = tableModel.getColumnField(selectedFieldIndex);
            String xmlPath = columnField.getGenericFullXmlPath();
            boolean canContainField = metadataBuilder.canAddChildNode(dataNode, xmlPath);
            if (canContainField) {
                if (this.dialogHandler.showConfirmDialogBox(MessageFormat.format(widgets.getString("INSERT A NEW FIELD CONFIRM"), columnField.getTranslateFieldName(), dataNode.toString()), widgets.getString("INSERT FIELD"))) {
                    try {
                        this.addChildNodeForFieldFromPlaceholder(metadataBuilder, dataNode, columnField, xmlPath);
                    }
                    catch (ArbilMetadataException mdEx) {
                        logger.error("Error while trying to create field", (Throwable)mdEx);
                        this.dialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT CREATE FIELD. SEE ERROR LOG FOR DETAILS."), widgets.getString("ERROR"));
                    }
                }
            } else {
                this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("THE NODE '%S' CANNOT CONTAIN A FIELD OF THE SAME TYPE AS '%S' IN '%S'"), dataNode.toString(), columnField.getTranslateFieldName(), columnField.getParentDataNode().toString()), widgets.getString("INSERT FIELD"));
            }
        } else {
            logger.debug("Data node {} is not editable. Will not attempt to instantiate greyed out field", (Object)dataNode);
        }
    }

    private void addChildNodeForFieldFromPlaceholder(MetadataBuilder metadataBuilder, ArbilDataNode dataNode, final ArbilField columnField, String xmlPath) throws ArbilMetadataException {
        URI resultURI = metadataBuilder.addChildNode(dataNode, xmlPath, dataNode.getURIFragment(), null, null, new NodeCreationCallback(){

            public void nodeCreated(ArbilDataNode reloadedDataNode, URI nodeURI) {
                logger.debug("Field created from placeholder");
                try {
                    ArbilTableController.this.processAddedFieldFromPlaceholder(reloadedDataNode, nodeURI, columnField);
                }
                catch (ArbilMetadataException mdEx) {
                    logger.error(widgets.getString("ERROR WHILE SETTING ATTRIBUTES ON FIELD"), (Throwable)mdEx);
                    ArbilTableController.this.dialogHandler.addMessageDialogToQueue(widgets.getString("COULD NOT SET ATTRIBUTES FOR NEW FIELD. SEE ERROR LOG FOR DETAILS"), widgets.getString("ERROR"));
                }
                reloadedDataNode.saveChangesToCache(false);
                reloadedDataNode.reloadNode();
            }
        });
        if (resultURI == null) {
            throw new ArbilMetadataException("Field could not be created. See previous messages for details.");
        }
    }

    private void processAddedFieldFromPlaceholder(ArbilDataNode dataNode, URI nodeURI, ArbilField columnField) throws ArbilMetadataException {
        String keyName = columnField.getKeyName();
        String languageId = columnField.getLanguageId();
        if (keyName != null || languageId != null) {
            ArbilField field = this.getAddedField(dataNode, nodeURI);
            if (field == null) {
                throw new ArbilMetadataException(String.format("Field '%s' not found on data node '%s'", nodeURI.getFragment(), dataNode.toString()));
            }
            if (keyName != null) {
                field.setKeyName(keyName);
            }
            if (languageId != null) {
                field.setLanguageId(languageId);
            }
        }
    }

    private ArbilField getAddedField(ArbilDataNode dataNode, URI addedNodeUri) {
        if (dataNode.waitTillLoaded()) {
            String fieldPath = addedNodeUri.getFragment();
            Pattern pattern = Pattern.compile("^(.*?)(\\((\\d+)\\))?$");
            Matcher matcher = pattern.matcher(fieldPath);
            if (matcher.matches()) {
                String fieldPathBase = matcher.group(1);
                for (ArbilField[] fieldArray : dataNode.getFields().values()) {
                    ArbilField field = fieldArray[fieldArray.length - 1];
                    if (!field.getFullXmlPath().startsWith(fieldPathBase)) continue;
                    if (field.getFieldValue().length() > 0) {
                        logger.warn("Value for new field is not the empty string but {}. Possibly wrong field was selected?", (Object)field.getFieldValue());
                    }
                    return field;
                }
            }
        }
        return null;
    }

    @Override
    public void copySelectedTableRowsToClipBoard(ArbilTable table) {
        int[] selectedRows = table.getSelectedRows();
        if (selectedRows.length > 0) {
            logger.debug("coll select mode: {}", (Object)table.getColumnSelectionAllowed());
            logger.debug("cell select mode: {}", (Object)table.getCellSelectionEnabled());
            boolean allCellsSelected = table.getSelectedRowCount() == table.getRowCount() && table.getSelectedColumnCount() == table.getColumnCount();
            ArbilTableModel arbilTableModel = table.getArbilTableModel();
            if (table.getCellSelectionEnabled() && !allCellsSelected) {
                logger.debug("cell select mode");
                ArbilField[] selectedFields = table.getSelectedFields();
                if (selectedFields != null) {
                    arbilTableModel.copyArbilFields(selectedFields);
                }
            } else {
                logger.debug("row select mode");
                arbilTableModel.copyArbilRows(selectedRows);
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue(widgets.getString("NOTHING SELECTED TO COPY"), widgets.getString("TABLE COPY"));
        }
    }

    @Override
    public void pasteIntoSelectedTableRowsFromClipBoard(ArbilTable table) {
        ArbilField[] selectedFields = table.getSelectedFields();
        if (selectedFields != null) {
            String pasteResult = table.getArbilTableModel().pasteIntoArbilFields(selectedFields);
            if (pasteResult != null) {
                this.dialogHandler.addMessageDialogToQueue(pasteResult, widgets.getString("PASTE INTO TABLE"));
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue(widgets.getString("NO ROWS SELECTED"), widgets.getString("PASTE INTO TABLE"));
        }
    }

    @Override
    public void checkPopup(MouseEvent evt, boolean checkSelection) {
        ArbilTable table = this.getEventSourceAsArbilTable(evt);
        ArbilTableModel tableModel = table.getArbilTableModel();
        if (!tableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
            Point p = evt.getPoint();
            int clickedRow = table.rowAtPoint(p);
            int clickedColumn = table.columnAtPoint(p);
            boolean clickedRowAlreadySelected = table.isRowSelected(clickedRow);
            if (!(!checkSelection || evt.isShiftDown() || evt.isControlDown() || evt.isPopupTrigger() && clickedRowAlreadySelected || !(clickedRow > -1 & clickedRow > -1))) {
                table.getSelectionModel().clearSelection();
                table.changeSelection(clickedRow, clickedColumn, false, evt.isShiftDown());
            }
        }
        if (evt.isPopupTrigger()) {
            TableCellEditor tableCellEditor = table.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            new TableContextMenu(table, this).show(evt.getX(), evt.getY());
        }
    }

    private ArbilTable getEventSourceAsArbilTable(InputEvent event) {
        Container tableAncestor;
        Object source = event.getSource();
        if (source instanceof ArbilTable) {
            return (ArbilTable)source;
        }
        if (source instanceof JTableHeader) {
            JTable table = ((JTableHeader)source).getTable();
            if (table instanceof ArbilTable) {
                return (ArbilTable)table;
            }
            logger.warn("InputEvent coming from header of a JTable that is not an ArbilTable");
        }
        if (source instanceof Component && (tableAncestor = SwingUtilities.getAncestorOfClass(ArbilTable.class, (Component)source)) != null) {
            return (ArbilTable)tableAncestor;
        }
        logger.warn("Could not find ArbilTable associated with InputEvent source {}", source);
        throw new RuntimeException("Cannot find ArbilTable in component hierarchy from event");
    }

    private class DeleteRowAction
    extends AbstractAction {
        private DeleteRowAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ArbilTableController.this.treeHelper.deleteNodes(e.getSource());
        }
    }

    private class TableHeaderMouseListener
    extends MouseAdapter {
        private TableHeaderMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            this.checkTableHeaderPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.checkTableHeaderPopup(evt);
        }

        public void mouseClicked(MouseEvent evt) {
            ArbilTable table = ArbilTableController.this.getEventSourceAsArbilTable(evt);
            ArbilTableModel tableModel = table.getArbilTableModel();
            if (evt.getButton() == 1) {
                tableModel.sortByColumn(table.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY()))));
                table.getTableHeader().revalidate();
            }
            this.checkTableHeaderPopup(evt);
        }

        private void checkTableHeaderPopup(MouseEvent evt) {
            ArbilTable table = ArbilTableController.this.getEventSourceAsArbilTable(evt);
            ArbilTableModel tableModel = table.getArbilTableModel();
            if (!tableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
                int targetColumn = table.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY())));
                logger.debug(widgets.getString("SHOWING HEADER MENU FOR COLUMN {}"), (Object)targetColumn);
                TableHeaderContextMenu popupMenu = new TableHeaderContextMenu(ArbilTableController.this, table, targetColumn);
                popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        public void mousePressed(MouseEvent evt) {
            ArbilTableController.this.checkPopup(evt, true);
        }

        public void mouseReleased(MouseEvent evt) {
            ArbilTableController.this.checkPopup(evt, true);
        }
    }
}

