/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.corpusstructure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import nl.mpi.corpusstructure.AccessCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessInfo {
    protected static final Logger logger = LoggerFactory.getLogger(AccessInfo.class);
    protected static final String GROUPS = "accessgroups";
    public static final String EVERYBODY = "everybody";
    public static final String NOBODY = "nobody";
    public static final String CLEARED = "cleared";
    public static final String ALL_AUTH = "anyAuthenticatedUser";
    public static final String IGNORE = "ignore";
    public static final int ACCESS_LEVEL_NONE = -1;
    public static final int ACCESS_LEVEL_OPEN_EVERYBODY = 1;
    public static final int ACCESS_LEVEL_OPEN_REGISTERED_USERS = 2;
    public static final int ACCESS_LEVEL_PERMISSION_NEEDED = 3;
    public static final int ACCESS_LEVEL_CLOSED = 4;
    public static final int ACCESS_LEVEL_EXTERNAL = 5;
    public static final int ACCESS_LEVEL_SCIENTIFIC = 6;
    private static Pattern validUserPattern = null;
    private String readRights;
    private String writeRights;
    private int accessLevel = -1;

    public static AccessInfo create(String readRights, String writeRights) {
        return AccessInfo.create(readRights, writeRights, -1);
    }

    public static AccessInfo create(String readRights, String writeRights, int accessLevel) {
        AccessInfo aInfo = new AccessInfo();
        aInfo.setReadRule(readRights);
        aInfo.setWriteRule(writeRights);
        aInfo.setAccessLevel(accessLevel);
        return aInfo;
    }

    protected static AccessInfo createFromDatabaseInfo(String readRights, String writeRights, int accessLevel) {
        AccessInfo aInfo = new AccessInfo();
        if (aInfo.isValidConstant(readRights)) {
            aInfo.setReadRule(readRights);
        } else {
            aInfo.setReadUsers(readRights);
        }
        if (aInfo.isValidConstant(writeRights)) {
            aInfo.setWriteRule(writeRights);
        } else {
            aInfo.setWriteUsers(writeRights);
        }
        aInfo.setAccessLevel(accessLevel);
        return aInfo;
    }

    protected AccessInfo() {
    }

    public String toString() {
        StringBuilder result = new StringBuilder("accessInfo:");
        result.append(" readRights: ").append(this.getReadRights());
        result.append(" writeRights: ").append(this.getWriteRights());
        result.append(" accessLevel: ").append(this.getAccessLevel());
        return result.toString();
    }

    protected boolean isValidConstant(String rights) {
        if (rights == null) {
            return false;
        }
        return EVERYBODY.equals(rights) || NOBODY.equals(rights) || ALL_AUTH.equals(rights) || CLEARED.equals(rights);
    }

    private List<String> convertToUserList(String rights) {
        ArrayList<String> usersList = new ArrayList<String>();
        if (rights != null) {
            StringTokenizer tokenizer = new StringTokenizer(rights, " ");
            while (tokenizer.hasMoreTokens()) {
                usersList.add(tokenizer.nextToken());
            }
        }
        return usersList;
    }

    public boolean hasReadAccess(String username) {
        return AccessCheck.checkRights(username, this.readRights);
    }

    public boolean hasWriteAccess(String username) {
        return AccessCheck.checkRights(username, this.writeRights);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AccessInfo otherAI = (AccessInfo)other;
        if (this.getAccessLevel() != otherAI.getAccessLevel()) {
            return false;
        }
        if (this.getWriteRights() == null || !this.getWriteRights().equals(otherAI.getWriteRights())) {
            return false;
        }
        return this.getReadRights() != null && this.getReadRights().equals(otherAI.getReadRights());
    }

    public int hashCode() {
        if (this.getReadRights() == null || this.getWriteRights() == null) {
            return -1;
        }
        return this.getAccessLevel() ^ this.getReadRights().hashCode() ^ this.getWriteRights().hashCode();
    }

    public String getReadRights() {
        return this.readRights;
    }

    public void setReadRule(String privs) {
        if (privs == null || privs.trim().length() < 1) {
            logger.warn("Readrights must not be empty - assuming NOBODY");
            privs = NOBODY;
        }
        if (!this.isValidConstant(privs)) {
            throw new IllegalArgumentException("Readrights must be a valid AccessInfo constant");
        }
        this.readRights = privs;
    }

    protected void setReadUsers(String users) {
        this.setReadUsers(this.convertToUserList(users));
    }

    public void setReadUsers(List users) {
        if (users == null || users.size() < 1) {
            throw new IllegalArgumentException("Readrights user list must not be empty");
        }
        Iterator iter = users.iterator();
        StringBuilder sb = new StringBuilder(users.size() * 31 + 1);
        sb.append(" ");
        if (validUserPattern == null) {
            validUserPattern = Pattern.compile("^[a-zA-Z0-9_.,;:-][a-zA-Z0-9_@.,;:-]*$");
        }
        while (iter.hasNext()) {
            String user = (String)iter.next();
            if (!validUserPattern.matcher(user).matches()) {
                throw new IllegalArgumentException("Readrights user contains illegal chars: " + user);
            }
            sb.append(user).append(" ");
        }
        this.readRights = sb.toString();
    }

    public String getWriteRights() {
        return this.writeRights;
    }

    public void setWriteRule(String privs) {
        if (privs == null || privs.trim().length() < 1) {
            logger.warn("Writerights must not be empty - assuming NOBODY");
            privs = NOBODY;
        }
        if (!this.isValidConstant(privs)) {
            throw new IllegalArgumentException("Writerights must be a valid AccessInfo constant");
        }
        this.writeRights = privs;
    }

    protected void setWriteUsers(String users) {
        this.setWriteUsers(this.convertToUserList(users));
    }

    public void setWriteUsers(List users) {
        if (users == null || users.size() < 1) {
            throw new IllegalArgumentException("Writerights user list must not be empty");
        }
        Iterator iter = users.iterator();
        StringBuilder sb = new StringBuilder(users.size() * 30);
        sb.append(" ");
        if (validUserPattern == null) {
            validUserPattern = Pattern.compile("^[a-zA-Z0-9_.,;:-][a-zA-Z0-9_@.,;:-]*$");
        }
        while (iter.hasNext()) {
            String user = (String)iter.next();
            if (!validUserPattern.matcher(user).matches()) {
                throw new IllegalArgumentException("Writerights user contains illegal chars: " + user);
            }
            sb.append(user).append(" ");
        }
        this.writeRights = sb.toString();
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    public void setAccessLevel(int accessLevel) {
        this.accessLevel = accessLevel;
    }
}

