/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.Date;
import java.util.Hashtable;

public class HTTPCookie {
    private Hashtable cookies = new Hashtable();

    public boolean containsCookie(String cookie) {
        return this.cookies.containsKey(cookie);
    }

    public String getCookieVal(String cookie) {
        Cookie c = (Cookie)this.cookies.get(cookie);
        if (c == null) {
            return null;
        }
        return c.value;
    }

    public void clear() {
        this.cookies.clear();
    }

    public void parseRequestHeader(String cookieHdr) {
        PushbackReader rdr = new PushbackReader(new StringReader(cookieHdr));
        try {
            while (true) {
                KeyValuePair kvp;
                if ((kvp = this.readPair(rdr)) == null) {
                    return;
                }
                this.cookies.put(kvp.key, new Cookie(kvp.key, kvp.val));
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing cookie: " + e);
            e.printStackTrace(System.err);
            return;
        }
    }

    private final void encodeString(String val, StringBuffer sb) {
        sb.append('\"');
        if (val != null) {
            block6: for (int i = 0; i < val.length(); ++i) {
                char ch = val.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block6;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block6;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block6;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block6;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
        }
        sb.append('\"');
    }

    private KeyValuePair readPair(PushbackReader rdr) throws IOException {
        String nm = HTTPCookie.readToken(rdr);
        if (nm == null) {
            return null;
        }
        String equalsSign = HTTPCookie.readToken(rdr);
        if (equalsSign == null) {
            return new KeyValuePair(nm, null);
        }
        if (!equalsSign.equals("=")) {
            return new KeyValuePair(nm, equalsSign);
        }
        String val = HTTPCookie.readToken(rdr);
        return new KeyValuePair(nm, val);
    }

    private static final String readToken(PushbackReader rdr) throws IOException {
        StringBuffer sb = new StringBuffer();
        int ich = 32;
        while (ich >= 0 && Character.isWhitespace((char)ich)) {
            ich = rdr.read();
        }
        if (ich < 0) {
            return null;
        }
        rdr.unread(ich);
        while (true) {
            if ((ich = rdr.read()) < 0) {
                if (sb.length() > 0) {
                    return sb.toString();
                }
                return null;
            }
            switch (ich) {
                case 59: {
                    if (sb.length() > 0) {
                        return sb.toString();
                    }
                    return String.valueOf((char)ich);
                }
                case 61: {
                    if (sb.length() > 0) {
                        rdr.unread(ich);
                        return sb.toString();
                    }
                    return String.valueOf((char)ich);
                }
                case 34: {
                    if (sb.length() > 0) {
                        return sb.toString();
                    }
                    return HTTPCookie.readRestOfString(rdr);
                }
            }
            if (Character.isWhitespace((char)ich)) {
                return sb.toString();
            }
            sb.append((char)ich);
        }
    }

    private static final String readRestOfString(PushbackReader rdr) throws IOException {
        StringBuffer sb = new StringBuffer();
        int ich;
        block9: while ((ich = rdr.read()) >= 0) {
            switch (ich) {
                case 92: {
                    ich = rdr.read();
                    if (ich < 0) {
                        return sb.toString();
                    }
                    switch (ich) {
                        case 110: {
                            sb.append('\n');
                            continue block9;
                        }
                        case 116: {
                            sb.append('\t');
                            continue block9;
                        }
                        case 114: {
                            sb.append('\r');
                            continue block9;
                        }
                    }
                    sb.append((char)ich);
                    continue block9;
                }
                case 34: {
                    return sb.toString();
                }
            }
            sb.append((char)ich);
        }
        return sb.toString();
    }

    private class KeyValuePair {
        String key = "";
        String val = "";

        KeyValuePair(String k, String v) {
            this.key = k;
            this.val = v;
        }

        public String toString() {
            return this.key + "=" + this.val;
        }
    }

    private class Cookie {
        String name = null;
        String value = null;
        String domain = null;
        Date expires = null;

        Cookie(String nm, String val) {
            this.name = nm;
            this.value = val;
        }
    }
}

