/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnection {
    private static Logger logger = LoggerFactory.getLogger(DBConnection.class);
    public static final int POSTGRESQL = 1;
    public static final int HSQLDB = 2;
    protected Connection connection = null;
    protected String message = "";
    protected String origin = "";
    protected Date openDate = null;
    protected boolean status = false;
    protected boolean closed = false;
    private static AtomicInteger n = new AtomicInteger(-1);
    private final int thisN = n.incrementAndGet();
    private String dbName = null;
    public int dbType = 0;
    public final String tableType;
    public final String boolType = "BOOLEAN";

    private void initSQLparams(String name) {
        if (name.indexOf("hsqldb") != -1) {
            this.dbName = this.dbName + " : HSQLDB";
            this.dbType = 2;
        } else {
            this.dbType = 1;
            this.dbName = this.dbName + " : POSTGRESQL";
        }
    }

    public DBConnection(String dbname) {
        this(dbname, null, null, null);
    }

    public DBConnection(String dbname, String origin) {
        this(dbname, null, null, origin);
    }

    public DBConnection(String dbname, String user, String passwd) {
        this(dbname, user, passwd, null);
    }

    public DBConnection(String dbname, String user, String passwd, String origin) {
        logger.trace("Opening of {} connection {} requested", (Object)dbname, (Object)this.thisN);
        this.origin = origin;
        this.dbName = dbname;
        this.openDate = new Date();
        if (dbname.startsWith("java:")) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(dbname);
                if (ds == null) {
                    logger.info("DBConnection:constr: No DataSource? " + dbname);
                    throw new RuntimeException("No DataSource: " + dbname);
                }
                try {
                    this.connection = ds.getConnection();
                    String dburl = this.connection.getMetaData().getURL();
                    logger.debug("DBConnection:constr: user: " + user + " JDNI DB name: " + dbname + " JDBC URL=" + dburl + " why: " + origin + " opened: " + this.openDate.getTime());
                    this.dbName = this.dbName + " -> " + dburl;
                    this.tableType = dburl.indexOf("hsqldb") != -1 ? "CACHED" : "";
                    this.initSQLparams(dburl);
                    this.status = true;
                }
                catch (SQLException sqle) {
                    logger.error("DBConnection:constr: SQL error for {} [{}] Error creating connection maybe driver missing?", new Object[]{dbname, this.thisN, sqle});
                    this.message = this.message + "DBConnection:constr: SQL error for " + dbname + "[" + this.thisN + "] Error creating connection, maybe driver missing?: " + sqle;
                    throw new RuntimeException(sqle);
                }
                catch (Exception e) {
                    logger.error("DBConnection:constr: Exception for {} [{}] Unexpected error", new Object[]{dbname, this.thisN, e});
                    this.message = this.message + "DBConnection:constr: Exception for " + dbname + "[" + this.thisN + "]\n" + e;
                    throw new RuntimeException(e);
                }
            }
            catch (RuntimeException e) {
                logger.error("DBConnection:constr: RuntimeException", (Throwable)e);
                throw e;
            }
            catch (NamingException e) {
                logger.error("DBConnection:constr: NamingException", (Throwable)e);
                throw new RuntimeException(e);
            }
            return;
        }
        logger.debug("DBConnection:constr: user: " + user + " JDBC URL: " + dbname + " why: " + origin + " opened: " + this.openDate.getTime());
        this.initSQLparams(dbname);
        String string = this.tableType = dbname.startsWith("jdbc:hsqldb") ? "CACHED" : "";
        if (dbname.startsWith("jdbc:hsqldb")) {
            if (user == null) {
                user = "sa";
            }
            if (passwd == null) {
                passwd = "";
            }
            try {
                Class<?> cl = Class.forName("org.hsqldb.jdbcDriver");
            }
            catch (ClassNotFoundException e) {
                logger.error("DBConnection:constr: driver not found: org.hsqldb.jdbcDriver");
                this.status = false;
                return;
            }
            try {
                this.connection = DriverManager.getConnection(dbname, user, passwd);
                this.status = true;
            }
            catch (Exception e) {
                logger.error("DBConnection:constr: HSQLDB connection create failed, error: " + e);
                this.status = false;
                return;
            }
        }
        if (dbname.startsWith("jdbc:postgresql")) {
            if (user == null) {
                user = "imdiArchive";
            }
            if (passwd == null) {
                passwd = "";
            }
            try {
                Class<?> cl = Class.forName("org.postgresql.Driver");
            }
            catch (ClassNotFoundException e) {
                logger.error("DBConnection:constr: driver not found: org.postgresql.Driver");
                this.status = false;
                return;
            }
            try {
                this.connection = DriverManager.getConnection(dbname, user, passwd);
                this.status = true;
            }
            catch (Exception e) {
                logger.error("DBConnection:constr: connection create failed for " + dbname + " error: " + e, (Throwable)e);
                this.status = false;
                return;
            }
        }
        logger.error("DBConnection:constr: Invalid DB specification: " + dbname, (Throwable)new Exception("tracing"));
        this.status = false;
        return;
    }

    public synchronized void close() {
        logger.trace("Closing of {} connection {} requested", (Object)this.dbName, (Object)this.thisN);
        try {
            if (this.connection != null) {
                this.connection.close();
                logger.debug("DBConnection:free: {} [{}] closed. why: {} opened: {}", new Object[]{this.dbName, this.thisN, this.origin, this.openDate.getTime()});
            } else {
                logger.warn("DBConnection:free: {} [{}] closed. why: {} opened: {}", new Object[]{this.dbName, this.thisN, this.origin, this.openDate.getTime()});
            }
        }
        catch (SQLException sqle) {
            logger.error("DBConnection:free: {} [{}]", new Object[]{this.dbName, this.thisN, sqle});
        }
        catch (Exception e) {
            logger.error("DBConnection:free: {} [{}]", new Object[]{this.dbName, this.thisN, e});
        }
        this.closed = true;
        this.connection = null;
        this.status = false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean getStatus() {
        block5: {
            try {
                if (this.closed) {
                    logger.warn("DBConnection:getStatus: connection closed by user: {} [{}]", (Object)this.dbName, (Object)this.thisN);
                    break block5;
                }
                if (this.connection == null) {
                    logger.warn("DBConnection:getStatus: connection was not created: {} [{}]", (Object)this.dbName, (Object)this.thisN);
                    break block5;
                }
                if (this.connection.isClosed()) {
                    logger.warn("DBConnection:getStatus: connection was closed by system: {} [{}]", (Object)this.dbName, (Object)this.thisN);
                    break block5;
                }
                return true;
            }
            catch (SQLException sqle) {
                logger.error("DBConnection: {} [{}]", new Object[]{this.dbName, this.thisN, sqle});
            }
        }
        this.status = false;
        return this.status;
    }

    public String toString() {
        return this.dbName;
    }

    public String getMessage() {
        return this.message;
    }
}

