/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import nl.mpi.metadata.api.MetadataAPI;
import nl.mpi.metadata.api.MetadataElementException;
import nl.mpi.metadata.api.MetadataException;
import nl.mpi.metadata.api.MetadataTypeException;
import nl.mpi.metadata.api.dom.DomBuildingMode;
import nl.mpi.metadata.api.dom.MetadataDocumentReader;
import nl.mpi.metadata.api.dom.MetadataDocumentWriter;
import nl.mpi.metadata.api.model.MetadataElement;
import nl.mpi.metadata.api.model.MetadataElementAttributeContainer;
import nl.mpi.metadata.api.type.MetadataDocumentTypeReader;
import nl.mpi.metadata.api.type.MetadataElementType;
import nl.mpi.metadata.api.validation.MetadataValidator;
import nl.mpi.metadata.cmdi.api.dom.CMDIApiDOMBuilderFactory;
import nl.mpi.metadata.cmdi.api.dom.CMDIComponentReader;
import nl.mpi.metadata.cmdi.api.dom.CMDIDocumentReader;
import nl.mpi.metadata.cmdi.api.dom.CMDIDocumentWriter;
import nl.mpi.metadata.cmdi.api.dom.CMDIDomBuilder;
import nl.mpi.metadata.cmdi.api.dom.CMDIResourceProxyReader;
import nl.mpi.metadata.cmdi.api.dom.DOMBuilderFactory;
import nl.mpi.metadata.cmdi.api.model.Attribute;
import nl.mpi.metadata.cmdi.api.model.CMDIContainerMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIDocument;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElement;
import nl.mpi.metadata.cmdi.api.model.CMDIMetadataElementFactory;
import nl.mpi.metadata.cmdi.api.model.impl.CMDIMetadataElementFactoryImpl;
import nl.mpi.metadata.cmdi.api.type.CMDIAttributeType;
import nl.mpi.metadata.cmdi.api.type.CMDIProfile;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileContainer;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileElement;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIProfileContainerImpl;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIProfileReader;
import nl.mpi.metadata.cmdi.api.validation.DefaultCMDIValidator;
import nl.mpi.metadata.cmdi.util.CMDIEntityResolver;
import org.apache.xmlbeans.XmlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class CMDIApi
implements MetadataAPI<CMDIProfile, CMDIProfileElement, CMDIAttributeType, Attribute, CMDIContainerMetadataElement, CMDIDocument> {
    private static final Logger logger = LoggerFactory.getLogger(CMDIApi.class);
    private final EntityResolver entityResolver;
    private final MetadataDocumentReader<CMDIDocument> documentReader;
    private final MetadataDocumentWriter<CMDIDocument> documentWriter;
    private final MetadataDocumentTypeReader<CMDIProfile> profileReader;
    private final MetadataValidator<CMDIDocument> cmdiValidator;
    private final CMDIMetadataElementFactory metadataElementFactory;
    private final CMDIProfileContainer profileContainer;
    private final DOMBuilderFactory domBuilderFactory;
    private final CMDIDomBuilder componentBuilder;

    public CMDIApi() {
        this(new CMDIEntityResolver(), new DefaultCMDIValidator(), new CMDIMetadataElementFactoryImpl());
    }

    public CMDIApi(EntityResolver entityResolver, MetadataValidator<CMDIDocument> cmdiValidator, CMDIMetadataElementFactory elementFactory) {
        this.entityResolver = entityResolver;
        this.cmdiValidator = cmdiValidator;
        this.metadataElementFactory = elementFactory;
        this.domBuilderFactory = new CMDIApiDOMBuilderFactory(entityResolver);
        this.componentBuilder = new CMDIDomBuilder(entityResolver, this.domBuilderFactory);
        this.documentWriter = new CMDIDocumentWriter(this.componentBuilder);
        this.profileReader = new CMDIProfileReader(entityResolver, this.domBuilderFactory);
        this.profileContainer = new CMDIProfileContainerImpl(this.profileReader);
        this.documentReader = new CMDIDocumentReader(this.profileContainer, new CMDIComponentReader(elementFactory), new CMDIResourceProxyReader());
    }

    public CMDIApi(MetadataDocumentReader<CMDIDocument> documentReader, MetadataDocumentWriter<CMDIDocument> documentWriter, MetadataDocumentTypeReader<CMDIProfile> profileReader, MetadataValidator<CMDIDocument> cmdiValidator, EntityResolver entityResolver, CMDIMetadataElementFactory elementFactory) {
        this.entityResolver = entityResolver;
        this.cmdiValidator = cmdiValidator;
        this.metadataElementFactory = elementFactory;
        this.documentWriter = documentWriter;
        this.profileReader = profileReader;
        this.documentReader = documentReader;
        this.domBuilderFactory = new CMDIApiDOMBuilderFactory(entityResolver);
        this.componentBuilder = new CMDIDomBuilder(entityResolver, this.domBuilderFactory);
        this.profileContainer = new CMDIProfileContainerImpl(profileReader);
    }

    @Override
    public void validateMetadataDocument(CMDIDocument document, ErrorHandler errorHandler) throws SAXException {
        this.getCmdiValidator().validateMetadataDocument(document, errorHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CMDIDocument getMetadataDocument(URL url) throws IOException, MetadataException {
        logger.debug("Opening stream for {}", (Object)url);
        URLConnection openConnection = url.openConnection();
        InputStream documentStream = this.openConnectionCheckRedirects(openConnection);
        try {
            CMDIDocument cMDIDocument = this.getMetadataDocument(url, documentStream);
            return cMDIDocument;
        }
        finally {
            logger.debug("Closing stream for {}", (Object)url);
            documentStream.close();
        }
    }

    @Override
    public CMDIDocument getMetadataDocument(URL url, InputStream documentStream) throws IOException, MetadataException {
        try {
            logger.debug("Reading DOM for {}", (Object)url);
            Document document = this.domBuilderFactory.newDOMBuilder().parse(documentStream, url.toExternalForm());
            logger.debug("Reading contents of {}", (Object)url);
            return this.getDocumentReader().read(document, url.toURI());
        }
        catch (SAXException saxEx) {
            throw new MetadataException("SAXException while building document from " + url, saxEx);
        }
        catch (URISyntaxException usEx) {
            throw new RuntimeException("URISyntaxException while building document from " + url, usEx);
        }
    }

    public CMDIDocument createMetadataDocument(CMDIProfile type) throws MetadataException, MetadataTypeException {
        return this.createMetadataDocument(type, DomBuildingMode.MANDATORY);
    }

    public CMDIDocument createMetadataDocument(CMDIProfile type, DomBuildingMode buildingMode) throws MetadataException, MetadataTypeException {
        Document document;
        try {
            document = this.componentBuilder.createDomFromSchema(type.getSchemaLocation(), buildingMode);
        }
        catch (FileNotFoundException ex) {
            throw new MetadataTypeException((MetadataElementType)type, (Throwable)ex);
        }
        catch (XmlException ex) {
            throw new MetadataTypeException((MetadataElementType)type, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new MetadataTypeException((MetadataElementType)type, (Throwable)ex);
        }
        try {
            return this.documentReader.read(document, null);
        }
        catch (IOException ex) {
            throw new MetadataException("I/O exception while reading newly created metadata document. Most likely the profile schema is not readable. See the inner exception for details.", ex);
        }
    }

    @Override
    public CMDIProfile getMetadataDocumentType(URI uri) throws IOException, MetadataException {
        return this.getProfileContainer().getProfile(uri);
    }

    @Override
    public void writeMetadataDocument(CMDIDocument document, StreamResult target) throws IOException, MetadataException, TransformerException {
        this.getDocumentWriter().write(document, target);
    }

    public CMDIMetadataElement insertMetadataElement(CMDIContainerMetadataElement container, CMDIProfileElement elementType) throws MetadataException {
        if (!container.getType().canContainType(elementType)) {
            throw new MetadataElementException((MetadataElement)container, String.format("Element type %1$s cannot be contained by provided container type %2$s", elementType, container.getType()));
        }
        CMDIMetadataElement newMetadataElement = this.metadataElementFactory.createNewMetadataElement(container, elementType);
        if (container.addChildElement(newMetadataElement)) {
            return newMetadataElement;
        }
        return null;
    }

    public Attribute insertAttribute(MetadataElementAttributeContainer<Attribute> container, CMDIAttributeType attributeType) throws MetadataException {
        if (!(container instanceof CMDIMetadataElement)) {
            throw new MetadataException(String.format("Cannot handle container of type %1$s" + container.getClass(), new Object[0]));
        }
        CMDIMetadataElement containerElement = (CMDIMetadataElement)container;
        if (!containerElement.getType().getAttributes().contains(attributeType)) {
            throw new MetadataElementException((MetadataElement)containerElement, String.format("Attribute type %1$s cannot be contained by provided element container type %2$s", attributeType, containerElement.getType()));
        }
        Attribute attribute = this.metadataElementFactory.createAttribute(containerElement, attributeType);
        if (container.addAttribute(attribute)) {
            return attribute;
        }
        return null;
    }

    private InputStream openConnectionCheckRedirects(URLConnection c) throws IOException, SecurityException {
        return this.openConnectionCheckRedirects(c, 5);
    }

    private InputStream openConnectionCheckRedirects(URLConnection c, int maxRedirects) throws IOException, SecurityException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null) {
                throw new SecurityException("illegal URL redirect");
            }
            if (!target.getProtocol().equals("http") && !target.getProtocol().equals("https")) {
                throw new SecurityException("illegal URL redirect: unsupported protocol (" + target.getProtocol() + ")");
            }
            if (redirects >= maxRedirects) {
                throw new SecurityException("illegal URL redirect: exceeded redirect limit (" + maxRedirects + ")");
            }
            if (c.getURL().getProtocol().equals("https") && target.getProtocol().equalsIgnoreCase("http")) {
                throw new SecurityException("illegal URL redirect: HTTPS --> HTTP");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }

    public MetadataDocumentReader<CMDIDocument> getDocumentReader() {
        return this.documentReader;
    }

    public MetadataDocumentWriter<CMDIDocument> getDocumentWriter() {
        return this.documentWriter;
    }

    public MetadataDocumentTypeReader<CMDIProfile> getProfileReader() {
        return this.profileReader;
    }

    public MetadataValidator<CMDIDocument> getCmdiValidator() {
        return this.cmdiValidator;
    }

    protected EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public CMDIProfileContainer getProfileContainer() {
        return this.profileContainer;
    }
}

