/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.type.impl;

import java.util.Collection;
import java.util.HashSet;
import javax.xml.namespace.QName;
import nl.mpi.metadata.api.type.MetadataElementAttributeType;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileElement;
import nl.mpi.metadata.cmdi.api.type.datacategory.DataCategory;
import nl.mpi.metadata.cmdi.api.type.impl.ComponentTypeImpl;
import org.apache.xmlbeans.SchemaProperty;

public abstract class CMDIProfileElementImpl
implements CMDIProfileElement {
    protected final ComponentTypeImpl parent;
    protected final SchemaProperty schemaElement;
    protected final QName qName;
    protected String description;
    protected DataCategory dataCategory;
    private Collection<MetadataElementAttributeType> attributes;
    private Collection<MetadataElementAttributeType> excludedAttributes;

    protected CMDIProfileElementImpl(SchemaProperty schemaElement, ComponentTypeImpl parent) {
        this.parent = parent;
        this.schemaElement = schemaElement;
        this.qName = schemaElement.getName();
    }

    @Override
    public MetadataElementAttributeType getAttributeTypeByName(String namespaceURI, String name) {
        for (MetadataElementAttributeType child : this.getAllAttributes()) {
            if (namespaceURI != null && !namespaceURI.equals(child.getNamespaceURI()) || !child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    @Override
    public Collection<MetadataElementAttributeType> getAttributes() {
        return this.attributes;
    }

    @Override
    public Collection<MetadataElementAttributeType> getAllAttributes() {
        if (this.excludedAttributes == null || this.excludedAttributes.isEmpty()) {
            return this.attributes;
        }
        HashSet<MetadataElementAttributeType> result = new HashSet<MetadataElementAttributeType>(this.attributes.size() + this.excludedAttributes.size());
        result.addAll(this.attributes);
        result.addAll(this.excludedAttributes);
        return result;
    }

    @Override
    public DataCategory getDataCategory() {
        return this.dataCategory;
    }

    @Override
    public void setDataCategory(DataCategory dataCategory) {
        this.dataCategory = dataCategory;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public int getMaxOccurences() {
        if (this.getSchemaElement().getMaxOccurs() != null) {
            return this.getSchemaElement().getMaxOccurs().intValue();
        }
        return -1;
    }

    @Override
    public int getMinOccurences() {
        if (this.getSchemaElement().getMinOccurs() != null) {
            return this.getSchemaElement().getMinOccurs().intValue();
        }
        return 0;
    }

    @Override
    public String getName() {
        if (this.qName.getLocalPart() != null) {
            return this.qName.getLocalPart();
        }
        return this.qName.toString();
    }

    @Override
    public SchemaProperty getSchemaElement() {
        return this.schemaElement;
    }

    @Override
    public ComponentTypeImpl getParent() {
        return this.parent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMDIProfileElementImpl other = (CMDIProfileElementImpl)obj;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        return this.qName == other.qName || this.qName != null && this.qName.equals(other.qName);
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + (this.parent != null ? this.parent.hashCode() : 0);
        hash = 67 * hash + (this.qName != null ? this.qName.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.qName.getLocalPart();
    }

    @Override
    public void setAttributes(Collection<MetadataElementAttributeType> attributes) {
        this.attributes = attributes;
    }

    @Override
    public void setExcludedAttributes(Collection<MetadataElementAttributeType> excludedAttributes) {
        this.excludedAttributes = excludedAttributes;
    }
}

