/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.imdi.api;

import nl.mpi.corpusstructure.ArchiveObjectsDB;
import nl.mpi.corpusstructure.NodeIdUtils;
import nl.mpi.corpusstructure.UnknownNodeException;
import nl.mpi.imdi.api.IMDIElement;
import nl.mpi.util.OurURL;

public class IMDILink
extends IMDIElement {
    private static int accessContext = 1;
    private static ArchiveObjectsDB resolver = null;
    private static boolean linksUseHandles = true;
    private OurURL url;
    private String urid = null;
    private int nodeType;
    private String type = null;
    private String format = null;
    private String languageId = null;
    private String linkName = null;
    private String linkDefinition = null;

    public static void setResolver(ArchiveObjectsDB res, int context, boolean useHandles) {
        if (resolver != null) {
            resolver.close();
        }
        resolver = res;
        accessContext = context;
        linksUseHandles = useHandles;
        if (!useHandles && System.err != null) {
            System.err.println("WARNING: IMDI links should always use Handles, not raw Node ID!");
        }
    }

    public static boolean hasResolver() {
        return resolver != null && resolver.getStatus();
    }

    public IMDILink(String spec, String domId, int nodeType, OurURL url) {
        super(spec, domId);
        this.nodeType = nodeType;
        this.url = url;
    }

    public int getNodeType() {
        return this.nodeType;
    }

    public void setURID(String u) {
        this.urid = u;
    }

    public String getURID() {
        return this.urid;
    }

    public void setURL(OurURL u) {
        this.url = u;
    }

    public OurURL getURL() {
        if (this.url != null || this.urid == null) {
            return this.url;
        }
        if (IMDILink.hasResolver()) {
            try {
                if (!linksUseHandles) {
                    return resolver.getObjectURL(this.urid, accessContext);
                }
                String objectId = resolver.getObjectForPID(this.urid);
                if (objectId == null) {
                    System.err.println("Cannot resolve Handle: " + this.urid);
                    return null;
                }
                return resolver.getObjectURL(objectId, accessContext);
            }
            catch (UnknownNodeException une) {
                System.err.println("Cannot resolve URID: " + this.urid);
            }
        } else {
            System.err.println("No resolver to process URID: " + this.urid);
        }
        return null;
    }

    public OurURL getRawURL() {
        return this.url;
    }

    public boolean setURIDfromURL() {
        String myNodeId = null;
        if (!IMDILink.hasResolver() || this.url == null) {
            return false;
        }
        myNodeId = resolver.getObjectId(this.url);
        if (myNodeId == null) {
            return false;
        }
        if (!linksUseHandles) {
            this.urid = myNodeId;
            return true;
        }
        try {
            String knownURID = resolver.getObjectPID(myNodeId);
            if (knownURID == null) {
                knownURID = NodeIdUtils.nodeIdToHandle((String)myNodeId, (String)resolver.getArchiveRoots().getHandlePrefix());
            }
            knownURID = NodeIdUtils.standardizePID((String)knownURID);
            this.urid = NodeIdUtils.formatPIDForStorage((String)knownURID, (String)resolver.getArchiveRoots().getHandlePrefix());
            return true;
        }
        catch (UnknownNodeException une) {
            return false;
        }
    }

    public void setLinkName(String cLinkName) {
        this.linkName = cLinkName;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkDefinition(String linkDef) {
        this.linkDefinition = linkDef;
    }

    public String getLinkDefinition() {
        return this.linkDefinition;
    }

    public void setType(String t) {
        this.type = t;
    }

    public String getType() {
        return this.type;
    }

    public void setFormat(String f) {
        this.format = f;
    }

    public String getFormat() {
        return this.format;
    }

    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String l) {
        this.languageId = l;
    }
}

