/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core.handle;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import nl.mpi.archiving.corpusstructure.core.handle.HandleResolver;
import nl.mpi.archiving.corpusstructure.core.handle.InvalidHandleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingHandleResolver
implements HandleResolver {
    private static final Logger logger = LoggerFactory.getLogger(CachingHandleResolver.class);
    private final HandleResolver inner;
    private final LoadingCache<URI, URI> cache;

    public CachingHandleResolver(HandleResolver resolver, int expireTime) {
        logger.info("Results of the handle resolver [{}] will be cached for {} seconds", (Object)resolver, (Object)expireTime);
        this.inner = resolver;
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)expireTime, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<URI, URI>(){

            public URI load(URI uri) throws Exception {
                return CachingHandleResolver.this.inner.resolve(uri);
            }
        });
    }

    @Override
    public URI resolve(URI uri) throws InvalidHandleException {
        try {
            return (URI)this.cache.get((Object)uri);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof InvalidHandleException) {
                throw (InvalidHandleException)ex.getCause();
            }
            logger.error("Error while getting resolved handle from cache", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Error while getting resolved handle from cache", (Throwable)ex);
        }
        return this.inner.resolve(uri);
    }
}

