/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import nl.mpi.arbil.ui.ImportExportUI;
import nl.mpi.arbil.util.XsdChecker;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import nl.mpi.translation.tools.Translator;
import nl.mpi.translation.tools.TranslatorImpl;
import nl.mpi.translation.tools.UrlStreamResolver;
import nl.mpi.translation.tools.UrlStreamResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdiImdiExportConverter {
    private static final Logger logger = LoggerFactory.getLogger(CmdiImdiExportConverter.class);
    private final XsdChecker xsdChecker = new XsdChecker();
    private final File root;
    private final ImportExportUI ui;
    private final Translator translator;
    private String fatalError = null;
    private int fileCount = 0;
    private int successCount = 0;
    private int failureCount = 0;
    private int validationErrorCount = 0;

    public CmdiImdiExportConverter(ImportExportUI ui, File directory) {
        this.root = directory;
        this.ui = ui;
        this.translator = CmdiImdiExportConverter.newTranslator(ui);
    }

    public void run() {
        this.fatalError = null;
        if (this.translator != null) {
            this.convertDir(this.root);
        } else {
            logger.error("No translator instance available, could not transform to CMDI");
            this.fatalError = "Conversion could not be carried out! See error log for details.";
        }
    }

    public CharSequence getResultMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.fatalError != null) {
            sb.append(this.fatalError).append(" ");
        }
        if (this.successCount > 0) {
            sb.append(String.format("Converted %d files to CMDI. ", this.successCount));
        }
        if (this.failureCount > 0) {
            sb.append(String.format("\nFailed to convert %d files. Choose 'Details' to get more information. ", this.failureCount));
        }
        return sb;
    }

    private void convertDir(File dir) {
        File[] directories;
        File[] imdiFiles = dir.listFiles(new ImdiFilter());
        this.fileCount += imdiFiles.length;
        for (File imdiFile : imdiFiles) {
            if (this.ui.isStopCopy()) {
                return;
            }
            this.convertToCmdi(imdiFile);
            this.ui.updateConversionStatus(this.fileCount, this.successCount + this.failureCount, this.failureCount, this.validationErrorCount);
        }
        for (File directory : directories = dir.listFiles(new DirectoryFilter())) {
            this.convertDir(directory);
        }
    }

    private void convertToCmdi(File imdiFile) {
        File cmdiFile = new File(imdiFile.getAbsolutePath().replaceAll(".imdi$", ".cmdi"));
        if (imdiFile.equals(cmdiFile)) {
            logger.error("Could not convert {} to CMDI: unexpected file extension", (Object)imdiFile);
            this.ui.addToMetadataCopyErrors(imdiFile.toURI());
            this.ui.appendToTaskOutput("Failed to convert to CMDI: " + imdiFile.getAbsolutePath());
            return;
        }
        if (!cmdiFile.exists() || this.ui.askOverwrite(cmdiFile.toURI())) {
            logger.debug("Converting {} to {}", (Object)imdiFile, (Object)cmdiFile);
            if (this.applyXslt(imdiFile, cmdiFile)) {
                this.validateOutput(cmdiFile, imdiFile);
            }
        }
        logger.debug("Conversion complete, deleting original IMDI {}", (Object)imdiFile);
        imdiFile.delete();
    }

    private void validateOutput(File cmdiFile, File imdiFile) {
        String checkerResult = this.xsdChecker.simpleCheck(cmdiFile);
        if (checkerResult != null) {
            this.ui.appendToXmlOutput(imdiFile.toString() + "\n");
            this.ui.appendToXmlOutput("destination path: " + cmdiFile.getAbsolutePath());
            logger.debug("checkerResult: {}", (Object)checkerResult);
            this.ui.appendToXmlOutput(checkerResult + "\n");
            this.ui.addToValidationErrors(imdiFile.toURI());
            ++this.validationErrorCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyXslt(File source, File result) {
        try {
            String cmdiOut = this.translator.getCMDI(source.toURI().toURL(), null);
            OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(result), "UTF-8");
            try {
                fw.write(cmdiOut);
            }
            finally {
                ((Writer)fw).close();
            }
            ++this.successCount;
            ArbilJournal.getSingleInstance().saveJournalEntry(result.getAbsolutePath(), "", source.getAbsolutePath(), "", "conversion");
            return true;
        }
        catch (IOException ex) {
            this.handleTransformError(source, ex);
        }
        catch (TransformerException ex) {
            this.handleTransformError(source, ex);
        }
        catch (XMLStreamException ex) {
            this.handleTransformError(source, ex);
        }
        return false;
    }

    private void handleTransformError(File source, Exception ex) {
        this.ui.addToMetadataCopyErrors(source.toURI());
        this.ui.appendToTaskOutput("Failed to convert file to CMDI: " + source.getAbsolutePath());
        ++this.failureCount;
    }

    private static TranslatorImpl newTranslator(ImportExportUI ui) {
        try {
            return new TranslatorImpl((UrlStreamResolver)new UrlStreamResolverImpl());
        }
        catch (IOException ex) {
            logger.error("Could not instantiate metadata translator", (Throwable)ex);
        }
        catch (TransformerConfigurationException ex) {
            logger.error("Could not instantiate metadata translator", (Throwable)ex);
        }
        ui.appendToTaskOutput("Could not transform to IMDI, failed to instantiate transformer");
        return null;
    }

    private static class ImdiFilter
    implements FileFilter {
        private ImdiFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".imdi");
        }
    }

    private static class DirectoryFilter
    implements FileFilter {
        private DirectoryFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    }
}

