/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.data.DocumentationLanguages;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.ui.TemplateDialogue;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.WindowManager;

public class LanguageListDialogue
extends TemplateDialogue {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private ArrayList<JCheckBox> checkBoxArray;
    private final DocumentationLanguages documentationLanguages = ArbilTemplateManager.getSingleInstance().getDefaultTemplate().getDocumentationLanguages();

    public LanguageListDialogue(JDialog parentFrameLocal, WindowManager windowManager, MessageDialogHandler dialogueHandler) {
        super(windowManager, dialogueHandler, parentFrameLocal);
    }

    public static void showLanguageDialogue(WindowManager windowManager, MessageDialogHandler dialogueHandler) {
        JDialog dialog = new JDialog(windowManager.getMainFrame(), widgets.getString("AVAILABLE LANGUAGES"), true);
        LanguageListDialogue languageListDialogue = new LanguageListDialogue(dialog, windowManager, dialogueHandler);
        languageListDialogue.populateLists();
        dialog.setContentPane(languageListDialogue);
        dialog.pack();
        LanguageListDialogue.setDialogHeight(dialog, windowManager);
        dialog.setVisible(true);
    }

    protected void populateLists() {
        this.cmdiProfilesPanel.getParent().remove(this.cmdiProfilesPanel);
        this.internalTemplatesPanel.setBorder(BorderFactory.createTitledBorder(widgets.getString("LANGUAGES TO DISPLAY IN THE FIELD LANGUAGE SELECT BOX FOR IMDI")));
        List<String> selectedLanguages = this.documentationLanguages.getSelectedLanguagesOrDefault();
        this.checkBoxArray = new ArrayList();
        for (ArbilVocabularyItem currentTemplate : this.documentationLanguages.getAllLanguages()) {
            JCheckBox languageCheckBox = new JCheckBox();
            languageCheckBox.setText(currentTemplate.itemDisplayName);
            languageCheckBox.setName(currentTemplate.itemDisplayName);
            languageCheckBox.setActionCommand(currentTemplate.itemDisplayName);
            languageCheckBox.setSelected(selectedLanguages.contains(currentTemplate.itemDisplayName));
            languageCheckBox.setToolTipText(currentTemplate.itemDisplayName);
            languageCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (((JCheckBox)e.getSource()).isSelected()) {
                        LanguageListDialogue.this.documentationLanguages.addselectedLanguage(e.getActionCommand());
                    } else {
                        LanguageListDialogue.this.documentationLanguages.removeselectedLanguages(e.getActionCommand());
                    }
                }
            });
            this.checkBoxArray.add(languageCheckBox);
        }
        LanguageListDialogue.addSorted(this.templatesPanel, this.checkBoxArray);
        JButton selectAllButton = new JButton();
        selectAllButton.setText(widgets.getString("LANGUAGES_SELECT ALL"));
        selectAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (JCheckBox currentCheckBox : LanguageListDialogue.this.checkBoxArray) {
                    currentCheckBox.setSelected(true);
                    LanguageListDialogue.this.documentationLanguages.addselectedLanguage(currentCheckBox.getActionCommand());
                }
            }
        });
        JButton selectNoneButton = new JButton();
        selectNoneButton.setText(widgets.getString("LANGUAGES_CLEAR SELECTION"));
        selectNoneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                for (JCheckBox currentCheckBox : LanguageListDialogue.this.checkBoxArray) {
                    currentCheckBox.setSelected(false);
                    LanguageListDialogue.this.documentationLanguages.removeselectedLanguages(currentCheckBox.getActionCommand());
                }
            }
        });
        this.internalTemplatesButtonPanel.removeAll();
        this.internalTemplatesButtonPanel.add(selectNoneButton);
        this.internalTemplatesButtonPanel.add(selectAllButton);
    }
}

