/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.favourites;

import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.favourites.FavouritesExporter;
import nl.mpi.arbil.favourites.FavouritesImportExportException;
import nl.mpi.arbil.ui.favourites.ExportUI;
import nl.mpi.flap.plugin.PluginDialogHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportAction
extends AbstractAction {
    private static final Logger logger = LoggerFactory.getLogger(ExportAction.class);
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/arbil/localisation/Widgets");
    private final PluginDialogHandler dialogHandler;
    private final FavouritesExporter exporter;
    private boolean openAfterExport = true;

    public ExportAction(PluginDialogHandler dialogHandler, FavouritesExporter exporter) {
        super("export");
        this.dialogHandler = dialogHandler;
        this.exporter = exporter;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!(e.getSource() instanceof ExportUI)) {
            throw new RuntimeException("Cannot retrieve favourites selection from UI, action source does not implement ExportUI");
        }
        ExportUI source = (ExportUI)e.getSource();
        this.exportFavourites(source.getSelectedFavourites());
    }

    private void exportFavourites(List<ArbilDataNode> nodesToExport) {
        if (nodesToExport.size() > 0) {
            try {
                File[] exportLocation = this.dialogHandler.showFileSelectBox(widgets.getString("SELECT EXPORT DESTINATION"), true, false, null, PluginDialogHandler.DialogueType.save, null);
                if (exportLocation != null && exportLocation.length > 0 && exportLocation[0] != null) {
                    this.exporter.exportFavourites(exportLocation[0], nodesToExport.toArray(new ArbilDataNode[0]));
                    this.openDirectory(exportLocation[0]);
                    this.dialogHandler.addMessageDialogToQueue(widgets.getString("FAVOURITES HAVE BEEN EXPORTED"), widgets.getString("EXPORT COMPLETE"));
                }
            }
            catch (FavouritesImportExportException ex) {
                logger.error("An error occurred while exporting favourites", (Throwable)ex);
                this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(widgets.getString("AN ERROR OCCURRED WHILE EXPORTING FAVOURITES"), ex.getMessage()), "Error");
            }
        } else {
            this.dialogHandler.addMessageDialogToQueue(widgets.getString("NO NODES ARE SELECTED. SELECT AT LEAST ONE NODE TO EXPORT."), widgets.getString("SELECT NODES TO EXPORT"));
        }
    }

    private void openDirectory(File exportLocation) {
        try {
            if (this.openAfterExport) {
                if (GraphicsEnvironment.isHeadless()) {
                    logger.info("Headless mode, not opening export target directory {}", (Object)exportLocation);
                } else {
                    Desktop.getDesktop().open(exportLocation);
                }
            }
        }
        catch (IOException ex) {
            logger.warn("Could not open target location {}", (Object)exportLocation, (Object)ex);
        }
        catch (RuntimeException ex) {
            logger.warn("Could not open target location {}", (Object)exportLocation, (Object)ex);
        }
    }

    public void setOpenAfterExport(boolean openAfterExport) {
        this.openAfterExport = openAfterExport;
    }
}

