/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.metadata.cmdi.api.type.impl;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.mpi.metadata.api.type.ControlledVocabularyItem;
import nl.mpi.metadata.api.type.MetadataElementAttributeType;
import nl.mpi.metadata.cmdi.api.dom.CMDINamespaceContext;
import nl.mpi.metadata.cmdi.api.type.CMDIProfileElement;
import nl.mpi.metadata.cmdi.api.type.CMDITypeException;
import nl.mpi.metadata.cmdi.api.type.datacategory.DataCategory;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIAttributeTypeImpl;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIControlledVocabularyItemImpl;
import nl.mpi.metadata.cmdi.api.type.impl.CMDIProfileElementImpl;
import nl.mpi.metadata.cmdi.api.type.impl.ComponentTypeImpl;
import nl.mpi.metadata.cmdi.api.type.impl.ControlledVocabularyElementTypeImpl;
import nl.mpi.metadata.cmdi.api.type.impl.ElementTypeImpl;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CmdiProfileElementSchemaReader {
    private static final Logger logger = LoggerFactory.getLogger(CmdiProfileElementSchemaReader.class);
    private final Document schemaDocument;
    private final XPath xPath;

    public CmdiProfileElementSchemaReader(Document document) {
        this.schemaDocument = document;
        this.xPath = XPathFactory.newInstance().newXPath();
        this.xPath.setNamespaceContext(new CMDINamespaceContext());
    }

    public void readSchema(CMDIProfileElementImpl profileElement) throws CMDITypeException {
        if (profileElement.getSchemaElement() == null) {
            throw new CMDITypeException(null, "Cannot read schema, it has not been set or loaded");
        }
        logger.debug("Reading schema for {}", (Object)profileElement.getSchemaElement().getName());
        this.readProperties(profileElement);
        this.readAttributes(profileElement);
        if (profileElement instanceof ComponentTypeImpl) {
            this.readChildren((ComponentTypeImpl)profileElement);
        }
    }

    protected void readProperties(CMDIProfileElementImpl profileElement) {
        if (profileElement instanceof ComponentTypeImpl) {
            this.readComponentId(profileElement);
        } else if (profileElement instanceof ControlledVocabularyElementTypeImpl) {
            this.readVocabularyItems((ControlledVocabularyElementTypeImpl)profileElement);
        }
        this.searchForAnnotations(profileElement);
    }

    protected void readAttributes(CMDIProfileElementImpl profileElement) {
        SchemaProperty[] attributeProperties = profileElement.getSchemaElement().getType().getAttributeProperties();
        if (attributeProperties != null && attributeProperties.length > 0) {
            ArrayList<MetadataElementAttributeType> attributes = new ArrayList<MetadataElementAttributeType>(attributeProperties.length);
            ArrayList<MetadataElementAttributeType> excludedAttributes = new ArrayList<MetadataElementAttributeType>();
            for (SchemaProperty attributeProperty : attributeProperties) {
                this.readAttribute(attributeProperty, profileElement, attributes, excludedAttributes);
            }
            profileElement.setAttributes(attributes);
            profileElement.setExcludedAttributes(excludedAttributes);
        } else {
            Set<MetadataElementAttributeType> attributes = Collections.emptySet();
            profileElement.setAttributes(attributes);
        }
    }

    private void readAttribute(SchemaProperty attributeProperty, CMDIProfileElementImpl profileElement, Collection<MetadataElementAttributeType> attributes, Collection<MetadataElementAttributeType> excludedAttributes) {
        QName attributeName = attributeProperty.getName();
        String attributeLocalPart = attributeName.getLocalPart();
        String attributeNamespaceURI = attributeName.getNamespaceURI();
        logger.debug("Creating attribute type '{}' of type {}", (Object)attributeName, (Object)attributeProperty.getType());
        boolean multilingualAttribute = false;
        if (profileElement instanceof ElementTypeImpl) {
            multilingualAttribute = this.readMultilingual((ElementTypeImpl)profileElement, attributeLocalPart, attributeNamespaceURI);
        }
        String type = attributeProperty.getType().toString();
        CMDIAttributeTypeImpl attribute = new CMDIAttributeTypeImpl(profileElement.getPathString(), attributeNamespaceURI, attributeLocalPart, type);
        attribute.setSchemaElement(attributeProperty);
        attribute.setDefaultValue(attributeProperty.getDefaultText());
        attribute.setMandatory(attributeProperty.getMinOccurs().compareTo(BigInteger.ZERO) > 0);
        if (multilingualAttribute) {
            excludedAttributes.add(attribute);
        } else {
            attributes.add(attribute);
        }
    }

    private boolean readMultilingual(ElementTypeImpl elementType, String attributeLocalPart, String attributeNamespaceURI) {
        boolean multilingual = "lang".equals(attributeLocalPart) && "http://www.w3.org/XML/1998/namespace".equals(attributeNamespaceURI);
        elementType.setMultilingual(multilingual);
        logger.debug("Set multilingual property of {} to {}", (Object)elementType, (Object)multilingual);
        return multilingual;
    }

    private void readChildren(ComponentTypeImpl componentType) throws CMDITypeException {
        List<CMDIProfileElement> children;
        SchemaProperty[] elements = componentType.getSchemaElement().getType().getElementProperties();
        if (elements != null && elements.length > 0) {
            children = new ArrayList<CMDIProfileElement>(elements.length);
            for (SchemaProperty child : elements) {
                CMDIProfileElementImpl childElement;
                boolean isComponent;
                boolean bl = isComponent = null != child.getType().getAttributeProperty(new QName("ComponentId")) || child.getType().getElementProperties().length > 0;
                if (isComponent) {
                    logger.debug("Creating child component type {}", (Object)child.getName().toString());
                    childElement = new ComponentTypeImpl(child, componentType, this.createChildPath(componentType, child));
                } else {
                    XmlAnySimpleType[] enumValues = child.getType().getEnumerationValues();
                    if (enumValues != null && enumValues.length > 0) {
                        logger.debug("Creating child CV element type {}", (Object)child.getName().toString());
                        childElement = new ControlledVocabularyElementTypeImpl(child, componentType, this.createChildPath(componentType, child));
                    } else {
                        logger.debug("Creating child element type {}", (Object)child.getName().toString());
                        childElement = new ElementTypeImpl(child, componentType, this.createChildPath(componentType, child));
                    }
                }
                this.readSchema(childElement);
                children.add(childElement);
            }
        } else {
            children = Collections.emptyList();
        }
        componentType.setChildren(children);
    }

    private StringBuilder createChildPath(ComponentTypeImpl componentType, SchemaProperty child) {
        return new StringBuilder(componentType.getPath()).append("/cmd:").append(child.getName().getLocalPart());
    }

    private void readComponentId(CMDIProfileElementImpl profileElement) {
        SchemaProperty componentIdAttribute = profileElement.getSchemaElement().getType().getAttributeProperty(new QName("ComponentId"));
        String componentId = componentIdAttribute == null ? null : componentIdAttribute.getDefaultText();
        ((ComponentTypeImpl)profileElement).setComponentId(componentId);
    }

    private void readVocabularyItems(ControlledVocabularyElementTypeImpl profileElement) {
        List<ControlledVocabularyItem> items;
        XmlAnySimpleType[] itemTypes = profileElement.getSchemaElement().getType().getEnumerationValues();
        if (itemTypes != null && itemTypes.length > 0) {
            items = new ArrayList<ControlledVocabularyItem>();
            for (XmlAnySimpleType itemType : profileElement.getSchemaElement().getType().getEnumerationValues()) {
                CMDIControlledVocabularyItemImpl item = new CMDIControlledVocabularyItemImpl();
                item.setValue(itemType.getStringValue());
                items.add(item);
            }
        } else {
            items = Collections.emptyList();
        }
        profileElement.setItems(items);
    }

    private void searchForAnnotations(CMDIProfileElementImpl profileElement) {
        SchemaParticle schemaParticle = profileElement.getSchemaElement().getType().getContentModel();
        if (schemaParticle != null && schemaParticle.getParticleType() == 4) {
            SchemaLocalElement schemaLocalElement = (SchemaLocalElement)schemaParticle;
            this.saveAnnotationData(profileElement, schemaLocalElement);
        } else if (this.schemaDocument != null) {
            String elementPath = profileElement.getPathString().replaceFirst("/cmd:", "//*[@name='").replaceAll("/cmd:", "']//*[@name='") + "']";
            try {
                Node elementSpecNode = (Node)this.xPath.evaluate(elementPath, this.schemaDocument, XPathConstants.NODE);
                if (elementSpecNode != null) {
                    NamedNodeMap attributes = elementSpecNode.getAttributes();
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        Node attrNode = attributes.item(i);
                        String nodeName = new QName(attrNode.getNamespaceURI(), attrNode.getLocalName()).toString();
                        this.saveAnnotationData(profileElement, nodeName, attrNode.getNodeValue());
                    }
                }
            }
            catch (XPathExpressionException ex) {
                logger.error(String.format("XPathExpressionException while reading annotation for profile element $1%s", profileElement), (Throwable)ex);
            }
        }
    }

    private void saveAnnotationData(CMDIProfileElementImpl profileElement, SchemaLocalElement schemaLocalElement) {
        SchemaAnnotation schemaAnnotation = schemaLocalElement.getAnnotation();
        if (schemaAnnotation != null) {
            for (SchemaAnnotation.Attribute annotationAttribute : schemaAnnotation.getAttributes()) {
                String annotationValue = annotationAttribute.getValue();
                String annotationName = annotationAttribute.getName().toString();
                this.saveAnnotationData(profileElement, annotationName, annotationValue);
            }
        }
    }

    private void saveAnnotationData(CMDIProfileElementImpl profileElement, String annotationName, String annotationValue) {
        if (!"".equals(annotationValue)) {
            if ("{http://www.clarin.eu}displaypriority".equals(annotationName) && profileElement instanceof ElementTypeImpl) {
                try {
                    int displayPriority = Integer.parseInt(annotationValue);
                    ((ElementTypeImpl)profileElement).setDisplayPriority(displayPriority);
                }
                catch (NumberFormatException nfEx) {
                    logger.warn(String.format("NumberFormatException in display priority (value: %1$s) for element %2$s", annotationValue, profileElement), (Throwable)nfEx);
                }
            }
            if ("{http://www.clarin.eu}documentation".equals(annotationName)) {
                profileElement.setDescription(annotationValue);
            }
            DataCategory datCat = null;
            if ("{http://www.isocat.org/ns/dcr}datcat".equals(annotationName)) {
                try {
                    URI dcUri = new URI(annotationValue);
                    datCat = new DataCategory(dcUri);
                }
                catch (URISyntaxException usEx) {
                    logger.warn(String.format("URISyntaxException in datcat (value: %1$s) for element %2$s", annotationValue, profileElement), (Throwable)usEx);
                }
            }
            if (datCat != null) {
                profileElement.setDataCategory(datCat);
            }
        }
    }
}

