/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.Vector;
import net.handle.hdllib4.HandleException;
import net.handle.hdllib4.HashBucket;
import net.handle.hdllib4.QueryOptions;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;

public class ServerHashtable {
    private int schemaVersion;
    private int headerLength = 40;
    private long dataVersion;
    private int numOfBits;
    private int maxSlotSize;
    private int maxAddressLength;
    private byte[] uniqueID;
    private HashBucket[] buckets;
    private byte[] encodedBody = null;
    private byte[] encodedBodyWithChecksum = null;

    public ServerHashtable(File hashFile) throws IOException, HandleException {
        byte[] hashBuf = new byte[(int)hashFile.length()];
        RandomAccessFile inFile = new RandomAccessFile(hashFile, "r");
        inFile.readFully(hashBuf);
        inFile.close();
        this.initWithCheckSum(hashBuf, 0, hashBuf.length);
    }

    public ServerHashtable(byte[] buf, int offset, int length) throws HandleException {
        this.initWithCheckSum(buf, offset, length);
    }

    public ServerHashtable(long dataVersion, int numOfBits, byte[] uniqueID, HashBucket[] buckets) throws HandleException {
        if (uniqueID == null || uniqueID.length < 16) {
            throw new HandleException(7, "uniqueID for hashtable - must be non-null with length >= 16");
        }
        this.dataVersion = dataVersion;
        this.numOfBits = numOfBits;
        this.uniqueID = uniqueID;
        this.buckets = buckets;
        this.buildEncodedBody();
    }

    private void initWithCheckSum(byte[] buf, int offset, int length) throws HandleException {
        MessageDigest md5Digest;
        if (buf.length < 16) {
            throw new HandleException(9, "no checksum found in hash table");
        }
        byte[] checksum = new byte[16];
        System.arraycopy(buf, offset, checksum, 0, 16);
        this.encodedBody = new byte[length - 16];
        System.arraycopy(buf, offset + 16, this.encodedBody, 0, this.encodedBody.length);
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(7, "no MD5 algorithm available");
        }
        byte[] newChecksum = md5Digest.digest(this.encodedBody);
        if (!MessageDigest.isEqual(newChecksum, checksum)) {
            throw new HandleException(9, "MD5 checksum failed");
        }
        this.initWithoutCheckSum(this.encodedBody, 0, this.encodedBody.length);
    }

    private void initWithoutCheckSum(byte[] buf, int offset, int length) throws HandleException {
        try {
            XdrDecoder decoder = new XdrDecoder(buf, offset, length);
            this.init(decoder);
        }
        catch (IOException e) {
            throw new HandleException(9, e.getMessage());
        }
    }

    private void init(XdrDecoder decoder) throws HandleException {
        try {
            this.schemaVersion = decoder.readShort();
            if (this.schemaVersion > 1) {
                this.headerLength = decoder.readShort();
            }
            this.dataVersion = decoder.readUnsignedInt();
            this.numOfBits = decoder.readShort();
            this.maxSlotSize = decoder.readShort();
            this.maxAddressLength = decoder.readShort();
            this.uniqueID = decoder.readBytes(16);
            Vector<HashBucket> tmpBuckets = new Vector<HashBucket>();
            while (decoder.moreData()) {
                HashBucket bucket = new HashBucket(decoder);
                tmpBuckets.addElement(bucket);
            }
            this.buckets = new HashBucket[tmpBuckets.size()];
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = (HashBucket)tmpBuckets.elementAt(i);
            }
        }
        catch (Exception e) {
            throw new HandleException(9, e.toString());
        }
    }

    public void printValues(PrintStream out) {
        int i;
        out.println("Hashtable headers:");
        out.println("  schemaVersion: " + this.schemaVersion);
        if (this.headerLength >= 0) {
            out.println("  headerLength: " + this.headerLength);
        }
        out.println("  dataVersion: " + this.dataVersion);
        out.println("  numOfBits: " + this.numOfBits);
        out.println("  maxSlotSize: " + this.maxSlotSize);
        out.println("  maxAddressLength: " + this.maxAddressLength);
        out.print("  uniqueID: ");
        for (i = 0; i < this.uniqueID.length; ++i) {
            out.print(" " + this.uniqueID[i]);
        }
        out.println("");
        out.println("Buckets:");
        for (i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].printValues(out);
        }
    }

    private synchronized void buildEncodedBody() throws HandleException {
        MessageDigest md5Digest;
        this.encodedBody = null;
        this.encodedBodyWithChecksum = null;
        int tableSize = 24 + XdrEncoder.calcArraySize(16);
        int maxSS = 0;
        int maxAddr = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            int tmp = this.buckets[i].getEncodingSize();
            maxSS = maxSS > tmp ? maxSS : tmp;
            tableSize += tmp;
            tmp = this.buckets[i].ipAddress.length;
            maxAddr = maxAddr > tmp ? maxAddr : tmp;
        }
        this.maxSlotSize = maxSS;
        this.maxAddressLength = maxAddr;
        XdrEncoder encoder = new XdrEncoder(tableSize);
        encoder.writeShort(this.schemaVersion);
        encoder.writeShort(this.headerLength);
        encoder.writeUInt(this.dataVersion);
        encoder.writeShort(this.numOfBits);
        encoder.writeShort(this.maxSlotSize);
        encoder.writeShort(this.maxAddressLength);
        encoder.writeBytes(this.uniqueID, 0, 16);
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i].writeBucket(encoder);
        }
        this.encodedBody = encoder.getCurrentBuffer();
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(7, "no MD5 algorithm available");
        }
        byte[] checksum = md5Digest.digest(this.encodedBody);
        this.encodedBodyWithChecksum = new byte[this.encodedBody.length + 16];
        System.arraycopy(this.encodedBody, 0, this.encodedBodyWithChecksum, 16, this.encodedBody.length);
        System.arraycopy(checksum, 0, this.encodedBodyWithChecksum, 0, 16);
    }

    public byte[] getEncodedValue() {
        if (this.encodedBody == null) {
            return null;
        }
        byte[] buf = new byte[this.encodedBody.length];
        System.arraycopy(this.encodedBody, 0, buf, 0, this.encodedBody.length);
        return buf;
    }

    public synchronized byte[] getEncodedValueWithChecksum() throws HandleException {
        MessageDigest md5Digest;
        if (this.encodedBody == null) {
            return null;
        }
        if (this.encodedBodyWithChecksum != null) {
            return this.encodedBodyWithChecksum;
        }
        this.encodedBodyWithChecksum = new byte[this.encodedBody.length + 16];
        System.arraycopy(this.encodedBody, 0, this.encodedBodyWithChecksum, 16, this.encodedBody.length);
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleException(7, "no MD5 algorithm available");
        }
        byte[] newChecksum = md5Digest.digest(this.encodedBody);
        System.arraycopy(newChecksum, 0, this.encodedBodyWithChecksum, 0, 16);
        return this.encodedBodyWithChecksum;
    }

    public HashBucket[] getPrimaryServers() {
        int count = (int)Math.pow(2.0, this.numOfBits);
        HashBucket[] retBuckets = new HashBucket[count];
        System.arraycopy(this.buckets, 0, retBuckets, 0, count);
        return retBuckets;
    }

    public HashBucket[] getAllServers() {
        return this.buckets;
    }

    public HashBucket[] determineServer(String handle, QueryOptions queryOptions) throws HandleException {
        boolean primaryOnly;
        byte[] handleBytes;
        String pureHandle = (handle.startsWith("//") ? handle.substring(2) : handle).toUpperCase();
        try {
            handleBytes = pureHandle.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HandleException(7, "unable to encode UTF8 string");
        }
        int serverNumber = 0;
        boolean bl = primaryOnly = queryOptions != null && queryOptions.getAuthenticateRequests();
        if (this.numOfBits > 0) {
            byte[] digest;
            try {
                MessageDigest md5Digest = MessageDigest.getInstance("MD5");
                digest = md5Digest.digest(handleBytes);
            }
            catch (NoSuchAlgorithmException e) {
                throw new HandleException(7, "no MD5 algorithm available");
            }
            long hashVal = (0xFFL & (long)digest[0]) << 24 | (0xFFL & (long)digest[1]) << 16 | (0xFFL & (long)digest[2]) << 8 | 0xFFL & (long)digest[3];
            serverNumber = (int)(hashVal >> 32 - this.numOfBits);
        }
        if (serverNumber >= this.buckets.length) {
            throw new HandleException(9, "Incorrect numBits setting in hashtable header!");
        }
        if (primaryOnly) {
            return new HashBucket[]{this.buckets[serverNumber]};
        }
        Vector<HashBucket> bucketVect = new Vector<HashBucket>();
        boolean totalWeight = false;
        while (true) {
            HashBucket bucket = this.buckets[serverNumber];
            bucketVect.addElement(bucket);
            if (bucket.secondarySlotNo <= serverNumber) break;
            serverNumber = bucket.secondarySlotNo;
        }
        Random rand = new Random();
        boolean n = false;
        HashBucket[] retBuckets = new HashBucket[bucketVect.size()];
        for (int i = 0; i < retBuckets.length; ++i) {
            int nextBucket = Math.abs(rand.nextInt()) % bucketVect.size();
            if (nextBucket == bucketVect.size()) {
                --nextBucket;
            }
            retBuckets[i] = (HashBucket)bucketVect.elementAt(nextBucket);
            bucketVect.removeElementAt(nextBucket);
        }
        return retBuckets;
    }
}

