/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.tree.swingtree;

import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import nl.mpi.archiving.tree.GenericTreeModelProvider;
import nl.mpi.archiving.tree.GenericTreeNode;
import nl.mpi.archiving.tree.swingtree.NullTreeNode;

public class GenericTreeSwingTreeNodeWrapper
implements TreeNode,
Serializable {
    private final GenericTreeModelProvider treeModelProvider;
    private final GenericTreeNode contentNode;
    private final TreeNode parent;

    public GenericTreeSwingTreeNodeWrapper(GenericTreeModelProvider treeModelProvider, GenericTreeNode contentNode) {
        this(treeModelProvider, contentNode, null);
    }

    public GenericTreeSwingTreeNodeWrapper(GenericTreeModelProvider treeModelProvider, GenericTreeNode contentNode, TreeNode parent) {
        this.contentNode = contentNode == null ? new NullTreeNode(parent) : contentNode;
        this.parent = parent;
        this.treeModelProvider = treeModelProvider;
    }

    public GenericTreeNode getContentNode() {
        if (this.contentNode instanceof NullTreeNode) {
            return null;
        }
        return this.contentNode;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return new GenericTreeSwingTreeNodeWrapper(this.treeModelProvider, this.treeModelProvider.getChild(this.contentNode, childIndex), this);
    }

    @Override
    public int getChildCount() {
        return this.treeModelProvider.getChildCount(this.contentNode);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.treeModelProvider.getIndexOfChild(this.contentNode, ((GenericTreeSwingTreeNodeWrapper)node).getContentNode());
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.treeModelProvider.getChildCount(this.contentNode) == 0;
    }

    public Enumeration children() {
        return new Enumeration(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index + 1 < GenericTreeSwingTreeNodeWrapper.this.treeModelProvider.getChildCount(GenericTreeSwingTreeNodeWrapper.this.contentNode);
            }

            public Object nextElement() {
                return new GenericTreeSwingTreeNodeWrapper(GenericTreeSwingTreeNodeWrapper.this.treeModelProvider, GenericTreeSwingTreeNodeWrapper.this.treeModelProvider.getChild(GenericTreeSwingTreeNodeWrapper.this.contentNode, this.index++), GenericTreeSwingTreeNodeWrapper.this);
            }
        };
    }

    public GenericTreeModelProvider getTreeModelProvider() {
        return this.treeModelProvider;
    }

    public String toString() {
        return this.contentNode.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (this.contentNode != null ? this.contentNode.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericTreeSwingTreeNodeWrapper other = (GenericTreeSwingTreeNodeWrapper)obj;
        return this.contentNode == other.contentNode || this.contentNode != null && this.contentNode.equals(other.contentNode);
    }
}

