/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import java.io.PrintStream;
import net.handle.hdllib4.Codes;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;

public class ResponsePacketHeader {
    public long version = 1L;
    public long sessionTag;
    public long command;
    public long sequenceNumber;
    public int numberOfPackets;
    public int errorCode;
    public int bodyLength = 0;

    public ResponsePacketHeader(XdrDecoder decoder) throws IOException {
        this.version = decoder.readUnsignedInt();
        if (this.version != 1L) {
            this.errorCode = 2;
            return;
        }
        this.sessionTag = decoder.readUnsignedInt();
        this.command = decoder.readUnsignedInt();
        this.sequenceNumber = decoder.readUnsignedInt();
        this.numberOfPackets = (int)decoder.readUnsignedInt();
        this.errorCode = decoder.readInt();
        this.bodyLength = (int)decoder.readUnsignedInt();
    }

    public ResponsePacketHeader(long sessionTag, long command, long sequenceNumber, int numberOfPackets, int errorCode) {
        this.version = 1L;
        this.sessionTag = sessionTag;
        this.command = command;
        this.sequenceNumber = sequenceNumber;
        this.numberOfPackets = numberOfPackets;
        this.errorCode = errorCode;
    }

    public void encodeHeader(XdrEncoder encoder) {
        encoder.writeUInt(1L);
        encoder.writeUInt(this.sessionTag);
        encoder.writeUInt(this.command);
        encoder.writeUInt(this.sequenceNumber);
        encoder.writeInt(this.numberOfPackets);
        encoder.writeInt(this.errorCode);
        encoder.writeUInt(this.bodyLength);
    }

    public void printValues(PrintStream out) {
        out.println("Version: " + this.version);
        out.println("sessionTag: " + this.sessionTag);
        out.println("command: " + this.command);
        out.println("sequenceNumber: " + this.sequenceNumber);
        out.println("numberOfPackets: " + this.numberOfPackets);
        out.println("errorCode: " + this.errorCode + " = " + Codes.getHPCodeDescription(this.errorCode));
        out.println("bodyLength: " + this.bodyLength);
    }
}

