/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.archiving.corpusstructure.core.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import javax.ejb.EJB;
import nl.mpi.archiving.corpusstructure.core.CorpusNode;
import nl.mpi.archiving.corpusstructure.core.OutputFormat;
import nl.mpi.archiving.corpusstructure.core.service.FilePathTranslator;
import nl.mpi.archiving.corpusstructure.core.service.NodeResolver;

public abstract class BaseNodeResolver
implements NodeResolver {
    @EJB
    private FilePathTranslator translator;

    public BaseNodeResolver() {
    }

    public BaseNodeResolver(FilePathTranslator translator) {
        this.translator = translator;
    }

    @Override
    public InputStream getInputStream(CorpusNode node) throws IOException {
        File localFile = this.getLocalFile(node);
        if (localFile != null) {
            try {
                return new FileInputStream(localFile);
            }
            catch (IOException ex) {
                throw new IOException("Could not open input stream for " + localFile.getAbsolutePath(), ex);
            }
        }
        return this.getUrl(node).openStream();
    }

    @Override
    public URI getPID(CorpusNode node, OutputFormat format) {
        URI pid = this.getPID(node);
        if (pid == null) {
            return null;
        }
        String f = format.toString().toLowerCase();
        return URI.create(pid.toString() + "@format=" + f);
    }

    @Override
    public File getLocalFile(CorpusNode node) {
        try {
            return this.translator.translateToLocalFile(node.getNodeURI());
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }
}

