/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.mpi.arbil.data.ArbilField;
import nl.mpi.arbil.ui.ArbilSplitPanel;

public class FindReplacePanel
extends JPanel
implements ActionListener,
FocusListener {
    String defaultFindText = "<enter find text>";
    String defaultReplaceText = "<enter replacement text>";
    ArbilSplitPanel splitPanel;
    JButton closeButton;
    JTextField seachField;
    JTextField replaceField;
    JCheckBox useJavaRegExCheckBox;
    JCheckBox replaceAllCheckBox;
    JButton searchButton;
    JButton replaceButton;

    public FindReplacePanel(ArbilSplitPanel splitPanelLocal) {
        this.splitPanel = splitPanelLocal;
        this.seachField = new JTextField(this.defaultFindText);
        this.replaceField = new JTextField(this.defaultReplaceText);
        this.seachField.setName(this.defaultFindText);
        this.replaceField.setName(this.defaultReplaceText);
        this.seachField.setForeground(Color.gray);
        this.replaceField.setForeground(Color.gray);
        this.useJavaRegExCheckBox = new JCheckBox("Regular Expression");
        this.replaceAllCheckBox = new JCheckBox("Replace All");
        this.useJavaRegExCheckBox.setToolTipText("Use Java Style Regular Expressions (eg: . any \\d digit \\s whitespace ? zero or once * zero or more + one or more ^ line start $ line end)");
        this.searchButton = new JButton("Find Next");
        this.replaceButton = new JButton("Replace Selected");
        this.closeButton = new JButton("Close");
        this.seachField.addActionListener(this);
        this.replaceField.addActionListener(this);
        this.searchButton.addActionListener(this);
        this.replaceButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.seachField.addFocusListener(this);
        this.replaceField.addFocusListener(this);
        this.add(this.seachField);
        this.add(this.replaceField);
        this.add(this.searchButton);
        this.add(this.replaceButton);
        this.add(this.closeButton);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        System.out.println(actionEvent.toString());
        if (actionEvent.getSource().equals(this.closeButton)) {
            this.splitPanel.showSearchPane();
            return;
        }
        String searchString = "";
        if (!this.seachField.getText().equals(this.defaultFindText)) {
            searchString = this.seachField.getText();
        }
        String replaceString = null;
        if (actionEvent.getSource().equals(this.replaceButton)) {
            replaceString = "";
            if (!this.replaceField.getText().equals(this.defaultReplaceText)) {
                replaceString = this.replaceField.getText();
            }
        }
        if (actionEvent.getSource().equals(this.replaceButton)) {
            for (ArbilField currentField : this.splitPanel.arbilTable.getSelectedFields()) {
                String currentFieldString;
                if (!currentField.getParentDataNode().isEditable() || !currentField.getFieldValue().contains(searchString) || !(currentFieldString = currentField.getFieldValue()).contains(searchString)) continue;
                currentFieldString = currentFieldString.replace(searchString, replaceString);
                currentField.setFieldValue(currentFieldString, true, false);
            }
            return;
        }
        boolean replaceAll = actionEvent.getSource().equals(this.replaceButton) && this.replaceAllCheckBox.isSelected();
        int startColumn = this.splitPanel.arbilTable.getSelectedColumn();
        int startRow = this.splitPanel.arbilTable.getSelectedRow();
        boolean firstTime = true;
        if (startColumn < 0) {
            firstTime = false;
            startColumn = 0;
        }
        if (startRow < 0) {
            firstTime = false;
            startRow = 0;
        }
        for (int currentRow = startRow; currentRow < this.splitPanel.arbilTable.getRowCount(); ++currentRow) {
            for (int currentColumn = startColumn; currentColumn < this.splitPanel.arbilTable.getColumnCount(); ++currentColumn) {
                if (firstTime) {
                    firstTime = false;
                    continue;
                }
                ArbilField[] currentCellValue = this.splitPanel.arbilTable.getTableCellContentAt(currentRow, currentColumn);
                if (currentCellValue instanceof ArbilField) {
                    currentCellValue = new ArbilField[]{(ArbilField)currentCellValue};
                }
                if (!(currentCellValue instanceof ArbilField[])) continue;
                for (ArbilField currentField : (ArbilField[])currentCellValue) {
                    if (!currentField.getFieldValue().contains(searchString)) continue;
                    this.splitPanel.arbilTable.setCellSelectionEnabled(true);
                    this.splitPanel.arbilTable.changeSelection(currentRow, currentColumn, false, false);
                    return;
                }
            }
            startColumn = 0;
        }
    }

    public void focusGained(FocusEvent e) {
        JTextField currentTextField = (JTextField)e.getSource();
        if (currentTextField.getText().equals(this.defaultFindText) || currentTextField.getText().equals(this.defaultReplaceText)) {
            currentTextField.setText("");
        }
        currentTextField.setForeground(Color.black);
    }

    public void focusLost(FocusEvent e) {
        JTextField currentTextField = (JTextField)e.getSource();
        if (currentTextField.getText().length() < 1) {
            currentTextField.setText(currentTextField.getName());
            currentTextField.setForeground(Color.gray);
        }
    }
}

