/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilTableCell;
import nl.mpi.arbil.data.DataNodeLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilDataNodeArrayTableCell
implements ArbilTableCell<ArbilDataNode[]> {
    private transient ArbilDataNode[] dataNodes;
    private ArrayList<URI> contentUris;
    private static DataNodeLoader dataNodeLoader;

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public ArbilDataNodeArrayTableCell(ArbilDataNode[] dataNode) {
        this.setContent(dataNode);
        this.setURIs();
    }

    @Override
    public ArbilDataNode[] getContent() {
        if (this.dataNodes == null && this.contentUris != null) {
            this.loadNodes();
        }
        return this.dataNodes;
    }

    @Override
    public final void setContent(ArbilDataNode[] content) {
        this.dataNodes = content;
        this.setURIs();
    }

    private void setURIs() {
        if (this.dataNodes == null) {
            this.contentUris = null;
        } else {
            this.contentUris = new ArrayList(this.dataNodes.length);
            for (ArbilDataNode node : this.dataNodes) {
                this.contentUris.add(node != null ? node.getURI() : null);
            }
        }
    }

    private void loadNodes() {
        if (this.contentUris == null) {
            this.dataNodes = null;
        } else {
            this.dataNodes = new ArbilDataNode[this.contentUris.size()];
            for (int i = 0; i < this.contentUris.size(); ++i) {
                this.dataNodes[i] = dataNodeLoader.getArbilDataNode(null, this.contentUris.get(i));
            }
        }
    }

    public String toString() {
        StringBuilder cellText = new StringBuilder();
        Arrays.sort(this.getContent(), new Comparator(){

            public int compare(Object o1, Object o2) {
                String value1 = o1.toString();
                String value2 = o2.toString();
                return value1.compareToIgnoreCase(value2);
            }
        });
        boolean hasAddedValues = false;
        for (ArbilDataNode currentArbilDataNode : this.getContent()) {
            if (hasAddedValues) {
                cellText.append(',');
            }
            cellText.append('[');
            cellText.append(currentArbilDataNode.toString());
            cellText.append(']');
            hasAddedValues = true;
        }
        return cellText.toString();
    }
}

