/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.typecheck;

import java.util.Collection;
import java.util.Vector;

public class TypeDef {
    int offset;
    String magic;
    int offset2;
    String magic2 = null;
    int offset3;
    String magic3 = null;
    boolean caseInsensitive;
    String formatName;
    Vector<String> extensions = new Vector();
    String judgement;

    public TypeDef(int offset, String magic, boolean caseInsensitive, String ext, String judgement, String formatName) {
        this.offset = offset;
        this.magic = magic;
        this.caseInsensitive = caseInsensitive;
        this.judgement = judgement;
        this.formatName = formatName;
        this.registerExtension(ext);
    }

    public void registerExtension(String extension) {
        this.extensions.add(extension.toLowerCase());
    }

    public void moreConstraints(int offset, String magic, int off3, String magic3) {
        this.magic2 = magic;
        this.offset2 = offset;
        this.magic3 = magic3;
        this.offset3 = off3;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public String getJudgement() {
        return this.judgement;
    }

    public boolean isAnythingMatcher() {
        return this.offset == Integer.MAX_VALUE && "ANYTHING".equals(this.magic);
    }

    public boolean isValidExtension(String ext) {
        return this.extensions.contains(ext.toLowerCase());
    }

    public Collection getValidExtensions() {
        return this.extensions;
    }

    public boolean isFormat(String data) {
        boolean retval;
        if (this.isAnythingMatcher()) {
            return true;
        }
        if (this.caseInsensitive) {
            data = data.toLowerCase();
            this.magic = this.magic.toLowerCase();
            if (this.magic2 != null) {
                this.magic2 = this.magic2.toLowerCase();
            }
            if (this.magic3 != null) {
                this.magic3 = this.magic3.toLowerCase();
            }
        }
        if ((retval = data.startsWith(this.magic, this.offset)) && this.magic2 != null) {
            retval = data.startsWith(this.magic2, this.offset2);
        }
        if (retval && this.magic3 != null) {
            retval = data.startsWith(this.magic3, this.offset3);
        }
        return retval;
    }
}

