/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.log4j.Logger;

public class Checksum {
    private static Logger logger = Logger.getLogger((String)Checksum.class.getName());
    private static final String zeroString = "00000000000000000000000000000000";

    public static void main(String[] args) {
        if (args.length == 1) {
            System.out.println("Command line: '" + args[0] + "'");
            if (new File(args[0]).canRead()) {
                System.out.println("File checksum: " + Checksum.create(args[0]));
            } else {
                System.out.println("Command line has no name of a readable file");
            }
            System.out.println("Text checksum: " + Checksum.checksumString(args[0]));
        } else {
            System.out.println("Usage : java Checksum [filename/string]\n");
        }
    }

    public static String checksumString(String text) {
        byte[] digest = null;
        try {
            byte[] chk = text.getBytes("UTF-8");
            MessageDigest complete = MessageDigest.getInstance("MD5");
            complete.update(chk, 0, chk.length);
            digest = complete.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error((Object)("This Java environment does not support the MD5SUM algorithm\n" + nsae));
            return null;
        }
        catch (UnsupportedEncodingException uee) {
            logger.error((Object)("This Java environment does not support the UTF-8 encoding\n" + uee));
            return null;
        }
        if (digest == null) {
            return "";
        }
        String md5 = zeroString + new BigInteger(1, digest).toString(16);
        return md5.substring(md5.length() - 32);
    }

    public static String create(String filename) {
        byte[] chk = Checksum.createChecksum(filename);
        if (chk == null) {
            return "";
        }
        String md5 = zeroString + new BigInteger(1, chk).toString(16);
        return md5.substring(md5.length() - 32);
    }

    public static byte[] createChecksum(String filename) {
        try {
            int numRead;
            FileInputStream fis = new FileInputStream(filename);
            byte[] buffer = new byte[1024];
            MessageDigest complete = MessageDigest.getInstance("MD5");
            do {
                if ((numRead = ((InputStream)fis).read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            ((InputStream)fis).close();
            return complete.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error((Object)("This Java environment does not support the MD5SUM algorithm\n" + nsae));
            return null;
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)("File not found: " + fnfe + " for: " + filename));
            return null;
        }
        catch (IOException ioe) {
            logger.error((Object)("File read error: " + ioe + " for: " + filename));
            logger.debug((Object)("Stack trace for I/O error for: " + filename + " follows..."), (Throwable)ioe);
            return null;
        }
    }
}

