/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jutil.BrowsePanel;
import net.handle.apps.gui.jutil.HelpPanel;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.apps.gui.jutil.PasswordPanel;
import net.handle.apps.gui.jwidget.GenerateKeyJPanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;
import net.handle.security.HdlSecurityProvider;

public class SessionSetupJPanel
extends JDialog
implements ActionListener {
    protected BrowsePanel browserPubkey;
    protected BrowsePanel browserCliPrivkey;
    protected BrowsePanel browserHdlPrivkey;
    protected JTextField keyrefHandleField;
    protected JTextField keyrefIndexField;
    protected JCheckBox sessionEncrypted;
    protected JCheckBox sessionAuthenticated;
    protected JTextField sessionTimeout;
    protected JButton genRSAKeyButton;
    protected JFrame parent;
    protected JLabel timeoutL1;
    protected JLabel timeoutL2;
    String privKeyFile;
    String pubKeyFile;
    protected JComboBox modeBox;
    JPanel modeOptionsPanel;
    JPanel hdlCipherPanel;
    JPanel emptyPanel;
    JPanel clientCipherPanel;
    static final String MODE_NONE = "Disabled";
    static final String MODE_DH = "Diffie-Hellman";
    static final String MODE_CLIENT = "Client Cipher";
    static final String MODE_SERVER = "Server Cipher";
    static final String MODE_HDL = "Cipher Reference";
    SessionSetupInfo oldInfo;
    HandleTool hdlTool;
    protected MyButton helpButton = new MyButton("Help", "Help for session setup");

    public SessionSetupJPanel(HandleTool parent, SessionSetupInfo info, boolean sessionsEnabled) {
        super(parent, "Session Setup", false);
        this.hdlTool = parent;
        JPanel panel = new JPanel(new GridBagLayout());
        this.parent = parent == null ? new JFrame() : parent;
        this.oldInfo = info;
        JButton okButton = new JButton(new AbstractAction("Ok"){

            public void actionPerformed(ActionEvent e) {
                try {
                    SessionSetupInfo ss = SessionSetupJPanel.this.getSetupInfo(SessionSetupJPanel.this.hdlTool.getCurrentAuthentication());
                    SessionSetupJPanel.this.hdlTool.resolver.setSessionTracker(new ClientSessionTracker(ss));
                    SessionSetupJPanel.this.dispose();
                }
                catch (Exception ee) {
                    String msg = ee.getMessage();
                    if (msg == null || msg.length() == 0) {
                        msg = ee.toString();
                    }
                    ee.printStackTrace();
                    JOptionPane.showMessageDialog(SessionSetupJPanel.this.hdlTool, msg, "Error", 0);
                }
            }
        });
        JButton cancelButton = new JButton(new AbstractAction("Cancel"){

            public void actionPerformed(ActionEvent e) {
                SessionSetupJPanel.this.dispose();
            }
        });
        this.helpButton.addActionListener(this);
        JPanel btnPanel = new JPanel();
        btnPanel.add(okButton);
        btnPanel.add(cancelButton);
        btnPanel.add(this.helpButton);
        this.genRSAKeyButton = new JButton("Generate Key Pair");
        this.genRSAKeyButton.addActionListener(this);
        this.browserPubkey = new BrowsePanel("Public Key File: ", (File)null, "", null, false);
        this.browserHdlPrivkey = new BrowsePanel("Private Key File: ", (File)null, "", null, false);
        this.hdlCipherPanel = new JPanel(new GridBagLayout());
        this.hdlCipherPanel.setBorder(new EmptyBorder(6, 2, 5, 5));
        this.keyrefHandleField = new JTextField("", 20);
        this.keyrefHandleField.setScrollOffset(0);
        this.keyrefHandleField.setToolTipText("Input public key ref handle");
        this.keyrefIndexField = new JTextField("300", 3);
        this.keyrefIndexField.setToolTipText("Input public key ref handle index");
        GridBagConstraints c = AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, false);
        this.hdlCipherPanel.add((Component)new JLabel("Public Key Reference Handle:"), c);
        ++c.gridx;
        this.hdlCipherPanel.add((Component)this.keyrefHandleField, c);
        c.gridx = 0;
        ++c.gridy;
        this.hdlCipherPanel.add((Component)new JLabel("Public Key Reference Handle Index:"), c);
        ++c.gridx;
        this.hdlCipherPanel.add((Component)this.keyrefIndexField, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        this.hdlCipherPanel.add((Component)this.browserHdlPrivkey, c);
        this.clientCipherPanel = new JPanel(new GridBagLayout());
        this.clientCipherPanel.setBorder(new EmptyBorder(6, 2, 5, 5));
        this.browserCliPrivkey = new BrowsePanel("Private Key File: ", (File)null, "", null, false);
        this.browserPubkey.setLayout(new FlowLayout(0));
        this.browserCliPrivkey.setLayout(new FlowLayout(0));
        this.clientCipherPanel.add((Component)this.browserPubkey, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 1, true, false));
        this.clientCipherPanel.add((Component)this.browserCliPrivkey, AwtUtil.getConstraints(0, 2, 1.0, 1.0, 1, 1, true, false));
        this.clientCipherPanel.add((Component)this.genRSAKeyButton, AwtUtil.getConstraints(0, 3, 1.0, 1.0, 1, 1, new Insets(0, 60, 0, 60), true, false));
        JPanel optionsP = new JPanel(new GridBagLayout());
        optionsP.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), "Session Options"), new EmptyBorder(10, 10, 10, 10)));
        String[] modes = new String[]{MODE_NONE, MODE_DH, MODE_CLIENT, MODE_HDL};
        this.modeBox = new JComboBox<String>(modes);
        try {
            HdlSecurityProvider.getInstance().generateRSAKeyPair(0);
        }
        catch (NoSuchAlgorithmException e) {
            this.modeBox.removeItem(MODE_HDL);
            this.modeBox.removeItem(MODE_CLIENT);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            HdlSecurityProvider.getInstance().generateDHKeyPair(0);
        }
        catch (NoSuchAlgorithmException e) {
            this.modeBox.removeItem(MODE_DH);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.modeBox.addActionListener(this);
        this.sessionEncrypted = new JCheckBox("Encrypted");
        this.sessionAuthenticated = new JCheckBox("Certified");
        this.sessionTimeout = new JTextField("86400", 5);
        this.timeoutL1 = new JLabel("Max Lifetime: ");
        this.timeoutL2 = new JLabel(" Seconds");
        JPanel timeoutP = new JPanel(new FlowLayout(0));
        timeoutP.add(this.sessionEncrypted);
        timeoutP.add(this.sessionAuthenticated);
        timeoutP.add(new JSeparator(0));
        timeoutP.add(this.timeoutL1);
        timeoutP.add(this.sessionTimeout);
        timeoutP.add(this.timeoutL2);
        Border b = this.timeoutL1.getBorder();
        this.timeoutL1.setBorder(new CompoundBorder(new EmptyBorder(0, 20, 0, 0), b));
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(new JLabel("Session Mode: "));
        p.add(this.modeBox);
        optionsP.add((Component)p, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, true, false));
        optionsP.add((Component)timeoutP, AwtUtil.getConstraints(0, 2, 1.0, 1.0, 1, 1, true, false));
        optionsP.add((Component)new JSeparator(1), AwtUtil.getConstraints(0, 3, 1.0, 1.0, 2, 1, true, true));
        this.modeOptionsPanel = new JPanel();
        optionsP.add((Component)this.modeOptionsPanel, AwtUtil.getConstraints(0, 4, 1.0, 1.0, 2, 1, true, true));
        Dimension d = new Dimension(500, 140);
        this.emptyPanel = new JPanel();
        this.modeOptionsPanel.setPreferredSize(d);
        this.clientCipherPanel.setPreferredSize(d);
        this.hdlCipherPanel.setMaximumSize(d);
        this.emptyPanel.setPreferredSize(d);
        this.getContentPane().add(panel);
        panel.add((Component)optionsP, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 2, 1, true, true));
        panel.add((Component)btnPanel, AwtUtil.getConstraints(0, 1, 1.0, 0.1, 1, 1, true, true));
        if (info == null) {
            this.modeBox.setSelectedIndex(0);
            this.sessionTimeout.setEnabled(false);
            this.sessionEncrypted.setEnabled(false);
            this.timeoutL1.setEnabled(false);
            this.timeoutL2.setEnabled(false);
            this.sessionAuthenticated.setEnabled(false);
            this.sessionTimeout.setEditable(false);
        } else {
            if (info.keyExchangeMode == 2) {
                this.modeBox.setSelectedItem(MODE_SERVER);
            } else if (info.keyExchangeMode == 1) {
                this.modeBox.setSelectedItem(MODE_CLIENT);
            } else if (info.keyExchangeMode == 3) {
                this.modeBox.setSelectedItem(MODE_HDL);
            } else if (info.keyExchangeMode == 0) {
                this.modeBox.setSelectedItem(MODE_NONE);
            } else if (info.keyExchangeMode == 4) {
                this.modeBox.setSelectedItem(MODE_DH);
            }
            this.browserCliPrivkey.setPath(this.privKeyFile);
            this.browserHdlPrivkey.setPath(this.privKeyFile);
            this.browserPubkey.setPath(this.pubKeyFile);
            this.sessionEncrypted.setSelected(info.encrypted);
            this.sessionAuthenticated.setSelected(info.authenticated);
            this.sessionTimeout.setText(Integer.toString(info.timeout));
            if (info.exchangeKeyHandle != null) {
                this.keyrefHandleField.setText(Util.decodeString(info.exchangeKeyHandle));
                this.keyrefIndexField.setText(Integer.toString(info.exchangeKeyIndex));
            }
        }
        this.pack();
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.modeBox) {
            this.modeBoxSelected();
        } else if (src == this.genRSAKeyButton) {
            this.generateKey();
        } else if (src == this.helpButton) {
            HelpPanel.show(this.parent, "/net/handle/apps/gui/help/en_en", "sessionsetup.html");
        }
    }

    private void modeBoxSelected() {
        this.modeOptionsPanel.removeAll();
        this.modeOptionsPanel.add(this.emptyPanel);
        this.modeOptionsPanel.revalidate();
        this.modeOptionsPanel.repaint();
        this.modeOptionsPanel.removeAll();
        String mode = (String)this.modeBox.getSelectedItem();
        this.sessionEncrypted.setEnabled(mode != MODE_NONE);
        this.sessionAuthenticated.setEnabled(mode != MODE_NONE);
        this.sessionTimeout.setEditable(mode != MODE_NONE);
        this.sessionTimeout.setEnabled(mode != MODE_NONE);
        this.timeoutL1.setEnabled(mode != MODE_NONE);
        this.timeoutL2.setEnabled(mode != MODE_NONE);
        if (mode == MODE_CLIENT) {
            this.modeOptionsPanel.add(this.clientCipherPanel);
        } else if (mode == MODE_HDL) {
            this.modeOptionsPanel.add(this.hdlCipherPanel);
        }
        this.modeOptionsPanel.revalidate();
        this.modeOptionsPanel.repaint();
    }

    public byte[] getPubKeyBytes() {
        File[] files = new File[1];
        if (!this.browserPubkey.getReadFile(files)) {
            return null;
        }
        this.pubKeyFile = files[0].getPath();
        return Util.getBytesFromFile(files[0]);
    }

    public PrivateKey getExchangePrivateKey() {
        File[] files;
        BrowsePanel browserPrivkey = this.modeBox.getSelectedItem() == MODE_HDL ? this.browserHdlPrivkey : this.browserCliPrivkey;
        if (!browserPrivkey.getReadFile(files = new File[1])) {
            return null;
        }
        this.privKeyFile = files[0].getPath();
        byte[] rawKey = Util.getBytesFromFile(files[0]);
        byte[] secretKey = null;
        try {
            while (true) {
                if (Util.requiresSecretKey(rawKey)) {
                    String[] passPhrase = new String[1];
                    if (!PasswordPanel.show(passPhrase, false)) continue;
                    secretKey = Util.encodeString(passPhrase[0]);
                }
                byte[] keyBytes = Util.decrypt(rawKey, secretKey);
                try {
                    PrivateKey privateKey = Util.getPrivateKeyFromBytes(keyBytes, 0);
                    return privateKey;
                }
                catch (Exception e) {
                    if (secretKey != null) {
                        JOptionPane.showMessageDialog(null, "There was an error decrypting your private key.\nAre you sure that you entered the correct passphrase?\nPlease try again.", "Warning", 2);
                        continue;
                    }
                    return null;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("Can't decrypt the private key file." + e);
            return null;
        }
    }

    private void generateKey() {
        GenerateKeyJPanel keyPanel = new GenerateKeyJPanel(new File(""));
        JOptionPane.showOptionDialog(this, keyPanel, "Generate Key Pair: ", 0, -1, null, new Object[]{"Close"}, null);
        this.browserPubkey.setPath(keyPanel.getPubkeyFile());
        this.browserCliPrivkey.setPath(keyPanel.getPrivkeyFile());
        this.browserHdlPrivkey.setPath(keyPanel.getPrivkeyFile());
    }

    public SessionSetupInfo getSetupInfo(AuthenticationInfo auth) throws Exception {
        String mode = (String)this.modeBox.getSelectedItem();
        final SessionSetupInfo sess = new SessionSetupInfo(0, auth);
        try {
            sess.timeout = Integer.parseInt(this.sessionTimeout.getText());
        }
        catch (NumberFormatException e) {
            throw new Exception("Invalid session lifetime value.");
        }
        if (mode == MODE_NONE) {
            return null;
        }
        if (mode == MODE_HDL) {
            sess.keyExchangeMode = 3;
            sess.exchangeKeyHandle = Util.encodeString(this.keyrefHandleField.getText());
            try {
                sess.exchangeKeyIndex = Integer.parseInt(this.keyrefIndexField.getText());
            }
            catch (NumberFormatException e) {
                throw new Exception("Invalid handle index.");
            }
            sess.privateExchangeKey = this.getExchangePrivateKey();
            if (sess.privateExchangeKey == null) {
                throw new Exception("Invalid private key file or passphrase");
            }
        } else if (mode == MODE_DH) {
            sess.keyExchangeMode = 4;
            if (this.oldInfo == null || this.oldInfo.publicExchangeKey == null || this.oldInfo.privateExchangeKey == null) {
                JOptionPane p = new JOptionPane("Generating Diffie-Hellman Keys", 2);
                final JDialog d = p.createDialog(this.parent, "Wait");
                d.setModal(false);
                d.show();
                new Thread(){

                    public void run() {
                        this.setPriority(1);
                        try {
                            sess.initDHKeys();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                3.access$000(this.this$1).hide();
                            }
                        });
                    }

                    static /* synthetic */ JDialog access$000(3 x0) {
                        return x0.d;
                    }
                }.run();
            }
        } else if (mode == MODE_CLIENT) {
            sess.keyExchangeMode = 1;
            sess.privateExchangeKey = this.getExchangePrivateKey();
            if (sess.privateExchangeKey == null) {
                throw new Exception("Invalid private key file or passphrase");
            }
            sess.publicExchangeKey = this.getPubKeyBytes();
        } else if (mode == MODE_SERVER) {
            sess.keyExchangeMode = 2;
        }
        return sess;
    }
}

