/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.util.Enumeration;
import java.util.Random;
import net.handle.hdllib.Cache;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.Util;
import net.handle.jdb.DBHash;

public class JDBCache
implements Cache {
    private DBHash db;
    private long purgeInterval = 300000L;
    private Integer dbLock = new Integer(new Random().nextInt());
    private Runnable purger;
    private boolean needReplacement = false;
    private File cacheFile;

    public JDBCache(File cacheDBFile) throws Exception {
        this.cacheFile = cacheDBFile;
        try {
            this.db = new DBHash(this.cacheFile, 2048, 1024);
        }
        catch (Exception e) {
            System.err.println("Error setting up cache: " + e);
            System.err.println("Cache will be reset in purge cycle");
            this.needReplacement = true;
        }
        this.purger = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    block20: {
                        try {
                            JDBCache.this.purgeHandles();
                        }
                        catch (Exception e) {
                            System.err.println("Error purging handles: " + e);
                            e.printStackTrace(System.err);
                            JDBCache.this.needReplacement = true;
                        }
                        try {
                            boolean localReset = false;
                            Integer n = JDBCache.this.dbLock;
                            synchronized (n) {
                                localReset = JDBCache.this.needReplacement;
                            }
                            if (!localReset) break block20;
                            System.err.println("resetting cache DB file");
                            n = JDBCache.this.dbLock;
                            synchronized (n) {
                                JDBCache.this.db = null;
                            }
                            if (JDBCache.this.cacheFile.exists()) {
                                JDBCache.this.cacheFile.delete();
                                Thread.currentThread();
                                Thread.sleep(5000L);
                            }
                            DBHash tmpDB = new DBHash(JDBCache.this.cacheFile, 2048, 1024);
                            Integer n2 = JDBCache.this.dbLock;
                            synchronized (n2) {
                                JDBCache.this.db = tmpDB;
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Error resetting cache DB: " + e);
                        }
                    }
                    try {
                        1 e = this;
                        synchronized (e) {
                            this.wait(JDBCache.this.purgeInterval);
                            continue;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error waiting for next cache purge: " + e);
                        continue;
                    }
                    break;
                }
            }
        };
        Thread t = new Thread(this.purger);
        t.setDaemon(true);
        t.setPriority(1);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getCachedValues(byte[] handle, byte[][] reqTypes, int[] reqIndexes) throws Exception {
        int clumpIndex;
        byte[] clumpType;
        int clumpLen;
        byte[] clumps;
        if (this.db == null || this.needReplacement) {
            return null;
        }
        try {
            Integer n = this.dbLock;
            synchronized (n) {
                boolean oldReplace = this.needReplacement;
                this.needReplacement = true;
                clumps = this.db.getValue(handle);
                this.needReplacement = oldReplace;
            }
        }
        catch (Exception e) {
            System.err.println("JDB error: " + e);
            this.needReplacement = true;
            return null;
        }
        if (clumps == null) {
            return null;
        }
        int idx = 0;
        boolean allValues = !(reqIndexes != null && reqIndexes.length > 0 || reqTypes != null && reqTypes.length > 0);
        byte[][] types = new byte[Encoder.readInt(clumps, idx)][];
        idx += 4;
        idx += Encoder.readByteArrayArray(types, clumps, idx);
        int[] indexes = Encoder.readIntArray(clumps, idx);
        int numClumps = Encoder.readInt(clumps, idx += 4 + 4 * indexes.length);
        idx += 4;
        if (types.length != 0 || indexes.length != 0) {
            int i;
            if (allValues) {
                return null;
            }
            if (reqIndexes != null && reqIndexes.length > 0) {
                for (i = 0; i < reqIndexes.length; ++i) {
                    if (Util.isInArray(indexes, reqIndexes[i])) continue;
                    return null;
                }
            }
            if (reqTypes != null && reqTypes.length > 0) {
                for (i = 0; i < reqTypes.length; ++i) {
                    if (Util.isInArray(types, reqTypes[i])) continue;
                    return null;
                }
            }
        }
        int startIdx = idx;
        int numMatches = 0;
        int now = (int)(System.currentTimeMillis() / 1000L);
        boolean gotClumps = false;
        while (idx < clumps.length) {
            clumpLen = Encoder.readInt(clumps, idx);
            idx += 4;
            clumpType = Encoder.getHandleValueType(clumps, idx += 4);
            clumpIndex = Encoder.getHandleValueIndex(clumps, idx);
            if (allValues || Util.isInArray(reqTypes, clumpType) || Util.isInArray(reqIndexes, clumpIndex)) {
                ++numMatches;
            }
            gotClumps = true;
            idx += clumpLen;
        }
        if (!gotClumps) {
            return null;
        }
        byte[][] retValues = new byte[numMatches][];
        int clumpNum = 0;
        HandleValue testValue = null;
        for (idx = startIdx; idx < clumps.length; idx += clumpLen) {
            clumpLen = Encoder.readInt(clumps, idx);
            int valueDate = Encoder.readInt(clumps, idx += 4);
            clumpType = Encoder.getHandleValueType(clumps, idx += 4);
            clumpIndex = Encoder.getHandleValueIndex(clumps, idx);
            if (!allValues && !Util.isInArray(reqTypes, clumpType) && !Util.isInArray(reqIndexes, clumpIndex)) continue;
            retValues[clumpNum] = new byte[clumpLen];
            if (testValue == null) {
                testValue = new HandleValue();
            }
            Encoder.decodeHandleValue(clumps, idx, testValue);
            if (testValue.isExpired(now, valueDate)) {
                return null;
            }
            System.arraycopy(clumps, idx, retValues[clumpNum], 0, retValues[clumpNum].length);
            ++clumpNum;
        }
        if (clumpNum != retValues.length) {
            System.err.println("Unknown cache error!!!");
            this.needReplacement = true;
            return null;
        }
        return retValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCachedValues(byte[] handle, HandleValue[] newValues, byte[][] newTypeList, int[] newIndexList) throws Exception {
        int lenLoc;
        int i;
        int i2;
        int i3;
        int newValueCount;
        Object types = null;
        int[] indexes = null;
        int[] valueDates = null;
        HandleValue[] values = null;
        byte[] clumps = null;
        try {
            Integer n = this.dbLock;
            synchronized (n) {
                if (this.db == null) {
                    return;
                }
                boolean oldReplace = this.needReplacement;
                this.needReplacement = true;
                clumps = this.db.getValue(handle);
                this.needReplacement = oldReplace;
            }
        }
        catch (Exception e) {
            System.err.println("JDB error: " + e);
            this.needReplacement = true;
            e.printStackTrace(System.err);
            return;
        }
        int idx = 0;
        if (clumps != null) {
            types = new byte[Encoder.readInt(clumps, idx)][];
            idx += 4;
            idx += Encoder.readByteArrayArray(types, clumps, idx);
            indexes = Encoder.readIntArray(clumps, idx);
            values = new HandleValue[Encoder.readInt(clumps, idx += 4 + 4 * indexes.length)];
            valueDates = new int[values.length];
            int startValuesIdx = idx += 4;
            int i4 = 0;
            while (idx < clumps.length) {
                int clumpLen = Encoder.readInt(clumps, idx);
                valueDates[i4] = Encoder.readInt(clumps, idx += 4);
                values[i4] = new HandleValue();
                Encoder.decodeHandleValue(clumps, idx += 4, values[i4]);
                ++i4;
                idx += clumpLen;
            }
        }
        int now = (int)(System.currentTimeMillis() / 1000L);
        int n = newValueCount = values == null ? 0 : values.length;
        if (!(newTypeList != null && ((byte[][])newTypeList).length > 0 || newIndexList != null && newIndexList.length > 0)) {
            types = null;
            indexes = null;
            values = null;
        } else if (types != null && ((byte[][])types).length <= 0 && indexes != null && indexes.length <= 0) {
            for (i3 = 0; values != null && i3 < newValues.length; ++i3) {
                int thisIndex = newValues[i3].index;
                for (int j = 0; j < values.length; ++j) {
                    if (values[j] == null || values[j].index != thisIndex) continue;
                    values[j] = null;
                }
            }
            newTypeList = null;
            newIndexList = null;
        } else {
            int j;
            if (newTypeList != null && ((byte[][])newTypeList).length > 0) {
                byte[][] typeListCopy = new byte[((byte[][])newTypeList).length][];
                System.arraycopy(newTypeList, 0, typeListCopy, 0, ((byte[][])newTypeList).length);
                newTypeList = typeListCopy;
            }
            for (i3 = 0; types != null && i3 < ((byte[][])types).length; ++i3) {
                if (types[i3] == null) continue;
                for (j = 0; newTypeList != null && j < ((byte[][])newTypeList).length; ++j) {
                    if (newTypeList[j] == null || !Util.equalsCI(types[i3], newTypeList[j])) continue;
                    newTypeList[j] = null;
                }
            }
            for (i3 = 0; indexes != null && i3 < indexes.length; ++i3) {
                if (indexes[i3] < 0) continue;
                for (j = 0; newIndexList != null && j < newIndexList.length; ++j) {
                    if (newIndexList[j] < 0 || indexes[i3] != newIndexList[j]) continue;
                    newIndexList[j] = -1;
                }
            }
            for (i3 = 0; values != null && i3 < newValues.length; ++i3) {
                boolean alreadyHaveVal = false;
                int thisIndex = newValues[i3].index;
                for (int j2 = 0; j2 < values.length; ++j2) {
                    if (values[j2] == null || values[j2].index != thisIndex) continue;
                    values[j2] = null;
                    alreadyHaveVal = true;
                }
            }
        }
        int dataLen = 0;
        int typeCount = 0;
        int indexCount = 0;
        int valueCount = 0;
        dataLen += 4;
        dataLen += 4;
        dataLen += 4;
        for (i2 = 0; types != null && i2 < ((byte[][])types).length; ++i2) {
            if (types[i2] == null) continue;
            dataLen += 4 + types[i2].length;
            ++typeCount;
        }
        for (i2 = 0; newTypeList != null && i2 < ((byte[][])newTypeList).length; ++i2) {
            if (newTypeList[i2] == null) continue;
            dataLen += 4 + newTypeList[i2].length;
            ++typeCount;
        }
        for (i2 = 0; indexes != null && i2 < indexes.length; ++i2) {
            if (indexes[i2] < 0) continue;
            dataLen += 4;
            ++indexCount;
        }
        for (i2 = 0; newIndexList != null && i2 < newIndexList.length; ++i2) {
            if (newIndexList[i2] < 0) continue;
            dataLen += 4;
            ++indexCount;
        }
        for (i2 = 0; values != null && i2 < values.length; ++i2) {
            if (values[i2] == null) continue;
            dataLen += 4;
            dataLen += 4;
            dataLen += Encoder.calcStorageSize(values[i2]);
            ++valueCount;
        }
        for (i2 = 0; newValues != null && i2 < newValues.length; ++i2) {
            if (newValues[i2] == null) continue;
            dataLen += 4;
            dataLen += 4;
            dataLen += Encoder.calcStorageSize(newValues[i2]);
            ++valueCount;
        }
        byte[] dataBuf = new byte[dataLen];
        int loc = 0;
        loc += Encoder.writeInt(dataBuf, loc, typeCount);
        for (i = 0; types != null && i < ((byte[][])types).length; ++i) {
            if (types[i] == null) continue;
            loc += Encoder.writeByteArray(dataBuf, loc, types[i]);
        }
        for (i = 0; newTypeList != null && i < ((byte[][])newTypeList).length; ++i) {
            if (newTypeList[i] == null) continue;
            loc += Encoder.writeByteArray(dataBuf, loc, newTypeList[i]);
        }
        loc += Encoder.writeInt(dataBuf, loc, indexCount);
        for (i = 0; indexes != null && i < indexes.length; ++i) {
            if (indexes[i] < 0) continue;
            loc += Encoder.writeInt(dataBuf, loc, indexes[i]);
        }
        for (i = 0; newIndexList != null && i < newIndexList.length; ++i) {
            if (newIndexList[i] < 0) continue;
            loc += Encoder.writeInt(dataBuf, loc, newIndexList[i]);
        }
        loc += Encoder.writeInt(dataBuf, loc, valueCount);
        for (i = 0; values != null && i < values.length; ++i) {
            if (values[i] == null) continue;
            lenLoc = loc;
            loc += 4;
            loc += Encoder.writeInt(dataBuf, loc, valueDates[i]);
            loc += Encoder.encodeHandleValue(dataBuf, loc, values[i]);
            Encoder.writeInt(dataBuf, lenLoc, loc - lenLoc - 8);
        }
        for (i = 0; newValues != null && i < newValues.length; ++i) {
            if (newValues[i] == null) continue;
            lenLoc = loc;
            loc += 4;
            loc += Encoder.writeInt(dataBuf, loc, now);
            loc += Encoder.encodeHandleValue(dataBuf, loc, newValues[i]);
            Encoder.writeInt(dataBuf, lenLoc, loc - lenLoc - 8);
        }
        Integer n2 = this.dbLock;
        synchronized (n2) {
            if (this.db == null) {
                return;
            }
            this.db.setValue(handle, dataBuf);
        }
    }

    public void setMaximumHandles(int maxHandles) {
    }

    public void setMaximumSize(int maxSize) {
    }

    public void close() throws Exception {
        this.db.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyPurger() {
        try {
            Runnable runnable = this.purger;
            synchronized (runnable) {
                this.purger.notify();
            }
        }
        catch (Exception e) {
            System.err.println("Error notifying purge thread!");
            e.printStackTrace(System.err);
        }
    }

    private void purgeHandles() {
        if (this.db == null) {
            return;
        }
        HandleValue value = new HandleValue();
        Enumeration enumeration = this.db.getEnumerator();
        while (enumeration.hasMoreElements()) {
            try {
                Object nextObj = enumeration.nextElement();
                if (nextObj == null) continue;
                byte[][] record = (byte[][])nextObj;
                int now = (int)(System.currentTimeMillis() / 1000L);
                byte[] handle = record[0];
                byte[] buf = record[1];
                int loc = 0;
                int numTypes = Encoder.readInt(buf, loc);
                loc += 4;
                for (int i = 0; i < numTypes; ++i) {
                    loc += Encoder.readInt(buf, loc) + 4;
                }
                int[] indexes = Encoder.readIntArray(buf, loc);
                int numValues = Encoder.readInt(buf, loc += 4 + indexes.length * 4);
                loc += 4;
                int numValidValues = 0;
                for (int i = 0; i < numValues; ++i) {
                    int valueLength = Encoder.readInt(buf, loc);
                    int valueDate = Encoder.readInt(buf, loc += 4);
                    Encoder.decodeHandleValue(buf, loc += 4, value);
                    loc += valueLength;
                    if (value.isExpired(now, valueDate)) continue;
                    ++numValidValues;
                }
                if (numValidValues > 0) continue;
                this.db.deleteValue(handle);
            }
            catch (Exception e) {
                this.needReplacement = true;
                System.err.println("Got exception purging handles: " + e);
                e.printStackTrace(System.err);
                break;
            }
        }
    }
}

