/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.util.Vector;
import net.handle.hdllib.ParameterPair;

public class ParameterSet {
    private static final String DEFAULT_DEFAULT_TYPE = "type";
    private static final String DEFAULT_HANDLE_TYPE = "type";
    private static final String DEFAULT_LOCAL_TYPE = "type";
    private ParameterPair[] defaultParamList;
    private ParameterPair[] handleParamList;
    private ParameterPair[] localParamList;
    public String handle;

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(this.handle);
        if (this.defaultParamList != null) {
            sb.append(" default[");
            for (i = 0; i < this.defaultParamList.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(this.defaultParamList[i]));
            }
            sb.append("]");
        }
        if (this.handleParamList != null) {
            sb.append(" handle[");
            for (i = 0; i < this.handleParamList.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(this.handleParamList[i]));
            }
            sb.append("]");
        }
        if (this.localParamList != null) {
            sb.append(" local[");
            for (i = 0; i < this.localParamList.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(String.valueOf(this.localParamList[i]));
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public ParameterSet(String handle, ParameterPair[] defaultParamList, ParameterPair[] handleParamList, ParameterPair[] localParamList) {
        this.handle = handle;
        this.defaultParamList = defaultParamList;
        this.handleParamList = handleParamList;
        this.localParamList = localParamList;
    }

    public ParameterSet(String handle, ParameterPair[] handleParamList) {
        this.handle = handle;
        this.handleParamList = handleParamList;
    }

    public String[] getLocalParametersByName(String name) {
        return ParameterSet.getParametersByName(name, this.localParamList, "type");
    }

    public String[] getDefaultParametersByName(String name) {
        return ParameterSet.getParametersByName(name, this.defaultParamList, "type");
    }

    public String[] getHandleParametersByName(String name) {
        return ParameterSet.getParametersByName(name, this.handleParamList, "type");
    }

    public String getLocalParameterString() {
        return this.getParameterString(this.localParamList);
    }

    public String getHandleParameterString() {
        return this.getParameterString(this.handleParamList);
    }

    public String getDefaultParameterString() {
        return this.getParameterString(this.defaultParamList);
    }

    private String getParameterString(ParameterPair[] params) {
        if (this.localParamList == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            buf.append(params[i].name);
            buf.append("=");
            buf.append(params[i].value);
            if (i == params.length - 1) continue;
            buf.append(";");
        }
        return buf.toString();
    }

    public boolean containsHandleParameter(String name) {
        return this.containsParameter(name, this.handleParamList);
    }

    private static final String[] getParametersByName(String name, ParameterPair[] pairs, String defaultName) {
        if (pairs == null || pairs.length <= 0) {
            return new String[0];
        }
        Vector<String> values = new Vector<String>();
        boolean isDefaultName = name.equals(defaultName);
        for (int i = 0; i < pairs.length; ++i) {
            if ((!isDefaultName || pairs[i].name.length() != 0) && !pairs[i].name.equals(name)) continue;
            values.addElement(pairs[i].value);
        }
        String[] valueArray = new String[values.size()];
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = (String)values.elementAt(i);
        }
        return valueArray;
    }

    private boolean containsParameter(String name, ParameterPair[] pairs) {
        if (pairs == null || pairs.length <= 0) {
            return false;
        }
        for (int i = pairs.length - 1; i >= 0; --i) {
            if (!pairs[i].name.equals(name)) continue;
            return true;
        }
        return false;
    }
}

