/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.RetrieveTxnRequest;
import net.handle.hdllib.SignedInputStream;
import net.handle.hdllib.SignedOutputStream;
import net.handle.hdllib.Transaction;
import net.handle.hdllib.TransactionCallback;
import net.handle.hdllib.TransactionQueueInterface;
import net.handle.hdllib.TransactionScannerInterface;
import net.handle.hdllib.Util;

public class RetrieveTxnResponse
extends AbstractResponse {
    public static final int NEED_TO_REDUMP = 1;
    public static final int SENDING_TRANSACTIONS = 2;
    private static final byte END_TRANSMISSION_RECORD = 0;
    private static final byte HANDLE_RECORD = 1;
    public boolean keepAlive = false;
    public RetrieveTxnRequest req = null;
    public TransactionQueueInterface txnQueue = null;
    private HandleStorage storage = null;
    private PrivateKey sourcePrivKey = null;
    private long lastTxnId = 0L;

    public RetrieveTxnResponse(TransactionQueueInterface txnQueue, RetrieveTxnRequest req, boolean keepAlive, HandleStorage storage, PrivateKey sourcePrivKey) throws HandleException {
        super(req, 1);
        this.req = req;
        this.txnQueue = txnQueue;
        this.keepAlive = keepAlive;
        this.storage = storage;
        this.streaming = true;
        this.sourcePrivKey = sourcePrivKey;
        this.lastTxnId = req.lastTxnId;
    }

    public RetrieveTxnResponse() {
        super(1001, 1);
        this.streaming = true;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int processStreamedPart(TransactionCallback callback, PublicKey sourceKey) throws HandleException {
        block22: {
            if (this.stream == null) {
                throw new HandleException(1, "Response stream not found");
            }
            threadPriority = Thread.currentThread().getPriority();
            try {
                try {
                    sin = new SignedInputStream(sourceKey, this.stream);
                    in = new DataInputStream(sin);
                    dataVersion = in.readInt();
                    status = in.readInt();
                    if (!sin.verifyBlock()) {
                        throw new HandleException(10, "Invalid signature on replication stream");
                    }
                    while (true) {
                        if ((recordType = in.readByte()) == 0) {
                            sourceDate = in.readLong();
                            if (!sin.verifyBlock()) {
                                throw new HandleException(10, "Invalid signature on replication stream");
                            }
                            callback.finishProcessing(sourceDate);
                            var11_13 = status;
                            var17_18 = null;
                            if (this.stream == null) break block22;
                            break;
                        }
                        if (recordType != 1) throw new HandleException(0, "Unknown transmission record type: " + recordType);
                        txn = new Transaction();
                        txn.txnId = in.readLong();
                        txn.handle = new byte[in.readInt()];
                        in.read(txn.handle, 0, txn.handle.length);
                        txn.action = in.readByte();
                        txn.date = in.readLong();
                        switch (txn.action) {
                            case 1: 
                            case 3: {
                                numValues = in.readInt();
                                txn.values = new HandleValue[numValues];
                                for (i = 0; i < numValues; ++i) {
                                    valueSize = in.readInt();
                                    buf = new byte[valueSize];
                                    for (n = 0; n < valueSize && (r = in.read(buf, n, valueSize - n)) >= 0; n += r) {
                                    }
                                    txn.values[i] = new HandleValue();
                                    Encoder.decodeHandleValue(buf, 0, txn.values[i]);
                                }
                                break;
                            }
                        }
                        if (!sin.verifyBlock()) {
                            throw new HandleException(10, "Invalid signature on replication stream");
                        }
                        callback.processTransaction(txn);
                        Thread.yield();
                    }
                }
                catch (Exception e) {
                    System.err.println(">>> Exception streaming: " + e);
                    e.printStackTrace(System.err);
                    if (e instanceof HandleException == false) throw new HandleException(1, "Exception receiving transactions: " + e);
                    throw (HandleException)e;
                }
            }
            catch (Throwable var16_22) {
                var17_19 = null;
                if (this.stream != null) {
                    try {
                        this.stream.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    Thread.currentThread().setPriority(threadPriority);
                    throw var16_22;
                }
                catch (Exception e) {
                    System.err.println("Unable to upgrade thread priority: " + e);
                    throw var16_22;
                }
            }
            ** try [egrp 2[TRYBLOCK] [4 : 537->547)] { 
lbl73:
            // 1 sources

            this.stream.close();
            break block22;
lbl75:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
        }
        ** try [egrp 3[TRYBLOCK] [5 : 549->559)] { 
lbl79:
        // 1 sources

        Thread.currentThread().setPriority(threadPriority);
        return var11_13;
lbl81:
        // 1 sources

        catch (Exception e) {
            System.err.println("Unable to upgrade thread priority: " + e);
        }
        return var11_13;
    }

    /*
     * Loose catch block
     */
    public void streamResponse(OutputStream outStream) throws HandleException {
        block9: {
            int threadPriority = Thread.currentThread().getPriority();
            SignedOutputStream sout = new SignedOutputStream(this.sourcePrivKey, outStream);
            DataOutputStream out = new DataOutputStream(sout);
            out.writeInt(1);
            TransactionScannerInterface scanner = this.txnQueue.getScanner(this.lastTxnId);
            if (this.txnQueue.getFirstDate() > this.req.lastQueryDate) {
                out.writeInt(1);
                sout.signBlock();
            } else {
                out.writeInt(2);
                sout.signBlock();
                this.forwardTransactions(scanner, out, sout);
            }
            out.writeByte(0);
            out.writeLong(System.currentTimeMillis());
            sout.signBlock();
            out.flush();
            scanner.close();
            Object var7_7 = null;
            try {
                Thread.currentThread().setPriority(threadPriority);
            }
            catch (Exception e) {
                System.err.println("Unable to upgrade thread priority: " + e);
            }
            break block9;
            {
                catch (Exception e) {
                    throw new HandleException(1, "Exception sending transactions: " + e);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    Thread.currentThread().setPriority(threadPriority);
                }
                catch (Exception e) {
                    System.err.println("Unable to upgrade thread priority: " + e);
                }
                throw throwable;
            }
        }
    }

    private void forwardTransactions(TransactionScannerInterface scanner, DataOutputStream out, SignedOutputStream sout) throws Exception {
        Transaction txn = null;
        while ((txn = scanner.nextTransaction()) != null) {
            if (txn.txnId <= this.req.lastTxnId) continue;
            if (txn.action != 5 && txn.action != 4) {
                boolean hashes;
                switch (this.req.rcvrHashType) {
                    case 0: {
                        hashes = Math.abs(txn.hashOnNA % this.req.numServers) == this.req.serverNum;
                        break;
                    }
                    case 1: {
                        hashes = Math.abs(txn.hashOnId % this.req.numServers) == this.req.serverNum;
                        break;
                    }
                    case 2: {
                        hashes = Math.abs(txn.hashOnAll % this.req.numServers) == this.req.serverNum;
                        break;
                    }
                    default: {
                        System.err.println("Warning: unknown hash type (" + this.req.rcvrHashType + ") in RetrieveTxnRequest");
                        hashes = true;
                    }
                }
                if (!hashes) continue;
            }
            out.writeByte(1);
            out.writeLong(txn.txnId);
            out.writeInt(txn.handle == null ? 0 : txn.handle.length);
            if (txn.handle != null) {
                out.write(txn.handle, 0, txn.handle.length);
            }
            out.writeByte(txn.action);
            out.writeLong(txn.date);
            switch (txn.action) {
                case 1: 
                case 3: {
                    byte[][] hdlValue = this.storage.getRawHandleValues(txn.handle, null, null);
                    if (hdlValue == null) {
                        hdlValue = this.storage.getRawHandleValues(Util.upperCase(txn.handle), null, null);
                    }
                    if (hdlValue == null) {
                        out.writeInt(0);
                        break;
                    }
                    out.writeInt(hdlValue.length);
                    for (int i = 0; i < hdlValue.length; ++i) {
                        if (hdlValue[i] == null) {
                            out.writeInt(0);
                            continue;
                        }
                        out.writeInt(hdlValue[i].length);
                        out.write(hdlValue[i]);
                    }
                    break;
                }
            }
            sout.signBlock();
            out.flush();
            Thread.yield();
        }
    }
}

