/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import net.handle.server.DnsUdpConstants;
import net.handle.server.DnsUdpRequestHandler;
import net.handle.server.HdlUdpRequestHandler;
import net.handle.server.Main;
import net.handle.server.NetworkInterface;
import net.handle.server.RequestHandlerPool;

public class DnsUdpInterface
extends NetworkInterface
implements DnsUdpConstants {
    private InetAddress bindAddress;
    private int threadLife = 500;
    private int bindPort;
    private int numThreads = 10;
    private int maxHandlers = 200;
    private boolean logAccesses = false;
    private boolean trackThreads = false;
    private DatagramSocket dsocket = null;
    private boolean keepServing = true;
    private String dnsToHandlePrefix = null;

    public DnsUdpInterface(Main main, Hashtable config) throws UnknownHostException {
        super(main);
        String bindAddressStr = (String)config.get("bind_address");
        this.bindAddress = bindAddressStr == null ? null : InetAddress.getByName(bindAddressStr);
        this.bindPort = Integer.parseInt((String)config.get("bind_port"));
        try {
            this.numThreads = Integer.parseInt((String)config.get("num_threads"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.dnsToHandlePrefix = (String)config.get("dns_handle_prefix");
        if (this.dnsToHandlePrefix == null) {
            this.dnsToHandlePrefix = "dns/";
        }
    }

    protected void stopService() {
        this.keepServing = false;
        try {
            this.dsocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void serveRequests() {
        try {
            this.dsocket = this.bindAddress == null ? new DatagramSocket(this.bindPort) : new DatagramSocket(this.bindPort, this.bindAddress);
        }
        catch (Exception e) {
            this.main.logError(100, String.valueOf(this.getClass()) + ": Error setting up server socket: " + e);
            return;
        }
        System.out.println("DNS-LOCAL handle Request Listener:");
        System.out.println("   address: " + (this.bindAddress == null ? "ANY" : "" + this.bindAddress));
        System.out.println("      port: " + this.bindPort);
        RequestHandlerPool handlerPool = new RequestHandlerPool(this.trackThreads ? "DNS" : null);
        handlerPool.setHandlerLife(this.threadLife);
        handlerPool.setMaxPossibleHandlers(this.maxHandlers);
        System.out.print("Starting DNS request handlers: ");
        for (int threadNum = 0; threadNum < this.numThreads; ++threadNum) {
            System.out.print('.');
            handlerPool.addHandler(new DnsUdpRequestHandler(this.main, this.dsocket, handlerPool, this, this.dnsToHandlePrefix, this.logAccesses));
        }
        System.out.println("");
        try {
            System.out.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        long reqCount = 0L;
        long recvTime = 0L;
        while (this.keepServing) {
            try {
                DatagramPacket dPacket = new DatagramPacket(new byte[512], 512);
                this.dsocket.receive(dPacket);
                recvTime = System.currentTimeMillis();
                ((HdlUdpRequestHandler)handlerPool.getHandler()).serviceRequest(dPacket, recvTime);
                if (++reqCount <= 1000L) continue;
                this.needsGC = true;
                reqCount = 0L;
            }
            catch (Exception e) {
                this.main.logError(75, "" + this.getClass() + ": Error handling request: " + e);
                e.printStackTrace(System.err);
            }
        }
        try {
            this.dsocket.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

