/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcher;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ArbilEntityResolver
implements EntityResolver {
    public static final int EXPIRE_CACHE_DAYS = 7;
    private static BugCatcher bugCatcher;
    private static SessionStorage sessionStorage;
    private URI parentUri;

    public static void setBugCatcher(BugCatcher bugCatcherInstance) {
        bugCatcher = bugCatcherInstance;
    }

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public ArbilEntityResolver(URI parentUriLocal) {
        this.parentUri = parentUriLocal;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String targetString;
        if (this.parentUri != null) {
            URI resolvedSystemIdURL = this.parentUri.resolve(systemId);
            targetString = resolvedSystemIdURL.toString();
        } else {
            targetString = systemId;
        }
        final File cachedfile = sessionStorage.updateCache(targetString, 7, false);
        if (!cachedfile.exists()) {
            bugCatcher.logError(new Exception("dependant xsd not stored in the jar for offline first time use: " + cachedfile));
        }
        String cachedfileString = cachedfile.toURI().toString();
        return new InputSource(cachedfileString){

            public InputStream getByteStream() {
                try {
                    return new FileInputStream(cachedfile);
                }
                catch (FileNotFoundException ex) {
                    bugCatcher.logError(ex);
                    return null;
                }
            }

            public Reader getCharacterStream() {
                try {
                    return new FileReader(cachedfile);
                }
                catch (FileNotFoundException ex) {
                    bugCatcher.logError(ex);
                    return null;
                }
            }
        };
    }
}

