/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui.wizard.setup;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizard;
import nl.mpi.arbil.ui.wizard.setup.ArbilSetupWizardModel;
import nl.mpi.arbil.ui.wizard.setup.TextInstructionWizardContent;

public class MetadataFormatSelectContent
extends TextInstructionWizardContent {
    private final ArbilSetupWizardModel model;
    private final JCheckBox imdiCheckBox;
    private final JCheckBox cmdiCheckBox;

    public MetadataFormatSelectContent(ArbilSetupWizardModel model) {
        super("/nl/mpi/arbil/resources/html/wizard/MetadataFormatSelect.html");
        this.model = model;
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.setLayout(new BoxLayout(checkBoxPanel, 3));
        checkBoxPanel.setBackground(Color.WHITE);
        this.imdiCheckBox = new JCheckBox("IMDI");
        this.imdiCheckBox.setBackground(Color.WHITE);
        this.imdiCheckBox.setHorizontalAlignment(2);
        checkBoxPanel.add(this.imdiCheckBox);
        this.cmdiCheckBox = new JCheckBox("CMDI");
        this.cmdiCheckBox.setBackground(Color.WHITE);
        this.cmdiCheckBox.setHorizontalAlignment(2);
        checkBoxPanel.add(this.cmdiCheckBox);
        this.add((Component)checkBoxPanel, "West");
        this.refresh();
    }

    public final void refresh() {
        super.refresh();
        this.imdiCheckBox.setSelected(this.model.isImdiSelected());
        this.cmdiCheckBox.setSelected(this.model.isCmdiSelected());
    }

    public boolean beforeNext() {
        this.updateModel();
        if (this.model.isImdiSelected() || this.model.isCmdiSelected()) {
            return true;
        }
        JOptionPane.showMessageDialog(this, "Select at least one of the options before continuing", "Select a metadata format", 2);
        return false;
    }

    public boolean beforePrevious() {
        this.updateModel();
        return true;
    }

    public Object getNext() {
        if (this.model.isCmdiSelected()) {
            return ArbilSetupWizard.CMDI_PROFILE_SELECT;
        }
        return ArbilSetupWizard.REMOTE_LOCATIONS;
    }

    public Object getPrevious() {
        return ArbilSetupWizard.INTRODUCTION;
    }

    private void updateModel() {
        this.model.setImdiSelected(this.imdiCheckBox.isSelected());
        this.model.setCmdiSelected(this.cmdiCheckBox.isSelected());
    }
}

